/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.parse;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.bizpack.BizPackage;
import com.huawei.ism.tool.bizpack.NodeItem;
import com.huawei.ism.tool.bizpack.ProcessInfo;
import com.huawei.ism.tool.bizpack.parse.XmlConfigParser;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.io.File;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ProcessInfoParser
extends XmlConfigParser {
    private static final String PACKAGE_SCRIPT_DIR = "script";
    private static final String ID = "id";
    private static final String DESCRIPTION = "description";
    private static final String PROCESS_ENV_NODE = "env";
    private static final String ENV_PARAM_NODE = "param";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String NODE_NAME = "node";
    private static final String DESCRIPTION_ATRRI = "description";
    private static final String MAIN_METHOD = "mainMethod";
    private static final String MAIN_METHOD_DEFAULT = "execute";
    private static final String FAIL_EXIT = "failexit";
    private static final String FAIL_EXIT_DEFAULT = "true";
    private static final String STORAGE_COMMON = "StorageCommon";
    private String packPath = "";

    public ProcessInfoParser(File xmlFile, String packPath) {
        super(xmlFile);
        this.packPath = packPath;
    }

    @Override
    public boolean parseContent(BizPackage bizPackage) {
        if (this.getDocument() == null) {
            return false;
        }
        Element root = this.getDocument().getDocumentElement();
        ProcessInfo processInfo = new ProcessInfo();
        processInfo.setId(root.getAttribute(ID));
        processInfo.setDescription(this.getAttribute(root, "description", ""));
        processInfo.setScriptPath(this.packPath + File.separator + PACKAGE_SCRIPT_DIR);
        this.parseEnvParam(processInfo, root);
        this.parseNodeItems(processInfo, root);
        bizPackage.getProcessInfoes().add(processInfo);
        return true;
    }

    private void parseEnvParam(ProcessInfo processInfo, Element root) {
        NodeList nodeList = root.getElementsByTagName(PROCESS_ENV_NODE);
        if (nodeList == null || nodeList.getLength() == 0) {
            return;
        }
        Element env = (Element)nodeList.item(0);
        this.parseEnvParams(processInfo, env);
    }

    private void parseEnvParams(ProcessInfo processInfo, Element env) {
        NodeList paramList = env.getElementsByTagName(ENV_PARAM_NODE);
        if (paramList == null || paramList.getLength() == 0) {
            return;
        }
        int length = paramList.getLength();
        for (int index = 0; index < length; ++index) {
            Element param = (Element)paramList.item(index);
            String paramName = param.getAttribute(NAME_ATTRIBUTE);
            if (StringUtils.isNULLStr((String)paramName)) continue;
            processInfo.getEnvParamNames().add(paramName);
        }
    }

    private void parseNodeItems(ProcessInfo processInfo, Element root) {
        NodeList nodeList = root.getElementsByTagName(NODE_NAME);
        if (nodeList == null || nodeList.getLength() == 0) {
            return;
        }
        int length = nodeList.getLength();
        ArrayList<NodeItem> nodeItems = new ArrayList<NodeItem>();
        for (int index = 0; index < length; ++index) {
            Element nodeElement = (Element)nodeList.item(index);
            NodeItem nodeItem = this.parseNodeItem(nodeElement);
            nodeItems.add(nodeItem);
        }
        processInfo.setNodeItems(nodeItems);
    }

    private NodeItem parseNodeItem(Element nodeElement) {
        NodeItem nodeItem = new NodeItem();
        nodeItem.setId(this.getAttribute(nodeElement, ID, ""));
        nodeItem.setDescription(this.getAttribute(nodeElement, "description", ""));
        nodeItem.setFailExit(Boolean.parseBoolean(this.getAttribute(nodeElement, FAIL_EXIT, FAIL_EXIT_DEFAULT)));
        nodeItem.setMainMethod(this.getAttribute(nodeElement, MAIN_METHOD, MAIN_METHOD_DEFAULT));
        String scriptName = this.getAttribute(nodeElement, PACKAGE_SCRIPT_DIR, "");
        String scriptPath = this.packPath + File.separator + PACKAGE_SCRIPT_DIR + File.separator + scriptName;
        File scriptFile = new File(FilePathUtils.filterPath(scriptPath));
        if (!scriptFile.exists()) {
            scriptPath = new File(this.packPath).getParent() + File.separator + STORAGE_COMMON + File.separator + scriptName;
        }
        nodeItem.setScriptFilePath(scriptPath);
        if (StringUtils.isNULLStr((String)nodeItem.getId())) {
            return null;
        }
        if (StringUtils.isNULLStr((String)nodeItem.getScriptFilePath())) {
            return null;
        }
        return nodeItem;
    }

    private String getAttribute(Element element, String attriName, String defaultValue) {
        String attribute = element.getAttribute(attriName);
        if (StringUtils.isNULLStr((String)attribute)) {
            attribute = defaultValue;
        }
        return attribute;
    }
}

