/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.context;

import com.huawei.ism.tool.base.flow.Flow;
import com.huawei.ism.tool.base.flow.IStep;
import com.huawei.ism.tool.base.ui.wizard.FlowWizardDialog;
import com.huawei.ism.tool.base.ui.wizard.GuideFlowWizardDialog;
import com.huawei.ism.tool.base.utils.IniReader;
import com.huawei.ism.tool.bizpack.BizPackage;
import com.huawei.ism.tool.bizpack.PackProduct;
import com.huawei.ism.tool.bizpack.wizardparse.context.JythonContext;
import com.huawei.ism.tool.bizpack.wizardparse.entity.BizPackageUserOpData;
import com.huawei.ism.tool.bizpack.wizardparse.entity.BizWizardConfig;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.settingdialog.SettingContentPanel;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.AbstractBizStepLayout;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DmeNode;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import org.slf4j.LoggerFactory;
import utils.Products;

public final class BizPackageContext {
    private static final BizPackageContext INSTANCE = new BizPackageContext();
    private static final int INVALID_STEP_NUM = -1;
    private List<BizPackage> bizPackages;
    private BizPackage curBizPackage;
    private BizWizardConfig curBizWizardCfg;
    private DevNode curDevice;
    private List<DmeNode> a800ZoneNodeList = new ArrayList<DmeNode>();
    private JythonContext jythonContext;
    private Window selectProcessDialog;
    private Window selectDeviceDialog;
    private String curToolName = "";
    private String mainDialogTitle = "";
    private JDialog wizard;
    private List<PackProduct> packProducts = new ArrayList<PackProduct>();
    private boolean singleDev = true;
    private boolean selfDefine = false;
    private int curWizardStepNum = -1;
    private Map<String, AbstractBizStepLayout> id2LayoutMap = new HashMap<String, AbstractBizStepLayout>();
    private String curStepId = "";
    private List<BizPackageUserOpData> userOpDatas = new ArrayList<BizPackageUserOpData>();
    private BizPackageUserOpData bizpackageUserOpData;
    private SettingContentPanel.ConfirmSwitch checkItemHandleSwitch;
    private SettingContentPanel.ConfirmSwitch checkRiskPowerSwitch;

    private BizPackageContext() {
        this.jythonContext = new JythonContext();
        this.bizPackages = new ArrayList<BizPackage>();
    }

    public ImageIcon getMultiModeRuningImg() {
        IniReader reader = new IniReader(new File("tool.ini"));
        String iconName = reader.getString("tool.icon");
        String iconPath = "." + File.separator + iconName;
        Image image = Toolkit.getDefaultToolkit().getImage(iconPath);
        ImageIcon icon = new ImageIcon(image);
        return icon;
    }

    public static BizPackageContext getInstance() {
        return INSTANCE;
    }

    public SettingContentPanel.ConfirmSwitch getCheckItemHandleSwitch() {
        return this.checkItemHandleSwitch;
    }

    public void setCheckItemHandleSwitch(SettingContentPanel.ConfirmSwitch confirmSwitch) {
        this.checkItemHandleSwitch = confirmSwitch;
    }

    public List<BizPackage> getBizPackages() {
        return this.bizPackages;
    }

    public void setBizPackages(List<BizPackage> bizPackages) {
        this.bizPackages = bizPackages;
    }

    public void addBizPackage(BizPackage bizPackage) {
        this.bizPackages.add(bizPackage);
    }

    public BizPackage getCurBizPackage() {
        return this.curBizPackage;
    }

    public void setCurBizPackage(BizPackage curBizPackage) {
        this.curBizPackage = curBizPackage;
    }

    public BizWizardConfig getCurBizWizardCfg() {
        return this.curBizWizardCfg;
    }

    public void setCurBizWizardCfg(BizWizardConfig curBizWizardCfg) {
        this.curBizWizardCfg = curBizWizardCfg;
    }

    public DevNode getCurDevice() {
        return this.curDevice;
    }

    public void setCurDevice(DevNode curDevice) {
        this.curDevice = curDevice;
    }

    public JythonContext getJythonContext() {
        return this.jythonContext;
    }

    public void setJythonContext(JythonContext jythonContext) {
        this.jythonContext = jythonContext;
    }

    public Window getSelectProcessDialog() {
        return this.selectProcessDialog;
    }

    public void setSelectProcessDialog(Window selectProcessDialog) {
        this.selectProcessDialog = selectProcessDialog;
    }

    public boolean isSupportDev(DevNode dev) {
        for (PackProduct packProduct : this.packProducts) {
            if (!this.containDevNode(dev, packProduct)) continue;
            return true;
        }
        return false;
    }

    public boolean containDevNode(DevNode devNode, PackProduct packProduct) {
        if (!devNode.getDeviceType().toString().trim().equals(packProduct.getProductName().trim())) {
            return false;
        }
        for (String version : packProduct.getVersions()) {
            String devVersion;
            if (!Products.contains((String)version, (String)(devVersion = devNode.getProductVersion())) && !Products.contains((String)devVersion, (String)version)) continue;
            return true;
        }
        return false;
    }

    public List<PackProduct> getPackProducts() {
        return this.packProducts;
    }

    public void setPackProducts(List<PackProduct> packProducts) {
        this.packProducts = packProducts;
    }

    public List<String> getSupportTypes() {
        ArrayList<String> type = new ArrayList<String>();
        for (PackProduct product : this.packProducts) {
            type.add(product.getProductName());
        }
        return type;
    }

    public void addProducts(PackProduct packProduct) {
        boolean hasProductFlag = false;
        for (PackProduct product : this.packProducts) {
            if (!product.getProductName().equals(packProduct.getProductName())) continue;
            hasProductFlag = true;
            List<String> vers = product.getVersions();
            vers.addAll(packProduct.getVersions());
        }
        if (hasProductFlag) {
            return;
        }
        this.packProducts.add(this.getCopyProduct(packProduct));
    }

    private PackProduct getCopyProduct(PackProduct product) {
        PackProduct packProduct = new PackProduct();
        packProduct.setProductName(product.getProductName());
        List<String> list = product.getVersions();
        packProduct.setVersions(new ArrayList<String>(list));
        packProduct.setScript(product.getScript());
        packProduct.setParam(product.getParam());
        return packProduct;
    }

    public String getCurToolName() {
        return this.curToolName;
    }

    public void setCurToolName(String curToolName) {
        this.curToolName = curToolName;
    }

    public JDialog getWizard() {
        return this.wizard;
    }

    public void setWizard(JDialog wizard) {
        this.wizard = wizard;
    }

    public boolean isSingleDev() {
        return this.singleDev;
    }

    public void setSingleDev(boolean singleDev) {
        this.singleDev = singleDev;
    }

    public boolean isSelfDefine() {
        return this.selfDefine;
    }

    public void setSelfDefine(boolean selfDefine) {
        this.selfDefine = selfDefine;
    }

    public String getMainDialogTitle() {
        return this.mainDialogTitle;
    }

    public void setMainDialogTitle(String mainDialogTitle) {
        this.mainDialogTitle = mainDialogTitle;
    }

    public Window getSelectDeviceDialog() {
        return this.selectDeviceDialog;
    }

    public void setSelectDeviceDialog(Window selectDeviceDialog) {
        this.selectDeviceDialog = selectDeviceDialog;
    }

    public int getCurWizardStepNum() {
        return this.curWizardStepNum;
    }

    public void setCurWizardStepNum(int curWizardStepNum) {
        this.curWizardStepNum = curWizardStepNum;
    }

    public Map<String, AbstractBizStepLayout> getId2LayoutMap() {
        return this.id2LayoutMap;
    }

    public void setId2LayoutMap(Map<String, AbstractBizStepLayout> id2LayoutMap) {
        this.id2LayoutMap = id2LayoutMap;
    }

    public String getCurStepId() {
        return this.curStepId;
    }

    public void setCurStepId(String curStepId) {
        this.curStepId = curStepId;
    }

    public BizPackageUserOpData getBizpackageUserOpData() {
        if (null == this.bizpackageUserOpData) {
            this.bizpackageUserOpData = new BizPackageUserOpData();
        }
        return this.bizpackageUserOpData;
    }

    public List<BizPackageUserOpData> getUserOpDatas() {
        return this.userOpDatas;
    }

    public void saveUserOpData() {
        try {
            ArrayList<BizPackageUserOpData> userOpDataList = new ArrayList<BizPackageUserOpData>();
            if (null != this.userOpDatas) {
                for (BizPackageUserOpData data : this.userOpDatas) {
                    userOpDataList.add(data);
                }
                UserOpDataSaveUtil.batchSaveUserOpdata(userOpDataList);
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(BizPackageContext.class).error("Save useropdata error..");
        }
    }

    public void saveJythonUserOpData() {
        try {
            Map dynamicAttr = (Map)BizPackageContext.getInstance().getJythonContext().getDict().get("userOpData");
            if (null != dynamicAttr) {
                this.getBizpackageUserOpData().getDynamicAttr().putAll(dynamicAttr);
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(BizPackageContext.class).error("Get jython useropdata error..");
        }
    }

    public void saveOneUserOpData() {
        this.userOpDatas.add(this.bizpackageUserOpData);
        this.bizpackageUserOpData = null;
    }

    public IStep getCurrentStep() {
        FlowWizardDialog flowWizard;
        Flow flow;
        JDialog currentWizard = this.getWizard();
        if (currentWizard instanceof FlowWizardDialog && (flow = (flowWizard = (FlowWizardDialog)currentWizard).getFlow()) != null) {
            return flow.getCurStep();
        }
        if (currentWizard instanceof GuideFlowWizardDialog && (flow = (flowWizard = (GuideFlowWizardDialog)currentWizard).getFlow()) != null) {
            return flow.getCurStep();
        }
        return null;
    }

    public List<DmeNode> getA800ZoneNodeList() {
        return this.a800ZoneNodeList;
    }

    public void setA800ZoneNodeList(List<DmeNode> a800ZoneNodeList) {
        this.a800ZoneNodeList = a800ZoneNodeList;
    }

    public SettingContentPanel.ConfirmSwitch getCheckRiskPowerSwitch() {
        return this.checkRiskPowerSwitch;
    }

    public void setCheckRiskPowerSwitch(SettingContentPanel.ConfirmSwitch checkRiskPowerSwitch) {
        this.checkRiskPowerSwitch = checkRiskPowerSwitch;
    }
}

