/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.entity.item;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.bizpack.wizardparse.entity.item.ItemResult;
import com.huawei.ism.tool.bizpack.wizardparse.util.PackagesResource;
import com.huawei.ism.tool.pyengine.psdk.bean.CheckConfigItem;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;

public class Item {
    private String date;
    private String desc;
    private boolean showDetail = false;
    private Map<String, String> resultIconPath;
    private ItemResult result;
    private String id = "";
    private String title = "";
    private String scriptName = "";
    private String param = "";
    private boolean mustSucc = false;
    private String reason = "";
    private String suggest = "";
    private CheckConfigItem configItem;
    private String remainTime = "";
    private String progress = "--";
    private int totMinutes = 0;

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getSuggest() {
        return this.suggest;
    }

    public void setSuggest(String suggest) {
        this.suggest = suggest;
    }

    public String getRemainTime() {
        return this.remainTime;
    }

    public void setRemainTime(String remainTime) {
        this.remainTime = remainTime;
    }

    public String getProgress() {
        return this.progress;
    }

    public void setProgress(String progress) {
        this.progress = progress;
    }

    public int getTotMinutes() {
        return this.totMinutes;
    }

    public void setTotMinutes(int totMinutes) {
        this.totMinutes = totMinutes;
    }

    public boolean isShowDetail() {
        return this.showDetail;
    }

    public void setShowDetail(boolean showDetail) {
        this.showDetail = showDetail;
    }

    public Item() {
        HashMap<String, String> resIconPath = new HashMap<String, String>();
        resIconPath.put(ItemResult.PASS.toString(), "success.gif");
        resIconPath.put(ItemResult.NOT_PASS.toString(), "failed.gif");
        resIconPath.put(ItemResult.SUCCEED.toString(), "success.gif");
        resIconPath.put(ItemResult.FAILED.toString(), "failed.gif");
        resIconPath.put(ItemResult.LOADING.toString(), "loading.gif");
        resIconPath.put(ItemResult.CHECKING.toString(), "loading.gif");
        resIconPath.put(ItemResult.EXECUTING.toString(), "loading.gif");
        this.setResultIconPath(resIconPath);
        this.setDate(new Date());
    }

    public Item(String title, ItemResult result) {
        this.result = result;
        this.title = title;
    }

    public String toString() {
        return "Item [date=" + this.date + ", desc=" + this.desc + ", id=" + this.id + ", mustSucc=" + this.mustSucc + ", param=" + this.param + ", result=" + (Object)((Object)this.result) + ", title=" + this.title + "]";
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(Date date2) {
        this.date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date2);
    }

    public void setDate(String date2) {
        this.date = date2;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public Map<String, String> getResultIconPath() {
        return this.resultIconPath;
    }

    protected void setResultIconPath(Map<String, String> resultIconPath) {
        this.resultIconPath = resultIconPath;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescRes(PackagesResource resource) {
        if (this.configItem != null) {
            return this.configItem.getName();
        }
        return resource.getString(this.getDesc());
    }

    public String getTitleRes(PackagesResource resource) {
        if (this.configItem != null) {
            return this.configItem.getName();
        }
        return resource.getString(this.getTitle());
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setResult(ItemResult result) {
        this.result = result;
    }

    public ItemResult getResult() {
        return this.result;
    }

    public ImageIcon getImageIcon() {
        if (null == this.result) {
            return null;
        }
        String path = this.getResultIconPath().get(this.result.toString());
        return ResourceUtil.getImage(path);
    }

    public String getScriptName() {
        return this.scriptName;
    }

    public void setScriptName(String scriptName) {
        this.scriptName = scriptName;
    }

    public String getParam() {
        return this.param;
    }

    public void setParam(String param) {
        this.param = param;
    }

    public void setMustSucc(boolean mustSucc) {
        this.mustSucc = mustSucc;
    }

    public boolean isMustSucc() {
        return this.mustSucc;
    }

    public CheckConfigItem getConfigItem() {
        return this.configItem;
    }

    public void setConfigItem(CheckConfigItem configItem) {
        this.configItem = configItem;
    }
}

