/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.intf;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.bizpack.BizPackage;
import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.intf.IBizPackageProcessUI;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.SelectDeviceDialog;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.waitdialog.ParseAllProductsWaitDialog;
import com.huawei.ism.tool.bizpack.wizardparse.util.BizPackageSceneUtils;
import com.huawei.ism.tool.bizpack.wizardparse.util.DevNodeUtil;
import com.huawei.ism.tool.bizpack.wizardparse.util.DeviceOptionUtil;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.ism.tool.framework.pubservice.PublicServiceManage;
import com.huawei.ism.tool.framework.pubservice.common.IDeviceManage;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubui.PublicUiManage;
import com.huawei.ism.tool.framework.pubui.common.IDeviceManageUI;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.util.SwingUtil;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BizPackageProcessUIImpl
implements IBizPackageProcessUI {
    private static final Logger log = LoggerFactory.getLogger(BizPackageProcessUIImpl.class);

    public BizPackageProcessUIImpl(String runningTool) {
        BizPackageContext.getInstance().setCurToolName(runningTool);
        this.init();
    }

    public void init() {
        this.disableHttpLog();
    }

    private void disableHttpLog() {
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.SimpleLog");
        System.setProperty("org.apache.commons.logging.simplelog.showdatetime", "true");
        System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.commons.httpclient", "stdout,basefile");
    }

    public void showBizWizard(BizPackage bizPackage, DevNode dev) {
    }

    @Override
    public void showSelectDeviceDialog(boolean singleDevice) {
        try {
            BizPackageContext.getInstance().setSingleDev(singleDevice);
            String selfDefine = ApplicationContext.getInstance().getAppConfig("tool.selfdefine.mode.enabled");
            if (selfDefine.trim().equalsIgnoreCase("true")) {
                BizPackageContext.getInstance().setSelfDefine(true);
            }
            SelectDeviceDialog sddialog = new SelectDeviceDialog(null);
            sddialog.loadProducts();
            SwingUtil.putScreenCenter((Window)sddialog);
            sddialog.setVisible(true);
            sddialog.setResizable(false);
            BizPackageContext.getInstance().setSelectDeviceDialog(sddialog);
            sddialog.requestFocus();
        }
        catch (Exception e) {
            log.error("error happen while execute.", (Throwable)e);
        }
    }

    @Override
    public void showSelectWizardDialog() {
        DevNode devNode;
        try {
            List fs = AsyncExcutor.execute((Window)null, (Callable[])new Callable[]{new ParseAllProductsWaitDialog()});
            Boolean markSign = (Boolean)fs.get(0);
            if (!markSign.booleanValue()) {
                DialogUtils.showErrorDialog(null, (String)ResourceUtil.getString("bizpackage.error.parseproductsfailed"));
                this.hanldeSceneToolStartFailed();
                return;
            }
        }
        catch (Exception e) {
            log.error("loadProducts faild", (Throwable)e);
            DialogUtils.showErrorDialog(null, (String)ResourceUtil.getString("bizpackage.error.parseproductsfailed"));
            this.hanldeSceneToolStartFailed();
            return;
        }
        List<DevNode> devNodeList = this.getDevManagerList();
        DevNode devNode2 = devNode = devNodeList.isEmpty() ? null : devNodeList.get(0);
        if (devNode == null || !DevNodeUtil.matchingBizpackage(devNode)) {
            DialogUtils.showErrorDialog(null, (String)ResourceUtil.getString("bizpackage.supportdialog.error.notSupport"));
            log.info("Select device {} failed. matching Bizpackage failed.", (Object)(null != devNode ? devNode.getIp() : null));
            this.hanldeSceneToolStartFailed();
            return;
        }
        DevNode requestNode = DeviceOptionUtil.transToRequestNode(devNode);
        if (DeviceOptionUtil.isNeedSetZoneInfos(devNode)) {
            BizPackageContext.getInstance().getJythonContext().getDict().put("zone_ids", DeviceOptionUtil.getAllZoneIds(devNode, false));
            DeviceOptionUtil.findDmeNode(devNode).ifPresent(aiDevNode -> BizPackageContext.getInstance().getJythonContext().getDict().put("dme_node", aiDevNode));
            DeviceOptionUtil.findA800Node(requestNode).ifPresent(a800Node -> BizPackageContext.getInstance().getJythonContext().getDict().put("a800_node", a800Node));
            BizPackageContext.getInstance().setA800ZoneNodeList(DeviceOptionUtil.getAllZoneNodes(devNode, true));
        }
        BizPackageContext.getInstance().getJythonContext().getDict().put("devNode0", requestNode);
        BizPackageContext.getInstance().getJythonContext().getDict().put("dev", DevNodeUtil.getDevMapDict(requestNode));
        BizPackageContext.getInstance().getJythonContext().setDevNode(requestNode);
        BizPackageContext.getInstance().setCurDevice(requestNode);
        DevNodeUtil.parseAndBuildDialog(null);
    }

    private void hanldeSceneToolStartFailed() {
        if (BizPackageSceneUtils.isScene()) {
            String toolId = BizPackageContext.getInstance().getCurToolName();
            ApplicationContext.getInstance().fireToolStopped(toolId);
        }
    }

    public List<DevNode> getDevManagerList() {
        IDeviceManage devMng = PublicServiceManage.getInstance().getService(IDeviceManage.class);
        if (devMng == null) {
            log.error("get DeviceManage =NULL");
            return Collections.emptyList();
        }
        List<DevNode> devs = SceneUtils.isA800SceneInTool() ? DeviceOptionUtil.getSelectNodes() : devMng.getNodeList();
        log.info("devs num={}", (Object)devs.size());
        BizPackageContext context = BizPackageContext.getInstance();
        Iterator<DevNode> iter = devs.iterator();
        while (iter.hasNext()) {
            DevNode dev = iter.next();
            log.info("devs ip={}", (Object)dev.getIp());
            if (!context.isSupportDev(dev)) {
                log.info("devs ip={} is ignored", (Object)dev.getIp());
                iter.remove();
                if (!devMng.deleteOneDevice(dev.getIp())) {
                    log.error("not support and delete one device[{}] in devMng failed", (Object)dev.getIp());
                }
            }
            this.handleNodeAddedBySshForwardingOrSocks(devMng, iter, dev);
        }
        return devs;
    }

    public void handleNodeAddedBySshForwardingOrSocks(IDeviceManage devMng, Iterator<DevNode> iter, DevNode dev) {
        IDeviceManageUI connUi;
        boolean flag;
        boolean isDevSocks5 = dev.getSocks5Proxy() != null;
        boolean isDevSsh = dev.getSshForwardList() != null && !dev.getSshForwardList().isEmpty();
        ArrayList failRet = new ArrayList();
        HashMap<String, String> failMap = new HashMap<String, String>();
        String toolName = UserOpDataSaveUtil.getToolIniProp("tool.name");
        if (toolName == null) {
            toolName = "";
        }
        log.info("Current tool:{}", (Object)toolName);
        boolean isFruTool = UserOpDataSaveUtil.FRU_TOOL_NAMES.contains(toolName.toUpperCase(Locale.ENGLISH));
        if (!isFruTool && (isDevSocks5 || isDevSsh)) {
            String errorMes;
            String string = errorMes = isDevSocks5 ? ResourceUtil.getString("devicemanager.layout.device.errormsg.reason.socket5") : "";
            if (errorMes.equals("")) {
                errorMes = ResourceUtil.getString("devicemanager.layout.device.errormsg.reason.ssh");
            }
            ArrayList<String> tmp = new ArrayList<String>();
            tmp.add(dev.getIp());
            tmp.add(errorMes);
            failRet.add(tmp);
            failMap.put(dev.getIp(), errorMes);
            iter.remove();
            if (!devMng.deleteOneDevice(dev.getIp())) {
                log.error("socket one device[{}] in devMng failed", (Object)dev.getIp());
            }
        }
        if (!failRet.isEmpty() && !(flag = (connUi = PublicUiManage.getInstance().getUi(IDeviceManageUI.class)).showMultiInfoDialog(null, ResourceUtil.getString("devicemanager.layout.device.import.deviceadddialog.batcherror"), new String[]{ResourceUtil.getString("devicemanager.layout.device.errormsg.ip"), ResourceUtil.getString("devicemanager.layout.device.errormsg.reason")}, failMap))) {
            log.error("show add device dialog err.");
        }
    }

    public void showSelectWizardDialog(BizPackage bizPackage, DevNode dev) {
    }
}

