/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.waitdialog;

import com.huawei.ism.autotest.AutoProcessConfig;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.context.JythonContext;
import com.huawei.ism.tool.bizpack.wizardparse.entity.BizStepConfig;
import com.huawei.ism.tool.bizpack.wizardparse.entity.BizWizardConfig;
import com.huawei.ism.tool.bizpack.wizardparse.task.ExecPyScriptTask;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.waitdialog.WaitDialogResult;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.group.GroupStepCfg;
import com.huawei.ism.tool.bizpack.wizardparse.util.PackagesResource;
import com.huawei.ism.tool.framework.platform.exception.SignException;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.ism.tool.obase.utils.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BuildOneProcessWaitDialog
implements Callable<WaitDialogResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildOneProcessWaitDialog.class);
    private static final String FLOW_XML = "Flow.xml";
    private static final String STEPDEFINE_XML = "StepDefine.xml";
    private static final String PROCESS = "Process";
    private static final String FLOW_CFG = "flow-config";
    private static final String FLOW_ELEMS = "flow-elems";
    private static final String XML_VER = "1.0";
    private static final String FLOW = "flow";
    private static final String SUB_FLOW = "sub-flow";
    private static final String RESOURCE = "resource";
    private static final String TITLE = "title";
    private static final String HELP = "help";
    private static final String STEP = "step";
    private static final String ID = "id";
    private static final String AUTO = "isAuto";
    private static final String CONDITION = "condition";
    private static final String CONDITION_ID = "stepCondition";
    private static final String NAME = "name";
    private static final String DESC = "desc";
    private static final String IMPL_CLAZZ = "implClazz";
    private static final String UNDER_LINE = "_";
    private static final String STEP_ID_SEP = ",";
    private static final String INIT_EXEC = "execute";
    private static final String CON_CLAZZ = "com.huawei.ism.tool.bizpack.wizardparse.ui.condition.StepCondition";
    private static final int INVALID_STEP_NUM = -1;
    private List<String> runStepIdList = new ArrayList<String>();
    private WaitDialogResult result = new WaitDialogResult();

    @Override
    public WaitDialogResult call() {
        try {
            BizWizardConfig curBizWizardCfg = BizPackageContext.getInstance().getCurBizWizardCfg();
            JythonContext ssEnv = BizPackageContext.getInstance().getJythonContext();
            ssEnv.getDict().put("runStepIdList", "");
            this.runStepIdList.clear();
            BizPackageContext.getInstance().setCurWizardStepNum(-1);
            if (this.execInitScript(curBizWizardCfg.getIniScriptName(), curBizWizardCfg.getIniScriptParam())) {
                if (!((Boolean)ssEnv.getDict().get("succ")).booleanValue()) {
                    String errText = (String)ssEnv.getDict().get("errMsg");
                    this.result.setFlag(false);
                    this.result.setErrMsg(errText);
                    return this.result;
                }
                String runStepStr = (String)ssEnv.getDict().get("runStepIdList");
                if (!StringUtils.isNULLStr(runStepStr)) {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("chg 2 idlist mode,runStepStr = " + runStepStr);
                    }
                    this.runStepIdList = this.getStepIdList(runStepStr);
                    this.filterAutoProcessSteps(curBizWizardCfg.getTitle(), this.runStepIdList);
                    BizPackageContext.getInstance().setCurWizardStepNum(this.runStepIdList.size());
                }
            } else {
                return this.result;
            }
            if (this.checkFileUtil(curBizWizardCfg)) {
                return this.result;
            }
        }
        catch (Exception e) {
            LOGGER.error("Load Process Failed ", (Throwable)e);
            this.result.setFlag(false);
            return this.result;
        }
        this.result.setFlag(true);
        return this.result;
    }

    boolean checkFileUtil(BizWizardConfig curBizWizardCfg) {
        StringBuilder xmlUperPath = new StringBuilder();
        xmlUperPath.append(ApplicationContext.getInstance().getWorkPath());
        xmlUperPath.append(File.separator);
        xmlUperPath.append(ApplicationContext.getInstance().getTmpPath());
        xmlUperPath.append(File.separator);
        xmlUperPath.append(PROCESS);
        File uperPath = new File(xmlUperPath.toString());
        if (!uperPath.exists() && !uperPath.mkdirs()) {
            this.result.setFlag(false);
            return true;
        }
        FileUtils.deleteAllInFolder((String)xmlUperPath.toString());
        String flowXmlPath = xmlUperPath.toString() + File.separator + FLOW_XML;
        String stepDefineXmlPath = xmlUperPath.toString() + File.separator + STEPDEFINE_XML;
        this.buildStepDefineXml(stepDefineXmlPath, curBizWizardCfg);
        this.buildFlowXml(flowXmlPath, curBizWizardCfg);
        curBizWizardCfg.setStepDefineXmlPath(stepDefineXmlPath);
        curBizWizardCfg.setFlowXmlPath(flowXmlPath);
        return false;
    }

    private void filterAutoProcessSteps(String processTitle, List<String> stepIds) {
        if (!UserOpDataSaveUtil.isAutoTestEnv()) {
            return;
        }
        AutoProcessConfig config = AutoProcessConfig.getInstance();
        PackagesResource resource = BizPackageContext.getInstance().getCurBizPackage().getResUtil();
        String processName = resource.getString(processTitle);
        List autoStepIds = (List)config.getProcessSteps().get(processName);
        if (autoStepIds == null) {
            return;
        }
        for (int i = stepIds.size() - 1; i >= 0; --i) {
            String stepId = stepIds.get(i);
            if (autoStepIds.contains(stepId)) continue;
            stepIds.remove(i);
        }
    }

    private List<String> getStepIdList(String stepStrs) {
        String[] ids = stepStrs.split(STEP_ID_SEP);
        ArrayList<String> idList = new ArrayList<String>();
        for (String stepid : ids) {
            if (StringUtils.isNULLStr(stepid)) continue;
            idList.add(stepid.trim());
            if (!LOGGER.isInfoEnabled()) continue;
            LOGGER.info("add step id:" + stepid);
        }
        return idList;
    }

    private boolean execInitScript(String pyName, String param) {
        JythonContext ssEnv = BizPackageContext.getInstance().getJythonContext();
        ssEnv.clearMsgData();
        String processPath = this.getScriptPath();
        ssEnv.getDict().put("importRootDir", processPath);
        try {
            ExecPyScriptTask pyTask = new ExecPyScriptTask(processPath, pyName);
            if (pyTask.execFunc(INIT_EXEC, param)) {
                return true;
            }
            this.result.setFlag(false);
            this.result.setErrMsg(ResourceUtil.getString(""));
            return false;
        }
        catch (FileNotFoundException e) {
            LOGGER.error("jython File not found.");
            this.result.setFlag(false);
            this.result.setException(new FileNotFoundException("file not found."));
            return false;
        }
        catch (SignException e) {
            LOGGER.error("python file has no sign", (Throwable)e);
            this.result.setFlag(false);
            this.result.setException(e);
            return false;
        }
        catch (Exception e) {
            LOGGER.error("jython exec err", (Throwable)e);
            this.result.setFlag(false);
            this.result.setException(e);
            return false;
        }
    }

    private boolean buildStepDefineXml(String xmlPath, BizWizardConfig cfg) {
        return this.buildXml(xmlPath, cfg, FLOW_ELEMS);
    }

    private boolean buildFlowXml(String xmlPath, BizWizardConfig cfg) {
        return this.buildXml(xmlPath, cfg, FLOW_CFG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean buildXml(String xmlPath, BizWizardConfig cfg, String rootName) {
        block11: {
            FileOutputStream out = null;
            try {
                Document document = XmlUtils.newDocumentBuilder().newDocument();
                document.setXmlVersion(XML_VER);
                Element root = document.createElement(rootName);
                document.appendChild(root);
                if (FLOW_CFG.equals(rootName)) {
                    this.buildFlowElement(root, cfg, document);
                } else {
                    this.buildStepDefineElement(root, cfg, document);
                }
                Transformer transFormer = XmlUtils.newTransformer();
                transFormer.setOutputProperty("encoding", "utf-8");
                DOMSource domSource = new DOMSource(document);
                File file = new File(xmlPath);
                if (!file.exists() && !file.createNewFile()) {
                    boolean bl = false;
                    StreamUtils.closeStream(out, null);
                    return bl;
                }
                out = new FileOutputStream(file);
                StreamResult xmlResult = new StreamResult(out);
                transFormer.transform(domSource, xmlResult);
                StreamUtils.closeStream(out, null);
            }
            catch (IOException e) {
                LOGGER.error("create new Flow.XML Failed", (Throwable)e);
            }
            catch (Exception e2) {
                LOGGER.error("Build Flow.XML Failed", (Throwable)e2);
                break block11;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                StreamUtils.closeStream(out, null);
            }
        }
        return true;
    }

    private void buildFlowElement(Element root, BizWizardConfig cfg, Document document) {
        PackagesResource util = BizPackageContext.getInstance().getCurBizPackage().getResUtil();
        List<BizStepConfig> steps = this.getStepCfgList(cfg.getSteps());
        Element flow = document.createElement(FLOW);
        flow.setAttribute(TITLE, cfg.getWizardTitle());
        flow.setAttribute(HELP, cfg.getHelpPath());
        for (BizStepConfig bizStepConfig : steps) {
            if (bizStepConfig instanceof GroupStepCfg) {
                this.createSubStepGroupFlow(document, flow, bizStepConfig);
                continue;
            }
            this.createStepFlow(document, flow, bizStepConfig);
        }
        Element res = document.createElement(RESOURCE);
        for (BizStepConfig step : steps) {
            if (step instanceof GroupStepCfg) {
                this.createSubStepGroupRes(document, util, res, step);
                continue;
            }
            this.createStepRes(document, util, res, step);
        }
        Element element = document.createElement(TITLE);
        element.setAttribute(ID, cfg.getWizardTitle());
        res.appendChild(element);
        Element nameZh = document.createElement("nameZh");
        nameZh.setTextContent(util.getString(cfg.getWizardTitle(), Locale.CHINESE));
        Element nameEn = document.createElement("nameEn");
        nameEn.setTextContent(util.getString(cfg.getWizardTitle(), Locale.ENGLISH));
        Element descZh = document.createElement("descZh");
        descZh.setTextContent(util.getString(cfg.getDescription(), Locale.CHINESE));
        Element descEn = document.createElement("descEn");
        descEn.setTextContent(util.getString(cfg.getDescription(), Locale.ENGLISH));
        element.appendChild(nameZh);
        element.appendChild(nameEn);
        element.appendChild(descZh);
        element.appendChild(descEn);
        root.appendChild(flow);
        root.appendChild(res);
    }

    private List<BizStepConfig> getStepCfgList(List<BizStepConfig> steps) {
        if (this.runStepIdList.isEmpty()) {
            return steps;
        }
        ArrayList<BizStepConfig> bizStepConfigs = new ArrayList<BizStepConfig>();
        for (String bizStepId : this.runStepIdList) {
            BizStepConfig cfg = this.getStepCfgById(steps, bizStepId);
            if (null == cfg) {
                LOGGER.error("get Step Cfg By Id error.cfg id=" + bizStepId);
                continue;
            }
            bizStepConfigs.add(cfg);
        }
        return bizStepConfigs;
    }

    private BizStepConfig getStepCfgById(List<BizStepConfig> steps, String id) {
        for (BizStepConfig cfg : steps) {
            String cfgId = cfg.getId();
            if (!cfgId.trim().equals(id.trim())) continue;
            return cfg;
        }
        return null;
    }

    private void createSubStepGroupFlow(Document document, Element flow, BizStepConfig step) {
        GroupStepCfg groupStepCfg = (GroupStepCfg)step;
        String title = groupStepCfg.getTitle();
        Element subFlowElement = document.createElement(SUB_FLOW);
        subFlowElement.setAttribute(TITLE, "title_" + title);
        List<BizStepConfig> subSteps = groupStepCfg.getSubStepList();
        for (BizStepConfig subStep : subSteps) {
            this.createStepFlow(document, subFlowElement, subStep);
        }
        flow.appendChild(subFlowElement);
    }

    private void createSubStepGroupRes(Document document, PackagesResource util, Element res, BizStepConfig step) {
        this.createStepRes(document, util, res, step);
        GroupStepCfg groupStepCfg = (GroupStepCfg)step;
        List<BizStepConfig> subSteps = groupStepCfg.getSubStepList();
        for (BizStepConfig subStep : subSteps) {
            this.createStepRes(document, util, res, subStep);
        }
    }

    private void createStepRes(Document document, PackagesResource util, Element res, BizStepConfig step) {
        Element titleElement = document.createElement(TITLE);
        titleElement.setAttribute(ID, "title_" + step.getTitle());
        res.appendChild(titleElement);
        Element nameZh = document.createElement("nameZh");
        nameZh.setTextContent(util.getString(step.getTitle(), Locale.CHINESE));
        Element nameEn = document.createElement("nameEn");
        nameEn.setTextContent(util.getString(step.getTitle(), Locale.ENGLISH));
        Element descZh = document.createElement("descZh");
        descZh.setTextContent(util.getString(step.getDescription(), Locale.CHINESE));
        Element descEn = document.createElement("descEn");
        descEn.setTextContent(util.getString(step.getDescription(), Locale.ENGLISH));
        titleElement.appendChild(nameZh);
        titleElement.appendChild(nameEn);
        titleElement.appendChild(descZh);
        titleElement.appendChild(descEn);
    }

    private void createStepFlow(Document document, Element flow, BizStepConfig step) {
        Element stepElement = document.createElement(STEP);
        stepElement.setAttribute(TITLE, "title_" + step.getTitle());
        stepElement.setAttribute(NAME, step.getTitle());
        stepElement.setAttribute(ID, step.getId());
        if (step.isAuto()) {
            stepElement.setAttribute(AUTO, "true");
        }
        if (step.getConditionCfg().isHasCondition()) {
            stepElement.setAttribute(CONDITION, CONDITION_ID);
        }
        flow.appendChild(stepElement);
    }

    private void buildStepDefineElement(Element root, BizWizardConfig cfg, Document document) {
        List<BizStepConfig> steps = this.getStepCfgList(cfg.getSteps());
        this.createDefineList(root, document, steps);
    }

    private void createDefineList(Element root, Document document, List<BizStepConfig> steps) {
        boolean hasStepCondition = false;
        for (BizStepConfig step : steps) {
            if (step instanceof GroupStepCfg) {
                this.buildSubStepDefine(root, step, document);
                continue;
            }
            Element stepElement = document.createElement(STEP);
            stepElement.setAttribute(NAME, step.getTitle());
            stepElement.setAttribute(IMPL_CLAZZ, step.getStepClazPathName());
            stepElement.setAttribute(DESC, step.getDescription());
            root.appendChild(stepElement);
            if (!step.getConditionCfg().isHasCondition()) continue;
            hasStepCondition = true;
        }
        if (hasStepCondition) {
            Element conditionElement = document.createElement(CONDITION);
            conditionElement.setAttribute(NAME, CONDITION_ID);
            conditionElement.setAttribute(IMPL_CLAZZ, CON_CLAZZ);
            conditionElement.setAttribute(DESC, "");
            root.appendChild(conditionElement);
        }
    }

    private void buildSubStepDefine(Element root, BizStepConfig step, Document document) {
        GroupStepCfg groupStepCfg = (GroupStepCfg)step;
        this.createDefineList(root, document, groupStepCfg.getSubStepList());
    }

    public void delFolder(String folderPath) {
        try {
            FileUtils.deleteAllInFolder((String)folderPath);
            String filePath = folderPath;
            File myFilePath = new File(filePath);
            if (myFilePath.delete()) {
                return;
            }
        }
        catch (Exception e) {
            LOGGER.error("delFolder failed.", (Throwable)e);
        }
    }

    private String getScriptPath() {
        String packPath = BizPackageContext.getInstance().getCurBizPackage().getAbsolutPath();
        StringBuilder scriptPath = new StringBuilder();
        scriptPath.append(packPath);
        scriptPath.append(File.separator);
        scriptPath.append(PROCESS);
        return scriptPath.toString();
    }
}

