/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.step;

import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.ui.wizard.FlowWizardCardLayout;
import com.huawei.ism.tool.base.utils.DateUtil;
import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.entity.BizStepConfig;
import com.huawei.ism.tool.bizpack.wizardparse.util.AutomateUtils;
import com.huawei.ism.tool.framework.pubui.common.ui.AbstractDeviceGraph;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Date;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;

public class AbstractBizStepLayout
extends FlowWizardCardLayout {
    private static final long serialVersionUID = -3835125972621876591L;
    private static final int BORDER_SIZE = 20;
    private static final int GAP_SIZE = 50;
    private JComponent leftPanel;
    private JComponent topPanel;
    private JComponent middlePanel;
    private JComponent bottomPanel;
    private JPanel rightPanel;
    private JScrollPane devGraphPane;
    private AbstractDeviceGraph devGraph;
    private BizStepConfig cfg;

    protected void initDevGraphPanel(Dimension size) {
        this.devGraphPane = new JScrollPane();
        this.rightPanel = new JPanel();
        UiMethod.setComponentSize((Dimension)size, (Component[])new Component[]{this.devGraphPane});
        this.rightPanel.add(this.devGraphPane);
        this.setCompName();
    }

    protected void initMiddleDevGraphPanel(Dimension size) {
        this.devGraphPane = new JScrollPane();
        this.middlePanel = new JPanel();
        UiMethod.setComponentSize((Dimension)size, (Component[])new Component[]{this.devGraphPane});
        this.middlePanel.add(this.devGraphPane);
        this.setCompName();
    }

    private void setCompName() {
        AutomateUtils.setNameAttribute(this.leftPanel, "leftPanel");
        AutomateUtils.setNameAttribute(this.rightPanel, "rightPanel");
        AutomateUtils.setNameAttribute(this.devGraphPane, "devGraphPane");
        AutomateUtils.setNameAttribute(this.middlePanel, "devGraphPane");
    }

    protected void initLayoutWithDevGraph() {
        if (null == this.leftPanel || null == this.rightPanel) {
            return;
        }
        JComponent view = UCD.buildHorizotalBox(null, (Component[])new Component[]{this.leftPanel, Box.createHorizontalStrut(18), this.rightPanel});
        this.setLayout(new BorderLayout());
        this.add(UiMethod.buildFrameSpace((JComponent)view, (int)20), "Center");
    }

    protected void initLayoutWithDevGraphInMiddle() {
        boolean isBottomPannelNull;
        boolean isTopPannelNull = null == this.topPanel;
        boolean bl = isBottomPannelNull = null == this.bottomPanel;
        JComponent view = isTopPannelNull && !isBottomPannelNull ? UCD.buildVerticalBox(null, (Component[])new Component[]{this.middlePanel, this.bottomPanel, Box.createHorizontalStrut(4)}) : (!isTopPannelNull && isBottomPannelNull ? UCD.buildVerticalBox(null, (Component[])new Component[]{this.topPanel, Box.createHorizontalStrut(8), this.middlePanel, Box.createHorizontalStrut(8)}) : (isTopPannelNull && isBottomPannelNull ? UCD.buildVerticalBox(null, (Component[])new Component[]{Box.createHorizontalStrut(8), this.middlePanel, Box.createHorizontalStrut(8)}) : UCD.buildVerticalBox(null, (Component[])new Component[]{this.topPanel, Box.createHorizontalStrut(8), this.middlePanel, Box.createHorizontalStrut(8), this.bottomPanel})));
        this.setLayout(new BorderLayout());
        this.add(UiMethod.buildFrameSpace((JComponent)view, (int)10));
    }

    protected void setViewInLayout(BizStepConfig bizCfg, JComponent view, boolean isCenter) {
        boolean isDevGraphMiddle;
        BizPackageContext.getInstance().getBizpackageUserOpData().getEachStepStartTime().put(bizCfg.getId(), String.valueOf(DateUtil.toBeiJingTimeMillis(new Date())));
        Map<String, Object> allAttributesMap = this.cfg.getAllAtributeMap();
        boolean bl = isDevGraphMiddle = null != allAttributesMap && allAttributesMap.getOrDefault("graphLoc", "").equals("middle");
        if (bizCfg.isNeedDeviceGraph()) {
            if (!isDevGraphMiddle) {
                this.setLeftPanel(view);
                this.initDevGraphPanel(bizCfg.getDevGraphSize());
                this.initLayoutWithDevGraph();
            } else {
                this.bottomPanel = view;
                this.initMiddleDevGraphPanel(bizCfg.getDevGraphSize());
                this.initLayoutWithDevGraphInMiddle();
            }
        } else {
            this.setLayout(new BorderLayout());
            if (isCenter) {
                this.add(UiMethod.buildFrameSpace((JComponent)view, (int)20), "Center");
            } else {
                this.add(UiMethod.buildFrameSpace((JComponent)view, (int)20));
            }
        }
    }

    protected int getRealWidthLimit(int oldWidthLimit) {
        if (null != this.cfg && this.cfg.isNeedDeviceGraph()) {
            return this.cfg.getDevGraphSize().width + oldWidthLimit + 50;
        }
        return oldWidthLimit;
    }

    protected void setJLabelText(JLabel label, String text, int widthLimit) {
        int realWidthLimit = this.getRealWidthLimit(widthLimit);
        Dimension wizardSize = this.getBizCfg().getWizardSize();
        if (wizardSize == null) {
            wizardSize = BizPackageContext.getInstance().getCurBizWizardCfg().getWizardSize();
        }
        int maxWidth = wizardSize.width - realWidthLimit;
        label.setText("<html>" + text + "</html>");
        View htmlView = BasicHTML.createHTMLView(label, label.getText());
        htmlView.setSize(maxWidth, 2.1474836E9f);
        int htmlViewHeight = (int)htmlView.getMinimumSpan(1);
        label.setPreferredSize(new Dimension(maxWidth, htmlViewHeight));
    }

    public JScrollPane getDevGraphPane() {
        return this.devGraphPane;
    }

    public void setDevGraphPane(JScrollPane devGraphPane) {
        this.devGraphPane = devGraphPane;
    }

    public AbstractDeviceGraph getDevGraph() {
        return this.devGraph;
    }

    public void setDevGraph(AbstractDeviceGraph devGraph) {
        this.devGraph = devGraph;
    }

    protected JComponent getLeftPanel() {
        return this.leftPanel;
    }

    protected void setLeftPanel(JComponent leftPanel) {
        this.leftPanel = leftPanel;
    }

    protected void setBizCfg(BizStepConfig bizCfg) {
        this.cfg = bizCfg;
    }

    public JComponent getTopPanel() {
        return this.topPanel;
    }

    public void setTopPanel(JComponent topPanel) {
        this.topPanel = topPanel;
    }

    public JComponent getBottomPanel() {
        return this.bottomPanel;
    }

    public void setBottomPanel(JComponent bottomPanel) {
        this.bottomPanel = bottomPanel;
    }

    protected BizStepConfig getBizCfg() {
        return this.cfg;
    }
}

