/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.step.detect;

import com.huawei.ism.autotest.AutoProcessConfig;
import com.huawei.ism.autotest.AutoProcessItem;
import com.huawei.ism.autotest.AutoProcessResult;
import com.huawei.ism.autotest.AutoProcessStatus;
import com.huawei.ism.tool.base.ui.component.jlist.ListItemType;
import com.huawei.ism.tool.base.ui.component.jlist.StepListItem;
import com.huawei.ism.tool.base.ui.task.ServiceTask;
import com.huawei.ism.tool.base.ui.task.ServiceTaskExecutor;
import com.huawei.ism.tool.base.ui.task.TaskResult;
import com.huawei.ism.tool.base.ui.wizard.FlowWizardCardLayout;
import com.huawei.ism.tool.base.ui.wizard.FlowWizardDialog;
import com.huawei.ism.tool.base.ui.wizard.FlowWizardState;
import com.huawei.ism.tool.base.ui.wizard.GuideFlowWizardDialog;
import com.huawei.ism.tool.base.ui.wizard.Navigation;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.context.JythonContext;
import com.huawei.ism.tool.bizpack.wizardparse.entity.BizStepConfig;
import com.huawei.ism.tool.bizpack.wizardparse.entity.item.ItemResult;
import com.huawei.ism.tool.bizpack.wizardparse.intf.IDevgGraphInit;
import com.huawei.ism.tool.bizpack.wizardparse.task.ExecPyScriptTask;
import com.huawei.ism.tool.bizpack.wizardparse.task.ExecPyUtils;
import com.huawei.ism.tool.bizpack.wizardparse.task.TaskManager;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.AbstractBizStep;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.detect.DetectStepCfg;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.detect.DetectStepLayout;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.detect.comp.DetectItem;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.detect.intf.IDetectItemUiObserver;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.detect.task.ExecDetectItemTask;
import com.huawei.ism.tool.framework.platform.exception.SignException;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONObject;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetectStep
extends AbstractBizStep
implements IDevgGraphInit,
IDetectItemUiObserver {
    private static final Logger log = LoggerFactory.getLogger(DetectStep.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(DetectStep.class);
    private DetectStepLayout detectLayout;
    private DetectStepCfg cfg;
    private ExecPyScriptTask task = null;
    private String execParam = "";
    private boolean finish = true;
    private List<DetectItem> detectItems = new ArrayList<DetectItem>();
    private Map<Integer, String> index2SecondItemId = new HashMap<Integer, String>();
    private Map<Integer, DetectItem> index2SecondItem = new HashMap<Integer, DetectItem>();
    private boolean failedModel = false;
    private boolean isRecheck = false;
    private boolean isInRemove = false;
    private boolean showPro;
    private boolean showLeftTime;

    protected FlowWizardCardLayout getLayout() {
        return this.detectLayout;
    }

    public boolean ending() {
        return true;
    }

    protected boolean init() {
        this.setCurStepID();
        ProgressDialog deprogressDialog = new ProgressDialog(this.getParentWindow());
        ServiceTaskExecutor taskExecutor = new ServiceTaskExecutor(deprogressDialog);
        TaskResult taskResult = taskExecutor.execute((ServiceTask)new InitStepTask());
        if (taskResult != null && taskResult.getResult() == TaskResult.Result.FAILED) {
            DialogUtils.showErrorDialog((Window)this.getParentWindow(), (String)taskResult.getErrorLocaleDescription());
            this.initItems();
            this.autoExec();
        }
        return true;
    }

    public boolean flowExiting() {
        if (!this.finish) {
            DialogUtils.showInfoDialog((Window)this.getParentWindow(), (String)ResourceUtil.getString("bizpackage.error.doitem.scriptrunning"));
            return false;
        }
        return this.cancel();
    }

    private void initTask() {
        if (this.task != null) {
            return;
        }
        String preScriptPath = this.getScriptPath();
        String pyName = this.cfg.getDetectList().getScript();
        try {
            this.task = new ExecPyScriptTask(preScriptPath, pyName);
        }
        catch (FileNotFoundException e) {
            LOGGER.error("init detect task file {} not found.", (Object)pyName);
        }
        catch (SignException e) {
            LOGGER.error("init detect task sign error.", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("init detect task error.", (Throwable)e);
        }
    }

    @Override
    public void initByConfig(BizStepConfig stepConfig) {
        if (stepConfig instanceof DetectStepCfg) {
            this.cfg = (DetectStepCfg)stepConfig;
            this.initLayout();
            super.setBackwardAbs(this.cfg.isBackward());
            super.setCancelScriptAbs(this.cfg.getCancelScript());
            super.setParamAbs(this.cfg.getParam());
            this.showLeftTime = this.cfg.isShowLeftTime();
            this.showPro = this.cfg.isShowPro();
            this.detectLayout.setStatusPanel(this.showPro, this.showLeftTime);
            this.execParam = this.cfg.getDetectList().getParam();
            this.initTask();
            this.initListener();
        }
    }

    private void initListener() {
        this.detectLayout.getItemList().addListSelectionListener((ListSelectionListener)new DetectListSelectListener());
    }

    private void initLayout() {
        this.detectLayout = new DetectStepLayout(this.cfg);
        this.operators.clear();
        this.operators.add(this.detectLayout.getBtnReDetect());
        this.detectLayout.getBtnReDetect().setEnabled(false);
        this.detectLayout.getBtnReDetect().addActionListener(new ReDetectActionLisnener());
    }

    private void autoExec() {
        this.finish = false;
        this.failedModel = false;
        this.isRecheck = false;
        this.index2SecondItemId.clear();
        this.index2SecondItem.clear();
        this.detectLayout.setCurrentLeftTime("");
        this.detectLayout.setCurrentLeftTimeDes("");
        this.detectLayout.setCurrentProgress("");
        ExecDetectItemTask detectItemTask = new ExecDetectItemTask(this.detectItems, this, this.getScriptPath(), this.cfg.isExecAllWhenFailed());
        if (this.showPro) {
            new QueryProgressTask().start();
        }
        if (this.showLeftTime) {
            new QueryRemainTimeTask().start();
        }
        TaskManager.submitTask(detectItemTask);
    }

    private void reDetectPerform() {
        this.isRecheck = true;
        this.detectLayout.setCurrentStatusTxt(ResourceUtil.getString("expansion.wizard.init"));
        if (this.cfg.isOnlyRecheckFailed()) {
            this.detectLayout.getBtnReDetect().setEnabled(false);
            this.removeSecondFailedItems();
            this.execOnlyFailedItems();
        } else {
            this.detectLayout.clearUI();
            this.autoExec();
        }
    }

    private void removeSecondFailedItems() {
        this.isInRemove = true;
        List<Integer> failedIndex = this.getReSortedFailedItems();
        for (Integer integer : failedIndex) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("remove line id:" + integer);
            }
            this.detectLayout.getListModel().remove(integer);
        }
        this.isInRemove = false;
    }

    private List<Integer> getFailedIdList() {
        ArrayList<Integer> failedIdList = new ArrayList<Integer>();
        for (int i = 0; i < this.detectLayout.getListModel().size(); ++i) {
            StepListItem item;
            ListItemType type;
            Object userObj = this.detectLayout.getListModel().getElementAt(i);
            if (!(userObj instanceof StepListItem) || !(type = (item = (StepListItem)userObj).getStepType()).equals((Object)ListItemType.FAILED)) continue;
            failedIdList.add(i);
        }
        return failedIdList;
    }

    private List<Integer> getReSortedFailedItems() {
        Set<Integer> failedIndex = this.index2SecondItemId.keySet();
        ArrayList<Integer> reSortedFailedItems = new ArrayList<Integer>();
        int size = failedIndex.size();
        for (int i = 0; i < size; ++i) {
            int maxIndex = 0;
            for (Integer integer : failedIndex) {
                if (integer <= maxIndex) continue;
                maxIndex = integer;
            }
            reSortedFailedItems.add(maxIndex);
            if (!failedIndex.contains(maxIndex)) continue;
            failedIndex.remove(maxIndex);
        }
        return reSortedFailedItems;
    }

    private void execOnlyFailedItems() {
        this.index2SecondItemId.clear();
        this.index2SecondItem.clear();
        this.finish = false;
        this.failedModel = false;
        List<Integer> failedIdList = this.getFailedIdList();
        ExecDetectItemTask detectItemTask = new ExecDetectItemTask(this.detectItems, this, this.getScriptPath(), this.cfg.isExecAllWhenFailed(), failedIdList);
        if (this.showPro) {
            new QueryProgressTask().start();
        }
        if (this.showLeftTime) {
            new QueryRemainTimeTask().start();
        }
        TaskManager.submitTask(detectItemTask);
    }

    private void initItems() {
        this.detectItems.clear();
        JythonContext ssEvn = BizPackageContext.getInstance().getJythonContext();
        ssEvn.clearMsgData();
        if (!this.task.execFunc("init", this.execParam)) {
            LOGGER.error("init items error.");
        }
        String josnStr = (String)ssEvn.getDict().get("retData");
        JSONArray array = new JSONArray(josnStr);
        for (int i = 0; i < array.length(); ++i) {
            JSONObject item = array.getJSONObject(i);
            DetectItem detectItem = new DetectItem();
            detectItem.setTitle(item.getString("title"));
            detectItem.setScript(item.getString("script"));
            if (item.has("param")) {
                detectItem.setParam(item.getString("param"));
            }
            detectItem.setId(item.getString("id"));
            this.detectItems.add(detectItem);
        }
    }

    private TaskResult initStep() {
        TaskResult taskResult;
        DetectStepCfg conCfg = (DetectStepCfg)BizPackageContext.getInstance().getCurBizWizardCfg().getStepsById(this.getId());
        this.initByConfig(conCfg);
        this.setAllStageNum();
        super.setIndex(this.getStageIndex());
        this.detectLayout.clearUI();
        this.detectLayout.setCurrentStatusTxt(ResourceUtil.getString("expansion.wizard.init"));
        this.detectLayout.setCurrentLeftTime("");
        this.detectLayout.setCurrentLeftTimeDes("");
        this.detectLayout.setCurrentProgress("");
        this.setRunningUiStatus();
        if (BizPackageContext.getInstance().getCurBizWizardCfg().getStepsById(this.getId()).isNeedDeviceGraph() && TaskResult.Result.FAILED == (taskResult = this.initDevGraph()).getResult()) {
            return taskResult;
        }
        this.initItems();
        this.autoExec();
        return new TaskResult(TaskResult.Result.SUCCESS);
    }

    @Override
    public void fireFinish(DetectItem item, int curIndex) {
        this.detectLayout.setStatusPanelEnable(false, false);
        this.detectLayout.setCurrentDesc("", this.showLeftTime);
        StepListItem parentItem = null;
        ItemResult result = item.getResult();
        if (result == ItemResult.FAILED) {
            this.failedModel = true;
            this.setCurrentStatusTxt(item.getTitle() + ResourceUtil.getStringWithParams("expansion.wizard.doitem.failed", " "));
            parentItem = new StepListItem(item.getTitle(), ListItemType.FAILED, 0);
        } else if (result == ItemResult.SUCCEED) {
            parentItem = new StepListItem(item.getTitle(), ListItemType.SUCCESS, 0);
        }
        StepListItem refreshItem = parentItem;
        this.detectLayout.getListModel().setElementAt(refreshItem, curIndex);
        this.setResult(result, curIndex, item);
    }

    private void setResult(ItemResult result, int curIndex, DetectItem item) {
        if (result == ItemResult.FAILED) {
            String retData = (String)BizPackageContext.getInstance().getJythonContext().getDict().get("retData");
            JSONArray array = new JSONArray(retData);
            for (int i = 0; i < array.length(); ++i) {
                JSONObject obj = array.getJSONObject(i);
                String id = obj.getString("id");
                String title = obj.getString("title");
                this.index2SecondItemId.put(curIndex + 1 + i, id);
                this.index2SecondItem.put(curIndex + 1 + i, item);
                StepListItem secondItem = new StepListItem(title, ListItemType.FAILED, 1);
                if (this.isRecheck && this.cfg.isOnlyRecheckFailed()) {
                    this.detectLayout.getListModel().insertElementAt(secondItem, curIndex + i + 1);
                    continue;
                }
                this.addNewLogInfo(secondItem);
            }
            this.notifyObserver(AutoProcessStatus.FAILURE);
        }
    }

    @Override
    public void setCurrentStatusTxt(String txt) {
        this.detectLayout.setCurrentStatusTxt(txt);
    }

    @Override
    public void refreshItemLoading(DetectItem item, final int curIndex) {
        final StepListItem parentItem = new StepListItem(item.getTitle(), ListItemType.RUNNING, 0);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LOGGER.info("AwtAction thread is running...");
                if (DetectStep.this.isRecheck && DetectStep.this.cfg.isOnlyRecheckFailed()) {
                    DetectStep.this.detectLayout.getListModel().setElementAt(parentItem, curIndex);
                    DetectStep.this.detectLayout.getItemList().updateUI();
                    DetectStep.this.detectLayout.getItemList().repaint();
                } else {
                    DetectStep.this.addNewLogInfo(parentItem);
                }
            }
        });
    }

    private void addNewLogInfo(StepListItem newItem) {
        this.detectLayout.getListModel().addElement(newItem);
        if (newItem.getLevel() == 0) {
            int lastIndex = this.detectLayout.getListModel().getSize() - 1;
            Rectangle rect = this.detectLayout.getItemList().getCellBounds(lastIndex, lastIndex);
            JViewport view = this.detectLayout.getScrollPane().getViewport();
            if (null != view && null != rect) {
                view.scrollRectToVisible(rect);
            }
        }
    }

    private void setLogInfo(StepListItem newItem, int index) {
        this.detectLayout.getListModel().setElementAt(newItem, index);
        if (newItem.getLevel() == 0) {
            int lastIndex = this.detectLayout.getListModel().getSize() - 1;
            Rectangle rect = this.detectLayout.getItemList().getCellBounds(lastIndex, lastIndex);
            JViewport view = this.detectLayout.getScrollPane().getViewport();
            if (null != view && null != rect) {
                view.scrollRectToVisible(rect);
            }
        }
    }

    @Override
    public void fireException(Exception e, DetectItem item, final int curIndex) {
        this.setCurrentStatusTxt(item.getTitle() + ResourceUtil.getStringWithParams("expansion.wizard.doitem.failed", " "));
        this.detectLayout.setStatusPanelEnable(false, false);
        this.detectLayout.setCurrentDesc("", this.showLeftTime);
        this.failedModel = true;
        final StepListItem parentItem = new StepListItem(item.getTitle(), ListItemType.FAILED, 0);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DetectStep.this.setLogInfo(parentItem, curIndex);
            }
        });
        if (e instanceof FileNotFoundException) {
            String msgs1 = ResourceUtil.getString("bizpackage.error.doitem.scriptfilenotfound");
            String msgs2 = ResourceUtil.getString("bizpackage.error.doitem.scriptfilenotfound.suggestion");
            this.addExeceptLog(msgs1, msgs2, curIndex);
        } else if (e instanceof SignException) {
            String msgs1 = ResourceUtil.getString("bizpackage.error.doitem.scriptfile.notsigned");
            String msgs2 = ResourceUtil.getString("bizpackage.error.doitem.scriptfile.notsigned.suggestion");
            this.addExeceptLog(msgs1, msgs2, curIndex);
        } else {
            String msgs1 = ResourceUtil.getString("bizpackage.error.doitem.scriptexecerr");
            String msgs2 = ResourceUtil.getString("bizpackage.error.doitem.scriptexecerr.suggestion");
            this.addExeceptLog(msgs1, msgs2, curIndex);
        }
        this.notifyObserver(AutoProcessStatus.FAILURE);
    }

    private void addExeceptLog(String msgs1, String msgs2, int curIndex) {
        StepListItem msgs1Item = new StepListItem(msgs1, ListItemType.FAILED, 1);
        StepListItem msgs2Item = new StepListItem(msgs2, ListItemType.FAILED, 1);
        if (this.isRecheck && this.cfg.isOnlyRecheckFailed()) {
            this.detectLayout.getListModel().insertElementAt(msgs1Item, curIndex + 1);
            this.index2SecondItemId.put(curIndex + 1, "");
            this.detectLayout.getListModel().insertElementAt(msgs2Item, curIndex + 2);
            this.index2SecondItemId.put(curIndex + 2, "");
        } else {
            this.addNewLogInfo(msgs1Item);
            this.index2SecondItemId.put(this.getCurItemNums() - 1, "");
            this.addNewLogInfo(msgs2Item);
            this.index2SecondItemId.put(this.getCurItemNums() - 1, "");
        }
    }

    private void setStatus(boolean isSucc, boolean backEnable) {
        final FlowWizardState curState = this.getUIState(isSucc, backEnable);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DetectStep.this.changeUIState(curState);
            }
        });
    }

    @Override
    public void startDetect() {
        this.setRunningUiStatus();
        log.info("startDetect refresh to running status.");
    }

    @Override
    public void fireAllFinish() {
        boolean isSucc;
        String title = BizPackageContext.getInstance().getCurBizPackage().getResUtil().getString(this.cfg.getTitle());
        this.detectLayout.setCurrentStatusTxt(title + ResourceUtil.getStringWithParams("expansion.wizard.doitem.finish", " "));
        this.detectLayout.setStatusPanelEnable(false, false);
        this.detectLayout.setCurrentDesc("", this.showLeftTime);
        this.finish = true;
        boolean bl = isSucc = !this.failedModel;
        if (this.failedModel) {
            this.detectLayout.getBtnReDetect().setEnabled(true);
        }
        switch (this.cfg.getBackaftersuc()) {
            case NOT_SET: {
                this.chgWizState(isSucc);
                break;
            }
            case ENABLE: {
                this.setStatus(isSucc, true);
                break;
            }
            case DISABLE: {
                this.setStatus(isSucc, false);
                break;
            }
        }
        this.notifyObserver(AutoProcessStatus.SUCCESS);
    }

    @Override
    public int getCurItemNums() {
        return this.detectLayout.getListModel().getSize();
    }

    @Override
    public TaskResult initDevGraph() {
        if (!ExecPyUtils.execInitScript(this.cfg.getScriptFile(), this.getParamAbs(), "initDevGraph")) {
            TaskResult deresult = new TaskResult(TaskResult.Result.FAILED);
            String errorMsg = ResourceUtil.getString("bizpackage.error.preset.execscriptfailed");
            deresult.setErrorLocaleDescription(errorMsg);
            return deresult;
        }
        return this.getDevGraphExecResult();
    }

    private TaskResult clickExecScript(JythonContext ssEnv, int index) {
        DetectItem item = this.index2SecondItem.get(index);
        String param = item.getParam();
        JythonExecuter jythonExecuter = item.getJythonExecuter();
        File pyFile = item.getPyFile();
        ssEnv.clearMsgData();
        ssEnv.getDict().put("curData", this.index2SecondItemId.get(index));
        try {
            jythonExecuter.compileScript(pyFile);
            if ("".equals(param.trim())) {
                Object[] paramList = new Object[]{ssEnv.getDict()};
                jythonExecuter.invokeFunction("click", paramList);
            } else {
                jythonExecuter.invokeFunction("click", new Object[]{ssEnv.getDict(), param});
            }
        }
        catch (SignException e) {
            LOGGER.error("python file has no sign", (Throwable)e);
            return new TaskResult(TaskResult.Result.FAILED);
        }
        catch (Exception e) {
            LOGGER.error("jython exec err", (Throwable)e);
            return new TaskResult(TaskResult.Result.FAILED);
        }
        return new TaskResult(TaskResult.Result.SUCCESS);
    }

    private void setCurrentProgress(int progress, boolean isshow) {
        String progressPer = progress + "%";
        this.detectLayout.getCurrentProgress().setVisible(isshow);
        this.detectLayout.setCurrentProgress(progressPer);
    }

    private void setCurrentRemainTime(int remainTime, boolean isshow) {
        int seconds = remainTime % 60;
        int minutes = remainTime / 60;
        String remainTimeFinal = this.getTime(minutes, seconds);
        this.detectLayout.getCurrentLeftTimeDes().setVisible(isshow);
        this.detectLayout.getCurrentLeftTime().setVisible(isshow);
        this.detectLayout.setCurrentLeftTimeDes(ResourceUtil.getString("wizard.doitem.desc.timeleft"));
        this.detectLayout.setCurrentLeftTime(remainTimeFinal);
    }

    private String getTime(int minutes, int seconds) {
        SimpleDateFormat fo = new SimpleDateFormat("HH:mm:ss");
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, minutes);
        cal.set(13, seconds);
        return fo.format(cal.getTime());
    }

    @Override
    public void initStatusPanel() {
        this.detectLayout.setStatusPanelEnable(this.showPro, this.showLeftTime);
    }

    @Override
    public void onStepDialogDisplayed() {
    }

    @Override
    public void onStepFinished(AutoProcessStatus status) {
        this.outputResult(status);
        if (status.equals((Object)AutoProcessStatus.SUCCESS)) {
            this.clickButton(Navigation.NEXT);
        } else if (status.equals((Object)AutoProcessStatus.FAILURE)) {
            this.clickButton(Navigation.CANCEL);
        }
    }

    private void outputResult(AutoProcessStatus status) {
        StringBuffer stringBuffer = new StringBuffer();
        String processName = AutoProcessConfig.getInstance().getCurrentProcess();
        String stepId = BizPackageContext.getInstance().getCurStepId();
        String stepString = String.format(Locale.ROOT, "%s--------step: %s, result: %s", System.lineSeparator(), stepId, status.toString());
        stringBuffer.append(stepString);
        for (DetectItem item : this.detectItems) {
            String itemName = item.getId();
            String itemString = String.format(Locale.ROOT, "%s------------check item: %s, result: %s", System.lineSeparator(), itemName, item.getResult().toString());
            stringBuffer.append(itemString);
            AutoProcessItem result = new AutoProcessItem();
            result.setId(item.getId());
            if (item.getResult() == ItemResult.FAILED || item.getResult() == ItemResult.NOT_PASS) {
                result.setResult(AutoProcessStatus.FAILURE.toString());
            }
            String resultKey = processName + "#" + stepId + "#" + item.getId();
            AutoProcessResult.getInstance().getResults().put(resultKey, result);
        }
        AutoProcessResult.getInstance().append(stringBuffer.toString());
    }

    private void clickButton(Navigation button) {
        FlowWizardDialog wizardDialog;
        if (BizPackageContext.getInstance().getWizard() instanceof FlowWizardDialog) {
            wizardDialog = (FlowWizardDialog)BizPackageContext.getInstance().getWizard();
            wizardDialog.clickNaviButton(button);
        }
        if (BizPackageContext.getInstance().getWizard() instanceof GuideFlowWizardDialog) {
            wizardDialog = (GuideFlowWizardDialog)BizPackageContext.getInstance().getWizard();
            wizardDialog.clickNaviButton(button);
        }
    }

    public void setDetectLayout(DetectStepLayout detectLayout) {
        this.detectLayout = detectLayout;
    }

    private class ExecClickTask
    extends ServiceTask {
        private JythonContext ssEnv = BizPackageContext.getInstance().getJythonContext();
        private int index;

        public ExecClickTask(int index) {
            this.index = index;
        }

        protected TaskResult doTask() {
            return DetectStep.this.clickExecScript(this.ssEnv, this.index);
        }
    }

    private class InitStepTask
    extends ServiceTask {
        private InitStepTask() {
        }

        protected TaskResult doTask() {
            return DetectStep.this.initStep();
        }
    }

    private class QueryRemainTimeTask
    extends Thread {
        private QueryRemainTimeTask() {
        }

        @Override
        public void run() {
            String id = "timeTask_" + new Date().getTime();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("queryRemainTimeTask id[" + id + "] start");
            }
            while (DetectStep.this.getSsEnv().getDict().get("remainTime") != null || !DetectStep.this.finish) {
                if (DetectStep.this.getSsEnv().getDict().get("remainTime") == null) {
                    DetectStep.this.setCurrentRemainTime(0, false);
                    continue;
                }
                int remainTime = (Integer)DetectStep.this.getSsEnv().getDict().get("remainTime");
                DetectStep.this.setCurrentRemainTime(remainTime, true);
                if (DetectStep.this.finish) {
                    if (!LOGGER.isInfoEnabled()) break;
                    LOGGER.info("queryRemainTimeTask id[" + id + "] end");
                    break;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    LOGGER.error("setCurrentProgress sleep err", (Throwable)e);
                }
            }
        }
    }

    private class QueryProgressTask
    extends Thread {
        private QueryProgressTask() {
        }

        @Override
        public void run() {
            String id = "progressTask_" + new Date().getTime();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("queryProgressTask id[" + id + "] start");
            }
            while (DetectStep.this.getSsEnv().getDict().get("curProgressPer") != null || !DetectStep.this.finish) {
                if (DetectStep.this.getSsEnv().getDict().get("curProgressPer") == null) {
                    DetectStep.this.setCurrentProgress(0, false);
                    continue;
                }
                int progress = (Integer)DetectStep.this.getSsEnv().getDict().get("curProgressPer");
                DetectStep.this.setCurrentProgress(progress, true);
                if (DetectStep.this.finish) {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("queryProgressTask id[" + id + "] end");
                    }
                    if (progress == 0) {
                        DetectStep.this.setCurrentProgress(0, false);
                        break;
                    }
                    if (progress <= 0 || progress >= 100) break;
                    DetectStep.this.setCurrentProgress(100, true);
                    break;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    LOGGER.error("setCurrentProgress sleep err", (Throwable)e);
                }
            }
        }
    }

    private class DetectListSelectListener
    implements ListSelectionListener {
        private int index = -1;

        private DetectListSelectListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (DetectStep.this.isInRemove) {
                return;
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("click getFirstIndex = " + e.getFirstIndex());
                LOGGER.info("click getLastIndex = " + e.getLastIndex());
            }
            if (e.getValueIsAdjusting()) {
                return;
            }
            int i2 = e.getLastIndex();
            int n = this.index = i2 == this.index ? e.getFirstIndex() : i2;
            if (!DetectStep.this.index2SecondItem.containsKey(this.index)) {
                return;
            }
            ProgressDialog progressDialog = new ProgressDialog(DetectStep.this.getParentWindow());
            ServiceTaskExecutor taskExecutor = new ServiceTaskExecutor(progressDialog);
            taskExecutor.execute((ServiceTask)new ExecClickTask(this.index));
        }
    }

    private class ReDetectActionLisnener
    implements ActionListener {
        private ReDetectActionLisnener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DetectStep.this.reDetectPerform();
        }
    }
}

