/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.step.exec;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.base.ui.filechooser.ToolFileChooser;
import com.huawei.ism.tool.base.ui.wizard.FlowWizardCardLayout;
import com.huawei.ism.tool.base.ui.wizard.FlowWizardState;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.entity.BizStepConfig;
import com.huawei.ism.tool.bizpack.wizardparse.task.ExecPyScriptTask;
import com.huawei.ism.tool.bizpack.wizardparse.ui.action.FailedDetailAction;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.table.TableColumn;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.table.TableData;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.table.TableItem;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.SelectDiskDialog;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.waitdialog.CompileAndExecOnePyFuncWaitDialog;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.waitdialog.WaitDialogResult;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.AbstractBizStep;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.exec.ImportCallable;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.exec.ImpotFileResultType;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.exec.MultiExecStepCfg;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.exec.MultiExecStepLayout;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.exec.ResultType;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.exec.status.ExecStatus;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.stop.comp.StopIoStatus;
import com.huawei.ism.tool.framework.platform.exception.SignException;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.util.UCD;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONObject;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiExecStep
extends AbstractBizStep {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiExecStep.class);
    private static final String MUL_PASSED_IMG = "success_old.gif";
    private static final String MUL_NOTPASSED_IMG = "failed_old.gif";
    private static final String MUL_LOADING_IMG = "loading.gif";
    private static final int MAX_FILE_LENGTH = 0x1400000;
    private MultiExecStepLayout mullayout;
    private MultiExecStepCfg mulcfg;
    private ExecPyScriptTask mulTask;
    private String mulscriptPath;
    private TableItem multable;
    private String mulpyName;
    private String mulsignColId;
    private int mulmaxMultiThreadNum = 1;
    private String mullastColId = "";
    private ExecutorService multhreadPool;
    private boolean mulfinish = true;
    private boolean mulisCheck = true;
    private boolean enableMutiSelect = false;
    private List<TableRow<?, ?>> mulreFailedIndexList = new ArrayList();
    private List<TableRow<?, ?>> mulfailedIndexList = new ArrayList();
    private Map<String, String> devStatusMap = new HashMap<String, String>();
    private ConcurrentHashMap<String, ArrayList<String>> selectDiskMap = new ConcurrentHashMap();

    @Override
    public void initByConfig(BizStepConfig stepConfig) {
        if (stepConfig instanceof MultiExecStepCfg) {
            this.mulcfg = (MultiExecStepCfg)stepConfig;
            this.mullayout = new MultiExecStepLayout(this.mulcfg);
            this.mulpyName = this.mulcfg.getScriptFile();
            this.mulscriptPath = this.getScriptPath();
            this.multable = this.mulcfg.getIoTable();
            this.enableMutiSelect = this.mulcfg.isEnableMutiSelect();
            super.setCancelScriptAbs(this.mulcfg.getCancelScript());
            super.setBackwardAbs(this.mulcfg.isBackward());
            super.setParamAbs(this.mulcfg.getParam());
            this.mulsignColId = this.mulcfg.getSignColId();
            this.mulmaxMultiThreadNum = this.mulcfg.getMultiNum();
            this.multhreadPool = Executors.newFixedThreadPool(this.mulmaxMultiThreadNum);
            this.mullayout.init(this.mulcfg);
            this.initListener();
            this.getSsEnv().getDict().put("selectDiskMap", this.selectDiskMap);
            this.setDocLinkParentWindow(this.mulcfg);
        }
    }

    private void initListener() {
        this.mullayout.getCheckButton().addActionListener(new ExecActionListener());
        this.mullayout.getFileImport().addClickListener((ToolHyperLinkLabel.ClickListener)new FileImportActionListener());
    }

    private boolean checkSelectionExec(List<TableRow> selectRows) {
        if (this.mulcfg.isExecOnce()) {
            boolean devHasExec = false;
            for (TableRow tableRow : selectRows) {
                TableData tabdata = (TableData)tableRow.getIdentifier();
                String tabKey = tabdata.getId2DataMap().get(this.mulsignColId);
                if (this.devStatusMap.get(tabKey).trim().equalsIgnoreCase(ExecStatus.WAITING.getKey())) continue;
                devHasExec = true;
            }
            if (devHasExec) {
                ExecPyScriptTask pytask = this.initOneExecPy();
                pytask.execFunc("execOnce");
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("execConProc" + this.getSsEnv().getDict().get("execConProc"));
                }
                Boolean conProc = (Boolean)this.getSsEnv().getDict().get("execConProc");
                return conProc;
            }
        }
        return true;
    }

    private boolean preProcess() {
        List selectRows = this.multable.getIsmTable().getMarkedRows();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(" select size =" + selectRows.size());
        }
        if (selectRows.isEmpty()) {
            DialogUtils.showInfoDialog((Window)this.getParentWindow(), (String)ResourceUtil.getString("bizpackage.error.multiexec.nodevice"));
            this.execExceptExit();
            return false;
        }
        if (this.mulcfg.isRiskWarn()) {
            ExecPyScriptTask pytask = this.initOneExecPy();
            pytask.execFunc("riskWarn");
            Boolean conProc = (Boolean)this.getSsEnv().getDict().get("continueProc");
            return conProc;
        }
        return true;
    }

    private void execExceptExit() {
        this.mullayout.getCheckButton().setEnabled(true);
        this.chgMultiStepStatus(true);
        this.mulfinish = true;
    }

    private void chgMultiStepStatus(boolean isSucc) {
        final FlowWizardState state = this.getMultiStepUIState(isSucc, this.isBackwardAbs());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MultiExecStep.this.changeUIState(state);
            }
        });
    }

    private FlowWizardState getMultiStepUIState(boolean isSucc, boolean backwizardEnable) {
        FlowWizardState state = backwizardEnable ? this.getMUIStateBackwizardEnable(isSucc) : this.getMUIStateBackwizardDisable(isSucc);
        return state;
    }

    private FlowWizardState getMUIStateBackwizardEnable(boolean isSucc) {
        FlowWizardState state = isSucc ? (this.getIndex() == 0 ? FlowWizardState.FIRST_STEP : (this.getIndex() >= this.getAllStageNum() - 1 ? FlowWizardState.LAST_STEP_PRE_SUC : FlowWizardState.MIDDLE_STEP)) : (this.getIndex() == 0 ? FlowWizardState.FIRST_STEP_RUNNING : (this.getIndex() >= this.getAllStageNum() - 1 ? FlowWizardState.LAST_STEP_FAILED : FlowWizardState.MIDDLE_STEP_FAILED));
        return state;
    }

    private FlowWizardState getMUIStateBackwizardDisable(boolean isSucc) {
        FlowWizardState state = isSucc ? (this.getIndex() == 0 ? FlowWizardState.FIRST_STEP : (this.getIndex() >= this.getAllStageNum() - 1 ? FlowWizardState.LAST_STEP_SUCCESS : FlowWizardState.MIDDLE_STEP_SUCCESS)) : (this.getIndex() == 0 ? FlowWizardState.FIRST_STEP_RUNNING : (this.getIndex() >= this.getAllStageNum() - 1 ? FlowWizardState.LAST_STEP_RUNNING : FlowWizardState.MIDDLE_STEP_RUNNING));
        return state;
    }

    private void execOneCheck(final TableRow<?, ?> row) {
        BizPackageContext.getInstance().getJythonContext().clearMsgData();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MultiExecStep.this.chgRowPreStatus(ExecStatus.EXECUTING.getKey(), row);
            }
        });
        TableData oneRow = (TableData)row.getIdentifier();
        Map<String, String> id2Map = oneRow.getId2DataMap();
        String key = id2Map.get(this.mulsignColId);
        JSONObject jsonData = new JSONObject(id2Map);
        this.setPrivateContext(key, jsonData);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("execute py func checkByRow param=" + key);
        }
        ExecPyScriptTask task = this.initOneExecPy();
        task.execFunc("checkByRow", key);
        Map taskMap = (Map)this.getSsEnv().getDict().get("taskMap");
        final Map curTaskMap = (Map)taskMap.get(key);
        Object data = curTaskMap.get("retData");
        if (data == null) {
            LOGGER.error("get retData failed.");
            this.chgRowPreStatus(StopIoStatus.WAITING.getKey(), row);
            return;
        }
        String statusData = (String)data;
        JSONObject statusJson = new JSONObject(statusData);
        final String status = (String)statusJson.get(this.mullastColId);
        if (status == null) {
            LOGGER.error("get retData status failed.");
            this.chgRowPreStatus(StopIoStatus.WAITING.getKey(), row);
            return;
        }
        this.devStatusMap.put(key, status);
        if (status.trim().equals(ExecStatus.FAILED.getKey()) || status.trim().equals(ExecStatus.PART_SUC.getKey())) {
            this.addFailedExecIndexList(row);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MultiExecStep.this.chgRowResultStatus(status, row, curTaskMap);
            }
        });
    }

    private ExecPyScriptTask initOneExecPy() {
        try {
            ExecPyScriptTask task = new ExecPyScriptTask(this.mulscriptPath, this.mulpyName);
            return task;
        }
        catch (FileNotFoundException e) {
            LOGGER.error("py file {} not found", (Object)this.mulpyName);
        }
        catch (SignException e) {
            LOGGER.error("py file not Signed", (Throwable)e);
        }
        return null;
    }

    private synchronized void setPrivateContext(String key, JSONObject jsonData) {
        HashMap<String, String> curTaskMap;
        HashMap<String, HashMap<String, String>> taskMap = (HashMap<String, HashMap<String, String>>)this.getSsEnv().getDict().get("taskMap");
        if (null == taskMap) {
            taskMap = new HashMap<String, HashMap<String, String>>();
            this.getSsEnv().getDict().put("taskMap", taskMap);
        }
        if (null == (curTaskMap = (HashMap<String, String>)taskMap.get(key))) {
            curTaskMap = new HashMap<String, String>();
            taskMap.put(key, curTaskMap);
        }
        curTaskMap.put("curData", jsonData.toString());
        curTaskMap.put("errMsg", "");
        curTaskMap.put("retData", "");
    }

    private void chgRowPreStatus(String value, TableRow<?, ?> row) {
        int colSize = this.multable.getTableModel().getAllColumnCount();
        if (null == row) {
            return;
        }
        this.setLastPreRowValue(row, colSize - 1, value);
        this.multable.getIsmTable().updateUI();
    }

    private void chgRowResultStatus(String value, TableRow<?, ?> row, Map<String, Object> curTaskMap) {
        int colSize = this.multable.getTableModel().getAllColumnCount();
        if (null == row) {
            return;
        }
        this.setLastRowResultValue(row, colSize - 1, value, curTaskMap);
        this.multable.getIsmTable().updateUI();
    }

    private synchronized void addFailedExecIndexList(TableRow<?, ?> row) {
        this.mulfailedIndexList.add(row);
    }

    private synchronized List<TableRow<?, ?>> getFailedExecIndexList() {
        return new ArrayList(this.mulfailedIndexList);
    }

    private synchronized void clearFailedExecIndexList() {
        this.mulfailedIndexList.clear();
    }

    private void initData() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BizPackageContext.getInstance().getJythonContext().clearMsgData();
                Window parent = MultiExecStep.this.getParentWindow();
                List fs = AsyncExcutor.execute((Window)parent, (Callable[])new Callable[]{new CompileAndExecOnePyFuncWaitDialog(MultiExecStep.this.mulscriptPath, MultiExecStep.this.mulpyName, "initData", MultiExecStep.this.getParamAbs())});
                WaitDialogResult result = (WaitDialogResult)fs.get(0);
                if (!WaitDialogResult.handleResult(MultiExecStep.this.getParentWindow(), result)) {
                    return;
                }
                MultiExecStep.this.mulTask = result.getTask();
                if (null == MultiExecStep.this.mulTask) {
                    DialogUtils.showErrorDialog((Window)MultiExecStep.this.getParentWindow(), (String)ResourceUtil.getString("bizpackage.error.preset.scriptinitfailed"));
                    return;
                }
                if (!((Boolean)MultiExecStep.this.getSsEnv().getDict().get("succ")).booleanValue()) {
                    String errText = (String)MultiExecStep.this.getSsEnv().getDict().get("errMsg");
                    DialogUtils.showErrorDialog((Window)MultiExecStep.this.getParentWindow(), (String)errText);
                    return;
                }
                MultiExecStep.this.initTableData();
            }
        });
    }

    private void reCheck() {
        List<TableRow<?, ?>> failedList = this.getFailedExecIndexList();
        for (TableRow<?, ?> tableRow : failedList) {
            this.chgRowPreStatus(StopIoStatus.WAITING.getKey(), tableRow);
        }
        new ReCheckThread().start();
    }

    protected FlowWizardCardLayout getLayout() {
        return this.mullayout;
    }

    protected boolean init() {
        this.setCurStepID();
        this.initByConfig(BizPackageContext.getInstance().getCurBizWizardCfg().getStepsById(this.getId()));
        this.setAllStageNum();
        this.mullayout.init(this.mulcfg);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("table.getTableModel() =" + this.multable.getTableModel().getAllRows().size());
        }
        this.mulisCheck = true;
        String ckbtnName = ResourceUtil.getString("bizpack.wizard.exec.btn." + this.mulcfg.getMode().getKey());
        this.mullayout.getCheckButton().setText(ckbtnName);
        this.mullayout.getCheckButton().setEnabled(true);
        UCD.formatMnemonicDisplay((AbstractButton)this.mullayout.getCheckButton());
        super.setIndex(this.getStageIndex());
        this.initData();
        this.chgWizState(false);
        return true;
    }

    private void initSelection() {
        String selSignKey = (String)this.getSsEnv().getDict().get("select_signKey");
        if (selSignKey == null || "".equalsIgnoreCase(selSignKey)) {
            LOGGER.error("read selSignKey from script error");
            return;
        }
        JSONArray selArr = (JSONArray)this.getSsEnv().getDict().get("select_data");
        if (selArr == null) {
            LOGGER.error("read selections data from script error");
            return;
        }
        int size = selArr.length();
        List allrows = this.multable.getIsmTable().getAllRows();
        int index = 0;
        for (TableRow row : allrows) {
            TableData oneRow = (TableData)row.getIdentifier();
            Map<String, String> id2Map = oneRow.getId2DataMap();
            String key = id2Map.get(selSignKey);
            for (int i = 0; i < size; ++i) {
                String selKey = selArr.getString(i);
                if (!key.equalsIgnoreCase(selKey)) continue;
                this.multable.getIsmTable().getSelectionModel().addSelectionInterval(index, index);
            }
            ++index;
        }
    }

    private void initTableData() {
        this.initFresh();
        this.initSelection();
    }

    public boolean ending() {
        this.saveSelections();
        return true;
    }

    private void saveSelections() {
        List selectRows = this.multable.getIsmTable().getMarkedRows();
        int size = selectRows.size();
        String[] selKeys = new String[size];
        for (int i = 0; i < size; ++i) {
            String key;
            TableRow row = (TableRow)selectRows.get(i);
            TableData oneRow = (TableData)row.getIdentifier();
            Map<String, String> id2Map = oneRow.getId2DataMap();
            selKeys[i] = key = id2Map.get(this.mulsignColId);
        }
        JSONArray selKeyObj = new JSONArray(Arrays.asList(selKeys));
        this.getSsEnv().getDict().put("selKeys", selKeyObj);
    }

    public boolean flowExiting() {
        if (!this.mulfinish) {
            String errInfo = ResourceUtil.getString("bizpackage.error.doitem.scriptrunning");
            DialogUtils.showInfoDialog((Window)this.getParentWindow(), (String)errInfo);
            return false;
        }
        return this.cancel();
    }

    public void initFresh() {
        Map<String, Object> contexDict = BizPackageContext.getInstance().getJythonContext().getDict();
        this.mullastColId = this.multable.getColIdListOnly().get(this.multable.getColIdListOnly().size() - 1);
        this.multable.getTableModel().removeAll();
        String json = (String)contexDict.get("retData_" + this.multable.getId());
        List<Map<String, String>> datas = this.multable.json2TableData(json);
        this.devStatusMap = null;
        this.devStatusMap = new HashMap<String, String>();
        for (Map<String, String> oneRowMap : datas) {
            TableData oneRowData = new TableData();
            oneRowData.setDataIdList(this.multable.getColIdListOnly());
            oneRowData.setId2DataMap(oneRowMap);
            this.multable.getTableModel().addRow(new TableRow[]{this.createTableRow(oneRowData)});
            this.devStatusMap.put(oneRowData.getId2DataMap().get(this.mulsignColId), ExecStatus.WAITING.getKey());
        }
        this.backToWaitingTable();
    }

    private void backToWaitingTable() {
        List allRows = this.multable.getTableModel().getAllRows();
        for (TableRow tableRow : allRows) {
            this.chgRowPreStatus(StopIoStatus.WAITING.getKey(), tableRow);
        }
    }

    private TableRow<?, ?> createTableRow(TableData oneRow) {
        DefaultTableRow newRow = new DefaultTableRow(this.multable.getColumnNames().length, (Object)oneRow, (Object)oneRow);
        List<String> dataIdLists = oneRow.getDataIdList();
        Map<String, String> id2DataMap = oneRow.getId2DataMap();
        List<String> detailIdList = this.multable.getDetailDialogIdList();
        String key = id2DataMap.get(this.mulsignColId);
        int i = 0;
        for (String id : dataIdLists) {
            String value = id2DataMap.get(id);
            if (detailIdList.contains(id)) {
                TableColumn columnDatas = this.multable.getId2ColCfgMap().get(id);
                IsmTableCell.HyperlinkCell link = new IsmTableCell.HyperlinkCell(ResourceUtil.getString("bizpack.wizard.stopiostep.detail"), (ActionListener)new HyperLinkListener(columnDatas, key));
                newRow.setValueAt(i, (Object)link);
                ++i;
                continue;
            }
            if (null == value) {
                ++i;
                continue;
            }
            if (i == dataIdLists.size() - 1) {
                this.setLastPreRowValue((TableRow<?, ?>)newRow, i, value);
                ++i;
                continue;
            }
            newRow.setValueAt(i, (Object)value);
            ++i;
        }
        return newRow;
    }

    private String tableData2json(TableData oneRow) {
        JSONObject multableData = new JSONObject(oneRow.getId2DataMap());
        return multableData.toString();
    }

    private String getTabelItemId(String id) {
        StringBuilder mulitemId = new StringBuilder();
        mulitemId.append("input");
        mulitemId.append('_');
        mulitemId.append(this.getId());
        mulitemId.append('_');
        mulitemId.append(id);
        return mulitemId.toString();
    }

    private void setLastPreRowValue(TableRow<?, ?> row, int colIndex, String value) {
        if (null == value || "".equals(value)) {
            return;
        }
        String mode = this.mulcfg.getMode().getKey();
        if (value.trim().equals(ExecStatus.WAITING.getKey())) {
            String statusStr = ResourceUtil.getString("bizpack.wizard.exec.status." + mode + ".waiting");
            row.setValueAt(colIndex, (Object)new IsmTableCell.IconCell(null, statusStr));
            return;
        }
        if (value.trim().equals(ExecStatus.EXECUTING.getKey())) {
            ImageIcon icon = ResourceUtil.getImage(MUL_LOADING_IMG);
            String statusStr = ResourceUtil.getString("bizpack.wizard.exec.status." + mode + ".executing");
            IsmTableCell.IconCell cell = new IsmTableCell.IconCell((Icon)icon, statusStr);
            row.setValueAt(colIndex, (Object)cell);
            icon.setImageObserver((ImageObserver)this.multable.getIsmTable());
        }
    }

    private void setLastRowResultValue(TableRow<?, ?> row, int colIndex, String value, Map<String, Object> curTaskMap) {
        if (null == value || "".equals(value)) {
            return;
        }
        String mode = this.mulcfg.getMode().getKey();
        Object extResult = curTaskMap.get("extResult");
        String extResultStr = "";
        if (null != extResult) {
            extResultStr = (String)extResult;
        }
        if (value.trim().equals(ExecStatus.SUCCEED.getKey())) {
            ImageIcon icon = ResourceUtil.getImage(MUL_PASSED_IMG);
            String statusStr = ResourceUtil.getString("bizpack.wizard.exec.status." + mode + ".succeed") + extResultStr;
            row.setValueAt(colIndex, (Object)new IsmTableCell.IconCell((Icon)icon, statusStr));
        } else if (value.trim().equals(ExecStatus.FAILED.getKey())) {
            ImageIcon icon = ResourceUtil.getImage(MUL_NOTPASSED_IMG);
            String statusStr = ResourceUtil.getString("bizpack.wizard.exec.failed.detail") + extResultStr;
            String errText = (String)curTaskMap.get("errMsg");
            row.setValueAt(colIndex, (Object)new IsmTableCell.HyperlinkIconCell(statusStr, (Icon)icon, (ActionListener)new FailedDetailAction(errText, this.getParentWindow())));
        } else if (value.trim().equals(ExecStatus.PART_SUC.getKey())) {
            ImageIcon icon = ResourceUtil.getImage(MUL_PASSED_IMG);
            String statusStr = ResourceUtil.getString("bizpack.wizard.exec.partsuc.detail") + extResultStr;
            String errText = (String)curTaskMap.get("errMsg");
            row.setValueAt(colIndex, (Object)new IsmTableCell.HyperlinkIconCell(statusStr, (Icon)icon, (ActionListener)new FailedDetailAction(errText, this.getParentWindow())));
        }
    }

    private class HyperLinkListener
    implements ActionListener {
        private TableColumn columnData;
        private String key;

        public HyperLinkListener(TableColumn columnData) {
            this.columnData = columnData;
        }

        public HyperLinkListener(TableColumn columnData, String key) {
            this(columnData);
            this.key = key;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectDiskDialog detailDialog = new SelectDiskDialog(this.columnData, MultiExecStep.this.mulscriptPath, this.key, MultiExecStep.this.getParentWindow());
            try {
                TableRow row = MultiExecStep.this.multable.getIsmTable().getMarkedRow();
                if (row == null) {
                    LOGGER.error("Getting current marked row is null");
                    return;
                }
                TableData oneRow = (TableData)row.getIdentifier();
                MultiExecStep.this.getSsEnv().getDict().put("input_changed_id", MultiExecStep.this.getTabelItemId(MultiExecStep.this.multable.getId()));
                MultiExecStep.this.getSsEnv().getDict().put(MultiExecStep.this.getTabelItemId(MultiExecStep.this.multable.getId()), MultiExecStep.this.tableData2json(oneRow));
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("click hyperLink[" + MultiExecStep.this.getTabelItemId(MultiExecStep.this.multable.getId()) + "]");
                }
                detailDialog.setVisible(true);
            }
            catch (Exception e1) {
                LOGGER.error("click hyperLink exception", (Throwable)e1);
            }
        }
    }

    private class ExecOneTask
    implements Runnable {
        private TableRow<?, ?> row;

        public ExecOneTask(TableRow<?, ?> row) {
            this.row = row;
        }

        @Override
        public void run() {
            MultiExecStep.this.execOneCheck(this.row);
        }
    }

    private class ReCheckThread
    extends Thread {
        private ReCheckThread() {
        }

        @Override
        public void run() {
            MultiExecStep.this.mulreFailedIndexList.clear();
            MultiExecStep.this.mulreFailedIndexList.addAll(MultiExecStep.this.getFailedExecIndexList());
            MultiExecStep.this.clearFailedExecIndexList();
            MultiExecStep.this.mulfinish = false;
            MultiExecStep.this.setRunningUiStatus();
            LOGGER.info("start check#######");
            if (null == MultiExecStep.this.mulTask) {
                DialogUtils.showErrorDialog((Window)MultiExecStep.this.getParentWindow(), (String)ResourceUtil.getString("bizpackage.error.preset.scriptinitfailed"));
                MultiExecStep.this.execExceptExit();
                return;
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(" check table.getTableModel() =" + MultiExecStep.this.mulreFailedIndexList.size());
            }
            MultiExecStep.this.multhreadPool = Executors.newFixedThreadPool(MultiExecStep.this.mulmaxMultiThreadNum);
            for (TableRow oneRow : MultiExecStep.this.mulreFailedIndexList) {
                Future<?> future = MultiExecStep.this.multhreadPool.submit(new ExecOneTask(oneRow));
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info("return value is " + future);
            }
            MultiExecStep.this.multhreadPool.shutdown();
            try {
                while (!MultiExecStep.this.multhreadPool.awaitTermination(100L, TimeUnit.MILLISECONDS)) {
                }
            }
            catch (InterruptedException e) {
                LOGGER.error("threadPool query shutdown err", (Throwable)e);
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("getFailedExecIndexList=" + MultiExecStep.this.getFailedExecIndexList());
            }
            if (!MultiExecStep.this.getFailedExecIndexList().isEmpty()) {
                MultiExecStep.this.mullayout.getCheckButton().setEnabled(true);
            }
            MultiExecStep.this.chgMultiStepStatus(true);
            MultiExecStep.this.mulfinish = true;
        }
    }

    private class SelectExecThread
    extends Thread {
        private SelectExecThread() {
        }

        @Override
        public void run() {
            MultiExecStep.this.mulfinish = false;
            MultiExecStep.this.setRunningUiStatus();
            LOGGER.info("start select task#######");
            if (null == MultiExecStep.this.mulTask) {
                DialogUtils.showErrorDialog((Window)MultiExecStep.this.getParentWindow(), (String)ResourceUtil.getString("bizpackage.error.preset.scriptinitfailed"));
                MultiExecStep.this.execExceptExit();
                return;
            }
            List selectRows = MultiExecStep.this.multable.getIsmTable().getMarkedRows();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(" select size =" + selectRows.size());
            }
            if (selectRows.isEmpty()) {
                DialogUtils.showInfoDialog((Window)MultiExecStep.this.getParentWindow(), (String)ResourceUtil.getString("bizpackage.error.multiexec.nodevice"));
                MultiExecStep.this.execExceptExit();
                return;
            }
            MultiExecStep.this.multhreadPool = Executors.newFixedThreadPool(MultiExecStep.this.mulmaxMultiThreadNum);
            for (TableRow tableRow : selectRows) {
                Future<?> future = MultiExecStep.this.multhreadPool.submit(new ExecOneTask(tableRow));
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info("return value is " + future);
            }
            MultiExecStep.this.multhreadPool.shutdown();
            try {
                while (!MultiExecStep.this.multhreadPool.awaitTermination(100L, TimeUnit.MILLISECONDS)) {
                }
            }
            catch (InterruptedException e) {
                LOGGER.error("threadPool query shutdown err", (Throwable)e);
            }
            MultiExecStep.this.mullayout.getCheckButton().setEnabled(true);
            MultiExecStep.this.chgMultiStepStatus(true);
            MultiExecStep.this.mulfinish = true;
            LOGGER.info("end select task#######");
        }
    }

    private class StartCheckThread
    extends Thread {
        private StartCheckThread() {
        }

        @Override
        public void run() {
            MultiExecStep.this.mulfinish = false;
            MultiExecStep.this.setRunningUiStatus();
            LOGGER.info("start task#######");
            if (null == MultiExecStep.this.mulTask) {
                DialogUtils.showErrorDialog((Window)MultiExecStep.this.getParentWindow(), (String)ResourceUtil.getString("bizpackage.error.preset.scriptinitfailed"));
                MultiExecStep.this.execExceptExit();
                LOGGER.info("check haven't start. task is null");
                return;
            }
            List allRows = MultiExecStep.this.multable.getTableModel().getAllRows();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(" check table.getTableModel() =" + MultiExecStep.this.multable.getTableModel().getAllRows().size());
            }
            MultiExecStep.this.multhreadPool = Executors.newFixedThreadPool(MultiExecStep.this.mulmaxMultiThreadNum);
            for (TableRow tableRow : allRows) {
                Future<?> future = MultiExecStep.this.multhreadPool.submit(new ExecOneTask(tableRow));
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info("return value is " + future);
            }
            MultiExecStep.this.multhreadPool.shutdown();
            try {
                while (!MultiExecStep.this.multhreadPool.awaitTermination(100L, TimeUnit.MILLISECONDS)) {
                }
            }
            catch (InterruptedException e1) {
                LOGGER.error("threadPool query shutdown err", (Throwable)e1);
            }
            if (!MultiExecStep.this.getFailedExecIndexList().isEmpty()) {
                MultiExecStep.this.mullayout.getCheckButton().setEnabled(true);
            }
            MultiExecStep.this.chgMultiStepStatus(true);
            MultiExecStep.this.mulfinish = true;
            try {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("exec result:" + MultiExecStep.this.devStatusMap);
                }
            }
            catch (Exception e) {
                LOGGER.error("Log records failed", (Throwable)e);
            }
        }
    }

    private class FileImportActionListener
    implements ToolHyperLinkLabel.ClickListener {
        private static final String SELECTFILE_DEFAULT_ID = "file_import_saveresult_path_id001";
        private File selectFile = null;

        private FileImportActionListener() {
        }

        public void clickLink(MouseEvent e) {
            this.importAction();
        }

        private void importAction() {
            this.selectFiles();
            this.importFile();
        }

        private void selectFiles() {
            LOGGER.info("you click chooseFile btn.");
            String[] ext = new String[]{};
            this.selectFile = ToolFileChooser.selectFile((Window)MultiExecStep.this.getParentWindow(), (String)ResourceUtil.getString("bizpack.wizard.exec.import.files"), (String[])ext, (String)SELECTFILE_DEFAULT_ID, (String)ResourceUtil.getString("bizpack.wizard.exec.files"), (int)0, (boolean)true, (boolean)true, (Locale)Locale.getDefault());
        }

        private void importFile() {
            if (this.selectFile != null && this.selectFile.exists()) {
                if (!this.checkFileSize()) {
                    DialogUtils.showErrorDialog((JDialog)MultiExecStep.this.getParent(), (String)ResourceUtil.getString("bizpack.wizard.exec.filesize.error"));
                    try {
                        if (LOGGER.isInfoEnabled()) {
                            LOGGER.info("import file:" + this.selectFile.getCanonicalPath() + " failed. file size is too lagre.");
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Log records failed", (Throwable)e);
                    }
                    return;
                }
                try {
                    this.transData2Py();
                }
                catch (IOException ioe) {
                    LOGGER.error("import selectFile file failed, transData2Py failed.");
                    return;
                }
                Callable[] tasks = this.getExecFileImportTasks();
                List results = AsyncExcutor.execute((Window)MultiExecStep.this.getParentWindow(), (Callable[])tasks);
                this.checkUploadSucc(results);
            }
        }

        private boolean checkFileSize() {
            return this.selectFile.length() <= 0x1400000L;
        }

        private Callable<?>[] getExecFileImportTasks() {
            ExecPyScriptTask task = MultiExecStep.this.initOneExecPy();
            List<String> keyList = this.getSelectedRowKey();
            Callable[] tasks = new Callable[keyList.size()];
            int index = 0;
            try {
                for (String key : keyList) {
                    tasks[index++] = new ImportCallable(MultiExecStep.this.getSsEnv(), key, task);
                }
            }
            catch (Exception e) {
                LOGGER.error("getExecFileImportTasks", (Throwable)e);
            }
            return tasks;
        }

        private void checkUploadSucc(List<ImpotFileResultType> results) {
            ResultType type = this.getResultType(results);
            String selectFilePath = null;
            try {
                selectFilePath = this.selectFile.getCanonicalPath();
            }
            catch (IOException e) {
                LOGGER.error("Get selectFile Canonical path failed. ");
            }
            if (type.equals((Object)ResultType.SUCCESS)) {
                DialogUtils.showSuccessDialog((JDialog)MultiExecStep.this.getParent(), (String)ResourceUtil.getString("bizpack.wizard.exec.import.succ"));
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("import file " + selectFilePath + " result:" + ResultType.SUCCESS.name());
                }
                return;
            }
            if (type.equals((Object)ResultType.PART_SUCCESS)) {
                DialogUtils.showErrorDialog((JDialog)MultiExecStep.this.getParent(), (String)ResourceUtil.getString("bizpack.wizard.exec.import.partfail"));
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("import file " + selectFilePath + " result:" + ResultType.PART_SUCCESS.name());
                }
                return;
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("import file " + selectFilePath + " result:" + ResultType.FAIL.name());
            }
            DialogUtils.showErrorDialog((JDialog)MultiExecStep.this.getParent(), (String)ResourceUtil.getString("bizpack.wizard.exec.import.fail"));
        }

        private ResultType getResultType(List<ImpotFileResultType> results) {
            boolean result = true;
            boolean result1 = false;
            for (ImpotFileResultType resultType : results) {
                result &= resultType.isSucc();
                result1 ^= resultType.isSucc();
            }
            ResultType type = result ? ResultType.SUCCESS : (result1 ? ResultType.PART_SUCCESS : ResultType.FAIL);
            return type;
        }

        private void transData2Py() throws IOException {
            MultiExecStep.this.getSsEnv().getDict().put("selectFilePath", this.selectFile.getCanonicalPath());
        }

        private List<String> getSelectedRowKey() {
            List selectRows = MultiExecStep.this.multable.getIsmTable().getMarkedRows();
            ArrayList<String> keylist = new ArrayList<String>();
            try {
                for (TableRow row : selectRows) {
                    TableData oneRow = (TableData)row.getIdentifier();
                    Map<String, String> id2Map = oneRow.getId2DataMap();
                    String key = id2Map.get(MultiExecStep.this.mulsignColId);
                    keylist.add(key);
                }
            }
            catch (Exception e) {
                LOGGER.error("getSelectedRowKey", (Throwable)e);
            }
            return keylist;
        }
    }

    private class ExecActionListener
    implements ActionListener {
        private ExecActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                MultiExecStep.this.mullayout.getCheckButton().setEnabled(false);
                FlowWizardState state = MultiExecStep.this.getUIState(false, false);
                MultiExecStep.this.changeUIState(state);
                List selectRows = MultiExecStep.this.multable.getIsmTable().getMarkedRows();
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("select size = " + selectRows.size());
                }
                if (!MultiExecStep.this.preProcess()) {
                    MultiExecStep.this.mullayout.getCheckButton().setEnabled(true);
                    MultiExecStep.this.changeUIState(MultiExecStep.this.getUIState(false, false));
                    MultiExecStep.this.chgMultiStepStatus(false);
                } else {
                    if (!MultiExecStep.this.checkSelectionExec(selectRows)) {
                        MultiExecStep.this.mullayout.getCheckButton().setEnabled(true);
                        MultiExecStep.this.changeUIState(MultiExecStep.this.getUIState(false, false));
                        MultiExecStep.this.chgMultiStepStatus(true);
                        return;
                    }
                    if (MultiExecStep.this.enableMutiSelect) {
                        new SelectExecThread().start();
                        return;
                    }
                    if (MultiExecStep.this.mulisCheck) {
                        String mode = MultiExecStep.this.mulcfg.getMode().getKey();
                        MultiExecStep.this.mullayout.getCheckButton().setText(ResourceUtil.getString("bizpack.wizard.exec.btn." + mode + ".re"));
                        UCD.formatMnemonicDisplay((AbstractButton)MultiExecStep.this.mullayout.getCheckButton());
                        MultiExecStep.this.mulisCheck = false;
                        new StartCheckThread().start();
                    } else {
                        MultiExecStep.this.reCheck();
                    }
                }
                LOGGER.info("actionPerformed end");
            }
            catch (Exception e1) {
                LOGGER.error("ExecActionListener", (Throwable)e1);
            }
        }
    }
}

