/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.step.preset.comp;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.context.JythonContext;
import com.huawei.ism.tool.bizpack.wizardparse.task.ExecPyUtils;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.preset.comp.InputItem;
import com.huawei.ism.tool.bizpack.wizardparse.util.PackagesResource;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemGroup {
    private static final Logger LOGGER = LoggerFactory.getLogger(ItemGroup.class);
    private String script = "";
    private String param = "";
    private boolean scriptInit = false;
    private GroupLayout layout = GroupLayout.CENTER;
    private List<InputItem> inputItems = new ArrayList<InputItem>();

    private void initItemsByScript() {
        JythonContext ssEnv = BizPackageContext.getInstance().getJythonContext();
        PackagesResource resutil = BizPackageContext.getInstance().getCurBizPackage().getResUtil();
        if (!ExecPyUtils.execInitScript(this.script, this.param, "getItems")) {
            return;
        }
        if (!((Boolean)ssEnv.getDict().get("succ")).booleanValue()) {
            String errMsg = (String)ssEnv.getDict().get("errMsg");
            LOGGER.error("init presetting step dropDown Text err." + errMsg);
        } else {
            String jsonStr = (String)ssEnv.getDict().get("retData");
            JSONArray jsonArray = new JSONArray(jsonStr);
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject jsonObject = (JSONObject)jsonArray.get(i);
                InputItem inputItem = this.loadOInputItemJson(jsonObject, resutil);
                this.inputItems.add(inputItem);
            }
        }
    }

    private InputItem loadOInputItemJson(JSONObject object, PackagesResource resutil) {
        String refreshId;
        InputItem inputItem = new InputItem();
        inputItem.setId(this.getJsonValue("id", object));
        inputItem.setType(this.getJsonValue("type", object));
        inputItem.setLabel(this.getJsonValue("label", object));
        inputItem.setRule(this.getJsonValue("rule", object));
        inputItem.setDefaultValue(this.getJsonValue("default", object));
        String defaultValueKey = this.getJsonValue("defaultKey", object);
        if (!StringUtils.isNULLStr(defaultValueKey)) {
            inputItem.setDefaultValue(resutil.getString(defaultValueKey));
        }
        inputItem.setInitSript(this.getJsonValue("initScript", object));
        inputItem.setInitParam(this.getJsonValue("param", object));
        String lenStr = this.getJsonValue("length", object);
        if (!StringUtils.isNULLStr(lenStr)) {
            inputItem.setCompSpectLen(Integer.valueOf(lenStr));
        }
        if (!(refreshId = this.getJsonValue("refreshItems", object)).equals("")) {
            String[] refreshIds = refreshId.split(",");
            List<String> refreshList = Arrays.asList(refreshIds);
            inputItem.setRefreshItems(refreshList);
        }
        return inputItem;
    }

    private String getJsonValue(String key, JSONObject object) {
        if (!object.has(key)) {
            return "";
        }
        String value = (String)object.get(key);
        if (StringUtils.isNULLStr(value)) {
            return "";
        }
        return value;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public String getParam() {
        return this.param;
    }

    public void setParam(String param) {
        this.param = param;
    }

    public List<InputItem> getInputItems() {
        if (!StringUtils.isNULLStr(this.script) && !this.scriptInit) {
            this.initItemsByScript();
            this.scriptInit = true;
        }
        return this.inputItems;
    }

    public void setInputItems(List<InputItem> inputItems) {
        this.inputItems = inputItems;
    }

    public GroupLayout getLayout() {
        return this.layout;
    }

    public void setLayout(String layoutStr) {
        if (StringUtils.isNULLStr(layoutStr)) {
            return;
        }
        if (layoutStr.equalsIgnoreCase(GroupLayout.NORTH.toString())) {
            this.layout = GroupLayout.NORTH;
        } else if (layoutStr.equalsIgnoreCase(GroupLayout.SOUTH.toString())) {
            this.layout = GroupLayout.SOUTH;
        }
    }

    public static enum GroupLayout {
        NORTH,
        SOUTH,
        CENTER;

    }
}

