/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.util;

import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import java.io.File;
import java.io.FileInputStream;
import java.util.Locale;
import java.util.Properties;
import javax.swing.ImageIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackagesResource {
    public static final String LOG_RECORD_FAILE = "Log records failed";
    public static final String UNMATCHED_STRING = "--";
    private static final Logger LOGGER = LoggerFactory.getLogger(PackagesResource.class);
    private static final String RES = "res";
    private static final String LANGUAGE = "language";
    private static final String IMAGE = "image";
    private static final String COMMON = "common";
    private static final String SUFFIX = ".properties";
    private static final LanguageManager LAN_MAN = LanguageManager.getInstance();
    private String pacPath = "";
    private Properties propertiesZh;
    private Properties propertiesEn;

    public PackagesResource(String packagesPath) {
        this.pacPath = packagesPath;
        this.propertiesZh = this.createProperties(Locale.CHINESE);
        this.propertiesEn = this.createProperties(Locale.ENGLISH);
    }

    public String getString(String key) {
        Locale locale = LAN_MAN.getCurrentLanguage();
        Locale loc = new Locale(locale.getLanguage());
        return this.getString(key, loc);
    }

    public String getString(String key, Locale loc) {
        Properties properties = null;
        properties = loc.equals(Locale.CHINESE) ? this.propertiesZh : (loc.equals(Locale.ENGLISH) ? this.propertiesEn : null);
        if (null == properties) {
            return UNMATCHED_STRING;
        }
        return properties.getProperty(key, UNMATCHED_STRING);
    }

    private String getCommonPath() {
        StringBuilder commonPath = new StringBuilder();
        commonPath.append(this.pacPath);
        commonPath.append(File.separator);
        commonPath.append(RES);
        commonPath.append(File.separator);
        commonPath.append(LANGUAGE);
        commonPath.append(File.separator);
        commonPath.append(COMMON);
        return commonPath.toString();
    }

    public ImageIcon getImage(String key) {
        String imageDir = this.getImageDir(key);
        File imageFile = new File(imageDir);
        if (!imageFile.exists()) {
            return new ImageIcon();
        }
        return new ImageIcon(imageDir);
    }

    private String getImageDir(String imageName) {
        StringBuilder dir = new StringBuilder();
        dir.append(this.pacPath);
        dir.append(File.separator);
        dir.append(RES);
        dir.append(File.separator);
        dir.append(IMAGE);
        dir.append(File.separator);
        dir.append(imageName);
        return dir.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties createProperties(Locale locale) {
        File file = new File(this.getPropertiesDir(locale));
        if (!file.exists()) {
            return null;
        }
        FileInputStream inpf = null;
        Properties properties = new Properties();
        try {
            inpf = new FileInputStream(file);
            properties.load(inpf);
        }
        catch (Exception e) {
            LOGGER.error("Load properties ERR", (Throwable)e);
        }
        finally {
            StreamUtils.closeStream(null, inpf);
        }
        return properties;
    }

    private String getPropertiesDir(Locale locale) {
        StringBuilder path = new StringBuilder();
        path.append(this.getCommonPath());
        path.append('_');
        path.append(locale.toString());
        path.append(SUFFIX);
        return path.toString();
    }
}

