/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.util;

import com.huawei.ism.tool.bizpack.wizardparse.util.TemplateUtils;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.pubservice.impl.AbstractUserOpDataSev;
import com.huawei.ism.tool.obase.utils.FileUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportBuilder {
    private static final Logger log = LoggerFactory.getLogger(ReportBuilder.class);
    private String outFilePath;
    private static final String[] HTML_NAME_LIST = new String[]{"detail.html", "left.html", "index.html", "summary.html", "front.html"};
    private static final String[] HTML_RESOURCES = new String[]{"css", "js", "images"};

    public ReportBuilder(String outFilePath) {
        this.outFilePath = outFilePath;
        File file = new File(outFilePath);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public boolean buildHtml(Map<String, Object> data, String httpName) {
        boolean flag = false;
        String filePatch = this.outFilePath + File.separator + httpName;
        try (BufferedWriter file = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePatch, true), StandardCharsets.UTF_8));){
            String ftl = TemplateUtils.processorFtl(httpName, data);
            file.write(ftl);
            flag = true;
        }
        catch (Exception e) {
            log.error("build result file error.", (Throwable)e);
        }
        return flag;
    }

    public boolean buildHtmlList(Map<String, Object> data) {
        for (String htmlName : HTML_NAME_LIST) {
            if (this.buildHtml(data, htmlName)) continue;
            return false;
        }
        return true;
    }

    public void copyHtmlResource() {
        String htmlPath = ApplicationContext.getInstance().getWorkPath() + File.separator + "packages" + File.separator + "fru";
        log.info("start to copy html dir htmlPath:{}, outFilePath:{}", (Object)htmlPath, (Object)this.outFilePath);
        for (String htmlResource : HTML_RESOURCES) {
            FileUtils.copyDir((String)(htmlPath + File.separator + htmlResource), (String)(this.outFilePath + File.separator + htmlResource));
        }
    }

    public void buildLogInfo() {
        File targetDir = new File(this.outFilePath);
        AbstractUserOpDataSev.copyLogInfo(targetDir);
    }
}

