/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.util;

import freemarker.cache.CacheStorage;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.MruCacheStorage;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TemplateUtils {
    private static final Logger log = LoggerFactory.getLogger(TemplateUtils.class);
    private static final String UTF8ENCODE = "UTF-8";
    private static final String TEMPLATE_DICTIONARY = "/html/";
    private static final Configuration CONFIGURATION = new Configuration(Configuration.VERSION_2_3_30);
    private static final int MAX = 200;

    private TemplateUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String processorFtl(String ftlPath, Object data) {
        try (CharArrayWriter arrayWriter = new CharArrayWriter();){
            Template template = CONFIGURATION.getTemplate(ftlPath, UTF8ENCODE);
            template.process(data, (Writer)arrayWriter);
            arrayWriter.flush();
            String string = arrayWriter.toString();
            return string;
        }
        catch (TemplateException | IOException e) {
            log.error("build freemarker template faild. path is : {}", (Object)ftlPath, (Object)e);
            return "";
        }
    }

    static {
        ClassTemplateLoader classTemplateLoader = new ClassTemplateLoader(TemplateUtils.class, TEMPLATE_DICTIONARY);
        MultiTemplateLoader loader = new MultiTemplateLoader(new TemplateLoader[]{classTemplateLoader});
        CONFIGURATION.setCacheStorage((CacheStorage)new MruCacheStorage(10, 200));
        CONFIGURATION.setLocale(Locale.getDefault());
        CONFIGURATION.clearEncodingMap();
        CONFIGURATION.setEncoding(Locale.CHINESE, UTF8ENCODE);
        CONFIGURATION.setTemplateLoader((TemplateLoader)loader);
    }
}

