/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.cbb.gtsib.component.bean;

import com.huawei.baize.cbb.gtsib.component.bean.BoardVersion;
import com.huawei.baize.cbb.gtsib.component.bean.Location;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class Board {
    @XmlAttribute(name="BoardType")
    private String boardType = "";
    @XmlAttribute(name="BarCode")
    private String barCode = "";
    @XmlAttribute(name="Item")
    private String item = "";
    @XmlAttribute(name="Description")
    private String description = "";
    @XmlAttribute(name="Location")
    private String location = "";
    @XmlAttribute(name="Name")
    private String name = "";
    @XmlAttribute(name="Manufactured")
    private String manufactured = "";
    @XmlAttribute(name="VendorName")
    private String vendorName = "";
    @XmlAttribute(name="IssueNumber")
    private String issueNumber = "";
    @XmlElement(name="BoardVersion")
    private List<BoardVersion> boardVersions;
    private Location parseLocation;

    public String getSlot() {
        return this.getParseLocation().getSubSlot().isEmpty() || this.parseLocation.getSubSlot().equals("-1") ? this.parseLocation.getSlot() : this.parseLocation.getSubSlot();
    }

    public Location getParseLocation() {
        if (this.parseLocation == null) {
            this.parseLocation = new Location(this.location);
        }
        return this.parseLocation;
    }

    public static BoardBuilder builder() {
        return new BoardBuilder();
    }

    public void setBoardType(String boardType) {
        this.boardType = boardType;
    }

    public void setBarCode(String barCode) {
        this.barCode = barCode;
    }

    public void setItem(String item) {
        this.item = item;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setManufactured(String manufactured) {
        this.manufactured = manufactured;
    }

    public void setVendorName(String vendorName) {
        this.vendorName = vendorName;
    }

    public void setIssueNumber(String issueNumber) {
        this.issueNumber = issueNumber;
    }

    public void setBoardVersions(List<BoardVersion> boardVersions) {
        this.boardVersions = boardVersions;
    }

    public void setParseLocation(Location parseLocation) {
        this.parseLocation = parseLocation;
    }

    public String getBoardType() {
        return this.boardType;
    }

    public String getBarCode() {
        return this.barCode;
    }

    public String getItem() {
        return this.item;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLocation() {
        return this.location;
    }

    public String getName() {
        return this.name;
    }

    public String getManufactured() {
        return this.manufactured;
    }

    public String getVendorName() {
        return this.vendorName;
    }

    public String getIssueNumber() {
        return this.issueNumber;
    }

    public List<BoardVersion> getBoardVersions() {
        return this.boardVersions;
    }

    public String toString() {
        return "Board(boardType=" + this.getBoardType() + ", barCode=" + this.getBarCode() + ", item=" + this.getItem() + ", description=" + this.getDescription() + ", location=" + this.getLocation() + ", name=" + this.getName() + ", manufactured=" + this.getManufactured() + ", vendorName=" + this.getVendorName() + ", issueNumber=" + this.getIssueNumber() + ", boardVersions=" + this.getBoardVersions() + ", parseLocation=" + this.getParseLocation() + ")";
    }

    public Board() {
    }

    public Board(String boardType, String barCode, String item, String description, String location, String name, String manufactured, String vendorName, String issueNumber, List<BoardVersion> boardVersions, Location parseLocation) {
        this.boardType = boardType;
        this.barCode = barCode;
        this.item = item;
        this.description = description;
        this.location = location;
        this.name = name;
        this.manufactured = manufactured;
        this.vendorName = vendorName;
        this.issueNumber = issueNumber;
        this.boardVersions = boardVersions;
        this.parseLocation = parseLocation;
    }

    public static class BoardBuilder {
        private String boardType;
        private String barCode;
        private String item;
        private String description;
        private String location;
        private String name;
        private String manufactured;
        private String vendorName;
        private String issueNumber;
        private List<BoardVersion> boardVersions;
        private Location parseLocation;

        BoardBuilder() {
        }

        public BoardBuilder boardType(String boardType) {
            this.boardType = boardType;
            return this;
        }

        public BoardBuilder barCode(String barCode) {
            this.barCode = barCode;
            return this;
        }

        public BoardBuilder item(String item) {
            this.item = item;
            return this;
        }

        public BoardBuilder description(String description) {
            this.description = description;
            return this;
        }

        public BoardBuilder location(String location) {
            this.location = location;
            return this;
        }

        public BoardBuilder name(String name) {
            this.name = name;
            return this;
        }

        public BoardBuilder manufactured(String manufactured) {
            this.manufactured = manufactured;
            return this;
        }

        public BoardBuilder vendorName(String vendorName) {
            this.vendorName = vendorName;
            return this;
        }

        public BoardBuilder issueNumber(String issueNumber) {
            this.issueNumber = issueNumber;
            return this;
        }

        public BoardBuilder boardVersions(List<BoardVersion> boardVersions) {
            this.boardVersions = boardVersions;
            return this;
        }

        public BoardBuilder parseLocation(Location parseLocation) {
            this.parseLocation = parseLocation;
            return this;
        }

        public Board build() {
            return new Board(this.boardType, this.barCode, this.item, this.description, this.location, this.name, this.manufactured, this.vendorName, this.issueNumber, this.boardVersions, this.parseLocation);
        }

        public String toString() {
            return "Board.BoardBuilder(boardType=" + this.boardType + ", barCode=" + this.barCode + ", item=" + this.item + ", description=" + this.description + ", location=" + this.location + ", name=" + this.name + ", manufactured=" + this.manufactured + ", vendorName=" + this.vendorName + ", issueNumber=" + this.issueNumber + ", boardVersions=" + this.boardVersions + ", parseLocation=" + this.parseLocation + ")";
        }
    }
}

