/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.cbb.gtsib.component.bean;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CollectNeResult {
    private static final List<String> RESULT_LIST_CSV_HEADERS = Arrays.asList("deviceIP", "deviceId", "devicePort", "vendor", "deviceName", "deviceType", "deviceVersion", "collectTime", "status", "costTime", "groupName", "template", "patchVersion", "resultPath", "connectStatus", "PeriodicCollectionSuccessRate", "Details");
    private String deviceName;
    private String neType;
    private String neVersion;
    private String nePatch;
    private String partSn;
    private String status;
    private String resultPath;
    private String connectStatus;
    private String details;
    private String deviceIP;

    public static CollectNeResult getCollectNeResult(Map<String, String> resultMap) {
        return CollectNeResult.builder().deviceName(resultMap.getOrDefault("deviceName", "")).neType(resultMap.getOrDefault("deviceType", "")).neVersion(resultMap.getOrDefault("NE_Version", "")).nePatch(resultMap.getOrDefault("NE_Patch", "")).partSn(resultMap.getOrDefault("SN", "")).details(resultMap.getOrDefault("Details", "")).connectStatus(resultMap.getOrDefault("connectStatus", "")).resultPath(resultMap.getOrDefault("resultPath", "")).status(resultMap.getOrDefault("status", "")).deviceIP(resultMap.getOrDefault("deviceIP", "")).build();
    }

    public static CollectNeResult getCollectNeResult(String line) {
        List items = Arrays.stream(line.split(",")).map(item -> item.replaceAll("\"", "")).collect(Collectors.toList());
        return CollectNeResult.builder().deviceName((String)items.get(RESULT_LIST_CSV_HEADERS.indexOf("deviceName"))).neType((String)items.get(RESULT_LIST_CSV_HEADERS.indexOf("deviceType"))).neVersion((String)items.get(RESULT_LIST_CSV_HEADERS.indexOf("deviceVersion"))).nePatch((String)items.get(RESULT_LIST_CSV_HEADERS.indexOf("patchVersion"))).partSn("").details((String)items.get(RESULT_LIST_CSV_HEADERS.indexOf("Details"))).connectStatus((String)items.get(RESULT_LIST_CSV_HEADERS.indexOf("connectStatus"))).resultPath((String)items.get(RESULT_LIST_CSV_HEADERS.indexOf("resultPath"))).status((String)items.get(RESULT_LIST_CSV_HEADERS.indexOf("status"))).deviceIP((String)items.get(RESULT_LIST_CSV_HEADERS.indexOf("deviceIP"))).build();
    }

    public List<String> toRow() {
        return Arrays.asList(this.deviceIP, this.deviceName, this.neType, this.status, this.resultPath, this.connectStatus, this.details, this.partSn, this.neVersion, this.nePatch);
    }

    CollectNeResult(String deviceName, String neType, String neVersion, String nePatch, String partSn, String status, String resultPath, String connectStatus, String details, String deviceIP) {
        this.deviceName = deviceName;
        this.neType = neType;
        this.neVersion = neVersion;
        this.nePatch = nePatch;
        this.partSn = partSn;
        this.status = status;
        this.resultPath = resultPath;
        this.connectStatus = connectStatus;
        this.details = details;
        this.deviceIP = deviceIP;
    }

    public static CollectNeResultBuilder builder() {
        return new CollectNeResultBuilder();
    }

    public static class CollectNeResultBuilder {
        private String deviceName;
        private String neType;
        private String neVersion;
        private String nePatch;
        private String partSn;
        private String status;
        private String resultPath;
        private String connectStatus;
        private String details;
        private String deviceIP;

        CollectNeResultBuilder() {
        }

        public CollectNeResultBuilder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public CollectNeResultBuilder neType(String neType) {
            this.neType = neType;
            return this;
        }

        public CollectNeResultBuilder neVersion(String neVersion) {
            this.neVersion = neVersion;
            return this;
        }

        public CollectNeResultBuilder nePatch(String nePatch) {
            this.nePatch = nePatch;
            return this;
        }

        public CollectNeResultBuilder partSn(String partSn) {
            this.partSn = partSn;
            return this;
        }

        public CollectNeResultBuilder status(String status) {
            this.status = status;
            return this;
        }

        public CollectNeResultBuilder resultPath(String resultPath) {
            this.resultPath = resultPath;
            return this;
        }

        public CollectNeResultBuilder connectStatus(String connectStatus) {
            this.connectStatus = connectStatus;
            return this;
        }

        public CollectNeResultBuilder details(String details) {
            this.details = details;
            return this;
        }

        public CollectNeResultBuilder deviceIP(String deviceIP) {
            this.deviceIP = deviceIP;
            return this;
        }

        public CollectNeResult build() {
            return new CollectNeResult(this.deviceName, this.neType, this.neVersion, this.nePatch, this.partSn, this.status, this.resultPath, this.connectStatus, this.details, this.deviceIP);
        }

        public String toString() {
            return "CollectNeResult.CollectNeResultBuilder(deviceName=" + this.deviceName + ", neType=" + this.neType + ", neVersion=" + this.neVersion + ", nePatch=" + this.nePatch + ", partSn=" + this.partSn + ", status=" + this.status + ", resultPath=" + this.resultPath + ", connectStatus=" + this.connectStatus + ", details=" + this.details + ", deviceIP=" + this.deviceIP + ")";
        }
    }
}

