/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.cbb.gtsib.component.bean;

import com.huawei.baize.cbb.gtsib.component.bean.Board;
import com.huawei.baize.cbb.gtsib.component.bean.DataEnd;
import com.huawei.baize.cbb.gtsib.component.bean.DataTable;
import com.huawei.baize.cbb.gtsib.component.bean.DataVersion;
import com.huawei.baize.cbb.gtsib.component.bean.DevicePart;
import com.huawei.baize.cbb.gtsib.component.bean.NEInformation;
import com.huawei.baize.cbb.gtsib.component.bean.Shelf;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="FILEDATA")
public class FileData {
    @XmlElement(name="DataVersion")
    private DataVersion dataVersion;
    @XmlElement(name="DataTable")
    private DataTable dataTable;
    @XmlElement(name="DataEnd")
    private DataEnd dataEnd;
    private String neId = "";
    private String neType = "";
    private String neVersion = "";
    private String nePatch = "";

    public String getParseNeId() {
        this.neId = this.getNeId();
        if (this.neId.contains("_")) {
            this.neId = this.neId.replaceAll("_", ",");
        }
        return this.neId;
    }

    private String getNeId() {
        if (!this.neId.isEmpty() && !"(NULL)".equals(this.neId)) {
            return this.neId;
        }
        if (this.hasUniqueNeIdInNEInformation()) {
            return this.neId;
        }
        if (this.hasUniqueNeIdInShelfs()) {
            return this.neId;
        }
        if (this.hasUniqueNeIdInBoards()) {
            return this.neId;
        }
        this.hasUniqueNeIdInDeviceParts();
        return this.neId;
    }

    private void hasUniqueNeIdInDeviceParts() {
        if (this.dataTable.getOutSourcingRoot() == null) {
            return;
        }
        Optional<DevicePart> notEmptySnBoard = this.dataTable.getOutSourcingRoot().getDevices().get(0).getDeviceParts().stream().filter(board -> !"(NULL)".equals(board.getSn())).filter(board -> board.getSn().length() > 4).findFirst();
        notEmptySnBoard.ifPresent(devicePart -> {
            this.neId = devicePart.getSn();
        });
    }

    private boolean hasUniqueNeIdInBoards() {
        if (this.dataTable.getBoardRoot() == null) {
            return false;
        }
        Optional<Board> notEmptySnBoard = this.dataTable.getBoardRoot().getBoards().stream().filter(board -> !"(NULL)".equals(board.getBarCode())).filter(board -> board.getBarCode().length() > 4).filter(board -> board.getParseLocation() != null).filter(board -> board.getParseLocation().getShelf() != null).min((b1, b2) -> b1.getParseLocation().getShelf().compareToIgnoreCase(b2.getParseLocation().getShelf()));
        if (notEmptySnBoard.isPresent()) {
            this.neId = notEmptySnBoard.get().getBarCode();
            return true;
        }
        return false;
    }

    private boolean hasUniqueNeIdInShelfs() {
        if (this.dataTable.getShelfRoot() == null) {
            return false;
        }
        Optional<Shelf> notEmptySnShelf = this.dataTable.getShelfRoot().getShelfs().stream().filter(shelf -> !"(NULL)".equals(shelf.getBarCode())).filter(shelf -> shelf.getBarCode().length() > 4).filter(shelf -> shelf.getParseLocation() != null).filter(shelf -> shelf.getParseLocation().getShelf() != null).min((s1, s2) -> s1.getParseLocation().getShelf().compareToIgnoreCase(s2.getParseLocation().getShelf()));
        if (notEmptySnShelf.isPresent()) {
            this.neId = notEmptySnShelf.get().getBarCode();
            return true;
        }
        return false;
    }

    private boolean hasUniqueNeIdInNEInformation() {
        if (this.dataTable.getNeInformation() == null) {
            return false;
        }
        NEInformation neInformation = this.dataTable.getNeInformation();
        String neEsn = neInformation.getNeEsn();
        if (neEsn != null && !"(NULL)".equals(neEsn) && neEsn.length() > 4) {
            this.neId = neInformation.getNeEsn();
            return true;
        }
        String neSn = neInformation.getNeSn();
        if (neSn != null && !"(NULL)".equals(neSn) && neSn.length() > 4) {
            this.neId = neInformation.getNeSn();
            return true;
        }
        String sn = neInformation.getSn();
        if (sn != null && !"(NULL)".equals(sn) && sn.length() > 4) {
            this.neId = neInformation.getSn();
            return true;
        }
        this.neId = neInformation.getNeId();
        return false;
    }

    public String getNeType() {
        if (this.neType.isEmpty() && this.dataTable.getNeInformation() != null) {
            this.neType = this.dataTable.getNeInformation().getType();
        }
        return this.neType;
    }

    public String getNeVersion() {
        if (this.neVersion.isEmpty() && this.dataTable.getNeInformation() != null) {
            this.neVersion = this.dataTable.getNeInformation().getVersion();
        }
        if (this.neVersion.isEmpty() && this.dataTable.getSoftwareRoot() != null) {
            this.neVersion = this.dataTable.getSoftwareRoot().getSoftwareVersions().get(0).getVersion();
        }
        return this.neVersion;
    }

    public DataVersion getDataVersion() {
        return this.dataVersion;
    }

    public DataTable getDataTable() {
        return this.dataTable;
    }

    public DataEnd getDataEnd() {
        return this.dataEnd;
    }

    public String getNePatch() {
        return this.nePatch;
    }

    public void setDataVersion(DataVersion dataVersion) {
        this.dataVersion = dataVersion;
    }

    public void setDataTable(DataTable dataTable) {
        this.dataTable = dataTable;
    }

    public void setDataEnd(DataEnd dataEnd) {
        this.dataEnd = dataEnd;
    }

    public void setNeId(String neId) {
        this.neId = neId;
    }

    public void setNeType(String neType) {
        this.neType = neType;
    }

    public void setNeVersion(String neVersion) {
        this.neVersion = neVersion;
    }

    public void setNePatch(String nePatch) {
        this.nePatch = nePatch;
    }

    public String toString() {
        return "FileData(dataVersion=" + this.getDataVersion() + ", dataTable=" + this.getDataTable() + ", dataEnd=" + this.getDataEnd() + ", neId=" + this.getNeId() + ", neType=" + this.getNeType() + ", neVersion=" + this.getNeVersion() + ", nePatch=" + this.getNePatch() + ")";
    }

    public FileData(DataVersion dataVersion, DataTable dataTable, DataEnd dataEnd, String neId, String neType, String neVersion, String nePatch) {
        this.dataVersion = dataVersion;
        this.dataTable = dataTable;
        this.dataEnd = dataEnd;
        this.neId = neId;
        this.neType = neType;
        this.neVersion = neVersion;
        this.nePatch = nePatch;
    }

    public FileData() {
    }
}

