/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.cbb.gtsib.component.common;

import com.huawei.baize.cbb.gtsib.component.bean.Board;
import com.huawei.baize.cbb.gtsib.component.bean.BoardRoot;
import com.huawei.baize.cbb.gtsib.component.bean.Device;
import com.huawei.baize.cbb.gtsib.component.bean.DevicePart;
import com.huawei.baize.cbb.gtsib.component.bean.FileData;
import com.huawei.baize.cbb.gtsib.component.bean.Location;
import com.huawei.baize.cbb.gtsib.component.bean.NEInformation;
import com.huawei.baize.cbb.gtsib.component.bean.OutSourcingRoot;
import com.huawei.baize.cbb.gtsib.component.bean.Shelf;
import com.huawei.baize.cbb.gtsib.component.bean.ShelfRoot;
import com.huawei.baize.cbb.gtsib.component.bean.SoftwareRoot;
import com.huawei.baize.cbb.gtsib.component.bean.SoftwareVersion;
import com.huawei.baize.cbb.gtsib.component.common.Const;
import com.huawei.baize.cbb.gtsib.component.utils.MappingUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeNode {
    private static final Logger log = LoggerFactory.getLogger(TreeNode.class);
    private String partSn = "";
    private String partType = "";
    private String partCategory = "";
    private String item = "";
    private String description = "";
    private String slot = "";
    private String parentSn = "";
    private String neId = "";
    private String neType = "";
    private String neVersion = "";
    private String nePatch = "";
    private String fatherNeId = "";
    private List<TreeNode> children = new ArrayList<TreeNode>();
    private Location location;

    public static Set<String> getHeaders(String lang) {
        return MappingUtils.getHeaders(new LinkedHashSet<String>(TreeNode.getHeaders()), lang);
    }

    public static List<String> getHeaders() {
        return Arrays.asList("Part_SN", "Part_Type", "Part_Category", "Item", "Description", "Slot", "Parent_SN", "NE_ID", "NE_Type", "NE_Version", "NE_Patch");
    }

    public static TreeNode build(FileData fileData) {
        TreeNode treeNode = new TreeNode();
        treeNode.loadNeInformation(fileData);
        treeNode.loadShelflist(fileData);
        treeNode.loadBoardlist(fileData);
        treeNode.loadOutSourcinglist(fileData);
        if (treeNode.children.size() != 1) {
            return treeNode;
        }
        TreeNode neNode = treeNode.children.get(0);
        if (neNode.children.isEmpty()) {
            if (neNode.partSn.isEmpty()) {
                neNode.partSn = neNode.neId;
            }
            if (neNode.partCategory.equals("NE")) {
                treeNode.children.clear();
            }
        }
        return treeNode;
    }

    private void loadNeInformation(FileData fileData) {
        NEInformation neInformation = fileData.getDataTable().getNeInformation();
        if (!neInformation.getFatherNeId().isEmpty()) {
            this.fatherNeId = neInformation.getFatherNeId();
        }
        this.neId = fileData.getParseNeId();
        this.neType = fileData.getNeType();
        this.neVersion = fileData.getNeVersion();
        this.partCategory = "ROOT_CATEGORY";
        if (this.neVersion.isEmpty()) {
            log.error("neInformation version is empty. neInformation.neId={}", (Object)neInformation.getNeId());
        }
        SoftwareRoot softwareRoot = fileData.getDataTable().getSoftwareRoot();
        this.loadNePatch(softwareRoot);
        this.children.add(this.buildNeNode());
    }

    private void loadNePatch(SoftwareRoot softwareRoot) {
        Optional<SoftwareVersion> softwareVersionOptional;
        if (softwareRoot == null) {
            log.debug("softwarelist is null, can't to load nePatch.");
            return;
        }
        List<SoftwareVersion> softwareVersions = softwareRoot.getSoftwareVersions();
        if (softwareVersions.isEmpty()) {
            log.debug("softwarelist is empty, can't to load nePatch.");
            return;
        }
        if (softwareVersions.size() > 1) {
            log.error("softwarelist size is more than 1, use first not empty patch as nePatch. softwarelist.size={}", (Object)softwareVersions.size());
        }
        if (!(softwareVersionOptional = softwareVersions.stream().filter(softwareVersion -> softwareVersion.getPatch() != null).filter(softwareVersion -> !softwareVersion.getPatch().getPatch().equals("IDLE")).findFirst()).isPresent()) {
            log.debug("no softwareVersion has patch, can't to load patch.");
            return;
        }
        this.nePatch = softwareVersionOptional.get().getPatch().getPatch();
    }

    private void loadShelflist(FileData fileData) {
        ShelfRoot shelfRoot = fileData.getDataTable().getShelfRoot();
        if (shelfRoot == null) {
            return;
        }
        List<Shelf> shelfs = shelfRoot.getShelfs();
        if (shelfs.isEmpty()) {
            return;
        }
        this.processBarCodeEqualsNeIdShelfs(shelfs);
        this.processShelfs(shelfs);
    }

    private void processShelfs(List<Shelf> shelfs) {
        shelfs.stream().filter(shelf -> !shelf.getBarCode().isEmpty()).forEach(shelf -> this.children.add(this.buildShelfNode((Shelf)shelf)));
    }

    private void processBarCodeEqualsNeIdShelfs(List<Shelf> shelfs) {
        List<Shelf> barCodeEqualsNeIdShelfs = shelfs.stream().filter(shelf -> shelf.getBarCode().equals(this.neId)).collect(Collectors.toList());
        barCodeEqualsNeIdShelfs.forEach(shelf -> {
            TreeNode neNode = this.children.get(0);
            neNode.partType = shelf.getType();
            neNode.partCategory = shelf.getClass().getSimpleName();
            neNode.item = shelf.getItem();
            neNode.description = shelf.getDescription();
            neNode.neId = this.neId;
            neNode.location = new Location(shelf.getLocation());
            shelfs.remove(shelf);
        });
    }

    private TreeNode buildNeNode() {
        TreeNode neNode = new TreeNode();
        neNode.partSn = this.neId;
        neNode.partCategory = "NE";
        neNode.slot = "-1";
        neNode.parentSn = "0";
        neNode.neId = this.neId;
        neNode.neType = this.neType;
        neNode.neVersion = this.neVersion;
        neNode.nePatch = this.nePatch;
        return neNode;
    }

    private TreeNode buildShelfNode(Shelf shelf) {
        TreeNode shelfNode = new TreeNode();
        shelfNode.partSn = shelf.getBarCode();
        shelfNode.partType = shelf.getType();
        shelfNode.partCategory = shelf.getClass().getSimpleName();
        shelfNode.item = shelf.getItem();
        shelfNode.description = shelf.getDescription();
        shelfNode.slot = "-1";
        shelfNode.parentSn = "0";
        shelfNode.neId = this.neId;
        shelfNode.location = new Location(shelf.getLocation());
        return shelfNode;
    }

    private void loadBoardlist(FileData fileData) {
        BoardRoot boardRoot = fileData.getDataTable().getBoardRoot();
        if (boardRoot == null) {
            log.debug("boardlist is null, can't to load boards.");
            return;
        }
        List<Board> boards = boardRoot.getBoards();
        if (boards.isEmpty()) {
            log.debug("boardlist is empty, can't to load boards.");
            return;
        }
        this.processBarCodeEqualsNeIdBoards(boards);
        this.children.forEach(shelf -> shelf.loadShelfBoardChildren(boards));
        boards.stream().filter(board -> !board.getBarCode().isEmpty()).forEach(board -> this.children.add(this.buildBoard((Board)board)));
    }

    private void processBarCodeEqualsNeIdBoards(List<Board> boards) {
        List<Board> barCodeEqualsNeIdBoards = boards.stream().filter(board -> board.getBarCode().equals(this.neId)).collect(Collectors.toList());
        TreeNode neNode = this.children.get(0);
        barCodeEqualsNeIdBoards.forEach(board -> {
            if (neNode.partCategory.equals("NE")) {
                neNode.setPartSn(board.getBarCode());
                neNode.setPartType(board.getBoardType());
                neNode.setItem(board.getItem());
                neNode.setLocation(board.getParseLocation());
                neNode.setPartCategory("Board");
                neNode.setDescription(board.getDescription());
            }
            boards.remove(board);
        });
    }

    private void loadShelfBoardChildren(List<Board> boards) {
        List parentBoards = boards.stream().filter(board -> this.location != null && board.getParseLocation().getShelf().equals(this.location.getShelf())).filter(board -> !board.getBarCode().isEmpty() && !board.getParseLocation().getSlot().isEmpty()).filter(board -> Arrays.asList(Const.INVALID_SUBSLOT).contains(board.getParseLocation().getSubSlot())).collect(Collectors.toList());
        boards.removeAll(parentBoards);
        List<Board> sameBarCodeBroads = parentBoards.stream().filter(board -> board.getBarCode().equals(this.partSn)).collect(Collectors.toList());
        if (sameBarCodeBroads.size() > 1) {
            log.error("more than 1 board.barCode equals shelf.partSn. boards.size={}, board.barCode={}", (Object)sameBarCodeBroads.size(), (Object)this.partSn);
        }
        sameBarCodeBroads.forEach(this::boardFillBackToShelf);
        parentBoards.removeAll(sameBarCodeBroads);
        parentBoards.stream().map(this::buildBoard).collect(Collectors.groupingBy(board -> board.getLocation().getSlot())).forEach((boardSlot, sameSlotBoards) -> {
            if (sameSlotBoards.size() > 1) {
                log.debug("more than 1 board has same slot, use the first one as parent. slot={}, boardNum={}", boardSlot, (Object)sameSlotBoards.size());
            }
            TreeNode parentBoard = (TreeNode)sameSlotBoards.get(0);
            sameSlotBoards.remove(parentBoard);
            List<Board> subBoards = boards.stream().filter(subBoard -> subBoard.getParseLocation().getShelf().equals(parentBoard.getLocation().getShelf())).filter(subBoard -> subBoard.getParseLocation().getSubSlot().equals(parentBoard.slot)).collect(Collectors.toList());
            boards.removeAll(subBoards);
            subBoards.forEach(subBoard -> parentBoard.children.add(parentBoard.buildBoard((Board)subBoard)));
            this.children.add(parentBoard);
            this.children.addAll((Collection<TreeNode>)sameSlotBoards);
        });
    }

    private void boardFillBackToShelf(Board board) {
        log.debug("board.barCode equals shelf.partSn, fill back the board field to the shelf. barCode={}", (Object)board.getBarCode());
        this.description = this.description.isEmpty() ? board.getDescription() : this.description;
        this.item = this.item.isEmpty() ? board.getItem() : this.item;
        this.partCategory = this.partCategory.equals("NE") ? "Shelf" : this.partCategory;
        this.partType = this.partType.isEmpty() ? board.getBoardType() : this.partType;
    }

    private TreeNode buildBoard(Board board) {
        TreeNode boardNode = new TreeNode();
        boardNode.partSn = board.getBarCode();
        boardNode.partType = board.getBoardType();
        boardNode.partCategory = board.getClass().getSimpleName();
        boardNode.item = board.getItem();
        boardNode.description = board.getDescription();
        String subSlot = board.getParseLocation().getSubSlot();
        boardNode.slot = Arrays.asList(Const.INVALID_SUBSLOT).contains(subSlot) ? board.getSlot() : subSlot;
        boardNode.parentSn = this.partSn;
        boardNode.neId = this.neId;
        boardNode.location = new Location(board.getLocation());
        return boardNode;
    }

    private void loadOutSourcinglist(FileData fileData) {
        OutSourcingRoot outSourcingRoot = fileData.getDataTable().getOutSourcingRoot();
        if (outSourcingRoot == null) {
            log.debug("OutSourcinglist is null, can't to load outSourcinglist.");
            return;
        }
        Device device = outSourcingRoot.getDevices().get(0);
        TreeNode neNode = this.children.get(0);
        this.deviceFillBackNe(device, neNode);
        List<DevicePart> deviceParts = device.getDeviceParts();
        this.children.forEach(shelf -> shelf.loadDeviceParts(deviceParts));
        deviceParts.forEach(devicePart -> neNode.children.add(neNode.buildDevicePart((DevicePart)devicePart)));
    }

    private void deviceFillBackNe(Device device, TreeNode neNode) {
        if (!neNode.partCategory.equals("NE")) {
            return;
        }
        if (!device.getSn().equals(neNode.getNeId())) {
            return;
        }
        neNode.partCategory = device.getType();
        neNode.item = device.getPartNumber();
    }

    private void loadDeviceParts(List<DevicePart> deviceParts) {
        if (this.location == null || this.location.getShelf() == null || this.location.getShelf().isEmpty()) {
            return;
        }
        String shelfName = this.location.getShelf();
        List<DevicePart> childrenDeviceParts = deviceParts.stream().filter(devicePart -> devicePart.getPartId() != null && devicePart.getPartId().startsWith(shelfName)).collect(Collectors.toList());
        childrenDeviceParts.forEach(devicePart -> {
            this.children.add(this.buildDevicePart((DevicePart)devicePart));
            deviceParts.remove(devicePart);
        });
    }

    private TreeNode buildDevicePart(DevicePart devicePart) {
        TreeNode devicePartNode = new TreeNode();
        devicePartNode.partSn = devicePart.getSn();
        devicePartNode.partType = devicePart.getBoardType();
        devicePartNode.partCategory = devicePart.getType();
        devicePartNode.item = devicePart.getPartNumber();
        devicePartNode.description = devicePart.getExtInfo();
        devicePartNode.slot = devicePart.getPartId();
        devicePartNode.parentSn = this.partSn.isEmpty() ? "0" : this.partSn;
        devicePartNode.neId = this.neId;
        return devicePartNode;
    }

    private void processPartSn() {
        if (this.partSn.equals(this.parentSn)) {
            this.partSn = "";
        }
        if (this.neType.isEmpty() && this.partSn.equals(this.neId)) {
            this.partSn = "";
        }
    }

    private void processHyphen() {
        this.partSn = this.processInvalidChr(this.partSn);
        this.parentSn = this.processInvalidChr(this.parentSn);
        this.item = this.processInvalidChr(this.item);
        this.partType = this.processInvalidChr(this.partType);
        this.partCategory = this.processInvalidChr(this.partCategory);
        this.description = this.processInvalidChr(this.description);
        this.slot = this.processInvalidChr(this.slot);
        this.neType = this.processInvalidChr(this.neType);
        this.neVersion = this.processInvalidChr(this.neVersion);
        this.nePatch = this.processInvalidChr(this.nePatch);
        if (this.parentSn.isEmpty()) {
            this.parentSn = this.neId;
        }
    }

    private String processInvalidChr(String origin) {
        return Const.INVALID_DATA.contains(origin) ? "" : origin;
    }

    public List<String> toRow() {
        this.processPartSn();
        this.processHyphen();
        return Stream.of(this.partSn, this.partType, this.partCategory, this.item, this.description, this.slot, this.parentSn, this.neId, this.neType, this.neVersion, this.nePatch).collect(Collectors.toList());
    }

    public List<List<String>> toRowList() {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        if (!this.partCategory.equals("ROOT_CATEGORY")) {
            result.add(this.toRow());
        }
        this.children.forEach(child -> result.addAll(child.toRowList()));
        return result;
    }

    public static TreeNodeBuilder builder() {
        return new TreeNodeBuilder();
    }

    public void setPartSn(String partSn) {
        this.partSn = partSn;
    }

    public void setPartType(String partType) {
        this.partType = partType;
    }

    public void setPartCategory(String partCategory) {
        this.partCategory = partCategory;
    }

    public void setItem(String item) {
        this.item = item;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setSlot(String slot) {
        this.slot = slot;
    }

    public void setParentSn(String parentSn) {
        this.parentSn = parentSn;
    }

    public void setNeId(String neId) {
        this.neId = neId;
    }

    public void setNeType(String neType) {
        this.neType = neType;
    }

    public void setNeVersion(String neVersion) {
        this.neVersion = neVersion;
    }

    public void setNePatch(String nePatch) {
        this.nePatch = nePatch;
    }

    public void setFatherNeId(String fatherNeId) {
        this.fatherNeId = fatherNeId;
    }

    public void setChildren(List<TreeNode> children) {
        this.children = children;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public String getPartSn() {
        return this.partSn;
    }

    public String getPartType() {
        return this.partType;
    }

    public String getPartCategory() {
        return this.partCategory;
    }

    public String getItem() {
        return this.item;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSlot() {
        return this.slot;
    }

    public String getParentSn() {
        return this.parentSn;
    }

    public String getNeId() {
        return this.neId;
    }

    public String getNeType() {
        return this.neType;
    }

    public String getNeVersion() {
        return this.neVersion;
    }

    public String getNePatch() {
        return this.nePatch;
    }

    public String getFatherNeId() {
        return this.fatherNeId;
    }

    public List<TreeNode> getChildren() {
        return this.children;
    }

    public Location getLocation() {
        return this.location;
    }

    public String toString() {
        return "TreeNode(partSn=" + this.getPartSn() + ", partType=" + this.getPartType() + ", partCategory=" + this.getPartCategory() + ", item=" + this.getItem() + ", description=" + this.getDescription() + ", slot=" + this.getSlot() + ", parentSn=" + this.getParentSn() + ", neId=" + this.getNeId() + ", neType=" + this.getNeType() + ", neVersion=" + this.getNeVersion() + ", nePatch=" + this.getNePatch() + ", fatherNeId=" + this.getFatherNeId() + ", children=" + this.getChildren() + ", location=" + this.getLocation() + ")";
    }

    public TreeNode(String partSn, String partType, String partCategory, String item, String description, String slot, String parentSn, String neId, String neType, String neVersion, String nePatch, String fatherNeId, List<TreeNode> children, Location location) {
        this.partSn = partSn;
        this.partType = partType;
        this.partCategory = partCategory;
        this.item = item;
        this.description = description;
        this.slot = slot;
        this.parentSn = parentSn;
        this.neId = neId;
        this.neType = neType;
        this.neVersion = neVersion;
        this.nePatch = nePatch;
        this.fatherNeId = fatherNeId;
        this.children = children;
        this.location = location;
    }

    public TreeNode() {
    }

    public static class TreeNodeBuilder {
        private String partSn;
        private String partType;
        private String partCategory;
        private String item;
        private String description;
        private String slot;
        private String parentSn;
        private String neId;
        private String neType;
        private String neVersion;
        private String nePatch;
        private String fatherNeId;
        private List<TreeNode> children;
        private Location location;

        TreeNodeBuilder() {
        }

        public TreeNodeBuilder partSn(String partSn) {
            this.partSn = partSn;
            return this;
        }

        public TreeNodeBuilder partType(String partType) {
            this.partType = partType;
            return this;
        }

        public TreeNodeBuilder partCategory(String partCategory) {
            this.partCategory = partCategory;
            return this;
        }

        public TreeNodeBuilder item(String item) {
            this.item = item;
            return this;
        }

        public TreeNodeBuilder description(String description) {
            this.description = description;
            return this;
        }

        public TreeNodeBuilder slot(String slot) {
            this.slot = slot;
            return this;
        }

        public TreeNodeBuilder parentSn(String parentSn) {
            this.parentSn = parentSn;
            return this;
        }

        public TreeNodeBuilder neId(String neId) {
            this.neId = neId;
            return this;
        }

        public TreeNodeBuilder neType(String neType) {
            this.neType = neType;
            return this;
        }

        public TreeNodeBuilder neVersion(String neVersion) {
            this.neVersion = neVersion;
            return this;
        }

        public TreeNodeBuilder nePatch(String nePatch) {
            this.nePatch = nePatch;
            return this;
        }

        public TreeNodeBuilder fatherNeId(String fatherNeId) {
            this.fatherNeId = fatherNeId;
            return this;
        }

        public TreeNodeBuilder children(List<TreeNode> children) {
            this.children = children;
            return this;
        }

        public TreeNodeBuilder location(Location location) {
            this.location = location;
            return this;
        }

        public TreeNode build() {
            return new TreeNode(this.partSn, this.partType, this.partCategory, this.item, this.description, this.slot, this.parentSn, this.neId, this.neType, this.neVersion, this.nePatch, this.fatherNeId, this.children, this.location);
        }

        public String toString() {
            return "TreeNode.TreeNodeBuilder(partSn=" + this.partSn + ", partType=" + this.partType + ", partCategory=" + this.partCategory + ", item=" + this.item + ", description=" + this.description + ", slot=" + this.slot + ", parentSn=" + this.parentSn + ", neId=" + this.neId + ", neType=" + this.neType + ", neVersion=" + this.neVersion + ", nePatch=" + this.nePatch + ", fatherNeId=" + this.fatherNeId + ", children=" + this.children + ", location=" + this.location + ")";
        }
    }
}

