/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.cbb.gtsib.component.extractor;

import com.huawei.baize.cbb.gtsib.api.exception.CommonException;
import com.huawei.baize.cbb.gtsib.component.bean.FileData;
import com.huawei.baize.cbb.gtsib.component.utils.MappingUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XmlExtractor {
    private static final String NE_INFORMATION = "NEInformation";
    private static final String SOFTWARE_LIST = "Softwarelist";
    private static final String NE_ID = "NE_ID";
    private static final String TYPE = "Type";
    private static final String VERSION = "Version";
    private static final String PATCH = "Patch";
    private static final String NE_TYPE = "NE_Type";
    private static final String NE_VERSION = "NE_Version";
    private static final String NE_PATCH = "NE_Patch";
    private static final String DEVICE_EXTEND = "DeviceExtend";
    private static final Unmarshaller UNMARSHALLER;

    private XmlExtractor() {
    }

    public static FileData extract(File xmlFile) {
        try {
            return (FileData)UNMARSHALLER.unmarshal(xmlFile);
        }
        catch (JAXBException e) {
            throw new CommonException("unmarshal " + xmlFile.getName() + " failed.", e);
        }
    }

    @Deprecated
    public static Map<String, List<Map<String, String>>> extract(File xmlFile, String configFilePath) {
        HashMap<String, List<Map<String, String>>> results = new HashMap<String, List<Map<String, String>>>();
        ArrayList<Map<String, String>> partRecords = new ArrayList<Map<String, String>>();
        results.put("part", partRecords);
        Map<String, Map<String, String>> mappingRule = MappingUtils.loadMappingRule(configFilePath);
        Document document = MappingUtils.read(xmlFile.getAbsolutePath());
        results.put("neInfo", XmlExtractor.extractNEInfoAndSoftware(document));
        for (Map.Entry<String, Map<String, String>> rule : mappingRule.entrySet()) {
            NodeList partListNode = document.getElementsByTagName(rule.getKey());
            Map<String, String> partMappingRule = mappingRule.get(rule.getKey());
            for (int i = 0; i < partListNode.getLength(); ++i) {
                Node node = partListNode.item(i);
                if (node.getNodeType() != 1) continue;
                XmlExtractor.addParts(partRecords, partMappingRule, MappingUtils.getChildNodes((Element)node));
            }
        }
        return results;
    }

    private static void addParts(List<Map<String, String>> partRecords, Map<String, String> partMappingRule, List<Node> parts) {
        for (Node part : parts) {
            if (part.getNodeType() != 1) continue;
            XmlExtractor.addPart(partRecords, partMappingRule, (Element)part);
        }
    }

    private static void addPart(List<Map<String, String>> partRecords, Map<String, String> partMappingRule, Element part) {
        if (DEVICE_EXTEND.equalsIgnoreCase(part.getNodeName())) {
            return;
        }
        LinkedHashMap<String, String> record = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> partRuleItem : partMappingRule.entrySet()) {
            String attr;
            String fieldXPath = partMappingRule.get(partRuleItem.getKey());
            if (fieldXPath.startsWith("@")) {
                attr = part.getAttribute(fieldXPath.substring(1));
                record.put(partRuleItem.getKey(), attr);
                continue;
            }
            if (fieldXPath.startsWith("../@")) {
                attr = ((Element)part.getParentNode()).getAttribute(fieldXPath.substring("../@".length()));
                record.put(partRuleItem.getKey(), attr);
                continue;
            }
            record.put(partRuleItem.getKey(), fieldXPath);
        }
        partRecords.add(record);
    }

    private static List<Map<String, String>> extractNEInfoAndSoftware(Document document) {
        Node neInfos = document.getElementsByTagName(NE_INFORMATION).item(0);
        LinkedHashMap<String, String> infos = new LinkedHashMap<String, String>();
        infos.put(NE_ID, ((Element)neInfos).getAttribute(NE_ID));
        infos.put(NE_TYPE, ((Element)neInfos).getAttribute(TYPE));
        String version = ((Element)neInfos).getAttribute(VERSION);
        infos.put(NE_VERSION, version);
        infos.put(NE_PATCH, "");
        Node softwarelist = document.getElementsByTagName(SOFTWARE_LIST).item(0);
        if (softwarelist == null) {
            return Collections.singletonList(infos);
        }
        List<Node> softwareVersions = MappingUtils.getChildNodes((Element)softwarelist);
        for (Node node : softwareVersions) {
            if (!version.equals(((Element)neInfos).getAttribute(VERSION))) continue;
            StringBuilder nePatch = new StringBuilder();
            List<Node> softwareVersionChild = MappingUtils.getChildNodes((Element)node);
            for (Node node1 : softwareVersionChild) {
                if (!node1.getNodeName().equals(PATCH)) continue;
                nePatch.append(nePatch.length() == 0 ? ((Element)node1).getAttribute(PATCH) : "," + ((Element)node1).getAttribute(PATCH));
            }
            infos.put(NE_PATCH, nePatch.toString());
            break;
        }
        return Collections.singletonList(infos);
    }

    static {
        try {
            UNMARSHALLER = JAXBContext.newInstance((Class[])new Class[]{FileData.class}).createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new CommonException("create jaxb context error.", e);
        }
    }
}

