/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.cbb.gtsib.component.utils;

import com.huawei.baize.cbb.gtsib.api.exception.CommonException;
import com.huawei.baize.cbb.gtsib.component.extractor.XmlExtractor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class MappingUtils {
    public static final String LANG_ZH = "zh_CN";
    public static final String LANG_EN = "en_US";
    private static final Map<String, Map<String, String>> LANG_MAPPING = MappingUtils.loadMappingRule(String.format(Locale.ENGLISH, "%sxmlmappings%scsv_fileds.xml", "/", "/"));
    private static final String UNSUPPORTED_LANG = "Unsupported lang ";
    private static final List<String> RESULT_SHEET_HEADERS_EN = Arrays.asList("Device_IP", "Device_Name", "NE_Type", "Status", "Result_Path", "Connect_Status", "Details", "Part_SN", "NE_Version", "NE_Patch");
    private static final List<String> RESULT_SHEET_HEADERS_ZH = Arrays.asList("\u8bbe\u5907IP", "\u8bbe\u5907\u540d\u79f0", "\u7f51\u5143\u578b\u53f7", "\u72b6\u6001", "\u7ed3\u679c\u8def\u5f84", "\u8fde\u63a5\u72b6\u6001", "\u8be6\u7ec6\u4fe1\u606f", "\u90e8\u4ef6\u6761\u7801", "\u7f51\u5143\u7248\u672c", "\u7f51\u5143\u8865\u4e01");

    private MappingUtils() {
    }

    public static Map<String, Map<String, String>> loadMappingRule(String configFilePath) {
        LinkedHashMap<String, Map<String, String>> partFiledMapping = new LinkedHashMap<String, Map<String, String>>();
        Document document = MappingUtils.read(configFilePath);
        Node fields = document.getElementsByTagName("fields").item(0);
        List<String> fieldMappings = MappingUtils.getDirectChildNodeNames((Element)fields);
        for (String fieldMapping : fieldMappings) {
            Node node = document.getElementsByTagName(fieldMapping).item(0);
            List<Node> nodeList = MappingUtils.getChildNodes((Element)node);
            LinkedHashMap<String, String> fieldToKeyMap = new LinkedHashMap<String, String>();
            for (Node node1 : nodeList) {
                if (node1.getNodeType() != 1) continue;
                Element element = (Element)node1;
                String fieldName = element.getAttribute("name");
                String key = element.getTextContent();
                fieldToKeyMap.put(fieldName, key);
            }
            partFiledMapping.put(fieldMapping, fieldToKeyMap);
        }
        return partFiledMapping;
    }

    public static Document read(String xmlFile) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            Document document;
            DocumentBuilder builder = factory.newDocumentBuilder();
            File file = new File(xmlFile);
            if (file.exists()) {
                document = builder.parse(file);
            } else {
                try (InputStream xmlFileStream = XmlExtractor.class.getResourceAsStream(xmlFile);){
                    document = builder.parse(xmlFileStream);
                }
            }
            document.getDocumentElement().normalize();
            return document;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new CommonException(e);
        }
    }

    public static List<Node> getChildNodes(Element parent) {
        ArrayList<Node> childNodes = new ArrayList<Node>();
        if (parent == null) {
            return childNodes;
        }
        NodeList nodeList = parent.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            childNodes.add(node);
        }
        return childNodes;
    }

    private static List<String> getDirectChildNodeNames(Element parent) {
        ArrayList<String> childNodeNames = new ArrayList<String>();
        NodeList childNodes = parent.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() != 1) continue;
            childNodeNames.add(childNode.getNodeName());
        }
        return childNodeNames;
    }

    public static Set<String> getHeaders(Set<String> headers, String lang) {
        switch (lang) {
            case "en_US": {
                return headers;
            }
            case "zh_CN": {
                return MappingUtils.changeHeaderToZh(headers);
            }
        }
        throw new CommonException(UNSUPPORTED_LANG + lang);
    }

    private static Set<String> changeHeaderToZh(Set<String> headers) {
        Map<String, String> headerMapping = LANG_MAPPING.get("HeaderList");
        LinkedHashSet<String> zhHeader = new LinkedHashSet<String>();
        for (String header : headers) {
            zhHeader.add(headerMapping.get(header));
        }
        return zhHeader;
    }

    public static String getFileNameByLang(String lang, String fileName) {
        switch (lang) {
            case "en_US": {
                return fileName;
            }
            case "zh_CN": {
                return LANG_MAPPING.get("FileList").get(fileName);
            }
        }
        throw new CommonException(UNSUPPORTED_LANG + lang);
    }

    public static String getSheetNameByLang(String lang) {
        switch (lang) {
            case "en_US": {
                return "net_hardware";
            }
            case "zh_CN": {
                return "\u786c\u4ef6\u7f51\u5143";
            }
        }
        throw new CommonException(UNSUPPORTED_LANG + lang);
    }

    public static String getNESheetNameByLang(String lang) {
        switch (lang) {
            case "en_US": {
                return "ne_result";
            }
            case "zh_CN": {
                return "\u7f51\u5143\u7ed3\u679c";
            }
        }
        throw new CommonException(UNSUPPORTED_LANG + lang);
    }

    public static List<String> getNEHeadersByLang(String lang) {
        switch (lang) {
            case "en_US": {
                return RESULT_SHEET_HEADERS_EN;
            }
            case "zh_CN": {
                return RESULT_SHEET_HEADERS_ZH;
            }
        }
        throw new CommonException(UNSUPPORTED_LANG + lang);
    }
}

