/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.cbb.gtsib.component.writer;

import com.huawei.baize.cbb.gtsib.api.exception.CommonException;
import com.huawei.baize.cbb.gtsib.component.common.TreeNode;
import com.huawei.baize.cbb.gtsib.component.utils.MappingUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class CsvWriter {
    public static final String CSV_SEPARATOR_STR = ",";
    private static final char CSV_QUOTE = '\"';

    private CsvWriter() {
    }

    @Deprecated
    public static void write(List<Map<String, String>> records, String outputDir, String fileName, String lang) {
        File outDir = new File(outputDir);
        if (!outDir.exists() && !outDir.mkdirs()) {
            throw new CommonException("Failed to create directory: " + outDir.getAbsolutePath());
        }
        if (records.isEmpty()) {
            return;
        }
        String filePath = outputDir + File.separator + fileName;
        boolean writerHeader = !new File(filePath).exists();
        Set<String> headers = records.get(0).keySet();
        Set<String> headerForWrite = MappingUtils.getHeaders(headers, lang);
        String headerLine = String.join((CharSequence)CSV_SEPARATOR_STR, headerForWrite);
        try (BufferedWriter writer = Files.newBufferedWriter(Paths.get(filePath, new String[0]), StandardCharsets.UTF_8, StandardOpenOption.APPEND, StandardOpenOption.CREATE);){
            if (writerHeader) {
                writer.append('\ufeff');
                writer.append(headerLine);
                writer.append(System.lineSeparator());
            }
            for (Map<String, String> record : records) {
                ArrayList<String> values = new ArrayList<String>();
                for (String key : headers) {
                    String value = record.get(key);
                    values.add(CsvWriter.escapeCsv(value != null ? value : ""));
                }
                writer.append(String.join((CharSequence)CSV_SEPARATOR_STR, values));
                writer.append(System.lineSeparator());
            }
            writer.flush();
        }
        catch (IOException e) {
            throw new CommonException("Failed to write data to csv.", e);
        }
    }

    public static void write(String outputDir, String fileName, String lang, List<List<String>> rows) {
        File outDir = new File(outputDir);
        if (!outDir.exists() && !outDir.mkdirs()) {
            throw new CommonException("Failed to create directory: " + outDir.getAbsolutePath());
        }
        if (rows.isEmpty()) {
            return;
        }
        String filePath = outputDir + File.separator + fileName;
        boolean writerHeader = !new File(filePath).exists();
        try (BufferedWriter writer = Files.newBufferedWriter(Paths.get(filePath, new String[0]), StandardCharsets.UTF_8, StandardOpenOption.APPEND, StandardOpenOption.CREATE);){
            if (writerHeader) {
                writer.append('\ufeff');
                writer.append(String.join((CharSequence)CSV_SEPARATOR_STR, TreeNode.getHeaders(lang)));
                writer.append(System.lineSeparator());
            }
            for (List<String> row : rows) {
                writer.append(row.stream().map(CsvWriter::escapeCsv).collect(Collectors.joining(CSV_SEPARATOR_STR)));
                writer.append(System.lineSeparator());
            }
            writer.flush();
        }
        catch (IOException e) {
            throw new CommonException("Failed to write data to csv.", e);
        }
    }

    public static String escapeCsv(String str) {
        if (str == null) {
            return null;
        }
        if (!str.contains(CSV_SEPARATOR_STR)) {
            return str;
        }
        try {
            StringWriter writer = new StringWriter();
            CsvWriter.escapeCsv(writer, str);
            return writer.toString();
        }
        catch (IOException ioe) {
            throw new CommonException("escape csv failed.", ioe);
        }
    }

    private static void escapeCsv(Writer out, String str) throws IOException {
        out.write(34);
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch == '\"') {
                out.write(34);
            }
            out.write(ch);
        }
        out.write(34);
    }
}

