/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.cbb.gtsib.component.writer;

import com.huawei.baize.cbb.gtsib.api.exception.CommonException;
import com.huawei.baize.cbb.gtsib.component.bean.CollectNeResult;
import com.huawei.baize.cbb.gtsib.component.common.TreeNode;
import com.huawei.baize.cbb.gtsib.component.utils.MappingUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WorkBookWriter {
    private static final Logger log = LoggerFactory.getLogger(WorkBookWriter.class);
    private static final String CELL_BUILDING_FORMAT = "TEXT";
    private static final String RESULT_LIST_CSV_CHARACTER = "GBK";

    private WorkBookWriter() {
    }

    public static void write(String outputDir, String fileName, List<List<String>> rows, String lang) {
        File outDir = new File(outputDir);
        if (!outDir.exists() && !outDir.mkdirs()) {
            throw new CommonException("Failed to create directory: " + outDir.getAbsolutePath());
        }
        if (rows.isEmpty()) {
            return;
        }
        String filePath = outputDir + File.separator + fileName;
        boolean writerHeader = !new File(filePath).exists();
        String sheetName = MappingUtils.getSheetNameByLang(lang);
        StandardOpenOption openOption = writerHeader ? StandardOpenOption.CREATE_NEW : StandardOpenOption.APPEND;
        try (XSSFWorkbook workbook = new XSSFWorkbook();
             OutputStream fops = Files.newOutputStream(Paths.get(filePath, new String[0]), openOption);){
            XSSFSheet sheet = workbook.createSheet(sheetName);
            int rowIndex = 0;
            XSSFCellStyle style = workbook.createCellStyle();
            style.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)CELL_BUILDING_FORMAT));
            if (writerHeader) {
                XSSFRow excelRow = sheet.createRow(rowIndex++);
                int cellIndex = 0;
                Set<String> headers = TreeNode.getHeaders(lang);
                for (String cellValue : headers) {
                    Cell excelCell = excelRow.createCell(cellIndex++);
                    excelCell.setCellValue(cellValue);
                    excelCell.setCellStyle((CellStyle)style);
                }
            }
            for (List<String> row : rows) {
                XSSFRow excelRow = sheet.createRow(rowIndex++);
                int cellIndex = 0;
                for (String cellValue : row) {
                    Cell excelCell = excelRow.createCell(cellIndex++);
                    excelCell.setCellValue(cellValue);
                    excelCell.setCellStyle((CellStyle)style);
                }
            }
            workbook.write(fops);
        }
        catch (IOException e) {
            throw new CommonException("Failed to write xlsx file: " + filePath, e);
        }
    }

    public static void writeResultByFile(String outputDir, String fileName, String resultFilePath, String lang) {
        if (resultFilePath == null || resultFilePath.isEmpty()) {
            return;
        }
        IOUtils.setMaxByteArrayInitSize((int)Integer.MAX_VALUE);
        IOUtils.setByteArrayMaxOverride((int)Integer.MAX_VALUE);
        String xlsxFile = outputDir + File.separator + fileName;
        Path path = Paths.get(xlsxFile, new String[0]);
        String neSheetName = MappingUtils.getNESheetNameByLang(lang);
        try (XSSFWorkbook workbook = new XSSFWorkbook(Files.newInputStream(path, new OpenOption[0]));
             OutputStream outputStream = Files.newOutputStream(path, StandardOpenOption.WRITE);){
            XSSFSheet sheet = workbook.createSheet(neSheetName);
            int rowIndex = 0;
            XSSFCellStyle style = workbook.createCellStyle();
            style.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)CELL_BUILDING_FORMAT));
            WorkBookWriter.writeDeviceResultHeader((Row)sheet.createRow(rowIndex++), style, lang);
            List<List<String>> rows = WorkBookWriter.getNeResultList(resultFilePath);
            for (List<String> row : rows) {
                XSSFRow excelRow = sheet.createRow(rowIndex++);
                int cellIndex = 0;
                for (String cellValue : row) {
                    Cell excelCell = excelRow.createCell(cellIndex++);
                    excelCell.setCellValue(cellValue);
                    excelCell.setCellStyle((CellStyle)style);
                }
            }
            workbook.write(outputStream);
        }
        catch (IOException e) {
            log.error("failed to write device result {}", (Object)xlsxFile, (Object)e);
        }
    }

    public static void writeResultByList(String outputDir, String fileName, List<Map<String, String>> resultList, String lang) {
        if (resultList == null || resultList.isEmpty()) {
            return;
        }
        IOUtils.setByteArrayMaxOverride((int)Integer.MAX_VALUE);
        IOUtils.setMaxByteArrayInitSize((int)Integer.MAX_VALUE);
        String xlsxFile = outputDir + File.separator + fileName;
        Path path = Paths.get(xlsxFile, new String[0]);
        String neSheetName = MappingUtils.getNESheetNameByLang(lang);
        try (XSSFWorkbook workbook = new XSSFWorkbook(Files.newInputStream(path, new OpenOption[0]));
             OutputStream outputStream = Files.newOutputStream(path, StandardOpenOption.WRITE);){
            XSSFSheet sheet = workbook.createSheet(neSheetName);
            XSSFCellStyle style = workbook.createCellStyle();
            int rowIndex = 0;
            style.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)CELL_BUILDING_FORMAT));
            WorkBookWriter.writeDeviceResultHeader((Row)sheet.createRow(rowIndex++), style, lang);
            for (Map<String, String> row : resultList) {
                XSSFRow excelRow = sheet.createRow(rowIndex++);
                int cellIndex = 0;
                List<String> cells = CollectNeResult.getCollectNeResult(row).toRow();
                for (String cell : cells) {
                    Cell excelCell = excelRow.createCell(cellIndex++);
                    excelCell.setCellValue(cell);
                    excelCell.setCellStyle((CellStyle)style);
                }
            }
            workbook.write(outputStream);
        }
        catch (IOException e) {
            log.error("failed to write device result {}", (Object)xlsxFile, (Object)e);
        }
    }

    private static void writeDeviceResultHeader(Row excelRow, XSSFCellStyle style, String lang) {
        List<String> headers = MappingUtils.getNEHeadersByLang(lang);
        int cellIndex = 0;
        for (String cellValue : headers) {
            Cell excelCell = excelRow.createCell(cellIndex++);
            excelCell.setCellValue(cellValue);
            excelCell.setCellStyle((CellStyle)style);
        }
    }

    private static List<List<String>> getNeResultList(String resultFilePath) {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(Files.newInputStream(Paths.get(resultFilePath, new String[0]), new OpenOption[0]), RESULT_LIST_CSV_CHARACTER));){
            List lines = br.lines().collect(Collectors.toList());
            boolean isData = false;
            for (String line : lines) {
                if (line.isEmpty()) continue;
                if (line.contains("deviceIP")) {
                    isData = true;
                    continue;
                }
                if (!isData) continue;
                result.add(CollectNeResult.getCollectNeResult(line).toRow());
            }
        }
        catch (FileNotFoundException e) {
            log.error("file not found {}", (Object)resultFilePath);
        }
        catch (IOException e) {
            log.error("read file error {},", (Object)resultFilePath, (Object)e);
        }
        return result;
    }
}

