/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.cbb.gtsib.impl;

import com.huawei.baize.cbb.gtsib.api.collector.IbCollector;
import com.huawei.baize.cbb.gtsib.api.exception.CommonException;
import com.huawei.baize.cbb.gtsib.component.bean.FileData;
import com.huawei.baize.cbb.gtsib.component.common.TreeNode;
import com.huawei.baize.cbb.gtsib.component.extractor.XmlExtractor;
import com.huawei.baize.cbb.gtsib.component.utils.MappingUtils;
import com.huawei.baize.cbb.gtsib.component.writer.CsvWriter;
import com.huawei.baize.cbb.gtsib.component.writer.WorkBookWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentGenerator
implements IbCollector {
    private static final Logger log = LoggerFactory.getLogger(ContentGenerator.class);
    private static final int MAX_DEPTH = 5;
    private static final Object[] LOCK = new Object[0];
    private final Map<String, TreeNode> parentTreeNodes = new HashMap<String, TreeNode>();
    private final Map<String, List<TreeNode>> childTreeNodes = new HashMap<String, List<TreeNode>>();

    @Override
    public List<String> collect(String inputDir, String outputDir) {
        return this.collect(inputDir, outputDir, "en_US");
    }

    @Override
    public List<String> collect(List<Map<String, String>> rows, String outputDir, String lang) {
        String timeStr = new SimpleDateFormat("yyyyMMddHHmmss", Locale.ENGLISH).format(new Date());
        String resultDirPath = outputDir + File.separator + MappingUtils.getFileNameByLang(lang, "Device_SN_List");
        this.clearDir(resultDirPath);
        String csvFileName = MappingUtils.getFileNameByLang(lang, "Device_SN_List") + "_" + timeStr + ".csv";
        String excelFileName = MappingUtils.getFileNameByLang(lang, "Device_SN_List") + "_" + timeStr + ".xlsx";
        String csvFile = resultDirPath + File.separator + csvFileName;
        String excelFile = resultDirPath + File.separator + excelFileName;
        List<List<String>> parseRows = rows.stream().map(this::toRow).collect(Collectors.toList());
        CsvWriter.write(resultDirPath, csvFileName, lang, parseRows);
        WorkBookWriter.write(resultDirPath, excelFileName, parseRows, lang);
        return Arrays.asList(csvFile, excelFile);
    }

    @Override
    public List<String> collect(String inputDir, String outputDir, String lang) {
        return this.collectWithResultFile(inputDir, outputDir, lang, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> collect(String inputXmlPath, String outputDir, boolean zipOutput, String lang) {
        Object[] objectArray = LOCK;
        synchronized (LOCK) {
            String fileAndDirName = MappingUtils.getFileNameByLang(lang, "Device_SN_List");
            String resultDir = outputDir + File.separator + fileAndDirName;
            this.clearDir(resultDir);
            String ibXmlPath = null;
            String csvFileName = null;
            String ibXmlDirName = null;
            String excelFileName = null;
            if (!new File(resultDir).exists()) {
                String string = new SimpleDateFormat("yyyyMMddHHmmss", Locale.ENGLISH).format(new Date());
                ibXmlDirName = fileAndDirName + "_" + string;
                ibXmlPath = resultDir + File.separator + ibXmlDirName;
                if (!new File(ibXmlPath).mkdirs()) {
                    throw new CommonException("can not create folder: " + ibXmlPath);
                }
                csvFileName = fileAndDirName + "_" + string + ".csv";
                excelFileName = fileAndDirName + "_" + string + ".xlsx";
            } else {
                for (File file : Objects.requireNonNull(new File(resultDir).listFiles())) {
                    String fileName = file.getName();
                    if (file.isDirectory()) {
                        ibXmlPath = file.getAbsolutePath();
                        ibXmlDirName = fileName;
                        continue;
                    }
                    if (fileName.endsWith(".csv")) {
                        csvFileName = fileName;
                        continue;
                    }
                    if (fileName.endsWith(".xlsx")) {
                        excelFileName = fileName;
                        continue;
                    }
                    log.debug("{} is not collect file.", (Object)fileName);
                }
            }
            if (ibXmlPath == null || csvFileName == null) {
                throw new CommonException("ibXmlPath or csvFileName or ibXmlDirName empty");
            }
            Path path = Paths.get(inputXmlPath, new String[0]);
            this.readFlow(path);
            ContentGenerator.copyFile(path, ibXmlPath);
            this.writeToFiles(lang, resultDir, csvFileName, excelFileName);
            String csvFilePath = resultDir + File.separator + csvFileName;
            String excelFilePath = resultDir + File.separator + excelFileName;
            if (!zipOutput) {
                // ** MonitorExit[objectArray] (shouldn't be in output)
                return Arrays.asList(ibXmlPath, csvFilePath, excelFilePath);
            }
            // ** MonitorExit[objectArray] (shouldn't be in output)
            return this.zipAgain(resultDir, ibXmlPath, csvFileName, ibXmlDirName);
        }
    }

    @Override
    public List<String> collectWithResultFile(String inputDir, String outputDir, String lang, String resultFilePath) {
        return this.collectWithResult(inputDir, outputDir, lang, resultFilePath, null);
    }

    @Override
    public List<String> collectWithResultList(String inputDir, String outputDir, String lang, List<Map<String, String>> resultList) {
        return this.collectWithResult(inputDir, outputDir, lang, null, resultList);
    }

    private List<String> collectWithResult(String inputDir, String outputDir, String lang, String resultFilePath, List<Map<String, String>> resultList) {
        this.parentTreeNodes.clear();
        this.childTreeNodes.clear();
        List<Path> ibmsXmlList = ContentGenerator.getIbmsXmlList(inputDir);
        if (ibmsXmlList.isEmpty()) {
            return Collections.emptyList();
        }
        String timeStr = new SimpleDateFormat("yyyyMMddHHmmss", Locale.ENGLISH).format(new Date());
        String resultDirPath = outputDir + File.separator + MappingUtils.getFileNameByLang(lang, "Device_SN_List");
        this.clearDir(resultDirPath);
        String ibXmlDirName = MappingUtils.getFileNameByLang(lang, "Device_SN_List") + "_" + timeStr;
        String ibXmlDirPath = resultDirPath + File.separator + ibXmlDirName;
        String errorIbXmlDirName = MappingUtils.getFileNameByLang(lang, "Device_SN_List") + "_" + (lang.equals("en_US") ? "Unresolved" : "\u65e0\u6cd5\u89e3\u6790") + "_" + timeStr;
        String errorIbXmlDirPath = resultDirPath + File.separator + errorIbXmlDirName;
        if (!new File(ibXmlDirPath).mkdirs() || !new File(errorIbXmlDirPath).mkdirs()) {
            throw new CommonException("can not create folder: " + ibXmlDirPath);
        }
        for (Path ibXmlFile : ibmsXmlList) {
            try {
                this.readFlow(ibXmlFile);
                ContentGenerator.copyFile(ibXmlFile, ibXmlDirPath);
            }
            catch (CommonException | IndexOutOfBoundsException e) {
                ContentGenerator.copyFile(ibXmlFile, errorIbXmlDirPath);
                log.error("Failed to read the XML file: {}", (Object)ibXmlFile.getFileName(), (Object)e);
            }
        }
        String csvFileName = MappingUtils.getFileNameByLang(lang, "Device_SN_List") + "_" + timeStr + ".csv";
        String excelFileName = MappingUtils.getFileNameByLang(lang, "Device_SN_List") + "_" + timeStr + ".xlsx";
        if (resultList != null && !resultList.isEmpty()) {
            this.writeToFilesWithResultList(lang, resultDirPath, csvFileName, excelFileName, resultList);
        } else if (resultFilePath != null && !resultFilePath.isEmpty()) {
            this.writeToFilesWithResultFile(lang, resultDirPath, csvFileName, excelFileName, resultFilePath);
        } else {
            this.writeToFiles(lang, resultDirPath, csvFileName, excelFileName);
        }
        String zipFile = this.processIbXmlDirPath(resultDirPath, ibXmlDirName, ibXmlDirPath);
        String errorZipFile = resultDirPath + File.separator + errorIbXmlDirName + ".zip";
        boolean noError = this.processErrorIbXmlDirPath(errorIbXmlDirPath, errorZipFile);
        String csvFile = resultDirPath + File.separator + csvFileName;
        String excelFile = resultDirPath + File.separator + excelFileName;
        return this.getAllPaths(csvFile, excelFile, zipFile, errorZipFile, noError);
    }

    private List<String> getAllPaths(String csvFile, String excelFile, String zipFile, String errorZipFile, boolean noError) {
        ArrayList<String> paths = new ArrayList<String>();
        paths.add(zipFile);
        paths.add(csvFile);
        paths.add(excelFile);
        if (!noError) {
            paths.add(errorZipFile);
        }
        return paths;
    }

    private String processIbXmlDirPath(String resultDirPath, String ibXmlDirName, String ibXmlDirPath) {
        String zipFile = resultDirPath + File.separator + ibXmlDirName + ".zip";
        try {
            ContentGenerator.zipXmlFolderAndDelete(ibXmlDirPath, zipFile);
        }
        catch (IOException e) {
            throw new CommonException(e);
        }
        return zipFile;
    }

    private boolean processErrorIbXmlDirPath(String errorIbXmlDirPath, String errorZipFile) {
        File errorIbXmlDir = new File(errorIbXmlDirPath);
        boolean noError = errorIbXmlDir.list() == null || errorIbXmlDir.list().length == 0;
        this.resolveErrorIbXmlFile(errorIbXmlDirPath, noError, errorZipFile);
        return noError;
    }

    private void resolveErrorIbXmlFile(String errorIbXmlDirPath, boolean noError, String errorZipFile) {
        if (!noError) {
            try {
                ContentGenerator.zipXmlFolderAndDelete(errorIbXmlDirPath, errorZipFile);
                return;
            }
            catch (IOException e) {
                throw new CommonException(e);
            }
        }
        try {
            ContentGenerator.deleteFolder(Paths.get(errorIbXmlDirPath, new String[0]));
        }
        catch (IOException e) {
            throw new CommonException(e);
        }
    }

    private List<String> toRow(Map<String, String> row) {
        List<String> headers = TreeNode.getHeaders();
        ArrayList<String> result = new ArrayList<String>();
        for (String header : headers) {
            result.add(row.get(header));
        }
        return result;
    }

    private void writeToFiles(String lang, String resultDirPath, String csvFileName, String excelFileName) {
        List<List<String>> rows = this.buildRows();
        CsvWriter.write(resultDirPath, csvFileName, lang, rows);
        if (excelFileName == null) {
            return;
        }
        try {
            WorkBookWriter.write(resultDirPath, excelFileName, rows, lang);
        }
        catch (NoClassDefFoundError e) {
            log.error("poi jar is not exist, can't write excel file.");
        }
    }

    private void writeToFilesWithResultFile(String lang, String resultDirPath, String csvFileName, String excelFileName, String resultFilePath) {
        List<List<String>> rows = this.buildRows();
        CsvWriter.write(resultDirPath, csvFileName, lang, rows);
        if (excelFileName == null) {
            return;
        }
        try {
            WorkBookWriter.write(resultDirPath, excelFileName, rows, lang);
            WorkBookWriter.writeResultByFile(resultDirPath, excelFileName, resultFilePath, lang);
        }
        catch (NoClassDefFoundError e) {
            log.error("poi jar is not exist, can't write excel file.");
        }
    }

    private void writeToFilesWithResultList(String lang, String resultDirPath, String csvFileName, String excelFileName, List<Map<String, String>> resultList) {
        List<List<String>> rows = this.buildRows();
        CsvWriter.write(resultDirPath, csvFileName, lang, rows);
        if (excelFileName == null) {
            return;
        }
        try {
            WorkBookWriter.write(resultDirPath, excelFileName, rows, lang);
            WorkBookWriter.writeResultByList(resultDirPath, excelFileName, resultList, lang);
        }
        catch (NoClassDefFoundError e) {
            log.error("poi jar is not exist, can't write excel file.");
        }
    }

    private List<List<String>> buildRows() {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        this.parentTreeNodes.forEach((parentKey, parent) -> {
            if (parent.getNeType().isEmpty()) {
                log.debug("parent neType is empty, do not fill back to child. neId={}", (Object)parent.getNeId());
            }
            if (parent.getNePatch().isEmpty()) {
                log.debug("parent nePatch is empty, do not fill back to child. neId={}", (Object)parent.getNeId());
            }
            result.addAll(parent.toRowList());
            List<TreeNode> children = this.childTreeNodes.remove(parentKey);
            if (children != null) {
                children.forEach(child -> child.getChildren().forEach(device -> {
                    device.setNeType(parent.getNeType().isEmpty() ? device.getNeType() : parent.getNeType());
                    device.setNePatch(parent.getNePatch().isEmpty() ? device.getNePatch() : parent.getNePatch());
                }));
                children.forEach(child -> result.addAll(child.toRowList()));
            }
        });
        if (!this.childTreeNodes.isEmpty()) {
            log.error("some file data has fatherNeId but not found father. fileData.size={}", (Object)this.childTreeNodes.size());
            this.childTreeNodes.values().stream().flatMap(Collection::stream).map(TreeNode::toRowList).forEach(result::addAll);
        }
        return result;
    }

    private void readFlow(Path ibXmlFile) {
        FileData fileData = XmlExtractor.extract(ibXmlFile.toFile());
        TreeNode treeNode = TreeNode.build(fileData);
        if (treeNode.getFatherNeId().isEmpty()) {
            if (this.parentTreeNodes.containsKey(treeNode.getNeId())) {
                log.error("duplicate neInformation parent, use first. neId={}", (Object)treeNode.getNeId());
                return;
            }
            this.parentTreeNodes.put(treeNode.getNeId(), treeNode);
            return;
        }
        this.childTreeNodes.putIfAbsent(treeNode.getFatherNeId(), new ArrayList());
        this.childTreeNodes.get(treeNode.getFatherNeId()).add(treeNode);
    }

    private List<String> zipAgain(String resultDir, String ibXmlPath, String csvFileName, String ibXmlDirName) {
        String xmlZipFile = resultDir + File.separator + ibXmlDirName + ".zip";
        Path sourceFolderPath = Paths.get(ibXmlPath, new String[0]);
        Path zipFilePath = Paths.get(xmlZipFile, new String[0]);
        String finalZipFile = resultDir + ".zip";
        this.deleteFile(finalZipFile);
        try {
            ContentGenerator.zipFolder(sourceFolderPath, zipFilePath);
        }
        catch (IOException e) {
            throw new CommonException(e);
        }
        try (ZipOutputStream zos = new ZipOutputStream(Files.newOutputStream(Paths.get(finalZipFile, new String[0]), new OpenOption[0]));){
            zos.putNextEntry(new ZipEntry(ibXmlDirName + ".zip"));
            byte[] bytes = Files.readAllBytes(zipFilePath);
            zos.write(bytes, 0, bytes.length);
            zos.closeEntry();
            this.deleteFile(xmlZipFile);
            zos.putNextEntry(new ZipEntry(csvFileName));
            String csvFilePath = resultDir + File.separator + csvFileName;
            bytes = Files.readAllBytes(Paths.get(csvFilePath, new String[0]));
            zos.write(bytes, 0, bytes.length);
            zos.closeEntry();
        }
        catch (IOException e) {
            throw new CommonException(e);
        }
        ArrayList<String> paths = new ArrayList<String>();
        paths.add(finalZipFile);
        return paths;
    }

    private void deleteFile(String finalZipFile) {
        boolean delete = new File(finalZipFile).delete();
        if (!delete) {
            log.warn("xml zip {} delete failed", (Object)finalZipFile);
        }
    }

    private static void copyFile(Path ibXmlFile, String ibXmlDirPath) {
        try {
            Path fileName = ibXmlFile.getFileName();
            if (fileName == null) {
                return;
            }
            Files.copy(ibXmlFile, Paths.get(ibXmlDirPath, fileName.toString()), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new CommonException(e);
        }
    }

    private static List<Path> getIbmsXmlList(String inputPath) {
        List<Path> fileList;
        try (Stream<Path> fileListStream = Files.find(Paths.get(inputPath, new String[0]), 5, (filePath, fileAttr) -> fileAttr.isRegularFile() && filePath.toString().endsWith(".xml") && filePath.getFileName().toString().startsWith("IB_"), new FileVisitOption[0]);){
            fileList = fileListStream.collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new CommonException(e);
        }
        return fileList;
    }

    private static void zipXmlFolderAndDelete(String ibXmlCopyPath, String zipFile) throws IOException {
        Path sourceFolderPath = Paths.get(ibXmlCopyPath, new String[0]);
        Path zipFilePath = Paths.get(zipFile, new String[0]);
        ContentGenerator.zipFolder(sourceFolderPath, zipFilePath);
        ContentGenerator.deleteFolder(sourceFolderPath);
    }

    private static void zipFolder(final Path sourceFolderPath, Path zipFilePath) throws IOException {
        try (final ZipOutputStream zos = new ZipOutputStream(Files.newOutputStream(zipFilePath, new OpenOption[0]));){
            Files.walkFileTree(sourceFolderPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    zos.putNextEntry(new ZipEntry(sourceFolderPath.relativize(file).toString()));
                    Files.copy(file, zos);
                    zos.closeEntry();
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    private static void deleteFolder(Path folderPath) throws IOException {
        Files.walkFileTree(folderPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private void clearDir(String resultDirPath) {
        File resultDir = new File(resultDirPath);
        if (!resultDir.exists()) {
            return;
        }
        File[] files = resultDir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            try {
                Files.delete(file.toPath());
            }
            catch (IOException e) {
                log.error("delete file {} error.", (Object)file.getName());
            }
        }
    }
}

