/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.encryptbase.service.impl;

import com.huawei.encryptbase.service.IWorkKeyUpdateObserver;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class WorkKeyUpdateService {
    private static final WorkKeyUpdateService INSTANCE = new WorkKeyUpdateService();
    private final List<IWorkKeyUpdateObserver> observerPool = new ArrayList<IWorkKeyUpdateObserver>();

    private WorkKeyUpdateService() {
    }

    public static WorkKeyUpdateService getInstance() {
        return INSTANCE;
    }

    public synchronized void addWorkKeyObservers(IWorkKeyUpdateObserver observer) {
        this.clearOldObserver(observer.getClass());
        this.observerPool.add(observer);
    }

    private void clearOldObserver(Class<? extends IWorkKeyUpdateObserver> clazz) {
        Iterator<IWorkKeyUpdateObserver> iter = this.observerPool.iterator();
        String obClsName = clazz.getName();
        while (iter.hasNext()) {
            IWorkKeyUpdateObserver ob = iter.next();
            Class<?> cls = ob.getClass();
            String clsName = cls.getName();
            if (!clsName.equals(obClsName)) continue;
            iter.remove();
        }
    }

    public synchronized List<IWorkKeyUpdateObserver> getAllWorkKeyObservers() {
        return new ArrayList<IWorkKeyUpdateObserver>(this.observerPool);
    }
}

