/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.encryptbase.utils;

import com.huawei.encryptbase.exception.EncryptBaseException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureRandomGenerateUtil {
    private static final Logger log = LoggerFactory.getLogger(SecureRandomGenerateUtil.class);
    private static final int DEFAULT_SECURE_BYTES_LEN = 32;
    private static final int SEED_LENGTH = 128;
    private static byte[] seed;

    public static String generateNumeric(int count) {
        StringBuilder str = new StringBuilder();
        SecureRandom secureRandom = SecureRandomGenerateUtil.createSecureRandom();
        for (int i = 0; i < count; ++i) {
            str.append(secureRandom.nextInt(10));
        }
        return str.toString();
    }

    public static byte[] generateByteSecureRandom(int bytesLen) {
        byte[] secureBytes = new byte[bytesLen];
        SecureRandom secureRandom = SecureRandomGenerateUtil.createSecureRandom();
        secureRandom.nextBytes(secureBytes);
        return secureBytes;
    }

    public static byte[] generateByteSecureRandom() {
        return SecureRandomGenerateUtil.generateByteSecureRandom(32);
    }

    public static String generateStrSecureRandom(int bytesLen) {
        byte[] secureBytes = SecureRandomGenerateUtil.generateByteSecureRandom(bytesLen);
        return Base64.encodeBase64String((byte[])secureBytes);
    }

    public static String generateStrSecureRandom() {
        return SecureRandomGenerateUtil.generateStrSecureRandom(32);
    }

    public static SecureRandom createSecureRandom() {
        try {
            if (SystemUtils.IS_OS_LINUX) {
                SecureRandomGenerateUtil.initSeed();
                return SecureRandomGenerateUtil.getLinuxSecureRandom();
            }
            return SecureRandom.getInstanceStrong();
        }
        catch (NoSuchAlgorithmException e) {
            log.error("NoSuchAlgorithmException", (Throwable)e);
            throw new EncryptBaseException("No Such Algorithm Exception", e);
        }
    }

    private static SecureRandom getLinuxSecureRandom() throws NoSuchAlgorithmException {
        if (seed != null) {
            return new SecureRandom(seed);
        }
        return SecureRandom.getInstance("SHA1PRNG");
    }

    private static void initSeed() {
        if (seed != null) {
            return;
        }
        try {
            BasicThreadFactory factory = new BasicThreadFactory.Builder().namingPattern("init-secure-random-seed-%d").daemon(true).build();
            ThreadPoolExecutor executorService = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1), (ThreadFactory)factory);
            CompletableFuture.supplyAsync(() -> {
                seed = SecureRandom.getSeed(128);
                return seed;
            }, executorService).get(30L, TimeUnit.SECONDS);
            executorService.shutdownNow();
        }
        catch (Exception e) {
            log.warn("Failed to init seed: {}", (Object)e.getMessage());
        }
    }
}

