/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uMate.common;

import com.huawei.uMate.common.log.Logger;
import com.sun.management.OperatingSystemMXBean;
import java.awt.Font;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;

public class SystemInfo {
    private static final Logger LOGGER = new Logger(SystemInfo.class);
    private static final long OS_DISK_REMAIN_SPACE = 0x40000000L;
    private static final long CUR_DISK_REMAIN_SPACE = 0x20000000L;
    private static final Font font = new Font("\u5b8b\u4f53", 0, 12);

    public static OSType GetOSType() {
        Properties properties = System.getProperties();
        String osInfo = properties.getProperty("os.name").toLowerCase(Locale.ENGLISH);
        if (osInfo.toLowerCase(Locale.ENGLISH).contains("windows")) {
            return OSType.Windows;
        }
        if (osInfo.toLowerCase(Locale.ENGLISH).contains("linux")) {
            return OSType.Linux;
        }
        return OSType.Other;
    }

    public static boolean checkEnvReq(StringBuilder info) {
        Properties properties = System.getProperties();
        String userdir = properties.getProperty("user.dir");
        long curFreeSpace = new File(userdir).getFreeSpace();
        LOGGER.info(String.format(Locale.ROOT, "userDir %s user_free_space: %sMB", userdir, curFreeSpace / 0x100000L));
        if (curFreeSpace < 0x20000000L) {
            info.append("The remaining capacity of the disk where uMate is running is less than 0.5GB. ");
        }
        long MaxMemory = Runtime.getRuntime().maxMemory();
        if (SystemInfo.GetOSType() == OSType.Windows) {
            Map<String, String> map = System.getenv();
            String value = map.get("SystemDrive");
            if (value != null) {
                long OSFreeSpace = new File(value).getFreeSpace();
                LOGGER.info(String.format(Locale.ROOT, "os_drive: %s os_free_space: %sMB", value, OSFreeSpace / 0x100000L));
                if (OSFreeSpace < 0x40000000L) {
                    info.append("The system disk capacity is less than 1GB. ");
                }
            }
            OperatingSystemMXBean os = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            long freePhysicalMemory = os.getFreePhysicalMemorySize();
            LOGGER.info(String.format(Locale.ROOT, "maxMemory: %sMB freeMemory: %sMB", MaxMemory / 0x100000L, freePhysicalMemory / 0x100000L));
            if (MaxMemory > freePhysicalMemory) {
                info.append("The remaining memory is less than the maximum memory requirements of the uMate application. ");
            }
        }
        if (info.toString().trim().equals("")) {
            return true;
        }
        info.append("Some unknown errors may has occurred in the situation, Do you want to continue?");
        return false;
    }

    public static String getTimeZoneDateStr(long currentDate) {
        TimeZone timeZone = TimeZone.getDefault();
        int timeZoneNumber = timeZone.getRawOffset() / 3600000;
        String timeZoneStr = "+";
        timeZoneStr = timeZoneNumber > 0 ? timeZoneStr + timeZoneNumber : (timeZoneNumber == 0 ? "" : Integer.toString(timeZoneNumber));
        String time = new SimpleDateFormat("yyyy-MM-dd").format(currentDate);
        return String.format(Locale.ROOT, "%s %s GMT%s", time, new SimpleDateFormat("HH:mm:ss").format(currentDate), timeZoneStr);
    }

    public static void exitSystem(int errorCode) {
        System.exit(errorCode);
    }

    public static enum OSType {
        Windows,
        Linux,
        Other;

    }
}

