/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.common;

import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TimerTaskManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimerTaskManager.class);
    public static final TimerTaskManager INSTANCE = new TimerTaskManager();
    private static ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(4);
    private Map<Runnable, TimerTask> taskMap = new ConcurrentHashMap<Runnable, TimerTask>();

    private TimerTaskManager() {
    }

    public static TimerTaskManager getInstance() {
        return INSTANCE;
    }

    public void scheduleCommonTask(Runnable task, int delay, int period, TimeUnit unit) {
        if (task == null) {
            throw new NullPointerException();
        }
        TimerTask oldTimerTask = this.taskMap.get(task);
        if (oldTimerTask != null) {
            scheduledThreadPoolExecutor.remove(oldTimerTask);
        }
        CommonTimerTask timerTask = new CommonTimerTask(task);
        this.taskMap.put(task, timerTask);
        ScheduledFuture<?> future = scheduledThreadPoolExecutor.scheduleAtFixedRate(timerTask, delay, period, unit);
        timerTask.setFuture(future);
    }

    public void scheduleSwingTask(Runnable task, int delay, int period, TimeUnit unit) {
        if (task == null) {
            throw new NullPointerException();
        }
        TimerTask oldTimerTask = this.taskMap.get(task);
        if (oldTimerTask != null) {
            oldTimerTask.cancel();
        }
        SwingTimerTask timerTask = new SwingTimerTask(task);
        this.taskMap.put(task, timerTask);
        ScheduledFuture<?> future = scheduledThreadPoolExecutor.scheduleAtFixedRate(timerTask, delay, period, unit);
        timerTask.setFuture(future);
    }

    public void cancel(Runnable task) {
        TimerTask timerTask = this.taskMap.remove(task);
        if (timerTask != null) {
            timerTask.cancel();
        }
    }

    @Deprecated
    public static ScheduledThreadPoolExecutor getScheduledTimer() {
        return scheduledThreadPoolExecutor;
    }

    public static void cancelScheduledTimer() {
        scheduledThreadPoolExecutor.getQueue().clear();
    }

    private static class SwingTimerTask
    extends java.util.TimerTask {
        private Runnable task;
        private Future<?> future;

        public SwingTimerTask(Runnable task) {
            this.task = new TimerTask(task);
        }

        public Future<?> getFuture() {
            return this.future;
        }

        public void setFuture(Future<?> future) {
            this.future = future;
        }

        @Override
        public boolean cancel() {
            if (this.future != null) {
                boolean cancel = this.future.cancel(true);
                this.future = null;
                this.task = null;
                return cancel;
            }
            return false;
        }

        @Override
        public void run() {
            if (SwingUtilities.isEventDispatchThread()) {
                this.task.run();
            } else {
                SwingUtilities.invokeLater(this.task);
            }
        }

        private static final class TimerTask
        implements Runnable {
            private final Runnable task;

            private TimerTask(Runnable task) {
                this.task = task;
            }

            @Override
            public void run() {
                try {
                    this.task.run();
                }
                catch (Exception e) {
                    LOGGER.error("SwingTimerTask", (Throwable)e);
                }
            }
        }
    }

    private static class CommonTimerTask
    extends TimerTask {
        private Runnable task;
        private Future<?> future;

        public CommonTimerTask(Runnable task) {
            this.task = task;
        }

        @Override
        public void run() {
            try {
                this.task.run();
            }
            catch (Exception e) {
                LOGGER.error("", (Throwable)e);
            }
        }

        @Override
        public boolean cancel() {
            if (this.future != null) {
                boolean result = this.future.cancel(true);
                this.future = null;
                this.task = null;
                return result;
            }
            return false;
        }

        public void setFuture(Future<?> future) {
            this.future = future;
        }
    }
}

