/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.common.bean;

import java.io.ObjectStreamException;

public enum DeviceType {
    N8000("N8000"),
    S2300("S2300"),
    S2600("S2600"),
    T3000("T3000"),
    S5000("S5000"),
    S5300("S5300"),
    AKI("AKI"),
    NEX("NEX"),
    OCEAN_STOR("OceanStor"),
    VIS("VIS"),
    S8000("S8000"),
    S5500("S5500"),
    S5600("S5600"),
    S_6800_E("S6800e"),
    C3("C3"),
    VTL3500("VTL3500"),
    VTL6000("VTL6000"),
    SIR6000("SIR6000"),
    HDP3500("HDP3500"),
    ALL_IN_ONE("AllInOne"),
    DORADO_2100("Dorado2100"),
    DORADO("Dorado"),
    N5000("N5000"),
    HVS88T("HVS88T"),
    SWITCHFC("SWITCHFC"),
    SWITCHFIBER("SWITCHFIBER");

    private static final long serialVersionUID = 5126097720840441893L;
    private String subType;
    private String description = null;

    private DeviceType(String description) {
        this.description = description;
    }

    public static DeviceType getDeviceType(String type) {
        for (DeviceType deviceType : DeviceType.values()) {
            if (!deviceType.getDescription().equals(type)) continue;
            return deviceType;
        }
        return null;
    }

    public String getDescription() {
        return this.description;
    }

    private Object readResolve() throws ObjectStreamException {
        String desc = this.getDescription();
        DeviceType type = DeviceType.valueOf(desc);
        type.subType = this.getSubType();
        throw new MyObjectStreamException("Can't find the device type which description is \"" + desc + "\"");
    }

    public static boolean isNASStorSerias(String type) {
        return N8000.getDescription().equalsIgnoreCase(type) || T3000.getDescription().equalsIgnoreCase(type);
    }

    public static boolean isNASStorSerias(DeviceType deviceType) {
        if (null == deviceType) {
            return false;
        }
        return N8000.equals((Object)deviceType) || T3000.equals((Object)deviceType);
    }

    public static boolean isVTLSerias(String type) {
        return VTL3500.getDescription().equalsIgnoreCase(type) || VTL6000.getDescription().equalsIgnoreCase(type) || ALL_IN_ONE.getDescription().equalsIgnoreCase(type);
    }

    public static boolean isVISSerias(DeviceType type) {
        if (null == type) {
            return false;
        }
        return S8000 == type || VIS == type;
    }

    public static boolean isVISSerias(String type) {
        if (null == type) {
            return false;
        }
        DeviceType deviceType = DeviceType.valueOf(type);
        return S8000 == deviceType || VIS == deviceType;
    }

    public static boolean isStorageCellSerias(String type) {
        DeviceType deviceType = DeviceType.valueOf(type);
        return !DeviceType.isNASStorSerias(type) && !DeviceType.isVISSerias(deviceType);
    }

    public String getSubType() {
        return this.subType;
    }

    public void setSubType(String subType) {
        this.subType = subType;
    }

    private static class MyObjectStreamException
    extends ObjectStreamException {
        private static final long serialVersionUID = 4076013163104990360L;

        public MyObjectStreamException(String classname) {
            super(classname);
        }
    }
}

