/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.common.entity.alarm;

import com.huawei.ism.common.bean.Event;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.exception.IsmException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlarmShortMessageConfig
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 4427198567467025132L;
    private Event.Level alarmLevel = Event.Level.INFO;
    private String arrayId = "";
    private transient List<String> receiveNumbers = new ArrayList<String>(0);
    private String shortMessageCenterNumber = "";
    private transient Map<Event.Level, Collection<String>> classficationReciveNums = new HashMap<Event.Level, Collection<String>>(0);
    private Country country;
    private boolean enableState;
    private String clientName;

    public AlarmShortMessageConfig(String arrayId, boolean enableState, Event.Level level, Country country, String shortMessageCenter, Collection<String> receiveNumbers) throws IsmException {
        if (null != arrayId) {
            this.arrayId = arrayId;
        }
        this.enableState = enableState;
        if (null != level) {
            this.alarmLevel = level;
        }
        if (null != shortMessageCenter) {
            this.shortMessageCenterNumber = shortMessageCenter;
        }
        this.country = null == country ? Country.UNKNOW : country;
        this.country = Country.getCountry(this.shortMessageCenterNumber);
        this.addReceiveNumbers(receiveNumbers);
    }

    public AlarmShortMessageConfig(String arrayId, boolean enableState, Event.Level level, Country country, String shortMessageCenternum, Collection<String> receiveNumbers, Map<Event.Level, Collection<String>> classficationReciveNums) throws IsmException {
        if (null != arrayId) {
            this.arrayId = arrayId;
        }
        this.enableState = enableState;
        if (null != level) {
            this.alarmLevel = level;
        }
        if (null != shortMessageCenternum) {
            this.shortMessageCenterNumber = shortMessageCenternum;
        }
        this.country = null == country ? Country.UNKNOW : country;
        this.country = Country.getCountry(this.shortMessageCenterNumber);
        this.addReceiveNumbers(receiveNumbers);
        if (null != classficationReciveNums) {
            this.classficationReciveNums = classficationReciveNums;
        }
    }

    public AlarmShortMessageConfig(String arrayId, boolean enableState, Event.Level level, String shortMessageCenter, Collection<String> receiveNumbers) throws IsmException {
        if (null != arrayId) {
            this.arrayId = arrayId;
        }
        this.enableState = enableState;
        if (null != level) {
            this.alarmLevel = level;
        }
        if (null != shortMessageCenter) {
            this.shortMessageCenterNumber = shortMessageCenter;
        }
        this.country = enableState ? Country.getCountry(this.shortMessageCenterNumber) : Country.UNKNOW;
        this.addReceiveNumbers(receiveNumbers);
    }

    public AlarmShortMessageConfig(String arrayId, boolean enableState, Event.Level alarmLevel, String shortMessageCenterNum, Collection<String> receiveNumbers, Map<Event.Level, Collection<String>> classficationReciveNums) throws IsmException {
        if (null != arrayId) {
            this.arrayId = arrayId;
        }
        this.enableState = enableState;
        if (null != alarmLevel) {
            this.alarmLevel = alarmLevel;
        }
        if (null != shortMessageCenterNum) {
            this.shortMessageCenterNumber = shortMessageCenterNum;
        }
        this.country = enableState ? Country.getCountry(this.shortMessageCenterNumber) : Country.UNKNOW;
        this.addReceiveNumbers(receiveNumbers);
        if (null != classficationReciveNums) {
            this.classficationReciveNums = classficationReciveNums;
        }
    }

    public synchronized void addReceiveNumber(String number) throws IsmException {
        this.receiveNumbers.add(number);
    }

    public synchronized void addReceiveNumbers(Collection<String> numbers) throws IsmException {
        this.receiveNumbers.addAll(numbers);
    }

    public boolean equals(Object object) {
        AlarmShortMessageConfig config;
        boolean isEqual = false;
        if (object == this) {
            isEqual = true;
        } else if (object == null) {
            isEqual = false;
        } else if (this.getClass().equals(object.getClass()) && this.checkEqual(config = (AlarmShortMessageConfig)object)) {
            isEqual = true;
        }
        return isEqual;
    }

    private boolean checkEqual(AlarmShortMessageConfig config) {
        return this.arrayId.equals(config.arrayId) && this.enableState == config.enableState && this.alarmLevel.equals((Object)config.alarmLevel) && this.country.equals((Object)config.country) && this.shortMessageCenterNumber.equals(config.shortMessageCenterNumber) && this.receiveNumbers.equals(config.receiveNumbers) && this.classficationReciveNums.equals(config.classficationReciveNums);
    }

    public Event.Level getAlarmLevel() {
        return this.alarmLevel;
    }

    public String getArrayId() {
        return this.arrayId;
    }

    public void setDeviceID(String deviceID) {
        if (null != deviceID) {
            this.arrayId = deviceID;
        }
    }

    public Country getCountry() {
        return this.country;
    }

    public synchronized Collection<String> getReceiveNumbers() {
        ArrayList<String> receiveNumbersClone = new ArrayList<String>(0);
        receiveNumbersClone.addAll(this.receiveNumbers);
        return receiveNumbersClone;
    }

    public String getShortMessageCenterNumber() {
        return this.shortMessageCenterNumber;
    }

    public void setShortMessageCenterNumber(String centerNumber) {
        if (null != centerNumber) {
            this.shortMessageCenterNumber = centerNumber;
        }
    }

    public synchronized int hashCode() {
        int hashCode = 17;
        hashCode = 37 * hashCode + this.arrayId.hashCode();
        hashCode = 37 * hashCode + this.country.hashCode();
        hashCode = 37 * hashCode + this.alarmLevel.hashCode();
        hashCode = 37 * hashCode + Boolean.valueOf(this.enableState).hashCode();
        hashCode = 37 * hashCode + this.shortMessageCenterNumber.hashCode();
        hashCode = 37 * hashCode + this.arrayId.hashCode();
        for (String s : this.receiveNumbers) {
            hashCode = 37 * hashCode + s.hashCode();
        }
        return hashCode;
    }

    public boolean isEnableState() {
        return this.enableState;
    }

    public synchronized boolean removeNumber(String number) {
        return this.receiveNumbers.remove(number);
    }

    public void setAlarmLevel(Event.Level alarmLevel) {
        if (null != alarmLevel) {
            this.alarmLevel = alarmLevel;
        }
    }

    public void setEnableState(boolean enableState) {
        this.enableState = enableState;
    }

    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String name) {
        this.clientName = name;
    }

    public String getDetail() {
        StringBuilder builder = new StringBuilder();
        builder.append(ResourceManager.getString("COMMON.TXT.SEND_LEVEL"));
        builder.append(": ");
        builder.append(this.alarmLevel.toString());
        builder.append(" ");
        builder.append(ResourceManager.getString("ALARM_SM_MOTIFICATION_SET_HINT"));
        builder.append(": ");
        String receiver = null;
        for (int i = 0; i < this.receiveNumbers.size(); ++i) {
            receiver = this.receiveNumbers.get(i);
            builder.append(receiver);
            if (i == this.receiveNumbers.size() - 1) continue;
            builder.append(',');
        }
        return builder.toString();
    }

    public String toString() {
        StringBuilder sbBuilder = new StringBuilder();
        sbBuilder.append(ResourceManager.getString("COMMON.TXT.SEND_LEVEL"));
        sbBuilder.append(": ");
        sbBuilder.append(this.alarmLevel.toString());
        sbBuilder.append("; ");
        sbBuilder.append(ResourceManager.getString("ALARM_SM_MOTIFICATION_SET_HINT"));
        sbBuilder.append(": ");
        String receive = null;
        for (int i = 0; i < this.receiveNumbers.size(); ++i) {
            receive = this.receiveNumbers.get(i);
            sbBuilder.append(receive);
            if (i == this.receiveNumbers.size() - 1) continue;
            sbBuilder.append(", ");
        }
        return sbBuilder.toString();
    }

    public AlarmShortMessageConfig clone() throws CloneNotSupportedException {
        AlarmShortMessageConfig clone = (AlarmShortMessageConfig)super.clone();
        clone.receiveNumbers = new ArrayList<String>(this.receiveNumbers);
        clone.classficationReciveNums = this.classficationReciveNums;
        return clone;
    }

    public void setClassficationReciveNums(Event.Level level, Collection<String> reciveNums) {
        if (null != this.classficationReciveNums.get((Object)level)) {
            this.classficationReciveNums.remove((Object)level);
        }
        this.classficationReciveNums.put(level, reciveNums);
    }

    public Collection<String> getClassficationReciveNumsByLevel(Event.Level level) {
        Collection<String> reciveNums = this.classficationReciveNums.get((Object)level);
        if (null == reciveNums) {
            return new ArrayList<String>(0);
        }
        return reciveNums;
    }

    public Map<Event.Level, Collection<String>> getClassficationReciveNums() {
        return this.classficationReciveNums;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }

    public static enum Country {
        CN(86),
        UNKNOW(0),
        US(1);

        private static final int CHINESE = 86;
        private static final String CHINESE_SECTION = "86";
        private static final int UNITED_STATES = 1;
        private static final String UNITED_STATES_SECTION = "1";
        private int value;

        private Country(int value) {
            this.value = value;
        }

        public static Country generateCountry(int country) {
            Country generatedCountry = null;
            switch (country) {
                case 86: {
                    generatedCountry = CN;
                    break;
                }
                case 1: {
                    generatedCountry = US;
                    break;
                }
                default: {
                    generatedCountry = UNKNOW;
                }
            }
            return generatedCountry;
        }

        public static Country getCountry(String centerNumber) {
            Country generatedCountry = null;
            if (null == centerNumber) {
                generatedCountry = UNKNOW;
            } else {
                String validCenterNumber = centerNumber;
                if (validCenterNumber.startsWith("+")) {
                    validCenterNumber = validCenterNumber.substring(validCenterNumber.indexOf("+") + 1);
                }
                generatedCountry = validCenterNumber.startsWith(CHINESE_SECTION) ? CN : (validCenterNumber.startsWith(UNITED_STATES_SECTION) ? US : UNKNOW);
            }
            return generatedCountry;
        }

        public int getValue() {
            return this.value;
        }
    }
}

