/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.connection;

import com.huawei.ism.common.bean.DeviceType;
import com.huawei.ism.connection.ConnectionMonitor;
import com.huawei.ism.connection.IConnection;
import com.huawei.ism.connection.SocketPool;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConnectionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionManager.class);
    private static ConnectionManager instance = new ConnectionManager();
    private Map<String, IConnection> connMap = new Hashtable<String, IConnection>(0);
    private Map<String, SocketPool> poolMapByDeviceID = new Hashtable<String, SocketPool>(0);
    private final Lock lock = new ReentrantLock();
    private Map<String, Class<? extends IConnection>> connClassMap = new Hashtable<String, Class<? extends IConnection>>(0);

    private ConnectionManager() {
    }

    public static ConnectionManager getInstance() {
        return instance;
    }

    public void closeAllConnection() {
        Collection<IConnection> allConnection = this.connMap.values();
        for (IConnection connection : allConnection) {
            if (connection == null) continue;
            try {
                connection.close();
            }
            catch (Exception e) {
                ToolLoggerFactory.getLogger(this.getClass()).error("close all connection error", (Throwable)e);
            }
        }
        this.connMap.clear();
    }

    public IConnection getConnection(String connectionID) {
        if (null == connectionID) {
            return null;
        }
        return this.connMap.get(connectionID);
    }

    public IConnection removeConnection(String connectionID) {
        return this.connMap.remove(connectionID);
    }

    public void setConnection(String connectionID, IConnection conn) {
        this.connMap.put(connectionID, conn);
    }

    public SocketPool getSocketPoolByDeviceID(String deviceID) {
        SocketPool pool = this.poolMapByDeviceID.get(deviceID);
        return pool;
    }

    public void setSocketPoolByDeviceID(String deviceID, SocketPool pool) {
        this.poolMapByDeviceID.put(deviceID, pool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDeviceIP(String deviceID, String ip) {
        try {
            this.lock.lock();
            SocketPool pool = this.poolMapByDeviceID.get(deviceID);
            if (pool != null) {
                pool.addDeviceIP(ip);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMasterIP(String deviceID, String ip) {
        try {
            this.lock.lock();
            SocketPool pool = this.poolMapByDeviceID.get(deviceID);
            if (pool != null) {
                pool.setMasterIP(ip);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void cleanAllIP(String deviceID) {
        try {
            this.lock.lock();
            SocketPool pool = this.poolMapByDeviceID.get(deviceID);
            if (pool != null) {
                pool.cleanAllIP();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public IConnection buildConnWithoutChgListener(String deviceType, Properties properties) {
        Class<? extends IConnection> clazz = this.connClassMap.get(deviceType);
        if (null == clazz) {
            clazz = this.connClassMap.get(DeviceType.OCEAN_STOR.name());
        }
        try {
            IConnection conn = clazz.newInstance();
            conn.init(properties);
            return conn;
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
            return null;
        }
    }

    public IConnection buildConnection(String deviceType, Properties properties) {
        IConnection conn = this.buildConnWithoutChgListener(deviceType, properties);
        if (null != conn) {
            conn.addStateChangeListener(new ConnectionMonitor(conn));
        }
        return conn;
    }

    public void registerConnectionClass(String deviceType, Class<? extends IConnection> clazz) {
        this.connClassMap.put(deviceType, clazz);
    }
}

