/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.service;

import com.huawei.ism.common.ICallback;
import com.huawei.ism.common.bean.DeviceType;
import com.huawei.ism.common.bean.ProductModelType;
import com.huawei.ism.connection.ConnectionManager;
import com.huawei.ism.connection.IConnection;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.message.IsmMsg;
import com.huawei.ism.message.IsmMsgManager;
import com.huawei.ism.model.AssociateType;
import com.huawei.ism.model.Associator;
import com.huawei.ism.model.MO;
import com.huawei.ism.model.MOType;
import com.huawei.ism.model.UUID;
import com.huawei.ism.service.Datacache;
import com.huawei.ism.service.DefaultCRUDHandler;
import com.huawei.ism.service.ICRUDHandler;
import com.huawei.ism.service.IMethod2;
import com.huawei.ism.service.MOsCache;
import com.huawei.ism.thread.ThreadPoolManager;
import com.huawei.ism.tlv.TLV;
import com.huawei.ism.tool.framework.pubservice.exception.EncapsulatedRuntimeException;
import com.huawei.ism.util.CommonUtil;
import com.huawei.ism.util.ProductToolContainer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CommonWorkTaker {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonWorkTaker.class);
    private static CommonWorkTaker instance = new CommonWorkTaker();
    private final Datacache datacache = Datacache.getInstance();
    private ProductToolContainer<MOType, ICRUDHandler> hanlderMap = new ProductToolContainer();
    private ProductToolContainer<String, IMethod2> methodMap = new ProductToolContainer();
    private Map<String, Semaphore> deviceSemaphoreMap = new HashMap<String, Semaphore>(0);
    private final Object LOCK = new Object();

    private CommonWorkTaker() {
    }

    public static CommonWorkTaker getInstance() {
        return instance;
    }

    public String getDeviceType(String deviceID) {
        MO deviceMO = this.getDeviceMO(deviceID);
        int product = deviceMO.getIntProperty(TLV.SYSTEM.PRODUCTMODE);
        ProductModelType type = ProductModelType.getProductModel(product);
        DeviceType deviceType = type.getDeviceTypeV2();
        return deviceType.name();
    }

    public MO getDeviceMO(String deviceID) {
        return this.datacache.getDeviceMO(deviceID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initDevice(String deviceType, String deviceID) {
        Object object = this.LOCK;
        synchronized (object) {
            Semaphore semaphore = this.deviceSemaphoreMap.get(deviceID);
            if (semaphore == null) {
                semaphore = new Semaphore(1);
                this.deviceSemaphoreMap.put(deviceID, semaphore);
            }
        }
        IConnection conn = ConnectionManager.getInstance().getConnection(deviceID);
        ICRUDHandler handler = this.hanlderMap.getTool(deviceType, MOType.SYSTEM);
        if (handler == null) {
            throw new NullPointerException("handler is null.");
        }
        handler.setConnection(conn);
        MO mo = handler.retrieve(new UUID(deviceID, MOType.SYSTEM, ""));
        this.datacache.saveMO(mo);
    }

    public void registerCRUDHandler(String deviceType, ICRUDHandler handler) {
        this.hanlderMap.registerTool(deviceType, handler.moType(), handler);
    }

    public void registerMethod(String deviceType, IMethod2 method) {
        this.methodMap.registerTool(deviceType, method.name(), method);
    }

    public void deleteMO(final UUID uuid, final ICallback callback) {
        final StackTraceElement[] srcStack = Thread.currentThread().getStackTrace();
        Runnable command = new Runnable(){

            @Override
            public void run() {
                IsmMsg msg = IsmMsgManager.getInstance().buildMsg("MSG_TYPE_DELETE_MO_RESULT");
                ICRUDHandler handler = CommonWorkTaker.this.getCRUDHandler(uuid.getDeviceID(), uuid.getMOTypeValue());
                try {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("Async delete MO, the uuid is" + uuid.toString());
                    }
                    handler.delete(uuid);
                    CommonWorkTaker.this.datacache.deleteMO(uuid);
                }
                catch (Exception e) {
                    CommonWorkTaker.this.asyncErrorLog(srcStack, e);
                    msg.setProperty("PROPERTY_EXCEPTION", e);
                }
                if (null != callback) {
                    callback.complete(msg);
                }
            }
        };
        ThreadPoolManager.getInstance().execute(command);
    }

    private void asyncErrorLog(StackTraceElement[] srcStack, Exception e) {
        StackTraceElement[] stElements = e.getStackTrace();
        StackTraceElement[] totalStack = new StackTraceElement[srcStack.length - 2 + stElements.length];
        System.arraycopy(stElements, 0, totalStack, 0, stElements.length);
        System.arraycopy(srcStack, 2, totalStack, stElements.length, srcStack.length - 2);
        e.setStackTrace(totalStack);
        LOGGER.error("", (Throwable)e);
    }

    public void deleteMO(UUID uuid) {
        try {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Syn delete MO, the uuid is" + uuid.toString());
            }
            ICRUDHandler handler = this.getCRUDHandler(uuid.getDeviceID(), uuid.getMOTypeValue());
            handler.delete(uuid);
            this.datacache.deleteMO(uuid);
        }
        catch (RuntimeException e) {
            LOGGER.error("", (Throwable)e);
            throw e;
        }
    }

    public void updateMO(MO newData) {
        try {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Sync update MO, the uuid is" + newData.getUUID());
            }
            ICRUDHandler handler = this.getCRUDHandler(newData.getDeviceID(), newData.getMOTypeValue());
            handler.update(newData);
            UUID uuid = new UUID(newData.getDeviceID(), newData.getMOTypeValue(), newData.getID());
            this.datacache.saveMO(handler.retrieve(uuid));
        }
        catch (RuntimeException e) {
            LOGGER.error("", (Throwable)e);
            throw e;
        }
    }

    public MO retrieveMOBy(MO newData) {
        try {
            ICRUDHandler handler = this.getCRUDHandler(newData.getDeviceID(), newData.getMOTypeValue());
            UUID uuid = new UUID(newData.getDeviceID(), newData.getMOTypeValue(), newData.getID());
            MO newMO = handler.retrieveBy(uuid, newData.getProperties());
            this.datacache.saveMO(newMO);
            return newMO;
        }
        catch (RuntimeException e) {
            LOGGER.error("", (Throwable)e);
            throw e;
        }
    }

    public void updateMO(final MO newData, final ICallback callback) {
        Runnable command = new Runnable(){

            @Override
            public void run() {
                StackTraceElement[] srcStack = Thread.currentThread().getStackTrace();
                IsmMsg msg = IsmMsgManager.getInstance().buildMsg("MSG_TYPE_DELETE_MO_RESULT");
                ICRUDHandler handler = CommonWorkTaker.this.getCRUDHandler(newData.getDeviceID(), newData.getMOTypeValue());
                try {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("Async update MO, the uuid is" + newData.getUUID());
                    }
                    handler.update(newData);
                    UUID uuid = new UUID(newData.getDeviceID(), newData.getMOTypeValue(), newData.getID());
                    MO newMO = handler.retrieve(uuid);
                    CommonWorkTaker.this.datacache.saveMO(newMO);
                    msg.setProperty("PROPERTY_MO", newMO);
                }
                catch (Exception e) {
                    CommonWorkTaker.this.asyncErrorLog(srcStack, e);
                    msg.setProperty("PROPERTY_EXCEPTION", e);
                }
                if (null != callback) {
                    callback.complete(msg);
                }
            }
        };
        ThreadPoolManager.getInstance().execute(command);
    }

    public void createMO(final String deviceID, final MOType moType, final Map<Object, Object> properties, final ICallback callback) {
        Runnable command = new Runnable(){

            @Override
            public void run() {
                StackTraceElement[] srcStack = Thread.currentThread().getStackTrace();
                IsmMsg msg = IsmMsgManager.getInstance().buildMsg("MSG_TYPE_CREATE_MO_RESULT");
                try {
                    MO mo = CommonWorkTaker.this.createMO(deviceID, moType, properties);
                    msg.setProperty("PROPERTY_MO", mo);
                }
                catch (Exception e) {
                    CommonWorkTaker.this.asyncErrorLog(srcStack, e);
                    msg.setProperty("PROPERTY_EXCEPTION", e);
                }
                if (null != callback) {
                    callback.complete(msg);
                }
            }
        };
        ThreadPoolManager.getInstance().execute(command);
    }

    public MO createMO(String deviceID, MOType moType, Map<Object, Object> properties) {
        MO mo = null;
        try {
            ICRUDHandler handler = this.getCRUDHandler(deviceID, moType);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Sync create mo, the moType is " + moType.name());
            }
            if (null != (mo = handler.create(deviceID, moType, properties))) {
                this.datacache.saveMO(mo);
            }
        }
        catch (RuntimeException e) {
            LOGGER.error("", (Throwable)e);
            throw e;
        }
        return mo;
    }

    public Map<Object, Object> invokeMethod(String deviceID, MOType motype, long cmd, Map<Object, Object> inArgs) {
        try {
            ICRUDHandler handler = this.getCRUDHandler(deviceID, motype);
            IConnection conn = ConnectionManager.getInstance().getConnection(deviceID);
            if (conn != null) {
                handler.setConnection(conn);
            }
            return handler.invoke(cmd, inArgs);
        }
        catch (RuntimeException e) {
            LOGGER.error("When invoke the method occur error. The code of the method is:" + cmd, (Throwable)e);
            throw e;
        }
    }

    public Map<Object, Object> invokeMethod(String deviceID, String methodName, Map<Object, Object> inArgs) {
        try {
            IMethod2 method = this.methodMap.getTool(this.getDeviceType(deviceID), methodName);
            IConnection conn = ConnectionManager.getInstance().getConnection(deviceID);
            if (method == null) {
                throw new EncapsulatedRuntimeException("Method is null.");
            }
            if (conn != null) {
                method.setConnection(conn);
            }
            return method.invoke(inArgs);
        }
        catch (RuntimeException e) {
            LOGGER.error("", (Throwable)e);
            throw e;
        }
    }

    public void invokeMethod(final String deviceID, final String methodName, final Map<Object, Object> inArgs, final ICallback callback) {
        Runnable command = new Runnable(){

            @Override
            public void run() {
                StackTraceElement[] srcStack = Thread.currentThread().getStackTrace();
                IsmMsg msg = IsmMsgManager.getInstance().buildMsg("MSG_TYPE_INVOKE_METHOD_RESULT");
                try {
                    Map<Object, Object> outArgs = CommonWorkTaker.this.invokeMethod(deviceID, methodName, inArgs);
                    for (Map.Entry<Object, Object> entry : outArgs.entrySet()) {
                        msg.setProperty(entry.getKey(), entry.getValue());
                    }
                }
                catch (Exception e) {
                    CommonWorkTaker.this.asyncErrorLog(srcStack, e);
                    msg.setProperty("PROPERTY_EXCEPTION", e);
                }
                if (null != callback) {
                    callback.complete(msg);
                }
            }
        };
        ThreadPoolManager.getInstance().execute(command);
    }

    public void asyncRetrieveMO(UUID uuid, ICallback callback) {
        this.asyncRetrieveMO(uuid, EGetDataMode.FromCache, callback);
    }

    public void asyncRetrieveMO(final UUID uuid, final EGetDataMode mode, final ICallback callback) {
        Runnable command = new Runnable(){

            @Override
            public void run() {
                StackTraceElement[] srcStack = Thread.currentThread().getStackTrace();
                IsmMsg msg = IsmMsgManager.getInstance().buildMsg("MSG_TYPE_RETRIEVE_MO_RESULT");
                MO mo = null;
                try {
                    mo = mode == EGetDataMode.FromDevice ? CommonWorkTaker.this.retrieveMOFromDevice(uuid) : CommonWorkTaker.this.retrieveMO(uuid);
                    msg.setProperty("PROPERTY_MO", mo);
                }
                catch (Exception e) {
                    CommonWorkTaker.this.asyncErrorLog(srcStack, e);
                    msg.setProperty("PROPERTY_EXCEPTION", e);
                }
                if (callback != null) {
                    callback.complete(msg);
                }
            }
        };
        ThreadPoolManager.getInstance().executeAndLogException(command, "retrieveMO, uuid = " + uuid);
    }

    public void asyncRetrieveMOs(final String deviceID, final MOType[] moTypes, final EGetDataMode mode, final ICallback callback) {
        Runnable command = new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        CommonWorkTaker.this.complete(callback, CommonWorkTaker.this.retrieveMOs(deviceID, moTypes, mode));
                    }
                    catch (Exception e) {
                        if (null == callback) break block2;
                        IsmMsg msg = IsmMsgManager.getInstance().buildMsg("PROPERTY_EXCEPTION");
                        msg.setProperty("PROPERTY_EXCEPTION", e);
                        callback.complete(msg);
                    }
                }
            }
        };
        ThreadPoolManager.getInstance().executeAndLogException(command, "retrieveMOs, deviceID = " + deviceID + " ;moTypes = " + ToStringBuilder.reflectionToString((Object)moTypes));
    }

    public void asyncRetrieveSubMOs(final UUID uuid, final MOType subMOType, final ICallback callback) {
        Runnable command = new Runnable(){

            @Override
            public void run() {
                CommonWorkTaker.this.complete(callback, CommonWorkTaker.this.retrieveSubMOs(uuid, subMOType));
            }
        };
        ThreadPoolManager.getInstance().executeAndLogException(command, "retrieveSubMOs, uuid = " + uuid + " ; subMOType = " + (Object)((Object)subMOType));
    }

    public void asyncAssociateMOs(final UUID uuid, final MOType associateMOType, final AssociateType associateType, final ICallback callback) {
        Runnable command = new Runnable(){

            @Override
            public void run() {
                CommonWorkTaker.this.complete(callback, CommonWorkTaker.this.associateMOs(uuid, associateMOType, associateType));
            }
        };
        ThreadPoolManager.getInstance().executeAndLogException(command, "associateMOs, uuid = " + uuid + " ;associateType = " + (Object)((Object)associateType));
    }

    public void asyncRetrieveAssociator(final UUID leftUUID, final UUID rightUUID, final MOType associateType, final ICallback callback) {
        Runnable command = new Runnable(){

            @Override
            public void run() {
                CommonWorkTaker.this.complete(callback, CommonWorkTaker.this.retrieveAssociator(leftUUID, rightUUID, associateType));
            }
        };
        ThreadPoolManager.getInstance().executeAndLogException(command, "retrieveAssociator, leftuuid = " + leftUUID + " ;rightuuid = " + rightUUID + " ;associateType = " + (Object)((Object)associateType));
    }

    public MO retrieveMO(UUID uuid) {
        return this.toRetrieve(uuid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MO retrieveMOFromDevice(UUID uuid) {
        MO mo = null;
        ICRUDHandler handler = this.getCRUDHandler(uuid.getDeviceID(), uuid.getMOType());
        Semaphore semaphore = null;
        try {
            semaphore = this.acquire(uuid.getDeviceID());
            mo = handler.retrieve(uuid);
        }
        finally {
            if (semaphore != null) {
                semaphore.release();
            }
        }
        if (mo != null) {
            this.datacache.saveMO(mo);
        }
        return mo;
    }

    public MOsCache retrieveMOs(String deviceID, MOType[] moTypes, EGetDataMode mode) {
        MOsCache cache = new MOsCache(deviceID);
        for (MOType moType : moTypes) {
            cache.saveMOList(moType.getValue(), this.retrieveMOs(deviceID, moType, mode));
        }
        return cache;
    }

    public List<MO> retrieveMOs(String deviceID, MOType moType, EGetDataMode mode) {
        if (mode == EGetDataMode.FromDevice) {
            return this.retrieveFromDevice(deviceID, moType);
        }
        return this.toRetrieve(deviceID, moType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MO> retrieveSubMOs(UUID uuid, MOType subMOType) {
        ICRUDHandler handler = this.getCRUDHandler(uuid.getDeviceID(), subMOType);
        Semaphore semaphore = null;
        try {
            semaphore = this.acquire(uuid.getDeviceID());
            List<MO> list = handler.retrieveChildrenOf(uuid);
            return list;
        }
        finally {
            if (semaphore != null) {
                semaphore.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MO> retrieveMOsOf(String deviceID, MOType moType, Map<Object, Object> properties) {
        ICRUDHandler handler = this.getCRUDHandler(deviceID, moType);
        Semaphore semaphore = null;
        try {
            semaphore = this.acquire(deviceID);
            List<MO> list = handler.retrieveAllOf(properties);
            return list;
        }
        finally {
            if (semaphore != null) {
                semaphore.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MO> associateMOs(UUID uuid, MOType associateMOType, AssociateType associateType) {
        ICRUDHandler handler = this.getCRUDHandler(uuid.getDeviceID(), associateMOType);
        Semaphore semaphore = null;
        try {
            semaphore = this.acquire(uuid.getDeviceID());
            List<MO> list = handler.associateAllOf(uuid, associateType);
            return list;
        }
        finally {
            if (semaphore != null) {
                semaphore.release();
            }
        }
    }

    public Associator retrieveAssociator(UUID leftUUID, UUID rightUUID, MOType associateType) {
        Datacache.OperationResult result = this.datacache.getMOs(leftUUID.getDeviceID(), associateType.getValue());
        List<MO> mos = null;
        mos = result.getResult() == Datacache.ResultDescription.NEED_SYNC ? this.retrieveFromDevice(leftUUID.getDeviceID(), associateType) : result.getMOs();
        Associator associator = null;
        for (MO mo : mos) {
            if (!(mo instanceof Associator)) continue;
            associator = CommonUtil.convertObject(mo, Associator.class);
            if (associator.isAssociatorOf(associateType, leftUUID, rightUUID)) break;
            associator = null;
        }
        return associator;
    }

    private Semaphore acquire(String deviceID) {
        Semaphore semaphore = this.deviceSemaphoreMap.get(deviceID);
        try {
            semaphore.acquire();
        }
        catch (InterruptedException e) {
            LOGGER.error("", (Throwable)e);
        }
        return semaphore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MO> retrieveFromDevice(String deviceID, MOType moType) {
        ICRUDHandler handler = this.getCRUDHandler(deviceID, moType);
        Semaphore semaphore = null;
        try {
            semaphore = this.acquire(deviceID);
            List<MO> newMOs = handler.retrieveAll(deviceID);
            this.datacache.saveMOs(deviceID, moType.getValue(), newMOs);
            List<MO> list = newMOs;
            return list;
        }
        finally {
            if (semaphore != null) {
                semaphore.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MO> toRetrieve(String deviceID, MOType moType) {
        Datacache.OperationResult result = this.datacache.getMOs(deviceID, moType.getValue());
        List<MO> mos = result.getMOs();
        LinkedList<MO> dirtyMOs = new LinkedList<MO>();
        switch (result.getResult()) {
            case NEED_SYNC: {
                mos = this.retrieveFromDevice(deviceID, moType);
                break;
            }
            case NEED_PART_SYNC: {
                dirtyMOs.addAll(result.getDirtyMOs());
                break;
            }
            default: {
                mos = result.getMOs();
            }
        }
        ICRUDHandler handler = null;
        Semaphore semaphore = null;
        MO newMO = null;
        for (MO dirtyMO : dirtyMOs) {
            block14: {
                handler = this.getCRUDHandler(deviceID, dirtyMO.getMOTypeValue());
                try {
                    semaphore = this.acquire(deviceID);
                    newMO = handler.retrieve(dirtyMO.getUUID());
                }
                catch (IsmException e) {
                    if (MOType.DISK.equals((Object)moType)) {
                        LOGGER.error("retrieve disk error. " + dirtyMO.getUUID() + e);
                        break block14;
                    }
                    throw e;
                }
                finally {
                    if (semaphore != null) {
                        semaphore.release();
                    }
                }
            }
            if (newMO != null) {
                mos.remove(dirtyMO);
                mos.add(newMO);
                this.datacache.saveMO(newMO);
                continue;
            }
            if (!dirtyMO.getBoolProperty("MO_NEW_CREATE").booleanValue()) continue;
            this.datacache.deleteMO(dirtyMO.getUUID());
        }
        LinkedList<MO> newRetu = new LinkedList<MO>();
        for (MO moe : mos) {
            if (moe.getBoolProperty("MO_NEW_CREATE").booleanValue()) continue;
            newRetu.add(moe);
        }
        return newRetu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MO toRetrieve(UUID uuid) {
        MO mo = null;
        Datacache.OperationResult result = this.datacache.getMO(uuid);
        if (null == result || result.getResult() == Datacache.ResultDescription.NEED_SYNC) {
            ICRUDHandler handler = this.getCRUDHandler(uuid.getDeviceID(), uuid.getMOTypeValue());
            Semaphore semaphore = null;
            try {
                semaphore = this.acquire(uuid.getDeviceID());
                mo = handler.retrieve(uuid);
            }
            finally {
                if (semaphore != null) {
                    semaphore.release();
                }
            }
            if (mo != null) {
                this.datacache.saveMO(mo);
            }
        } else {
            mo = result.getDatacacheMo();
        }
        return mo;
    }

    private ICRUDHandler getCRUDHandler(String deviceID, int typeValue) {
        IConnection conn;
        MOType moType = MOType.getType(typeValue);
        ICRUDHandler handler = this.hanlderMap.getTool(this.getDeviceType(deviceID), moType);
        if (handler == null) {
            handler = new DefaultCRUDHandler(moType);
        }
        if ((conn = ConnectionManager.getInstance().getConnection(deviceID)) != null) {
            handler.setConnection(conn);
        }
        return handler;
    }

    private ICRUDHandler getCRUDHandler(String deviceID, MOType moType) {
        IConnection conn;
        ICRUDHandler handler = this.hanlderMap.getTool(this.getDeviceType(deviceID), moType);
        if (handler == null) {
            handler = new DefaultCRUDHandler(moType);
        }
        if ((conn = ConnectionManager.getInstance().getConnection(deviceID)) != null) {
            handler.setConnection(conn);
        }
        return handler;
    }

    private void complete(ICallback callback, List<MO> mos) {
        if (null != callback) {
            IsmMsg msg = IsmMsgManager.getInstance().buildMsg("MSG_TYPE_RETRIEVE_MO_RESULT");
            msg.setProperty("PROPERTY_MO_LIST", mos);
            callback.complete(msg);
        }
    }

    private void complete(ICallback callback, MOsCache cache) {
        if (null != callback) {
            IsmMsg msg = IsmMsgManager.getInstance().buildMsg("MSG_TYPE_RETRIEVE_MO_RESULT");
            msg.setProperty("PROPERTY_MOS_CACHE", cache);
            callback.complete(msg);
        }
    }

    private void complete(ICallback callback, MO mo) {
        if (null != callback) {
            IsmMsg msg = IsmMsgManager.getInstance().buildMsg("MSG_TYPE_RETRIEVE_MO_RESULT");
            msg.setProperty("PROPERTY_MO", mo);
            callback.complete(msg);
        }
    }

    public static enum EGetDataMode {
        FromDevice,
        FromCache;

    }
}

