/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing;

import com.huawei.ism.ui.swing.TernaryCheckBox;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;

public class CheckBoxGroup {
    private static final long serialVersionUID = 8297494125227488798L;
    private List<JCheckBox> checkBoxs = new ArrayList<JCheckBox>(0);
    private TernaryCheckBox parent = null;

    public CheckBoxGroup(TernaryCheckBox parent, JCheckBox ... checkBoxs) {
        this.parent = parent;
        this.parent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckBoxGroup.this.parentActionHandler();
            }
        });
        for (JCheckBox checkBox : checkBoxs) {
            this.checkBoxs.add(checkBox);
            this.addChildActionListener(checkBox);
        }
    }

    public boolean isSelected() {
        return this.parent.isSelected();
    }

    public boolean isPartialSelected() {
        return this.parent.isPartialSelected();
    }

    public void add(JCheckBox checkBox) {
        if (checkBox == null) {
            return;
        }
        this.checkBoxs.add(checkBox);
        this.addChildActionListener(checkBox);
    }

    private void addChildActionListener(JCheckBox checkBox) {
        checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckBoxGroup.this.childActionHandler();
            }
        });
    }

    private void parentActionHandler() {
        this.parent.setPartialSelected(false);
        this.select(this.parent.isSelected());
    }

    private void childActionHandler() {
        int selected = 0;
        for (JCheckBox checkBox : this.checkBoxs) {
            selected = checkBox.isSelected() ? selected + 1 : selected;
        }
        this.parent.setPartialSelected(false);
        this.parent.setSelected(true);
        this.parent.setSelected(false);
        if (selected == 0) {
            this.parent.setSelected(false);
        } else if (selected == this.checkBoxs.size()) {
            this.parent.setSelected(true);
        } else {
            this.parent.setPartialSelected(true);
        }
    }

    private void select(boolean selected) {
        for (JCheckBox checkBox : this.checkBoxs) {
            checkBox.setSelected(selected);
        }
    }
}

