/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.dialog;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.ui.swing.LayoutConstants;
import com.huawei.ism.ui.swing.dialog.DialogsConstants;
import com.huawei.ism.ui.swing.text.IsmTextArea;
import com.huawei.ism.ui.swing.text.IsmTextField;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.Utils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextInputDialog
extends JDialog
implements DialogsConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(TextInputDialog.class);
    private static final int FIELD_LENGTH = 20;
    private static final int GRIDX_0 = 0;
    private static final int GRIDY_0 = 0;
    private static final int GRIDY_1 = 1;
    private static final int INSETS_EMPTY = 0;
    private static final int MAX_CONTENT_LENGTH = 128;
    private static final long serialVersionUID = 3007169049914687651L;
    private static final double WEIGHTX_1 = 0.1;
    private static final double WEIGHTY_1 = 0.1;
    private static final String INPUT_DIALOG_NAME = "platform_dialogs_RequireInputConfirmationDialog";
    private static final String BUREAU_INSPECT_USER = "BUREAU_INSPECT_USER";
    private static final String USER_NAME_NOT_NULL = "USER_NAME_NOT_NULL";
    private static final String REQUIRE_INPUT_CONFIRMATIONCANNEL = "REQUIRE_INPUT_CONFIRMATIONCANNEL";
    private static final String REQUIRE_INPUT_CONFIRMATIONCONFIRM = "REQUIRE_INPUT_CONFIRMATIONCONFIRM";
    private static final String BUREAU_INSPECT_PROMPT_LABEL = "BUREAU_INSPECT_PROMPT_LABEL";
    private static final String USER_NAME_LABLE = "USER_NAME_LABLE";
    private JPanel buttonPanel;
    private JButton cannelButton;
    private JButton confirmButton;
    private JPanel displayPanel;
    private IsmTextArea displayPrompt;
    private IsmTextArea whiteLabelPrompt;
    private IsmTextField inputTextField;
    private JPanel promptDisplayPanel;
    private JLabel promptLabel;
    private int closeEventValue = -1;
    private JPanel wholePanel;

    public TextInputDialog(JDialog parent, String title) {
        super((Dialog)parent, true);
        this.setName(INPUT_DIALOG_NAME);
        this.toFront();
        this.init(title);
        this.confirmButton.setMnemonic('O');
    }

    public TextInputDialog(JDialog parent) {
        this(parent, ResourceManager.getString(BUREAU_INSPECT_USER));
    }

    public String getInputTextValue() {
        return this.inputTextField.getText();
    }

    public int getCloseEventValue() {
        return this.closeEventValue;
    }

    public void setCloseEventValue(int value) {
        if (Utils.isJunitTest()) {
            this.closeEventValue = value;
        }
    }

    @Override
    public void processWindowEvent(WindowEvent windowEvent) {
        switch (windowEvent.getID()) {
            case 200: {
                this.inputTextField.requestFocus();
                break;
            }
            case 201: {
                this.closeEventValue = 1;
                this.dispose();
                break;
            }
        }
    }

    private void cancelButtonAction(ActionEvent e) {
        this.closeEventValue = 1;
        this.dispose();
    }

    private void confirmButtonAction() {
        this.closeEventValue = 0;
        if (this.checkInputNotNull()) {
            this.dispose();
        }
    }

    private boolean checkInputNotNull() {
        if (StringUtils.isNULLObjectOrNullStr(this.inputTextField.getText())) {
            this.displayPrompt.setText(ResourceManager.getString(USER_NAME_NOT_NULL));
            this.displayPrompt.setVisible(true);
            return false;
        }
        return true;
    }

    private void init(String title) {
        this.cannelButton = new JButton(ResourceManager.getString(REQUIRE_INPUT_CONFIRMATIONCANNEL));
        this.confirmButton = new JButton(ResourceManager.getString(REQUIRE_INPUT_CONFIRMATIONCONFIRM));
        this.whiteLabelPrompt = new IsmTextArea();
        this.whiteLabelPrompt.setText(ResourceManager.getString(BUREAU_INSPECT_PROMPT_LABEL));
        this.displayPrompt = new IsmTextArea(false, true);
        this.buttonPanel = new JPanel();
        this.inputTextField = IsmTextField.getNameLengthTextField("[a-zA-Z\\u4e00-\\u9fa5\\u002a\\u00b7\\s]*", "", 128, 20);
        this.promptLabel = new JLabel();
        this.promptLabel.setText(ResourceManager.getString(USER_NAME_LABLE));
        this.promptDisplayPanel = new JPanel();
        this.initComponent();
        this.initEvent();
        this.initButton();
        super.setTitle(title);
        this.pack();
        this.setBackground(LayoutConstants.BACKGROUND_COLOR);
        this.pack();
        SwingUtil.putScreenCenter(this);
        this.setResizable(false);
    }

    private void initComponent() {
        this.initLayoutPane();
        this.initDisplayPane();
    }

    private void initDisplayPane() {
        this.displayPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.displayPanel.add((Component)this.promptDisplayPanel, gridBagConstraints);
        this.promptDisplayPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.promptDisplayPanel.add((Component)this.whiteLabelPrompt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.promptDisplayPanel.add((Component)this.promptLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        this.promptDisplayPanel.add((Component)this.inputTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.anchor = 17;
        this.promptDisplayPanel.add((Component)this.displayPrompt, gridBagConstraints);
    }

    private void initLayoutPane() {
        this.setDefaultCloseOperation(2);
        this.wholePanel = new JPanel();
        this.displayPanel = new JPanel();
        this.wholePanel.setLayout(new GridBagLayout());
        this.add((Component)this.wholePanel, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.wholePanel.add((Component)this.displayPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 12, 0);
        gridBagConstraints.weightx = 0.1;
        this.wholePanel.add((Component)this.buttonPanel, gridBagConstraints);
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 0));
        this.buttonPanel.add(Box.createHorizontalGlue());
        this.buttonPanel.add(this.confirmButton);
        this.buttonPanel.add(Box.createHorizontalStrut(12));
        this.buttonPanel.add(this.cannelButton);
        this.buttonPanel.add(Box.createHorizontalGlue());
    }

    private void initButton() {
        Dimension buttonDefaultSize = new Dimension(80, BUTTON_HTGHT);
        this.cannelButton.setPreferredSize(buttonDefaultSize);
        this.confirmButton.setPreferredSize(buttonDefaultSize);
        this.getRootPane().setDefaultButton(this.confirmButton);
        this.cannelButton.setMnemonic('C');
    }

    private void initEvent() {
        this.confirmButton.addActionListener(e -> this.confirmButtonAction());
        this.cannelButton.addActionListener(actionEvent -> this.cancelButtonAction(actionEvent));
    }
}

