/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.plaf;

import com.huawei.ism.ui.swing.control.IsmComboBoxButton;
import com.huawei.ism.ui.swing.plaf.IsmBorders;
import com.huawei.ism.ui.swing.plaf.IsmComboPopup;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.util.CommonUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;

public class IsmComboBoxUI
extends BasicComboBoxUI {
    public static ComponentUI createUI(JComponent c) {
        return new IsmComboBoxUI();
    }

    @Override
    protected ComboPopup createPopup() {
        return new IsmComboPopup(this.comboBox);
    }

    protected ListCellRenderer createRenderer() {
        return new IsmComboBoxRenderer();
    }

    @Override
    public void addEditor() {
        super.addEditor();
        ((JTextField)this.editor).setBorder(null);
    }

    @Override
    protected JButton createArrowButton() {
        IsmComboBoxButton button = new IsmComboBoxButton(this.comboBox, UIManager.getIcon("ComboBox.arrowIcon"), true, this.currentValuePane, this.listBox);
        button.setMargin(new Insets(0, 1, 1, 3));
        button.setBorder(IsmBorders.getButtonBorder(false));
        button.setFocusPainted(this.comboBox.isEditable());
        return button;
    }

    @Override
    public void paintCurrentValueBackground(Graphics g, Rectangle bounds, boolean hasFocus) {
        if (g == null || bounds == null) {
            throw new NullPointerException("Must supply a non-null Graphics and Rectangle");
        }
    }

    @Override
    public void paintCurrentValue(Graphics graphics, Rectangle bounds, boolean hasFocus) {
        bounds.setLocation((int)bounds.getX() + 1, (int)bounds.getY() + 1);
        bounds.width -= 2;
        bounds.height -= 2;
        super.paintCurrentValue(graphics, bounds, hasFocus);
    }

    @Override
    protected ComboBoxEditor createEditor() {
        return new IsmComboBoxEditor();
    }

    private void updateButtonForOcean(JButton button) {
        button.setFocusPainted(this.comboBox.isEditable());
    }

    @Override
    public PropertyChangeListener createPropertyChangeListener() {
        return new BasicComboBoxUI.PropertyChangeHandler(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                super.propertyChange(propertyChangeEvent);
                String propertyName = propertyChangeEvent.getPropertyName();
                if (propertyName.equals("editable")) {
                    IsmComboBoxButton button = CommonUtil.convertObject(IsmComboBoxUI.this.arrowButton, IsmComboBoxButton.class);
                    button.setIconOnly(IsmComboBoxUI.this.comboBox.isEditable() || IsmComboBoxUI.this.usingNewStyle());
                    IsmComboBoxUI.this.comboBox.repaint();
                    IsmComboBoxUI.this.updateButtonForOcean(button);
                } else if (propertyName.equals("background")) {
                    Color color = (Color)propertyChangeEvent.getNewValue();
                    IsmComboBoxUI.this.arrowButton.setBackground(color);
                    IsmComboBoxUI.this.listBox.setBackground(color);
                } else if (propertyName.equals("foreground")) {
                    Color color = (Color)propertyChangeEvent.getNewValue();
                    IsmComboBoxUI.this.arrowButton.setForeground(color);
                    IsmComboBoxUI.this.listBox.setForeground(color);
                }
            }
        };
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new IsmComboBoxLayoutManager();
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        if (!this.isMinimumSizeDirty) {
            return new Dimension(this.cachedMinimumSize);
        }
        Dimension size = null;
        if (!this.comboBox.isEditable() && this.arrowButton != null && this.arrowButton instanceof IsmComboBoxButton) {
            IsmComboBoxButton button = (IsmComboBoxButton)this.arrowButton;
            Insets buttonInsets = button.getInsets();
            Insets insets = this.comboBox.getInsets();
            size = this.getDisplaySize();
            size.width += insets.left + insets.right;
            size.width += buttonInsets.left + buttonInsets.right;
            size.width += buttonInsets.right + button.getComboIcon().getIconWidth();
            size.height += insets.top + insets.bottom;
            size.height += buttonInsets.top + buttonInsets.bottom;
        } else if (this.comboBox.isEditable() && this.arrowButton != null && this.editor != null) {
            size = super.getMinimumSize(jComponent);
            Insets margin = this.arrowButton.getMargin();
            if (margin != null) {
                size.height += margin.top + margin.bottom;
                size.width += margin.left + margin.right;
            }
        } else {
            size = super.getMinimumSize(jComponent);
        }
        this.cachedMinimumSize.setSize(size.width, Math.min(size.height, 21));
        this.isMinimumSizeDirty = false;
        return new Dimension(this.cachedMinimumSize);
    }

    private boolean usingNewStyle() {
        return true;
    }

    private void layoutComboBox(Container parent, IsmComboBoxLayoutManager manager) {
        if (this.comboBox.isEditable() && !this.usingNewStyle()) {
            manager.superLayout(parent);
            return;
        }
        if (this.arrowButton != null) {
            if (this.usingNewStyle() && this.arrowButton instanceof IsmComboBoxButton) {
                Icon icon = ((IsmComboBoxButton)this.arrowButton).getComboIcon();
                Insets buttonInsets = this.arrowButton.getInsets();
                Insets insets = this.comboBox.getInsets();
                int buttonWidth = icon.getIconWidth() + buttonInsets.left + buttonInsets.right;
                this.arrowButton.setBounds(IsmPlafUtils.isLeftToRight(this.comboBox) ? this.comboBox.getWidth() - insets.right - buttonWidth : insets.left, insets.top, buttonWidth, this.comboBox.getHeight() - insets.top - insets.bottom);
            } else {
                Insets insets = this.comboBox.getInsets();
                int width = this.comboBox.getWidth();
                int height = this.comboBox.getHeight();
                this.arrowButton.setBounds(insets.left, insets.top, width - (insets.left + insets.right), height - (insets.top + insets.bottom));
            }
        }
        if (this.editor != null && this.usingNewStyle()) {
            Rectangle cvb = this.rectangleForCurrentValue();
            this.editor.setBounds(cvb);
        }
    }

    protected static class IsmComboBoxRenderer
    extends BasicComboBoxRenderer.UIResource {
        private static final long serialVersionUID = 1L;
        private static final Object BORDER_KEY = new StringBuilder("BORDER_KEY");
        private static final EmptyBorder NULL_BORDER = new EmptyBorder(0, 0, 0, 0);

        public IsmComboBoxRenderer() {
            this.setBorder(NULL_BORDER);
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (!(comp instanceof JComponent)) {
                return comp;
            }
            JComponent jComp = (JComponent)comp;
            if (index == -1 && isSelected) {
                Border border = jComp.getBorder();
                IsmBorders.DashedBorder dashedBorder = new IsmBorders.DashedBorder(list.getForeground());
                jComp.setBorder(dashedBorder);
                if (jComp.getClientProperty(BORDER_KEY) == null) {
                    jComp.putClientProperty(BORDER_KEY, border == null ? NULL_BORDER : border);
                }
            } else if (jComp.getBorder() instanceof IsmBorders.DashedBorder) {
                Object storedBorder = jComp.getClientProperty(BORDER_KEY);
                if (storedBorder instanceof Border) {
                    jComp.setBorder(storedBorder == NULL_BORDER ? null : (Border)storedBorder);
                }
                jComp.putClientProperty(BORDER_KEY, null);
            }
            if (index == -1) {
                jComp.setForeground(list.getForeground());
            }
            if (null != value) {
                jComp.setToolTipText(value.toString());
            }
            return comp;
        }
    }

    private static class IsmComboBoxEditor
    extends BasicComboBoxEditor
    implements UIResource {
        public IsmComboBoxEditor() {
            this.editor = new TextFieldComboBoxEditor();
            this.editor.setName("ISMV1R2_framework_IsmComboBoxUI_editor");
            if (this.editor.hasFocus()) {
                this.editor.selectAll();
            }
        }
    }

    private static class TextFieldComboBoxEditor
    extends JTextField {
        private static final long serialVersionUID = 1L;

        public TextFieldComboBoxEditor() {
            super("", 9);
        }

        @Override
        public void setText(String text) {
            if (this.getText().equals(text)) {
                return;
            }
            super.setText(text);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension pref = super.getPreferredSize();
            pref.height += 4;
            return pref;
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension min = super.getMinimumSize();
            min.height += 4;
            return min;
        }
    }

    public class IsmComboBoxLayoutManager
    extends BasicComboBoxUI.ComboBoxLayoutManager {
        public IsmComboBoxLayoutManager() {
            super(IsmComboBoxUI.this);
        }

        @Override
        public void layoutContainer(Container parent) {
            IsmComboBoxUI.this.layoutComboBox(parent, this);
        }

        public void superLayout(Container parent) {
            super.layoutContainer(parent);
        }
    }
}

