/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.plaf;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalTextFieldUI;

public class IsmTextFieldUI
extends MetalTextFieldUI {
    private boolean rollover = false;
    private boolean focus = false;
    private MixLisstenerImp mixedListener;

    public static ComponentUI createUI(JComponent c) {
        return new IsmTextFieldUI();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
    }

    protected boolean isFocus() {
        return this.focus;
    }

    protected boolean isRollover() {
        return this.rollover;
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.mixedListener = new MixLisstenerImp();
        this.getComponent().addMouseListener(this.mixedListener);
        this.getComponent().addFocusListener(this.mixedListener);
        this.getComponent().addKeyListener(this.mixedListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.getComponent().removeMouseListener(this.mixedListener);
        this.getComponent().removeFocusListener(this.mixedListener);
        this.getComponent().removeKeyListener(this.mixedListener);
    }

    private class MixLisstenerImp
    extends MouseAdapter
    implements FocusListener,
    KeyListener {
        private MixLisstenerImp() {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            IsmTextFieldUI.this.rollover = false;
            this.refresh();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            IsmTextFieldUI.this.rollover = true;
            this.refresh();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void focusGained(FocusEvent e) {
            IsmTextFieldUI.this.focus = true;
            this.refresh();
        }

        @Override
        public void focusLost(FocusEvent e) {
            IsmTextFieldUI.this.focus = false;
            this.refresh();
        }

        protected void refresh() {
            if (IsmTextFieldUI.this.getComponent().getParent() != null) {
                IsmTextFieldUI.this.getComponent().getParent().repaint();
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            this.refresh();
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.refresh();
        }

        @Override
        public void keyTyped(KeyEvent e) {
            this.refresh();
        }
    }
}

