/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.table;

import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.IsmVirtualTableCell;
import com.huawei.ism.ui.swing.table.VirtualTableModel;
import com.huawei.ism.ui.swing.table.VirtualTableScrollPane;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.RowFilter;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class IsmVirtualTable
extends IsmTable {
    private static final long serialVersionUID = 1441065115576860840L;
    private static final ComparableComparator VISTUAL_COMPARATOR = new ComparableComparator();
    private VirtualTableScrollPane virtualTableScrollPane;

    public IsmVirtualTable(VirtualTableModel model, boolean isSimpleTable) {
        super((TableModel)model, isSimpleTable);
        IsmVistualTableRowSorter sorter = new IsmVistualTableRowSorter(this.dataModel);
        this.setRowSorter(sorter);
    }

    public IsmVirtualTable(VirtualTableModel model) {
        super(model);
        IsmVistualTableRowSorter sorter = new IsmVistualTableRowSorter(this.dataModel);
        this.setRowSorter(sorter);
    }

    public VirtualTableScrollPane getVirtualTableScrollPane() {
        return this.virtualTableScrollPane;
    }

    public void setVirtualTableScrollPane(VirtualTableScrollPane virtualTableScrollPane) {
        this.virtualTableScrollPane = virtualTableScrollPane;
    }

    private static class ComparableComparator
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = -183458342748434454L;

        private ComparableComparator() {
        }

        public int compare(Object o1, Object o2) {
            Object temp1 = o1;
            Object temp2 = o2;
            if (o1 instanceof IsmVirtualTableCell) {
                temp1 = ((IsmVirtualTableCell)o1).getValue();
            }
            if (o2 instanceof IsmVirtualTableCell) {
                temp2 = ((IsmVirtualTableCell)o2).getValue();
            }
            return ((Comparable)temp1).compareTo(temp2);
        }
    }

    private final class IsmVistualTableRowSorter
    extends TableRowSorter<TableModel> {
        private IsmVistualTableRowSorter(TableModel model) {
            super(model);
        }

        @Override
        public void setRowFilter(RowFilter<? super TableModel, ? super Integer> filter) {
            super.setRowFilter(filter);
            IsmVirtualTable.this.fireFilterChanged();
        }

        @Override
        public void toggleSortOrder(int column) {
            int i;
            int[] selRows = IsmVirtualTable.this.getSelectedRows();
            for (int i2 = 0; i2 < selRows.length; ++i2) {
                selRows[i2] = IsmVirtualTable.this.convertRowIndexToModel(selRows[i2]);
            }
            IsmVirtualTable.this.clearSelection();
            super.toggleSortOrder(column);
            int startIndex = -1;
            int endIndex = -1;
            for (i = 0; i < selRows.length; ++i) {
                selRows[i] = IsmVirtualTable.this.convertRowIndexToView(selRows[i]);
            }
            Arrays.sort(selRows);
            for (i = 0; i < selRows.length; ++i) {
                int rowIndexToView = selRows[i];
                if (rowIndexToView < 0) continue;
                if (startIndex == -1) {
                    startIndex = rowIndexToView;
                    endIndex = rowIndexToView;
                    continue;
                }
                if (rowIndexToView - 1 == endIndex) {
                    endIndex = rowIndexToView;
                    continue;
                }
                IsmVirtualTable.this.addRowSelectionInterval(startIndex, endIndex);
                startIndex = rowIndexToView;
                endIndex = rowIndexToView;
            }
            if (startIndex != -1 && endIndex != -1) {
                IsmVirtualTable.this.addRowSelectionInterval(startIndex, endIndex);
            }
            IsmVirtualTable.this.getVirtualTableScrollPane().initDispalyRow(IsmVirtualTable.this);
        }

        @Override
        public Comparator<?> getComparator(int column) {
            return VISTUAL_COMPARATOR;
        }
    }
}

