/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.table;

import com.huawei.ism.ui.swing.table.IsmAbstractTableModel;
import com.huawei.ism.ui.swing.table.IsmVirtualTable;
import com.huawei.ism.ui.swing.table.IsmVirtualTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.table.VirtualTableRow;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VirtualTableModel
extends IsmAbstractTableModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(VirtualTableModel.class);
    public static final int EXTRA_ROW_NUM = 5;
    private static final long serialVersionUID = -7057504085278764412L;
    private CompsBean[] comps;
    private VirtualTableRowBean[] rowBeans;
    private int num = 0;

    public VirtualTableModel(String[] columnNames, int ... visibleColumnIds) {
        this(20, columnNames, visibleColumnIds);
    }

    public VirtualTableModel(int num, String[] columnNames, int ... visibleColumnIds) {
        super(columnNames, visibleColumnIds);
        this.num = num + 10;
        this.init();
    }

    public VirtualTableModel(String[] columnNames, int[] fiexedVisibleColumnIds, int ... visibleColumnIds) {
        this(20, columnNames, fiexedVisibleColumnIds, visibleColumnIds);
    }

    public VirtualTableModel(int num, String[] columnNames, int[] fiexedVisibleColumnIds, int ... visibleColumnIds) {
        super(columnNames, fiexedVisibleColumnIds, visibleColumnIds);
        this.num = num;
        this.init();
    }

    @Override
    public void removeAll() {
        if (this.getRowList().isEmpty()) {
            return;
        }
        this.getRowList().clear();
        this.fireTableDataChanged();
    }

    @Override
    public void removeRow(TableRow ... targetRows) {
        if (null == targetRows || targetRows.length == 0 || this.getRowList().isEmpty()) {
            return;
        }
        int firstRow = -1;
        int lastRow = -1;
        LinkedList<TableRow> validRows = new LinkedList<TableRow>();
        HashSet removeIdentifiers = new HashSet();
        for (TableRow targetRow : targetRows) {
            int currentRow = this.getRowList().indexOf(targetRow);
            if (-1 == currentRow) continue;
            if (firstRow < 0 || lastRow < 0) {
                lastRow = firstRow = currentRow;
            } else {
                firstRow = Math.min(firstRow, currentRow);
                lastRow = Math.max(lastRow, currentRow);
            }
            validRows.add(targetRow);
            removeIdentifiers.add(targetRow.getIdentifier());
        }
        if (firstRow >= 0 && lastRow >= 0) {
            this.fireTableRowsDeleted(firstRow, lastRow);
        }
        if (!validRows.isEmpty()) {
            this.getRowList().removeAll(validRows);
            this.fireTableDataChanged();
        }
    }

    @Override
    public void addRow(TableRow ... targetRows) {
        if (null == targetRows || targetRows.length == 0) {
            return;
        }
        int firstRow = this.getRowList().size();
        int removeItems = 0;
        ArrayList<TableRow> updateList = new ArrayList<TableRow>();
        for (TableRow targetRow : targetRows) {
            if (this.getRowList().contains(targetRow)) {
                this.getRowList().remove(targetRow);
                ++removeItems;
                LOGGER.error("Override the reduplicate the TableRow: " + targetRow.getIdentifier());
            }
            this.getRowList().add(targetRow);
            updateList.add(targetRow);
        }
        if (targetRows.length == removeItems && targetRows.length > 0) {
            super.updateRow(updateList);
            return;
        }
        int endRow = firstRow + targetRows.length - removeItems - 1;
        if (firstRow <= endRow) {
            this.fireTableRowsInserted(firstRow, endRow);
        }
    }

    public void addRows(List<TableRow> rows) {
        for (TableRow row : rows) {
            this.addRow(row);
        }
    }

    public void init() {
        this.comps = new CompsBean[this.num];
        this.rowBeans = new VirtualTableRowBean[this.num];
        for (int i = 0; i < this.num; ++i) {
            CompsBean bean = new CompsBean();
            bean.setCells(this.getCompoents());
            this.comps[i] = bean;
        }
    }

    public abstract IsmVirtualTableCell[] getCompoents();

    public void readyForDisplay(int index, IsmVirtualTable table) {
        int rowCount = table.getRowCount();
        int remainRowCount = rowCount - index;
        int needInitRowCount = remainRowCount > this.num ? this.num : remainRowCount;
        VirtualTableRow[] newRows = new VirtualTableRow[needInitRowCount];
        int iterIndex = index;
        for (int i = 0; i < needInitRowCount; ++i) {
            VirtualTableRow row;
            int temp = table.convertRowIndexToModel(iterIndex++);
            newRows[i] = row = (VirtualTableRow)this.getRow(temp);
        }
        this.removeComps(newRows);
        this.addComps(newRows);
    }

    private void removeComps(VirtualTableRow[] newRows) {
        if (newRows == null || newRows.length == 0) {
            return;
        }
        for (VirtualTableRowBean rowBean : this.rowBeans) {
            if (rowBean == null || this.isInRows(rowBean.getRow(), newRows)) continue;
            this.removeCompsBean(rowBean);
        }
    }

    private void addComps(VirtualTableRow[] newRows) {
        if (newRows == null || newRows.length == 0) {
            return;
        }
        for (VirtualTableRow row : newRows) {
            if (this.isInRows(row)) continue;
            this.addRowBean(row);
        }
    }

    private boolean isInRows(VirtualTableRow row) {
        if (row == null) {
            return true;
        }
        for (VirtualTableRowBean temp : this.rowBeans) {
            if (temp == null || row != temp.getRow()) continue;
            return true;
        }
        return false;
    }

    private boolean isInRows(VirtualTableRow row, VirtualTableRow[] rows) {
        if (row == null) {
            return true;
        }
        for (VirtualTableRow temp : rows) {
            if (row != temp) continue;
            return true;
        }
        return false;
    }

    private void removeCompsBean(VirtualTableRowBean rowBean) {
        for (int i = 0; i < this.num; ++i) {
            if (this.rowBeans[i] != rowBean) continue;
            rowBean.getRow().removeComps();
            this.comps[rowBean.getUserCompsIndex()].setUse(false);
            rowBean.setRow(null);
            return;
        }
    }

    private void addRowBean(VirtualTableRow row) {
        for (int i = 0; i < this.num; ++i) {
            if (this.rowBeans[i] == null) {
                this.rowBeans[i] = new VirtualTableRowBean();
            }
            if (this.rowBeans[i].getRow() != null) continue;
            this.rowBeans[i].setRow(row);
            this.getNextCompsForRow(this.rowBeans[i]);
            return;
        }
    }

    private void getNextCompsForRow(VirtualTableRowBean rowBean) {
        int length = this.comps.length;
        for (int i = 0; i < length; ++i) {
            if (this.comps[i].isUse()) continue;
            IsmVirtualTableCell[] cells = this.comps[i].getCells();
            if (null == cells) {
                throw new NullPointerException();
            }
            rowBean.getRow().setCompoments(cells);
            rowBean.setUserCompsIndex(i);
            this.comps[i].setUse(true);
            return;
        }
    }

    private static class CompsBean {
        private IsmVirtualTableCell[] cells;
        private boolean use = false;

        private CompsBean() {
        }

        public IsmVirtualTableCell[] getCells() {
            return null == this.cells ? null : (IsmVirtualTableCell[])this.cells.clone();
        }

        public void setCells(IsmVirtualTableCell[] cells) {
            this.cells = cells;
        }

        public boolean isUse() {
            return this.use;
        }

        public void setUse(boolean use) {
            this.use = use;
        }
    }

    private static class VirtualTableRowBean {
        private VirtualTableRow row = null;
        private int userCompsIndex = -1;

        private VirtualTableRowBean() {
        }

        public VirtualTableRow getRow() {
            return this.row;
        }

        public void setRow(VirtualTableRow row) {
            this.row = row;
        }

        public int getUserCompsIndex() {
            return this.userCompsIndex;
        }

        public void setUserCompsIndex(int userCompsIndex) {
            this.userCompsIndex = userCompsIndex;
        }
    }
}

