/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.text;

import com.huawei.ism.tool.base.utils.VerifyUtil;
import com.huawei.ism.ui.swing.plaf.IsmBorders;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.ui.swing.plaf.unify.UnifyBorders;
import com.huawei.ism.ui.swing.text.RegexDocument;
import com.huawei.ism.ui.widgets.PopupInform;
import com.huawei.ism.util.UCD;
import com.huawei.ism.util.Utils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPAddressField
extends JPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(IPAddressField.class);
    private static final long serialVersionUID = 9045162062071601152L;
    private static final int IP_PANEL_WIDTH = 170;
    private static final int IP_PANEL_HIGH = 20;
    private static final int DEFAULT_FIRST_BOTTOM = 1;
    private static final int DEFAULT_FIRST_TOP = 223;
    private static final int DEFAULT_BOTTOM = 0;
    private static final int DEFAULT_TOP = 255;
    private static final String DOT = ".";
    private static final int UNIT_FIELD_NUMBER = 4;
    private static final int DEFAULT_INPUT_CHAR_NUM = 3;
    private static final String NUMBER_REGREX = "[0-9]*";
    private static final String MASK_A = "255.0.0.0";
    private static final String MASK_B = "255.255.0.0";
    private static final String MASK_C = "255.255.255.0";
    private boolean isError;
    private String errorToolTip = "";
    private transient PopupInform popupInform;
    private transient Popup popup;
    private List<JTextField> unitTextFieldList = new ArrayList<JTextField>(0);
    private boolean forward = true;
    private boolean backward = true;
    private boolean backSpaceBackward = true;
    private UnitTextFieldHandle unitTextFieldHandle;
    private int firstUnitMinInt;
    private int firstUnitMaxInt;
    private Timer insideTimer;

    public IPAddressField() {
        this(1, 223);
    }

    public PopupInform getPopupInform() {
        return this.popupInform;
    }

    public void setPopupInform(PopupInform popupInform) {
        this.popupInform = popupInform;
    }

    public IPAddressField(int firstUnitMin, int firstUnitMax) {
        this.firstUnitMinInt = firstUnitMin;
        this.firstUnitMaxInt = firstUnitMax;
        this.unitTextFieldHandle = new UnitTextFieldHandle();
        this.initLayout();
    }

    private void initLayout() {
        this.setBackground(Color.WHITE);
        this.setLayout(new BoxLayout(this, 0));
        this.addUnit(this.newUnitTextField(this.firstUnitMinInt, this.firstUnitMaxInt));
        this.addUnit(this.newDotPanel());
        this.addUnit(this.newUnitTextField(0, 255));
        this.addUnit(this.newDotPanel());
        this.addUnit(this.newUnitTextField(0, 255));
        this.addUnit(this.newDotPanel());
        this.addUnit(this.newUnitTextField(0, 255));
        this.setPreferredSize(new Dimension(170, 20));
        this.setMaximumSize(new Dimension(170, 20));
        if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.unify) {
            this.setBorder(UnifyBorders.getTextAreaBorder());
            this.addListener();
        } else {
            this.setBorder(IsmBorders.getTextFieldBorder());
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (!IsmPlafUtils.isUnifyStyle()) {
            return;
        }
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.setColor(UIManager.getColor("TextField.backgroundTopHighlighter"));
        graphics.drawLine(1, 1, this.getWidth() - 2, 1);
        int gradientHeight = UIManager.getInt("TextField.backgroundGradientHeight");
        String gradientKey = "TextField.backgroundNormalGradient";
        if (!this.isEnabled()) {
            gradientKey = "TextField.backgroundDisabledGradient";
        }
        IsmPlafUtils.drawGradient((Component)this, graphics, gradientKey, new Rectangle(1, 2, this.getWidth() - 2, gradientHeight), true);
    }

    private void addListener() {
        FocusListener focusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                IPAddressField.this.setBorder(UnifyBorders.getIPAddressFieldBorder(UIManager.getColor("TextField.rdFocusOuterColor")));
            }

            @Override
            public void focusLost(FocusEvent e) {
                IPAddressField.this.setBorder(UnifyBorders.getIPAddressFieldBorder(UIManager.getColor("TextField.disabledBorderColor")));
            }
        };
        for (JTextField textField : this.unitTextFieldList) {
            textField.addFocusListener(focusListener);
        }
        this.addMouseListener();
        this.addDocumentListener();
        this.insideTimer = new Timer(1000, new StillInsideTimerAction());
        this.insideTimer.setRepeats(false);
        this.insideTimer.setInitialDelay(ToolTipManager.sharedInstance().getDismissDelay());
    }

    public void updateInformTask() {
        if (!this.isEnabled()) {
            return;
        }
        if (this.isError) {
            this.showErrorTip();
            return;
        }
    }

    private void showErrorTip() {
        JToolTip tip = new JToolTip();
        tip.setForeground(Color.WHITE);
        tip.setBackground(UIManager.getColor("TextComponent.errTooltipBorderColor"));
        tip.setName("ISMV1R2_framework_IsmPopupInformManager_tip");
        UCD.setTipText(tip, this.errorToolTip);
        PopupFactory popupFactory = PopupFactory.getSharedInstance();
        this.popup = popupFactory.getPopup(this, tip, (int)this.getLocationOnScreen().getX() + 10, this.getHeight() + (int)this.getLocationOnScreen().getY() + 4);
        this.popup.show();
        this.insideTimer.start();
    }

    public void hideInform() {
        if (this.popup == null) {
            return;
        }
        if (this.isError) {
            this.popup.hide();
        }
        this.insideTimer.stop();
        this.popup = null;
    }

    private void addMouseListener() {
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                IPAddressField.this.updateInformTask();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                IPAddressField.this.hideInform();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                IPAddressField.this.hideInform();
            }
        };
        this.addMouseListener(mouseListener);
        for (JTextField unitTextField : this.unitTextFieldList) {
            unitTextField.addMouseListener(mouseListener);
        }
    }

    private void addDocumentListener() {
        DocumentListener documentListener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                IPAddressField.this.hideInform();
                IPAddressField.this.isError = false;
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                IPAddressField.this.hideInform();
                IPAddressField.this.isError = false;
            }
        };
        for (JTextField unitTextField : this.unitTextFieldList) {
            unitTextField.getDocument().addDocumentListener(documentListener);
        }
    }

    public boolean isShowErrorToolTip() {
        return this.isError;
    }

    public String getErrorToolTip() {
        return this.errorToolTip;
    }

    public void setErrorToolTip(String errorToolTip) {
        this.errorToolTip = errorToolTip;
        this.setError(true);
        this.repaint();
    }

    public void setError(boolean isErrorTemp) {
        this.isError = isErrorTemp;
        if (isErrorTemp && this.popupInform != null) {
            this.popupInform.setErrorTooltip(this.errorToolTip, isErrorTemp);
        }
        this.repaint();
    }

    public String getIPText() {
        StringBuffer sb = new StringBuffer();
        String st = null;
        int i = 0;
        for (JTextField unitTextField : this.unitTextFieldList) {
            st = unitTextField.getText();
            if (!"".equals(st)) {
                i = Integer.valueOf(st);
                sb.append(i).append(DOT.trim());
                continue;
            }
            sb.append(" ").append(DOT.trim());
        }
        return sb.substring(0, sb.length() - 1);
    }

    public String getMaskText() {
        if (Utils.isNullStr(this.unitTextFieldList.get(0).getText())) {
            return null;
        }
        int iptype = Integer.valueOf(this.unitTextFieldList.get(0).getText());
        if (iptype >= 0 && iptype <= 127) {
            return MASK_A;
        }
        if (iptype >= 128 && iptype <= 191) {
            return MASK_B;
        }
        if (iptype >= 192 && iptype <= 223) {
            return MASK_C;
        }
        return MASK_A;
    }

    public void setIPText(String ip) {
        String tem = ip;
        if (null == ip || "".equals(ip)) {
            tem = " . . . ";
        }
        String[] ipUnits = tem.split("\\" + DOT.trim());
        for (int i = 0; i < this.unitTextFieldList.size(); ++i) {
            if (null != ipUnits[i]) {
                this.unitTextFieldList.get(i).setText(ipUnits[i]);
                continue;
            }
            this.unitTextFieldList.get(i).setText("");
        }
    }

    public Optional<JTextField> getUnitTextField(int index) {
        JTextField result = null;
        if (index >= 0 && index < 4) {
            result = this.unitTextFieldList.get(index);
        }
        return Optional.ofNullable(result);
    }

    @Override
    public void setEnabled(boolean enable) {
        Component[] comps;
        if (enable) {
            this.setBackground(Color.WHITE);
        } else {
            this.setBackground(UIManager.getColor("TextField.disabledBackground"));
        }
        for (Component comp : comps = this.getComponents()) {
            comp.setEnabled(enable);
        }
        super.setEnabled(enable);
    }

    public boolean isIPValid() {
        for (int i = 0; i < 4; ++i) {
            if (!"".equals(this.getUnitTextField(i).get().getText())) continue;
            return false;
        }
        return true;
    }

    public boolean isLoopbackIP() {
        return this.getUnitTextField(0).get().getText().equals("127");
    }

    private void setIpFocusForwardLeft(Document document, JTextField s, int keyCode) {
        String content = "";
        try {
            content = document.getText(0, document.getLength());
        }
        catch (BadLocationException e1) {
            LOGGER.error("", (Throwable)e1);
        }
        Integer contentInt = null;
        try {
            contentInt = Integer.parseInt(content);
        }
        catch (NumberFormatException ex) {
            LOGGER.error("number exception, set contentInt to null.");
            contentInt = null;
        }
        if (content.equals("") || null == contentInt) {
            return;
        }
        int k = 0;
        String selectedTxt = null;
        for (int i = 0; i < this.unitTextFieldList.size(); ++i) {
            if (s != this.unitTextFieldList.get(i)) continue;
            selectedTxt = this.unitTextFieldList.get(i).getSelectedText();
            if (null != selectedTxt && selectedTxt.trim().length() != 0) break;
            if (i < this.unitTextFieldList.size() - 1 && keyCode != 16) {
                k = i + 1;
                this.unitTextFieldList.get(k).requestFocus();
                this.unitTextFieldList.get(k).select(0, 3);
                break;
            }
            k = i;
            this.unitTextFieldList.get(k).setCaretPosition(this.unitTextFieldList.get(k).getText().length());
            break;
        }
    }

    private void setIpFocusForwardRight(JTextField jTextField) {
        if ("".equals(jTextField.getText()) && jTextField != this.unitTextFieldList.get(this.unitTextFieldList.size() - 1)) {
            jTextField.transferFocus();
        } else {
            int k = 0;
            String selectedTxt = null;
            for (int i = 0; i < this.unitTextFieldList.size(); ++i) {
                if (jTextField != this.unitTextFieldList.get(i)) continue;
                if (i < this.unitTextFieldList.size() - 1) {
                    selectedTxt = this.unitTextFieldList.get(i).getSelectedText();
                    if (null != selectedTxt && selectedTxt.trim().length() != 0) break;
                    boolean bl = this.forward = !this.forward;
                    if (!this.forward) continue;
                    k = i + 1;
                    this.unitTextFieldList.get(k).requestFocus();
                    this.unitTextFieldList.get(k).setCaretPosition(0);
                    this.backward = false;
                    break;
                }
                this.backward = true;
            }
        }
    }

    private void setIpFocusBackwardLeft(JTextField jTextField) {
        if ("".equals(jTextField.getText()) && jTextField != this.unitTextFieldList.get(0)) {
            jTextField.transferFocusBackward();
        } else {
            int k = 0;
            String selectedTxt = null;
            for (int i = 0; i < this.unitTextFieldList.size(); ++i) {
                if (jTextField != this.unitTextFieldList.get(i)) continue;
                if (0 != i) {
                    selectedTxt = this.unitTextFieldList.get(i).getSelectedText();
                    if (null != selectedTxt && selectedTxt.trim().length() != 0) break;
                    boolean bl = this.backward = !this.backward;
                    if (!this.backward) continue;
                    k = i - 1;
                    this.unitTextFieldList.get(k).requestFocus();
                    this.unitTextFieldList.get(k).setCaretPosition(this.unitTextFieldList.get(k).getText().length());
                    this.forward = false;
                    break;
                }
                this.forward = true;
            }
        }
    }

    private void setIpFocusBackwardRight(JTextField s) {
        int k = 0;
        for (int i = 0; i < this.unitTextFieldList.size(); ++i) {
            if (s != this.unitTextFieldList.get(i) || 0 == i) continue;
            boolean bl = this.backSpaceBackward = !this.backSpaceBackward;
            if (!this.backSpaceBackward) continue;
            k = i - 1;
            this.unitTextFieldList.get(k).requestFocus();
            this.unitTextFieldList.get(k).setCaretPosition(this.unitTextFieldList.get(k).getText().length());
            break;
        }
    }

    public void addKeyListeners(KeyListener keyListener) {
        for (int i = 0; i < 4; ++i) {
            this.unitTextFieldList.get(i).addKeyListener(keyListener);
        }
    }

    private void addUnit(JComponent comp) {
        if (null == comp) {
            return;
        }
        this.add(comp);
        if (comp instanceof JTextField) {
            this.unitTextFieldList.add((JTextField)comp);
            comp.addKeyListener(this.unitTextFieldHandle);
        }
    }

    private JLabel newDotPanel() {
        return new MyCustJLablel(" ");
    }

    private JTextField newUnitTextField(int bottom, int top) {
        RegexDocument ipDRegexDocument = RegexDocument.createNumberDocument(NUMBER_REGREX, bottom, top, 3);
        JTextField ipUnitTextField = new JTextField(ipDRegexDocument, "", 3);
        ipUnitTextField.putClientProperty("IPAdressField", Boolean.TRUE);
        ipUnitTextField.setHorizontalAlignment(0);
        ipUnitTextField.setBorder(BorderFactory.createEmptyBorder());
        ipUnitTextField.setOpaque(false);
        ipUnitTextField.setInputVerifier(new MyInputFilterr(top, bottom));
        return ipUnitTextField;
    }

    protected class StillInsideTimerAction
    implements ActionListener {
        protected StillInsideTimerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            IPAddressField.this.hideInform();
        }
    }

    private class UnitTextFieldHandle
    extends KeyAdapter
    implements Serializable {
        private static final long serialVersionUID = -3443158205324924938L;

        private UnitTextFieldHandle() {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            char inputKey = keyEvent.getKeyChar();
            JTextField source = (JTextField)keyEvent.getSource();
            int keyCode = keyEvent.getKeyCode();
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Component component = keyboardFocusManager.getFocusOwner();
            JTextField ipUnitTextField = (JTextField)component;
            if (VerifyUtil.isEmpty(ipUnitTextField)) {
                LOGGER.warn("Null textField, focus jump failed.");
                return;
            }
            Document document = ipUnitTextField.getDocument();
            if ('.' == inputKey || 3 == document.getLength() && 37 != keyCode && 39 != keyCode) {
                IPAddressField.this.setIpFocusForwardLeft(document, source, keyCode);
            }
            if (39 == keyCode) {
                IPAddressField.this.setIpFocusForwardRight(source);
            }
            if (37 == keyCode) {
                IPAddressField.this.setIpFocusBackwardLeft(source);
            }
            if (0 == ipUnitTextField.getCaretPosition() && 8 == keyCode) {
                IPAddressField.this.setIpFocusBackwardRight(source);
            }
        }
    }

    private static final class MyCustJLablel
    extends JLabel {
        private static final long serialVersionUID = 9045162062071601152L;

        private MyCustJLablel(String text) {
            super(text);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Color color = this.getForeground();
            if (!this.isEnabled()) {
                color = Color.GRAY;
            }
            graphics.setColor(color);
            graphics.fillOval(0, this.getHeight() - 6, 2, 2);
        }
    }

    private static final class MyInputFilterr
    extends InputVerifier {
        private final int top;
        private final int bottom;

        private MyInputFilterr(int top, int bottom) {
            this.top = top;
            this.bottom = bottom;
        }

        @Override
        public boolean verify(JComponent input) {
            if (input instanceof JTextField) {
                JTextField ipField = (JTextField)input;
                String data = ipField.getText();
                if ("".equals(data)) {
                    return true;
                }
                int iData = Integer.parseInt(data);
                if (iData > this.top) {
                    ipField.setText(String.valueOf(this.top));
                } else if (iData < this.bottom) {
                    ipField.setText(String.valueOf(this.bottom));
                }
            }
            return true;
        }
    }
}

