/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.widgets;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.tool.framework.pubservice.exception.EncapsulatedRuntimeException;
import com.huawei.ism.ui.swing.text.IsmPasswordField;
import com.huawei.ism.ui.swing.text.IsmTextArea;
import com.huawei.ism.ui.swing.text.IsmTextField;
import com.huawei.ism.util.UCD;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.JViewport;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopupInform {
    private static final Logger LOGGER = LoggerFactory.getLogger(PopupInform.class);
    private Map<InformType, JToolTip> informTipMap;
    private Map<InformType, Integer> informPriorityMap;
    private Map<InformType, Object> informRestrictMap;
    private Popup popup;
    private boolean isShowing;
    private boolean isErrering = false;
    private String errorToolTip = null;
    private JTextComponent textComponent;
    private boolean isSpecial;
    private Timer insideTimer;

    public PopupInform(JTextComponent textComponent) {
        this(textComponent, false);
    }

    public PopupInform(JTextComponent textComponent, boolean isSpecial) {
        this.addTips2TextArea(textComponent);
        this.createInformRestrictMap();
        this.textComponent = textComponent;
        this.addListener(textComponent);
        this.initTimmer();
        this.isSpecial = isSpecial;
    }

    private void addListener(JTextComponent textComp) {
        textComp.getDocument().addDocumentListener(new DocumentListenerImp());
        textComp.addMouseListener(new MouseListenerImp());
    }

    private void initTimmer() {
        this.insideTimer = new Timer(1000, new StillInsideTimerAction());
        this.insideTimer.setRepeats(false);
        this.insideTimer.setInitialDelay(ToolTipManager.sharedInstance().getDismissDelay());
    }

    private void addTips2TextArea(JTextComponent textComp) {
        if (textComp instanceof IsmTextArea) {
            IsmTextArea ismTArea = (IsmTextArea)textComp;
            ismTArea.setPopupInform(this);
        }
    }

    private void createInformRestrictMap() {
        this.informTipMap = new HashMap<InformType, JToolTip>(0);
        this.informPriorityMap = new HashMap<InformType, Integer>(0);
        this.informPriorityMap.put(InformType.NONE, Integer.MAX_VALUE);
        this.informRestrictMap = new HashMap<InformType, Object>(0);
        this.informRestrictMap.put(null, "");
    }

    public void addInform(InformType informType, String tipText, int priority, Object restrict) {
        if (informType == InformType.NONE) {
            return;
        }
        if (!informType.isMatch(restrict)) {
            String exDesc = "InformType \"" + (Object)((Object)informType) + "\" MissMatch with " + restrict.getClass().getName();
            throw new EncapsulatedRuntimeException(exDesc);
        }
        this.removeInform(informType);
        if (informType == InformType.MIN_VALID_LENGTH || informType == InformType.MAX_VALID_LENGTH) {
            this.addInformDegrade(informType, restrict);
        } else {
            this.informRestrictMap.put(informType, restrict);
        }
        JToolTip tip = new JToolTip();
        tip.setName("ISMV1R2_framework_IsmPopupInformManager_tip");
        UCD.setTipText(tip, tipText);
        this.informTipMap.put(informType, tip);
        this.informPriorityMap.put(informType, priority);
    }

    public void addCapsLockInform() {
        this.addInform(InformType.CAPSLOCK_ON, ResourceManager.getString("CAPS_LOCK_INFOM"), 0, null);
    }

    private void addInformDegrade(InformType informType, Object restrict) {
        if (informType == InformType.MIN_VALID_LENGTH) {
            int minValidLen = (Integer)restrict;
            int n = minValidLen = minValidLen < 0 ? 0 : minValidLen;
            if (this.isContain(InformType.MAX_VALID_LENGTH)) {
                int maxValidLen = (Integer)this.informRestrictMap.get((Object)InformType.MAX_VALID_LENGTH);
                if (minValidLen >= maxValidLen) {
                    throw new EncapsulatedRuntimeException("Malformed Valid Restrict.");
                }
                this.informRestrictMap.put(informType, minValidLen);
            } else {
                this.informRestrictMap.put(informType, minValidLen);
            }
        } else if (informType == InformType.MAX_VALID_LENGTH) {
            int maxValidLen = (Integer)restrict;
            int n = maxValidLen = maxValidLen <= 0 ? Integer.MAX_VALUE : maxValidLen;
            if (this.isContain(InformType.MIN_VALID_LENGTH)) {
                int minValidLen = (Integer)this.informRestrictMap.get((Object)InformType.MIN_VALID_LENGTH);
                if (minValidLen >= maxValidLen) {
                    throw new EncapsulatedRuntimeException("Malformed Valid Restrict.");
                }
                this.informRestrictMap.put(informType, maxValidLen);
            } else {
                this.informRestrictMap.put(informType, maxValidLen);
            }
        }
    }

    public void removeInform(InformType informType) {
        if (informType == InformType.NONE) {
            return;
        }
        this.informPriorityMap.remove((Object)informType);
        this.informTipMap.remove((Object)informType);
        this.informRestrictMap.remove((Object)informType);
    }

    public void removeAllInform() {
        for (InformType informType : InformType.values()) {
            this.removeInform(informType);
        }
    }

    public boolean isContain(InformType informType) {
        return this.informTipMap.containsKey((Object)informType);
    }

    public Set<InformType> getInformSet() {
        return this.informTipMap.keySet();
    }

    public void updateInformTask() {
        if (!this.textComponent.isEnabled()) {
            return;
        }
        if (this.isErrering && null != this.errorToolTip) {
            this.showErrorTip(this.errorToolTip);
            return;
        }
        LinkedList<InformTask> taskList = new LinkedList<InformTask>();
        Object restrict = null;
        for (InformType informType : this.getInformSet()) {
            if (informType == InformType.NONE) continue;
            restrict = this.informRestrictMap.get((Object)informType);
            this.updateInformTaskDegrade(restrict, informType, taskList);
        }
        if (!taskList.isEmpty()) {
            Collections.sort(taskList);
            InformType validInformType = ((InformTask)taskList.get(0)).informType();
            this.showInform(validInformType);
        } else {
            this.hideInform();
        }
    }

    private void updateInformTaskDegrade(Object restrict, InformType informType, List<InformTask> taskList) {
        int textLength = this.textComponent.getText().length();
        switch (informType) {
            case MIN_VALID_LENGTH: {
                int minValidLen = (Integer)restrict;
                if (textLength < 0 || textLength >= minValidLen) break;
                taskList.add(new InformTask(InformType.MIN_VALID_LENGTH));
                break;
            }
            case MAX_VALID_LENGTH: {
                int maxValidLen = (Integer)restrict;
                if (textLength <= 0 || textLength <= maxValidLen) break;
                taskList.add(new InformTask(InformType.MAX_VALID_LENGTH));
                break;
            }
            case CAPSLOCK_ON: {
                boolean isCapsLockOn = false;
                try {
                    isCapsLockOn = Toolkit.getDefaultToolkit().getLockingKeyState(20);
                }
                catch (UnsupportedOperationException e) {
                    LOGGER.error("", (Throwable)e);
                }
                if (!isCapsLockOn) break;
                taskList.add(new InformTask(InformType.CAPSLOCK_ON));
                break;
            }
            case INVALID_INPUT: {
                String regex = (String)restrict;
                if (!this.textComponent.getText().matches(regex)) break;
                taskList.add(new InformTask(InformType.INVALID_INPUT));
                break;
            }
            case USER_DEFINE: {
                taskList.add(new InformTask(InformType.USER_DEFINE));
                break;
            }
        }
    }

    private void showInform(InformType informType) {
        if (!this.textComponent.isShowing()) {
            return;
        }
        this.hideInform();
        JToolTip tip = this.informTipMap.get((Object)informType);
        if (tip == null) {
            return;
        }
        if (this.textComponent instanceof IsmTextField) {
            IsmTextField ismTextField = (IsmTextField)this.textComponent;
            String tooltiptext = ismTextField.getPoupInfo();
            if (null == tooltiptext || tooltiptext.length() == 0) {
                tip.setTipText(null);
                return;
            }
            tip.setTipText(tooltiptext);
        }
        if (tip.getTipText().trim().length() == 0 || "<html></html>".equals(tip.getTipText().trim())) {
            return;
        }
        Point point = this.isSpecial ? this.computeInformLocationSpecial() : this.computeInformLocation(tip);
        PopupFactory popupFactory = PopupFactory.getSharedInstance();
        this.popup = popupFactory.getPopup(this.textComponent, tip, (int)point.getX(), (int)point.getY());
        this.popup.show();
        this.insideTimer.start();
        this.isShowing = true;
        this.isErrering = false;
    }

    private void showErrorTip(String errorStr) {
        this.hideInform();
        JToolTip tip = new JToolTip();
        tip.setForeground(Color.WHITE);
        tip.setBackground(UIManager.getColor("TextComponent.errTooltipBorderColor"));
        tip.setName("ISMV1R2_framework_IsmPopupInformManager_tip");
        this.errorToolTip = errorStr;
        UCD.setTipText(tip, errorStr);
        Point location = this.isSpecial ? this.computeInformLocationSpecial() : this.computeInformLocation(tip);
        PopupFactory popupFactory = PopupFactory.getSharedInstance();
        this.popup = popupFactory.getPopup(this.textComponent, tip, (int)location.getX(), (int)location.getY());
        this.popup.show();
        this.insideTimer.start();
        this.isShowing = true;
        this.isErrering = true;
    }

    public void setErrorTooltip(String errorStr, boolean error) {
        this.errorToolTip = errorStr;
        this.isErrering = error;
        if (this.isShowing) {
            return;
        }
        this.isShowing = false;
    }

    public void hideInform() {
        if (this.popup == null) {
            return;
        }
        if (this.isShowing) {
            this.popup.hide();
        }
        this.insideTimer.stop();
        this.popup = null;
        this.isShowing = false;
    }

    private Point computeInformLocation(JToolTip tip) {
        boolean leftToRight = this.textComponent.getComponentOrientation().isLeftToRight();
        Rectangle screenBounds = this.textComponent.getGraphicsConfiguration().getBounds();
        Point screenLocation = this.textComponent.getLocationOnScreen();
        if (this.textComponent.getParent() instanceof JViewport) {
            screenLocation = this.textComponent.getParent().getLocationOnScreen();
        }
        Point location = new Point();
        Dimension size = tip.getPreferredSize();
        location.setLocation((int)screenLocation.getX() + 10, (int)screenLocation.getY() + 24);
        int tmpX = (int)location.getX();
        int tmpY = (int)location.getY();
        if (!leftToRight) {
            tmpX -= size.width;
        }
        if (tmpX < (int)screenBounds.getX()) {
            tmpX = (int)screenBounds.getX();
        } else if (tmpX - (int)screenBounds.getX() + size.width > screenBounds.width) {
            tmpX = (int)screenBounds.getX() + Math.max(0, screenBounds.width - size.width);
        }
        if (tmpY < (int)screenBounds.getY()) {
            tmpY = (int)screenBounds.getY();
        } else if ((int)location.getY() - (int)screenBounds.getY() + size.height > screenBounds.height) {
            tmpY = (int)screenBounds.getY() + Math.max(0, screenBounds.height - size.height);
        }
        location.setLocation(tmpX, tmpY);
        return location;
    }

    private Point computeInformLocationSpecial() {
        Point screenLocation = this.textComponent.getLocationOnScreen();
        if (this.textComponent.getParent() instanceof JViewport) {
            screenLocation = this.textComponent.getParent().getLocationOnScreen();
        }
        Point location = new Point();
        location.setLocation((int)screenLocation.getX() + 10, (int)screenLocation.getY() + this.textComponent.getHeight() + 4);
        return location;
    }

    private void inputContentChange() {
        JTextField ismTextField;
        this.hideInform();
        if (this.textComponent instanceof IsmTextField) {
            ismTextField = (IsmTextField)this.textComponent;
            this.isErrering = false;
            ((IsmTextField)ismTextField).setError(false);
        }
        if (this.textComponent instanceof IsmPasswordField) {
            ismTextField = (IsmPasswordField)this.textComponent;
            this.isErrering = false;
            ((IsmPasswordField)ismTextField).setError(false);
        }
        if (this.textComponent instanceof IsmTextArea) {
            IsmTextArea ismTextArea = (IsmTextArea)this.textComponent;
            this.isErrering = false;
            ismTextArea.setError(false);
        }
    }

    protected class StillInsideTimerAction
    implements ActionListener {
        protected StillInsideTimerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PopupInform.this.hideInform();
        }
    }

    private class MouseListenerImp
    implements MouseListener {
        private MouseListenerImp() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            PopupInform.this.hideInform();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            PopupInform.this.updateInformTask();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            PopupInform.this.hideInform();
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }

    private class DocumentListenerImp
    implements DocumentListener {
        private DocumentListenerImp() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            PopupInform.this.inputContentChange();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            PopupInform.this.inputContentChange();
        }
    }

    private class InformTask
    implements Comparable<InformTask> {
        private InformType informTypeLocal;

        private InformType getInformType() {
            return this.informTypeLocal;
        }

        public InformTask(InformType informType) {
            this.informTypeLocal = informType;
        }

        @Override
        public int compareTo(InformTask informTypeTemp) {
            Integer currentPriority = (Integer)PopupInform.this.informPriorityMap.get((Object)this.informTypeLocal);
            return currentPriority.compareTo((Integer)PopupInform.this.informPriorityMap.get((Object)informTypeTemp.informType()));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof InformTask)) {
                return false;
            }
            return this.compareTo((InformTask)obj) == 0;
        }

        public int hashCode() {
            return (Integer)PopupInform.this.informPriorityMap.get((Object)this.informTypeLocal);
        }

        public InformType informType() {
            return this.getInformType();
        }
    }

    public static enum InformType {
        MIN_VALID_LENGTH(Integer.class),
        MAX_VALID_LENGTH(Integer.class),
        INVALID_INPUT(String.class),
        CAPSLOCK_ON(Object.class),
        NONE(Object.class),
        USER_DEFINE(Object.class);

        private Class<?> restrictClazz;

        private InformType(Class<?> restrictClazz) {
            if (restrictClazz == null) {
                throw new NullPointerException("RestrictClazz is null.");
            }
            this.restrictClazz = restrictClazz;
        }

        boolean isMatch(Object restrict) {
            if (restrict == null && this.restrictClazz == Object.class) {
                return true;
            }
            return this.restrictClazz.isInstance(restrict);
        }
    }
}

