/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui2.mainframe.device;

import com.huawei.ism.common.resourcemanager.CustomResourceManager;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;

final class PopupAdapter
extends MouseAdapter
implements KeyListener {
    private static final int MAX_ROW = 5;
    private JPopupMenu popmenu;
    private JTextField component = null;
    private List<JMenuItem> items = new ArrayList<JMenuItem>(10);

    public PopupAdapter(JTextField component, String resKey) {
        this.component = component;
        this.component.setFocusable(true);
        this.component.setFocusTraversalKeysEnabled(false);
        this.component.addKeyListener(this);
        this.component.addMouseListener(this);
        this.popmenu = new JPopupMenu();
        this.resetMenuItem(resKey);
    }

    public void resetMenuItem(String resKey) {
        String key;
        this.popmenu.removeAll();
        String popValue = CustomResourceManager.getInstance().getString(resKey);
        if (popValue == null) {
            this.component.requestFocus();
            return;
        }
        String[] keys = popValue.split(",");
        int index = 0;
        JMenuItem menuItem = null;
        String[] stringArray = keys;
        int n = stringArray.length;
        for (int i = 0; i < n && (index = this.resetMenuItem2(index, menuItem = new JMenuItem(key = stringArray[i]))) <= 5; ++i) {
        }
    }

    private int resetMenuItem2(int index, final JMenuItem menuItem) {
        menuItem.setIconTextGap(1);
        this.items.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupAdapter.this.component.setText(menuItem.getText());
            }
        });
        this.popmenu.add(menuItem);
        return index + 1;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.component.isEnabled()) {
            return;
        }
        this.showPMenu();
        this.component.requestFocus();
    }

    private void showPMenu() {
        Dimension dms = new Dimension(this.component.getWidth() - 12, 22);
        for (JMenuItem menuItem : this.items) {
            menuItem.setSize(dms);
            menuItem.setPreferredSize(dms);
        }
        if (this.popmenu.getSubElements().length > 0) {
            this.popmenu.show(this.component, this.component.getX(), this.component.getY() + this.component.getHeight());
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (!this.component.isEnabled()) {
            return;
        }
        if (keyEvent.getKeyChar() == '\t') {
            if (this.popmenu.isVisible()) {
                this.popmenu.setVisible(false);
            }
            if (keyEvent.isShiftDown()) {
                this.component.transferFocusBackward();
            } else {
                this.component.transferFocus();
            }
        } else if (keyEvent.getKeyChar() != '\n') {
            this.showPMenu();
            this.component.requestFocus();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\n') {
            int selectIndex = -1;
            for (int i = 0; i < this.items.size(); ++i) {
                if (!this.items.get(i).isArmed()) continue;
                selectIndex = i;
            }
            this.popmenu.setVisible(false);
            if (selectIndex >= 0) {
                this.component.setText(this.items.get(selectIndex).getText());
            }
        }
    }
}

