/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui2.module.event;

import com.huawei.ism.common.LauncherManager;
import com.huawei.ism.common.bean.DeviceContext;
import com.huawei.ism.common.bean.DeviceType;
import com.huawei.ism.common.bean.Event;
import com.huawei.ism.ui.module.event.EventStatPane;
import com.huawei.ism.ui.swing.control.ToolBarButton;
import com.huawei.ism.ui2.mainframe.device.DevicePane;
import com.huawei.ism.ui2.module.event.EventManagerPanel;
import com.huawei.ism.ui2.module.featuremanager.FeatureItem;
import com.huawei.ism.ui2.module.featuremanager.FeatureItemFactory;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Map;
import javax.swing.SwingUtilities;

public class DefaultEventStatPane
extends EventStatPane {
    private static final long serialVersionUID = 1L;

    @Override
    protected void addHandler() {
        Map<Event.Level, ToolBarButton> buttonMap = this.getButtons();
        Event.Level level = null;
        for (Map.Entry<Event.Level, ToolBarButton> entry : buttonMap.entrySet()) {
            level = entry.getKey();
            this.add(entry, level);
        }
    }

    private void add(Map.Entry<Event.Level, ToolBarButton> entry, Event.Level level) {
        ToolBarButton levelButton = entry.getValue();
        levelButton.addMouseListener(new ButtonHandler(level));
    }

    private final class ButtonHandler
    extends MouseAdapter {
        private final Event.Level level;

        private ButtonHandler(Event.Level level) {
            this.level = level;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            FeatureItem eventclassItem;
            DevicePane devicePane = (DevicePane)SwingUtilities.getAncestorOfClass(DevicePane.class, mouseEvent.getComponent());
            DeviceContext deviceConxt = LauncherManager.getInstance().getDeviceContext(DefaultEventStatPane.this.getDeviceID());
            if (null == deviceConxt) {
                throw new NullPointerException();
            }
            if (deviceConxt.getDeviceType().equals((Object)DeviceType.N8000)) {
                eventclassItem = FeatureItemFactory.getFeatureItem(DefaultEventStatPane.this.getDeviceID(), deviceConxt.getDeviceType(), "home_event");
            } else {
                eventclassItem = FeatureItemFactory.getFeatureItem(DefaultEventStatPane.this.getDeviceID(), deviceConxt.getDeviceType(), "event_manager");
                eventclassItem.setParent(FeatureItemFactory.getFeatureItem(DefaultEventStatPane.this.getDeviceID(), deviceConxt.getDeviceType(), "monitor"));
            }
            EventManagerPanel eventPane = (EventManagerPanel)eventclassItem.getPropertyPane();
            devicePane.setFeaturePane(eventclassItem);
            eventPane.clickEventIcon(this.level);
        }
    }
}

