/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui2.perfstat;

import com.huawei.ism.common.Launcher;
import com.huawei.ism.common.bean.ProductSpeciality;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.swing.LayoutConstants;
import com.huawei.ism.ui.swing.control.ImgsAssembledPane;
import com.huawei.ism.ui.swing.control.RequiredHBox;
import com.huawei.ism.ui.swing.text.IsmTextField;
import com.huawei.ism.ui.swing.text.RegexDocument;
import com.huawei.ism.ui.swing.text.validator.NotEmptyInputValidator;
import com.huawei.ism.ui.swing.text.validator.ValueRangeInputValidator;
import com.huawei.ism.ui2.perfstat.util.PerfStatUtil;
import com.huawei.ism.util.CommonUtil;
import com.huawei.ism.util.Pair;
import com.huawei.ism.util.UCD;
import com.huawei.ism.util.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.sql.Time;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PerfStatStrategySettingLayout
extends JPanel {
    private static final long serialVersionUID = 6853252109283420369L;
    private static final int INTERVAL_UNIT = 5;
    private IsmTextField statDaysTextField;
    private IsmTextField samplingIntervalTextField;
    private IsmTextField autoStopDaysTextField;
    private JCheckBox archiveDataCheckBox;
    private JLabel archiveDatalabel;
    private JComboBox deviceComboBox;
    private JComboBox samplingIntervalComboBox;
    private JLabel historyIntervalLabel;
    private JComboBox historyIntervalComboBox;
    private RequiredHBox historyIntervalHBox;
    private JLabel statDaysLabel;
    private JLabel statDaysRangeLabel;
    private RequiredHBox statDaysHBox;
    private JLabel samplingIntervalRangeLabel;
    private JLabel deviceValueLabel;
    private JLabel samplingIntervalLabel;
    private RequiredHBox samplingIntervalHBox;
    private JLabel statusLabel;
    private JLabel statusValueLabel;
    private JButton statusBtn;
    private boolean startBtn;
    private JLabel startTimeLabel;
    private JLabel startTimeValueLabel;
    private RequiredHBox startTimeValueHBox;
    private JLabel endTimeLabel;
    private JLabel endTimeValueLabel;
    private RequiredHBox endTimeValueHBox;
    private JLabel autoStopDaysRangeLabel;
    private JCheckBox autoStopDaysCheckBox;
    private Box autoStopDaysHBox;
    private RequiredHBox deviceNameHBox;
    private JLabel deviceNameLabel;
    private JLabel deviceNameValueLabel;
    private String deviceID;
    private String selectedDeviceID;
    private boolean isSplit;

    public PerfStatStrategySettingLayout(String deviceID) {
        this(deviceID, false, deviceID);
    }

    public PerfStatStrategySettingLayout(String deviceID, boolean isSplit, String selectedDeviceID) {
        this.deviceID = deviceID;
        this.isSplit = isSplit;
        this.selectedDeviceID = selectedDeviceID;
        this.doLayoutUI(deviceID);
    }

    public boolean isSplitInterval(String deviceIdTemp) {
        Launcher launcher = CommonUtil.getLauncher(deviceIdTemp);
        return launcher.isSupportSpeciality(ProductSpeciality.PERFORMANCE_SPLITED_INTERVAL);
    }

    protected void initDeviceComboBoxData(String deviceIdTemp) {
        if (null != deviceIdTemp) {
            Pair<String, String> arrayPair = new Pair<String, String>(deviceIdTemp, CommonUtil.getDeviceName(deviceIdTemp));
            this.deviceComboBox.addItem(arrayPair);
            Launcher launcher = CommonUtil.getLauncher(deviceIdTemp);
            Pair<String, String> subDevicePair = null;
            for (String dID : launcher.getSubDeviceIDs()) {
                subDevicePair = new Pair<String, String>(dID, CommonUtil.getDeviceName(dID));
                this.deviceComboBox.addItem(subDevicePair);
            }
            if (null != this.selectedDeviceID) {
                Pair<String, String> selectedPair = new Pair<String, String>(this.selectedDeviceID, CommonUtil.getDeviceName(this.selectedDeviceID));
                this.deviceComboBox.setSelectedItem(selectedPair);
            }
        }
    }

    public void doLayoutUI(String deviceIdTemp) {
        if (this.isSplit) {
            this.createNewComponents();
            this.newLayoutComponents(deviceIdTemp);
        } else {
            this.createOldComponents();
            this.oldLayoutComponent(deviceIdTemp);
            this.samplingIntervalTextField.addFocusListener(this.getFocusListenerForRealTimeTextField());
            this.samplingIntervalTextField.addKeyListener(this.getSamplingIntervalTextFieldKeyLisenter());
        }
    }

    private Pair<Component, Component> getDevicePair() {
        boolean isFilt;
        this.deviceNameLabel.setText(Utils.transferStringToLower(CommonUtil.addColon(ResourceManager.getString("DEVICE_NAME"))));
        UCD.setJComponentWidth(this.deviceComboBox, 200);
        boolean bl = isFilt = !CommonUtil.getLauncher(this.deviceID).getSubDeviceIDs().isEmpty();
        if (isFilt) {
            this.deviceNameHBox = new RequiredHBox(UCD.buildHBoxLeft(this.deviceComboBox, Box.createGlue()), true);
            this.initDeviceComboBoxData(this.deviceID);
        } else {
            this.deviceValueLabel.setText(CommonUtil.getDeviceName(this.deviceID));
            this.deviceNameHBox = new RequiredHBox(UCD.buildHBoxLeft(this.deviceValueLabel, Box.createGlue()), true);
        }
        this.deviceNameValueLabel.setText(CommonUtil.getDeviceName(this.deviceID));
        return new Pair<Component, Component>(this.deviceNameLabel, new RequiredHBox(this.deviceNameValueLabel, false));
    }

    private void createOldComponents() {
        this.deviceNameLabel = new JLabel(Utils.transferStringToLower(CommonUtil.addColon(ResourceManager.getString("COMMON.TXT.ARRAY_FILTER") + ":")));
        this.deviceNameValueLabel = new JLabel();
        this.deviceComboBox = new JComboBox();
        this.deviceValueLabel = new JLabel();
        this.samplingIntervalLabel = new JLabel(PerfStatUtil.transferStringToLower(CommonUtil.addColon(ResourceManager.getString("REAL_TIME_INTERVAL"))));
        UCD.setJComponentSize(this.samplingIntervalLabel, this.samplingIntervalLabel.getPreferredSize().width + 10, this.samplingIntervalLabel.getPreferredSize().height);
        this.samplingIntervalTextField = IsmTextField.getNumberTextField(60L, 3600L, 4, 14);
        this.samplingIntervalTextField.addInputValidator(new NotEmptyInputValidator());
        this.samplingIntervalTextField.addInputValidator(new ValueRangeInputValidator(60.0, 3600.0));
        this.samplingIntervalTextField.setInputValueName(ResourceManager.getString("perfstat.strategySettings.samplingInterval"));
        this.samplingIntervalTextField.getTextFieldPopupInfo().removeAllInform();
        this.samplingIntervalRangeLabel = new JLabel(ResourceManager.getString("perfstat.realtime.statStrategy.samplingIntervalRange"));
        this.samplingIntervalHBox = new RequiredHBox(UCD.buildHBoxLeft(this.samplingIntervalTextField, this.samplingIntervalRangeLabel, Box.createGlue()), true);
        this.statDaysLabel = new JLabel(PerfStatUtil.transferStringToLower(CommonUtil.addColon(ResourceManager.getString("STOP_STATISTIC"))));
        this.statDaysTextField = IsmTextField.getNumberTextField(1L, Integer.MAX_VALUE, 8, 14);
        this.statDaysTextField.addInputValidator(new NotEmptyInputValidator());
        this.statDaysTextField.setInputValueName(ResourceManager.getString("STOP_STATISTIC"));
        this.statDaysTextField.getTextFieldPopupInfo().removeAllInform();
        this.statDaysRangeLabel = new JLabel();
        this.statDaysHBox = new RequiredHBox(UCD.buildHBoxLeft(this.statDaysTextField, Box.createGlue()), true);
        this.archiveDataCheckBox = new JCheckBox();
        this.archiveDataCheckBox.setText(PerfStatUtil.transferStringToLower(ResourceManager.getString("ARCHIVE_DATA")));
        this.archiveDatalabel = new JLabel(PerfStatUtil.transferStringToLower(ResourceManager.getString("ARCHIVE_DATA_TMP")));
        this.archiveDatalabel.setEnabled(false);
        this.statusLabel = new JLabel(CommonUtil.addColon(ResourceManager.getString("STATUS")));
        this.statusValueLabel = new JLabel();
        this.statusBtn = UCD.createButton(ResourceManager.getString("DISABLE_TEXT"));
        this.startTimeLabel = new JLabel(CommonUtil.addColon(PerfStatUtil.transferStringToLower(ResourceManager.getString("START_STAT_TIME"))));
        this.startTimeValueLabel = new JLabel();
        this.startTimeValueHBox = new RequiredHBox(this.startTimeValueLabel, false);
        this.endTimeLabel = new JLabel(CommonUtil.addColon(PerfStatUtil.transferStringToLower(ResourceManager.getString("END_STAT_TIME"))));
        this.endTimeValueLabel = new JLabel();
        this.endTimeValueHBox = new RequiredHBox(this.endTimeValueLabel, false);
        PerfStatUtil.setSameWidthAndAlign(4, this.samplingIntervalLabel, this.statDaysLabel, this.statusLabel, this.startTimeLabel, this.endTimeLabel);
    }

    private void createNewComponents() {
        this.deviceNameLabel = new JLabel(Utils.transferStringToLower(CommonUtil.addColon(ResourceManager.getString("COMMON.TXT.ARRAY_FILTER") + ":")));
        this.deviceNameValueLabel = new JLabel();
        this.deviceComboBox = new JComboBox();
        this.deviceValueLabel = new JLabel();
        this.samplingIntervalLabel = new JLabel(Utils.transferStringToLower(CommonUtil.addColon(ResourceManager.getString("REAL_TIME_INTERVAL"))));
        UCD.setJComponentSize(this.samplingIntervalLabel, this.samplingIntervalLabel.getPreferredSize().width + 10, this.samplingIntervalLabel.getPreferredSize().height);
        this.samplingIntervalComboBox = new JComboBox();
        UCD.setJComponentWidth(this.samplingIntervalComboBox, 200);
        this.samplingIntervalHBox = new RequiredHBox(UCD.buildHBoxLeft(this.samplingIntervalComboBox, Box.createGlue()), true);
        this.historyIntervalLabel = new JLabel(Utils.transferStringToLower(CommonUtil.addColon(ResourceManager.getString("HISTORY_INTERVAL"))));
        this.historyIntervalComboBox = new JComboBox();
        UCD.setJComponentWidth(this.historyIntervalComboBox, 200);
        this.historyIntervalHBox = new RequiredHBox(UCD.buildHBoxLeft(this.historyIntervalComboBox, Box.createGlue()), true);
        this.setComponentsFeature();
        this.historyIntervalLabel.setPreferredSize(new Dimension(100, 30));
        PerfStatUtil.setSameWidthAndAlign(4, this.statusLabel, this.startTimeLabel, this.endTimeLabel, this.historyIntervalLabel, this.samplingIntervalLabel, this.deviceNameLabel);
        this.historyIntervalComboBox.addItem(60);
        this.historyIntervalComboBox.addItem(300);
        this.historyIntervalComboBox.addItem(900);
        this.historyIntervalComboBox.addItem(1800);
        this.historyIntervalComboBox.addItem(3600);
        for (int i = 1; i < 13; ++i) {
            this.samplingIntervalComboBox.addItem(5 * i);
        }
    }

    private void setComponentsFeature() {
        this.autoStopDaysCheckBox = new JCheckBox();
        this.autoStopDaysCheckBox.setText(Utils.transferStringToLower(CommonUtil.addColon(ResourceManager.getString("AUTO_STOP_DAYS"))));
        this.autoStopDaysTextField = IsmTextField.getNumberTextField(0L, 420L, 3, 14);
        this.autoStopDaysTextField.addInputValidator(new NotEmptyInputValidator());
        this.autoStopDaysRangeLabel = new JLabel(Utils.transferStringToLower(ResourceManager.getString("perfstat.realtime.statStrategy.autoStopDaysRange")));
        this.autoStopDaysHBox = UCD.buildHBoxLeft(this.autoStopDaysTextField, Box.createGlue());
        this.archiveDataCheckBox = new JCheckBox();
        this.archiveDataCheckBox.setText(Utils.transferStringToLower(ResourceManager.getString("ARCHIVE_DATA")));
        this.archiveDatalabel = new JLabel(PerfStatUtil.transferStringToLower(ResourceManager.getString("ARCHIVE_DATA_TMP")));
        this.archiveDatalabel.setEnabled(false);
        this.statusLabel = new JLabel(CommonUtil.addColon(ResourceManager.getString("STATUS")));
        this.statusValueLabel = new JLabel();
        this.statusBtn = UCD.createButton(ResourceManager.getString("DISABLE_TEXT"));
        this.startTimeLabel = new JLabel(CommonUtil.addColon(Utils.transferStringToLower(ResourceManager.getString("START_STAT_TIME"))));
        this.startTimeValueLabel = new JLabel();
        this.startTimeValueHBox = new RequiredHBox(this.startTimeValueLabel, false);
        this.endTimeLabel = new JLabel(CommonUtil.addColon(Utils.transferStringToLower(ResourceManager.getString("END_STAT_TIME"))));
        this.endTimeValueLabel = new JLabel();
        this.endTimeValueHBox = new RequiredHBox(this.endTimeValueLabel, false);
    }

    public void oldLayoutComponent(String deviceIdTemp) {
        Pair<JLabel, RequiredHBox> samplingIntervalPair = new Pair<JLabel, RequiredHBox>(this.samplingIntervalLabel, this.samplingIntervalHBox);
        Pair<JLabel, RequiredHBox> statDaysPair = new Pair<JLabel, RequiredHBox>(this.statDaysLabel, this.statDaysHBox);
        Pair<JLabel, RequiredHBox> statusPair = new Pair<JLabel, RequiredHBox>(this.statusLabel, new RequiredHBox(UCD.buildHBoxLeft(this.statusValueLabel, this.statusBtn), false));
        Pair<JLabel, RequiredHBox> startTimePair = new Pair<JLabel, RequiredHBox>(this.startTimeLabel, this.startTimeValueHBox);
        Pair<JLabel, RequiredHBox> endTimePair = new Pair<JLabel, RequiredHBox>(this.endTimeLabel, this.endTimeValueHBox);
        ArrayList<Pair<Component, Component>> topPairs = new ArrayList<Pair<Component, Component>>(0);
        topPairs.add(this.getDevicePair());
        topPairs.add(samplingIntervalPair);
        topPairs.add(statDaysPair);
        ArrayList<Pair<Component, Component>> bottomPairs = new ArrayList<Pair<Component, Component>>(0);
        bottomPairs.add(statusPair);
        bottomPairs.add(startTimePair);
        bottomPairs.add(endTimePair);
        Box wholebox = UCD.buildVBoxTop(LayoutConstants.LINE_MARGIN_PIXEL, UCD.createRightKVPane(LayoutConstants.LINE_MARGIN_PIXEL, 0, topPairs), UCD.buildHBoxLeft(this.archiveDataCheckBox), UCD.buildHBoxLeft(Box.createHorizontalStrut(6), this.archiveDatalabel), new ImgsAssembledPane.HorizonalSeparator(), UCD.createRightKVPane(LayoutConstants.LINE_MARGIN_PIXEL, bottomPairs));
        this.setLayout(new BorderLayout());
        this.add((Component)UCD.layComponentToTop(wholebox), "Center");
    }

    public void newLayoutComponents(String deviceIdTemp) {
        Pair<JLabel, RequiredHBox> samplingIntervalPair = new Pair<JLabel, RequiredHBox>(this.samplingIntervalLabel, this.samplingIntervalHBox);
        Pair<JLabel, RequiredHBox> historyIntervalPair = new Pair<JLabel, RequiredHBox>(this.historyIntervalLabel, this.historyIntervalHBox);
        Pair<JLabel, RequiredHBox> newStatusPair = new Pair<JLabel, RequiredHBox>(this.statusLabel, new RequiredHBox(UCD.buildHBoxLeft(this.statusValueLabel, this.statusBtn), false));
        Pair<JLabel, RequiredHBox> newStartTimePair = new Pair<JLabel, RequiredHBox>(this.startTimeLabel, this.startTimeValueHBox);
        Pair<JLabel, RequiredHBox> newEndTimePair = new Pair<JLabel, RequiredHBox>(this.endTimeLabel, this.endTimeValueHBox);
        ArrayList<Pair<Component, Component>> newTopPairs = new ArrayList<Pair<Component, Component>>(0);
        newTopPairs.add(this.getDevicePair());
        newTopPairs.add(samplingIntervalPair);
        newTopPairs.add(historyIntervalPair);
        ArrayList<Pair<Component, Component>> bottomPairs = new ArrayList<Pair<Component, Component>>(0);
        bottomPairs.add(newStatusPair);
        bottomPairs.add(newStartTimePair);
        bottomPairs.add(newEndTimePair);
        Box wholebox = UCD.buildVBoxTop(LayoutConstants.LINE_MARGIN_PIXEL, UCD.createRightKVPane(LayoutConstants.LINE_MARGIN_PIXEL, 0, newTopPairs), UCD.buildHBoxLeft(this.archiveDataCheckBox), UCD.buildHBoxLeft(Box.createHorizontalStrut(6), this.archiveDatalabel), UCD.buildHBoxLeft(this.autoStopDaysCheckBox, this.autoStopDaysHBox), new ImgsAssembledPane.HorizonalSeparator(), UCD.createRightKVPane(LayoutConstants.LINE_MARGIN_PIXEL, bottomPairs));
        this.setLayout(new BorderLayout());
        this.add((Component)UCD.layComponentToTop(wholebox), "Center");
    }

    public void setData(Map<Object, Object> data, String deviceIdTemp) {
        boolean isSwitchOn;
        Object isArchiveOnObject = data.get("isArchiveSwitchOn");
        Object samplingIntervalObject = data.get("samplingInterval");
        Object maxDays = data.get("statisticMaxDays");
        Object isAutoStop = data.get("isAutoStop");
        if (isArchiveOnObject != null && samplingIntervalObject != null && maxDays != null && isAutoStop != null) {
            this.setArchieve((Long)isArchiveOnObject == 1L);
            this.setInterval((Long)samplingIntervalObject);
            this.setStopDatasPomt();
            this.setStopDays(((Long)maxDays).intValue());
            if (this.isSplitInterval(deviceIdTemp)) {
                Object historyInterval = data.get("archiveInterval");
                if (null != historyInterval) {
                    this.setHistoryInterval(Long.parseLong(historyInterval.toString()));
                }
                this.setAutoStop((Long)isAutoStop == 1L);
            }
        }
        boolean bl = isSwitchOn = (Long)data.get("isPerformanceSwitchOn") == 1L;
        if (isSwitchOn) {
            this.setBeginEndTime(data, deviceIdTemp);
            this.setStatus(true);
            this.closeOptionalSettings();
        } else {
            this.setStatus(false);
            this.setBeginTime(null);
            this.setEndTime(null);
            this.openOptionalSettings();
        }
    }

    private void setBeginEndTime(Map<Object, Object> data, String deviceIdTemp) {
        Object beginTime = data.get("switchStartTime");
        if (beginTime != null) {
            this.setBeginTime(CommonUtil.gmtToString(new Time((Long)beginTime), deviceIdTemp));
        } else {
            this.setBeginTime(null);
        }
        Object endTime = data.get("switchEndTime");
        if (endTime != null) {
            this.setEndTime(CommonUtil.gmtToString(new Time((Long)endTime), deviceIdTemp));
        } else {
            this.setEndTime(null);
        }
    }

    public Map<Object, Object> getUISetting() {
        HashMap<Object, Object> strategy = new HashMap<Object, Object>(0);
        if (this.isStartBtn()) {
            strategy.put("samplingInterval", this.getInterval());
            strategy.put("isArchiveSwitchOn", this.isArchieve() ? 1L : 0L);
            strategy.put("statisticMaxDays", this.getStopDays());
            if (this.isSplit) {
                strategy.put("archiveInterval", this.getHistoryInterval());
                strategy.put("isAutoStop", this.isAutoStop() ? 1L : 0L);
            } else {
                strategy.put("archiveInterval", this.getInterval());
                strategy.put("isAutoStop", 1L);
            }
        }
        return strategy;
    }

    private int calcuStopDays() {
        int sampleInterval = this.getInterval();
        int days = sampleInterval * 7 / 60;
        return days;
    }

    public void setStopDatasPomt() {
        int days;
        int sampleInterval = this.getInterval();
        String autoStopDays = "";
        if (this.isSplit) {
            days = 31;
        } else {
            if (sampleInterval < 60 || sampleInterval > 3600) {
                this.setStopDatasPomt("(--)");
                this.autoStopDaysTextField.setText("");
                return;
            }
            days = this.calcuStopDays();
        }
        if ("zh".equals(ResourceManager.getLocale().getLanguage())) {
            this.setStopDatasPomt("(1~" + days + ')');
        } else {
            this.setStopDatasPomt("(1\u2013" + days + ')');
        }
        RegexDocument numberDocument = RegexDocument.createNumberDocument("[0-9]*", 1L, days, String.valueOf(days).length(), false);
        if (this.isSplit) {
            autoStopDays = this.autoStopDaysTextField.getText();
            this.autoStopDaysTextField.setDocument(numberDocument);
            this.autoStopDaysTextField.setText(autoStopDays);
        } else {
            autoStopDays = this.statDaysTextField.getText();
            this.statDaysTextField.setText(autoStopDays);
        }
        this.statusBtn.setFocusable(false);
    }

    public void setStatus(boolean start) {
        if (start) {
            this.setStatusText(ResourceManager.getString("perfstat.realtime.statStrategy.openStatus"));
            this.statusBtn.setText(ResourceManager.getString("SYSTEM_PERFORMANCE_STATISTICS_CLOSE"));
            this.startBtn = false;
        } else {
            this.setStatusText(ResourceManager.getString("perfstat.realtime.statStrategy.closeStatus"));
            this.statusBtn.setText(ResourceManager.getString("SYSTEM_PERFORMANCE_STATISTICS_OPEN"));
            this.startBtn = true;
        }
    }

    public void setStatusText(String text) {
        this.statusValueLabel.setText(text);
    }

    public boolean isStartBtn() {
        return this.startBtn;
    }

    public int getInterval() {
        if (this.isSplit) {
            return (Integer)this.samplingIntervalComboBox.getItemAt(this.samplingIntervalComboBox.getSelectedIndex());
        }
        String interval = this.samplingIntervalTextField.getText();
        if (null == interval || "".equals(interval.trim())) {
            return 0;
        }
        return Integer.valueOf(this.samplingIntervalTextField.getText());
    }

    public void setInterval(Long interval) {
        if (this.isSplit) {
            for (int i = 0; i < this.samplingIntervalComboBox.getItemCount(); ++i) {
                if (((Integer)this.samplingIntervalComboBox.getItemAt(i)).intValue() != interval.intValue()) continue;
                this.samplingIntervalComboBox.setSelectedIndex(i);
                break;
            }
        } else if (interval == null) {
            this.samplingIntervalTextField.setText("");
        } else {
            this.samplingIntervalTextField.setText(String.valueOf(interval));
        }
    }

    public int getHistoryInterval() {
        return (Integer)this.historyIntervalComboBox.getSelectedItem();
    }

    public void setHistoryInterval(Long interval) {
        int index = 0;
        for (int i = 0; i < this.historyIntervalComboBox.getItemCount(); ++i) {
            if (((Integer)this.historyIntervalComboBox.getItemAt(i)).intValue() != interval.intValue()) continue;
            index = i;
        }
        this.historyIntervalComboBox.setSelectedIndex(index);
    }

    public boolean isArchieve() {
        return this.archiveDataCheckBox.isSelected();
    }

    public void setArchieve(boolean archieve) {
        this.archiveDataCheckBox.setSelected(archieve);
    }

    public int getStopDays() {
        String stopDatas = this.isSplit ? this.autoStopDaysTextField.getText() : this.statDaysTextField.getText();
        if ("".equals(stopDatas.trim())) {
            return 0;
        }
        return Integer.valueOf(stopDatas);
    }

    public void setStopDays(Integer days) {
        if (days == null) {
            if (this.isSplit) {
                this.autoStopDaysTextField.setText("");
                return;
            }
            this.statDaysTextField.setText("");
        } else {
            if (this.isSplit) {
                this.autoStopDaysTextField.setText(String.valueOf(days));
                return;
            }
            this.statDaysTextField.setText(String.valueOf(days));
        }
    }

    public boolean isAutoStop() {
        return this.autoStopDaysCheckBox.isSelected();
    }

    public void setAutoStop(boolean isAutoStop) {
        this.autoStopDaysCheckBox.setSelected(isAutoStop);
    }

    public void addStatusBtnActionListener(ActionListener actionListener) {
        this.statusBtn.addActionListener(actionListener);
    }

    public void setStopDatasPomt(String text) {
        if (this.isSplit) {
            this.autoStopDaysRangeLabel.setText(text);
        } else {
            this.statDaysRangeLabel.setText(text);
        }
    }

    public void setBeginTime(String time) {
        if (null != time) {
            this.startTimeValueLabel.setText(time);
        } else {
            this.startTimeValueLabel.setText("--");
        }
    }

    public void setEndTime(String time) {
        if (null != time) {
            this.endTimeValueLabel.setText(time);
        } else {
            this.endTimeValueLabel.setText("--");
        }
    }

    public void openOptionalSettings() {
        if (this.isSplit) {
            this.samplingIntervalComboBox.setEnabled(true);
            this.historyIntervalComboBox.setEnabled(true);
            this.autoStopDaysTextField.setEnabled(true);
            this.autoStopDaysCheckBox.setEnabled(true);
            this.archiveDataCheckBox.setEnabled(true);
        } else {
            this.samplingIntervalLabel.setEnabled(true);
            this.samplingIntervalTextField.setEnabled(true);
            this.samplingIntervalRangeLabel.setEnabled(true);
            this.archiveDataCheckBox.setEnabled(true);
            this.statDaysLabel.setEnabled(true);
            this.statDaysTextField.setEnabled(true);
            this.statDaysRangeLabel.setEnabled(true);
        }
        this.startTimeLabel.setEnabled(true);
        this.startTimeValueHBox.setEnabled(true);
        this.endTimeLabel.setEnabled(true);
        this.endTimeValueHBox.setEnabled(true);
    }

    public void closeOptionalSettings() {
        if (this.isSplit) {
            this.samplingIntervalComboBox.setEnabled(false);
            this.historyIntervalComboBox.setEnabled(false);
            this.autoStopDaysTextField.setEnabled(false);
            this.autoStopDaysCheckBox.setEnabled(false);
        } else {
            this.samplingIntervalTextField.setEnabled(false);
            this.samplingIntervalRangeLabel.setEnabled(false);
            this.statDaysTextField.setEnabled(false);
            this.statDaysRangeLabel.setEnabled(false);
        }
        this.archiveDataCheckBox.setEnabled(false);
    }

    public JComponent[] getAllComponent() {
        if (this.isSplit) {
            return new JComponent[]{this.autoStopDaysTextField, this.archiveDataCheckBox, this.startTimeValueHBox, this.endTimeValueHBox, this.statusBtn, this.samplingIntervalComboBox};
        }
        return new JComponent[]{this.statDaysTextField, this.archiveDataCheckBox, this.startTimeValueHBox, this.endTimeValueHBox, this.statusBtn, this.samplingIntervalTextField};
    }

    private FocusListener getFocusListenerForRealTimeTextField() {
        return new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                PerfStatStrategySettingLayout.this.doRealTimeTextField();
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        };
    }

    private KeyListener getSamplingIntervalTextFieldKeyLisenter() {
        return new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                PerfStatStrategySettingLayout.this.doRealTimeTextField();
                if (PerfStatStrategySettingLayout.this.isSplit) {
                    PerfStatStrategySettingLayout.this.autoStopDaysTextField.setError(false);
                } else {
                    PerfStatStrategySettingLayout.this.statDaysTextField.setError(false);
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        };
    }

    private void doRealTimeTextField() {
        int sampleInterval = this.getInterval();
        if (sampleInterval < 60 || sampleInterval > 3600) {
            this.setStopDatasPomt("(--)");
        } else {
            int days = this.calcuStopDays();
            this.setStopDatasPomt(ResourceManager.getStringWithParams("perfstat.setting.monitoringDays.rangeFrom", days));
            this.setStopDatasPomt();
        }
    }

    public IsmTextField getStatDaysTextField() {
        return this.statDaysTextField;
    }

    public IsmTextField getSamplingIntervalTextField() {
        return this.samplingIntervalTextField;
    }

    public IsmTextField getAutoStopDaysTextField() {
        return this.autoStopDaysTextField;
    }

    public JCheckBox getArchiveDataCheckBox() {
        return this.archiveDataCheckBox;
    }

    public JComboBox getDeviceComboBox() {
        return this.deviceComboBox;
    }

    public JLabel getDeviceValueLabel() {
        return this.deviceValueLabel;
    }

    public JComboBox getSamplingIntervalComboBox() {
        return this.samplingIntervalComboBox;
    }

    public JLabel getHistoryIntervalLabel() {
        return this.historyIntervalLabel;
    }

    public JComboBox getHistoryIntervalComboBox() {
        return this.historyIntervalComboBox;
    }

    public RequiredHBox getHistoryIntervalHBox() {
        return this.historyIntervalHBox;
    }
}

