/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui2.perfstat.util;

import com.huawei.ism.common.LauncherManager;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.ui2.perfstat.util.PerfStatDataSource;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DataSourceManager {
    private static final Map<String, PerfStatDataSource> DATASOURCEMAP = new ConcurrentHashMap<String, PerfStatDataSource>();

    private DataSourceManager() {
    }

    public static PerfStatDataSource getDataSource(String deviceID) {
        if (!DATASOURCEMAP.containsKey(deviceID)) {
            PerfStatDataSource dataSource = LauncherManager.getInstance().getLauncher(deviceID).getPerfStatDataSource(deviceID);
            if (dataSource == null) {
                throw new IsmException(-1L);
            }
            DATASOURCEMAP.put(deviceID, dataSource);
        }
        return DATASOURCEMAP.get(deviceID);
    }
}

