/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.util;

import com.huawei.ism.util.GetPropertyPriviAction;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.font.FontRenderContext;
import java.awt.image.BufferedImage;
import java.math.BigDecimal;
import java.security.AccessController;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwingUIUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(SwingUIUtil.class);
    public static final int GRAB_EVENT_MASK = Integer.MIN_VALUE;
    public static final Object AA_TEXT_PROPERTY_KEY = new StringBuffer("AATextPropertyKey");
    public static final FontRenderContext AA_FRC;
    private static final boolean AA_TEXT;
    private static final boolean AA_TEXT_DEFINED;

    public static BufferedImage getScaledIconImage(List<Image> imageListIn, int widthIn, int heightIn) {
        if (widthIn == 0 || heightIn == 0) {
            return null;
        }
        Image bestImageTemp = null;
        int bestWidthTemp = 0;
        int bestHeightTemp = 0;
        double bestSimilarityTemp = 3.0;
        for (Image imTemp : imageListIn) {
            double scaleMeasureTemp;
            int ihTemp;
            int iwTemp;
            if (imTemp == null) {
                LOGGER.error("SwingUIUtil.getScaledIconImage: Skipping the image passed into Java because it's null.");
                continue;
            }
            try {
                iwTemp = imTemp.getWidth(null);
                ihTemp = imTemp.getHeight(null);
            }
            catch (RuntimeException runtimeException) {
                LOGGER.error("SwingUIUtil.getScaledIconImage: Perhaps the image passed into Java is broken. Skipping this icon.");
                continue;
            }
            if (iwTemp <= 0 || ihTemp <= 0) continue;
            double scaleFactorTemp = Math.min((double)widthIn / (double)iwTemp, (double)heightIn / (double)ihTemp);
            int adjwTemp = 0;
            int adjhTemp = 0;
            Object[] params = SwingUIUtil.getParams(scaleFactorTemp, iwTemp, ihTemp);
            adjwTemp = Integer.valueOf(params[1].toString());
            double similarityTemp = ((double)widthIn - (double)adjwTemp) / (double)widthIn + ((double)heightIn - (double)(adjhTemp = Integer.valueOf(params[2].toString()).intValue())) / (double)heightIn + (scaleMeasureTemp = Double.valueOf(params[3].toString()).doubleValue());
            if (similarityTemp < bestSimilarityTemp) {
                bestSimilarityTemp = similarityTemp;
                bestImageTemp = imTemp;
                bestWidthTemp = adjwTemp;
                bestHeightTemp = adjhTemp;
            }
            if (similarityTemp != 0.0) continue;
            break;
        }
        return SwingUIUtil.degradeForgetScaledIconImage(bestImageTemp, widthIn, heightIn, bestWidthTemp, bestHeightTemp);
    }

    private static Object[] getParams(double scaleFactorTemp, int iwTemp, int ihTemp) {
        double scaleMeasureTemp = 1.0;
        int adjwTemp = 0;
        int adjhTemp = 0;
        double actualScaleFactorTemp = scaleFactorTemp;
        if (actualScaleFactorTemp >= 2.0) {
            actualScaleFactorTemp = Math.floor(actualScaleFactorTemp);
            adjwTemp = iwTemp * (int)actualScaleFactorTemp;
            adjhTemp = ihTemp * (int)actualScaleFactorTemp;
            scaleMeasureTemp = 1.0 - 0.5 / actualScaleFactorTemp;
        } else if (actualScaleFactorTemp >= 1.0) {
            actualScaleFactorTemp = 1.0;
            adjwTemp = iwTemp;
            adjhTemp = ihTemp;
            scaleMeasureTemp = 0.0;
        } else if (actualScaleFactorTemp >= 0.75) {
            actualScaleFactorTemp = 0.75;
            adjwTemp = iwTemp * 3 / 4;
            adjhTemp = ihTemp * 3 / 4;
            scaleMeasureTemp = 0.3;
        } else if (actualScaleFactorTemp >= 0.6666) {
            actualScaleFactorTemp = 0.6666;
            adjwTemp = iwTemp * 2 / 3;
            adjhTemp = ihTemp * 2 / 3;
            scaleMeasureTemp = 0.33;
        } else {
            BigDecimal bd1 = new BigDecimal("1.0");
            BigDecimal bd2 = new BigDecimal(actualScaleFactorTemp);
            double scaleDeviderTemp = Math.ceil(bd1.divide(bd2).doubleValue());
            actualScaleFactorTemp = 1.0 / scaleDeviderTemp;
            adjwTemp = (int)Math.round((double)iwTemp / scaleDeviderTemp);
            adjhTemp = (int)Math.round((double)ihTemp / scaleDeviderTemp);
            scaleMeasureTemp = 1.0 - 1.0 / scaleDeviderTemp;
        }
        Object[] params = new Object[]{actualScaleFactorTemp, adjwTemp, adjhTemp, scaleMeasureTemp};
        return params;
    }

    public static void setWindowOpaque(Window window, boolean flag) {
        Color color = window.getBackground();
        if (color == null) {
            color = new Color(0, 0, 0, 0);
        }
        window.setBackground(new Color(color.getRed(), color.getGreen(), color.getBlue(), flag ? 255 : 0));
    }

    public static boolean getBoolean(JComponent jcomponent, String sre, boolean flag) {
        Object obj = UIManager.get(sre, jcomponent.getLocale());
        if (obj == null || !(obj instanceof Boolean)) {
            return flag;
        }
        return (Boolean)obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage degradeForgetScaledIconImage(Image bestImageTemp, int widthIn, int heightIn, int bestWidthTemp, int bestHeightTemp) {
        if (bestImageTemp == null) {
            return null;
        }
        BufferedImage bimageTemp = new BufferedImage(widthIn, heightIn, 2);
        Graphics2D gTemp = bimageTemp.createGraphics();
        gTemp.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        try {
            int xTemp = bestWidthTemp / 2;
            int yTemp = bestHeightTemp / 2;
            LOGGER.error("WWindowPeer.getScaledIconData() result : w : " + bestWidthTemp + " h : " + bestHeightTemp + " iW : " + bestImageTemp.getWidth(null) + " iH : " + bestImageTemp.getHeight(null) + " adjW : " + bestWidthTemp + " adjH : " + bestHeightTemp + " x : " + xTemp + " y : " + yTemp);
            gTemp.drawImage(bestImageTemp, xTemp, yTemp, bestWidthTemp, bestHeightTemp, null);
        }
        finally {
            gTemp.dispose();
        }
        return bimageTemp;
    }

    public static FontMetrics getFontMetrics(JComponent componentIn, Graphics graphIn, Font fontIn) {
        if (null != componentIn) {
            return componentIn.getFontMetrics(fontIn);
        }
        return Toolkit.getDefaultToolkit().getFontMetrics(fontIn);
    }

    public static FontMetrics getFontMetrics(JComponent componentIn, Graphics graphIn) {
        return SwingUIUtil.getFontMetrics(componentIn, graphIn, graphIn.getFont());
    }

    public static String clipStringIfNecessary(JComponent componentIn, FontMetrics fmIn, String stringIn, int availTextWidthIn) {
        if (stringIn == null || stringIn.equals("")) {
            return "";
        }
        int textWidthTemp = SwingUIUtil.stringWidth(componentIn, fmIn, stringIn);
        if (textWidthTemp > availTextWidthIn) {
            return SwingUIUtil.clipString(componentIn, fmIn, stringIn, availTextWidthIn);
        }
        return stringIn;
    }

    public static int stringWidth(JComponent componentIn, FontMetrics fmIn, String stringIn) {
        return fmIn.stringWidth(stringIn);
    }

    public static String clipString(JComponent componentIn, FontMetrics fmIn, String stringIn, int availTextWidthIn) {
        int nCharsTemp;
        String clipStringTemp = "...";
        int widthTemp = SwingUIUtil.stringWidth(componentIn, fmIn, clipStringTemp);
        int max = stringIn.length();
        for (nCharsTemp = 0; nCharsTemp < max && (widthTemp += fmIn.charWidth(stringIn.charAt(nCharsTemp))) <= availTextWidthIn; ++nCharsTemp) {
        }
        return stringIn.substring(0, nCharsTemp) + clipStringTemp;
    }

    public static void drawString(JComponent componentIn, Graphics graphIn, String textIn, int xIn, int yIn) {
        if (textIn == null || textIn.length() <= 0) {
            return;
        }
        if (SwingUIUtil.drawTextAntialiased() && graphIn instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)graphIn;
            Object oldAAValue = g2.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphIn.drawString(textIn, xIn, yIn);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, oldAAValue);
        } else {
            graphIn.drawString(textIn, xIn, yIn);
        }
    }

    private static boolean drawTextAntialiased() {
        if (!AA_TEXT_DEFINED) {
            return false;
        }
        return AA_TEXT;
    }

    public static Graphics2D getGraphics2D(Graphics graphIn) {
        if (graphIn instanceof Graphics2D) {
            return (Graphics2D)graphIn;
        }
        return null;
    }

    public static void drawStringUnderlineCharAt(JComponent componentIn, Graphics graphIn, String textIn, int underlinedIndexIn, int xIn, int yIn) {
        SwingUIUtil.drawString(componentIn, graphIn, textIn, xIn, yIn);
        if (underlinedIndexIn >= 0 && underlinedIndexIn < textIn.length()) {
            FontMetrics fmTemp = graphIn.getFontMetrics();
            int underlineRectXTemp = xIn + SwingUIUtil.stringWidth(componentIn, fmTemp, textIn.substring(0, underlinedIndexIn));
            int underlineRectYTemp = yIn;
            int underlineRectWidth = fmTemp.charWidth(textIn.charAt(underlinedIndexIn));
            int underlineRectHeightTemp = 1;
            graphIn.fillRect(underlineRectXTemp, underlineRectYTemp + 1, underlineRectWidth, underlineRectHeightTemp);
        }
    }

    static {
        Object aa = AccessController.doPrivileged(new GetPropertyPriviAction("swing.aatext"));
        AA_TEXT_DEFINED = aa != null;
        AA_TEXT = "true".equals(aa);
        AA_FRC = new FontRenderContext(null, true, false);
    }
}

