/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.util;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.ui.swing.plaf.unify.UnifyLookAndFeel;
import com.huawei.ism.ui.templets.IsmDialog;
import java.awt.Dimension;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class TestUtil {
    public static void testUILayout(JComponent comp) {
        TestUtil.testUILayout(comp, 0, 0);
    }

    public static void testUILayout(JComponent comp, int width, int height) {
        final IsmDialog frame = new IsmDialog(null, "", IsmDialog.ECommonButton.Confirm, IsmDialog.ECommonButton.Help);
        frame.setDefaultCloseOperation(2);
        frame.setResizable(true);
        frame.setLocationRelativeTo(frame);
        frame.addContentPane(comp);
        if (width != 0 && height != 0) {
            frame.setSize(new Dimension(width, height));
        } else {
            frame.pack();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                frame.setVisible(true);
            }
        });
    }

    public static void init() {
        try {
            IsmPlafUtils.setLocale(Locale.ENGLISH);
            UIManager.setLookAndFeel(new UnifyLookAndFeel());
            ResourceManager.init();
        }
        catch (UnsupportedLookAndFeelException e) {
            ToolLoggerFactory.getLogger(TestUtil.class).error("init UnsupportedLookAndFeelException", (Throwable)e);
        }
    }
}

