/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.utils;

import com.huawei.ism.tool.framework.platform.PlatformAppContext;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.platform.util.PlatformUtils;
import java.io.File;
import java.nio.file.Paths;
import java.text.Normalizer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContextUtil.class);
    private static final String NO_CONTEXT_CLASS = "context_class_not_found";
    private static final Map<String, ClassLoader> CONTEXTLOADERMAP = new ConcurrentHashMap<String, ClassLoader>();
    private static final String TOOLSFOLDER = "tools";
    private static final String UPDATECHECKER = "updatechecker";

    public static String getContextPackageName(Class<?> invokerCls) {
        String pkgName = "";
        String className = ContextUtil.getContextClassName(invokerCls);
        if (!NO_CONTEXT_CLASS.equals(className)) {
            pkgName = PlatformUtils.getPluginId(className);
        }
        return pkgName;
    }

    private static String getContextClassName(Class<?> invokerCls) {
        String className = NO_CONTEXT_CLASS;
        StackTraceElement[] stackList = Thread.currentThread().getStackTrace();
        if (null != stackList) {
            String prevClass = null;
            for (StackTraceElement stackTraceElement : stackList) {
                className = stackTraceElement.getClassName();
                if (invokerCls.getName().equals(className) || Thread.class.getName().equals(className) || className.equals(prevClass) || ToolException.class.getName().equals(className) || "com.huawei.ism.tool.obase.exception.ToolException".equals(className)) continue;
                if (null != prevClass) break;
                prevClass = className;
            }
        }
        return className;
    }

    public static ClassLoader getContextClassLoader(Class<?> invokerCls) {
        String className = ContextUtil.getContextClassName(invokerCls);
        ClassLoader classLoader = CONTEXTLOADERMAP.get(className);
        if (null != classLoader) {
            return classLoader;
        }
        classLoader = ContextUtil.class.getClassLoader();
        if (!NO_CONTEXT_CLASS.equals(className)) {
            ToolLoggerFactory.getLogger(ContextUtil.class).info("Loadding class: " + className);
            Class<?> cls = PlatformAppContext.getInstance().getRuntime().loadClass(className);
            if (null != cls) {
                classLoader = cls.getClassLoader();
                CONTEXTLOADERMAP.put(className, classLoader);
            }
        }
        return classLoader;
    }

    public static String getObaseResPath(String pluginId) {
        return PlatformAppContext.getInstance().getRuntime().getObaseResPath(pluginId);
    }

    public static String getToolBoxPath() {
        String userDir = ApplicationContext.getInstance().getWorkPath();
        File iniFile = new File(userDir, "tool.ini");
        File updatecheckerFile = new File(userDir, "updatechecker.exe");
        int index = userDir.lastIndexOf(TOOLSFOLDER);
        if (-1 != index && iniFile.exists()) {
            LOGGER.info("Tools is getting the toolbox userDir");
            userDir = userDir.substring(0, index - 1);
        } else if (userDir.endsWith(UPDATECHECKER) && updatecheckerFile.exists()) {
            LOGGER.info("Updatechecker is getting the toolbox userDir");
            userDir = Normalizer.normalize(userDir, Normalizer.Form.NFKC);
            index = userDir.lastIndexOf(UPDATECHECKER);
            userDir = userDir.substring(0, index - 1);
        }
        StringBuilder sbBuilder = new StringBuilder(userDir);
        sbBuilder.append(File.separator);
        return sbBuilder.toString();
    }

    public static boolean isInToolBox() {
        String workPath = ApplicationContext.getInstance().getWorkPath();
        return Paths.get(workPath, TOOLSFOLDER).toFile().exists() && Paths.get(workPath, UPDATECHECKER).toFile().exists();
    }

    public static <T> T convertObject(Object obj, Class<T> clazz) {
        if (clazz == null || obj == null) {
            return null;
        }
        if (clazz.isAssignableFrom(obj.getClass())) {
            return (T)obj;
        }
        throw new ClassCastException("case " + obj.getClass().getName() + " to " + clazz.getName() + " exception.");
    }
}

