/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.utils;

import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.OSCmdUtils;
import com.huawei.ism.tool.base.utils.StreamStatusOperator;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.VerifyUtil;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.ism.tool.framework.pubservice.exception.EncapsulatedRuntimeException;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.filechooser.FileSystemView;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileUtils {
    private static final Logger log = LoggerFactory.getLogger(FileUtils.class);
    private static final int SLEEP_TIME = 50;
    public static final String RW = "rw";
    public static final int ONE_KB = 1024;
    public static final int ONE_MB = 0x100000;
    private static final int DEFAULT_CMD_TIMEOUT = 6;
    private static final long FILE_MAX_SIZE = 0x80000000L;
    public static final long FILE_MAX_SIZE_4G = 0x100000000L;

    private FileUtils() {
    }

    public static void createDir(String filePath) {
        File tmpFile = new File(FilePathUtils.getSafePath(filePath));
        FileUtils.createDir(tmpFile);
    }

    public static void createDir(File path) {
        if (!path.exists() && !path.mkdirs()) {
            LoggerFactory.getLogger(FileUtils.class).info("create path failed.");
        }
    }

    public static void clearDir(String dir) {
        if (!dir.equals("")) {
            String actualDir = dir;
            try {
                actualDir = new File(actualDir).getCanonicalPath();
            }
            catch (IOException e1) {
                ToolLoggerFactory.getLogger(FileUtils.class).error("can not getCanonicalPath", (Object)actualDir);
                return;
            }
            String str = "";
            String os = System.getProperty("os.name");
            if (null == os) {
                throw new EncapsulatedRuntimeException("cannot get the System Property of [os.name].");
            }
            str = os.startsWith("Windows") ? "cmd.exe /c rmdir /Q /S \"" + actualDir + "\"" : "rm -r " + actualDir;
            try {
                OSCmdUtils.executeCmd(str, 120);
            }
            catch (Exception e) {
                ToolLoggerFactory.getLogger(FileUtils.class).error("clear file dir error.", (Throwable)e);
            }
        }
    }

    public static void copyDir(String sourceDir, String targetDir) {
        FileUtils.createDir(targetDir);
        File[] file = new File(sourceDir).listFiles();
        if (file == null) {
            return;
        }
        for (int i = 0; i < file.length; ++i) {
            try {
                FileUtils.executeCopy(sourceDir, targetDir, file[i].getCanonicalFile());
                continue;
            }
            catch (IOException e) {
                ToolLoggerFactory.getLogger(FileUtils.class).error("Copy file failed", (Throwable)e);
            }
        }
    }

    public static void copyDirThrowEx(String sourceDir, String targetDir) throws Exception {
        FileUtils.createDir(targetDir);
        File[] file = new File(sourceDir).listFiles();
        if (file == null) {
            return;
        }
        for (int i = 0; i < file.length; ++i) {
            FileUtils.executeCopyThrowEx(sourceDir, targetDir, file[i]);
        }
    }

    public static void copyDirThrowEx(String sourceDir, String targetDir, StreamStatusOperator streamOperator) throws Exception {
        if (VerifyUtil.isEmpty(streamOperator)) {
            FileUtils.copyDirThrowEx(sourceDir, targetDir);
            return;
        }
        if (streamOperator.isManualTerminated()) {
            return;
        }
        FileUtils.createDir(targetDir);
        File[] file = new File(sourceDir).listFiles();
        if (file == null) {
            return;
        }
        for (int i = 0; i < file.length; ++i) {
            FileUtils.executeCopyThrowEx(sourceDir, targetDir, file[i], streamOperator);
        }
    }

    private static void executeCopyThrowEx(String sourceDir, String targetDir, File file) throws Exception {
        if (file.isFile()) {
            File targetFile = new File(new File(targetDir).getCanonicalPath() + File.separator + file.getName());
            StreamUtils.copyFileThrowEx(file, targetFile);
        } else if (file.isDirectory() && !file.isHidden()) {
            String dir1 = sourceDir + File.separator + file.getName();
            String dir2 = targetDir + File.separator + file.getName();
            FileUtils.copyDirThrowEx(dir1, dir2);
        }
    }

    private static void executeCopyThrowEx(String sourceDir, String targetDir, File file, StreamStatusOperator streamOperator) throws Exception {
        if (file.isFile()) {
            File targetFile = new File(new File(targetDir).getCanonicalPath() + File.separator + file.getName());
            StreamUtils.copyFileThrowEx(file, targetFile, streamOperator);
        } else if (file.isDirectory() && !file.isHidden()) {
            String dir1 = sourceDir + File.separator + file.getName();
            String dir2 = targetDir + File.separator + file.getName();
            FileUtils.copyDirThrowEx(dir1, dir2, streamOperator);
        }
    }

    public static void deleteAllInFolder(String path) {
        File[] excludeFiles = new File[]{};
        FileUtils.deleteAllInFolder(path, excludeFiles);
    }

    public static void deleteFile(String path) {
        File file = new File(path);
        if (!file.exists()) {
            return;
        }
        FileUtils.deleteFile(file);
    }

    public static void deleteFile(File file) {
        if (file.isDirectory()) {
            File[] fileList = file.listFiles();
            if (fileList == null) {
                return;
            }
            for (File tmpFile : fileList) {
                FileUtils.deleteFile(tmpFile);
            }
            if (!file.delete()) {
                ToolLoggerFactory.getLogger(FileUtils.class).error("Delete file error" + file.toString().replace('\n', '_').replace('\r', '_'));
            }
        } else if (!file.delete()) {
            ToolLoggerFactory.getLogger(FileUtils.class).error("Delete file error" + file.toString().replace('\n', '_').replace('\r', '_'));
        }
    }

    public static boolean deleteDirectory(String path) {
        try {
            MoreFiles.deleteRecursively((Path)Paths.get(path, new String[0]), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
            ToolLoggerFactory.getLogger(FileUtils.class).error("try to delete path {} success", (Object)path);
            return true;
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(FileUtils.class).error("try to delete path {} failed", (Object)path, (Object)e);
            return false;
        }
    }

    public static void deleteAndKeepFile(String folder, int keepSize) {
        File file = new File(folder);
        if (file.isDirectory()) {
            File[] files = file.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isFile();
                }
            });
            if (files == null || files.length == 0) {
                return;
            }
            int totalSize = FileUtils.calculateFilesSize(keepSize, files);
            FileUtils.sortFileByTime(files);
            int index = 0;
            while (totalSize > keepSize && index < files.length) {
                File fileTemp = files[index++];
                totalSize = (int)((long)totalSize - fileTemp.length());
                FileUtils.deleteTempFile(fileTemp);
            }
        }
    }

    public static void mkJarInCi(String path, String name) {
        File file;
        File filePath = new File(path);
        if (!filePath.exists()) {
            filePath.mkdirs();
        }
        if (!(file = new File(path, name)).exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                ToolLoggerFactory.getLogger(FileUtils.class).error("create file error" + file, (Throwable)e);
            }
        }
    }

    private static void deleteTempFile(File fileTemp) {
        File fileDelete = null;
        try {
            fileDelete = fileTemp.getCanonicalFile();
            if (!fileDelete.delete()) {
                ToolLoggerFactory.getLogger(FileUtils.class).error("Delete file failed.");
            }
        }
        catch (IOException e) {
            ToolLoggerFactory.getLogger(FileUtils.class).error("Delete file failed.", (Throwable)e);
        }
    }

    private static int calculateFilesSize(int keepSize, File[] files) {
        int totalSize = 0;
        for (File fileTemp : files) {
            if (fileTemp.length() > (long)keepSize) {
                FileUtils.deleteTempFile(fileTemp);
                continue;
            }
            totalSize = (int)((long)totalSize + fileTemp.length());
        }
        return totalSize;
    }

    public static void sortFileByTime(Object obj) {
        if (obj == null) {
            return;
        }
        if (List.class.isInstance(obj)) {
            Collections.sort((List)obj, new FileComp());
        }
        if (obj instanceof File[]) {
            Arrays.sort((File[])obj, new FileComp());
        }
    }

    private static boolean needExclude(File tmpFile, File[] excludeFiles) {
        if (null == excludeFiles || excludeFiles.length < 1) {
            return false;
        }
        for (File file : excludeFiles) {
            if (!file.equals(tmpFile)) continue;
            return true;
        }
        return false;
    }

    public static void deleteAllInFolder(String path, File[] excludeFiles) {
        File dir = new File(path);
        if (!dir.exists()) {
            ToolLoggerFactory.getLogger(FileUtils.class).error(dir + " is not exist.");
            return;
        }
        if (!dir.isDirectory()) {
            ToolLoggerFactory.getLogger(FileUtils.class).error(dir + " is not a directory.");
            return;
        }
        File[] fileList = dir.listFiles();
        if (fileList == null) {
            return;
        }
        for (File tmpFile : fileList) {
            if (FileUtils.needExclude(tmpFile, excludeFiles)) continue;
            FileUtils.deleteFile(tmpFile);
        }
    }

    public static void copyDir(String sourceDir, String targetDir, File[] excludeFiles) {
        FileUtils.createDir(targetDir);
        File[] file = new File(sourceDir).listFiles();
        if (file == null) {
            return;
        }
        for (int i = 0; i < file.length; ++i) {
            if (FileUtils.needExclude(file[i], excludeFiles)) continue;
            FileUtils.executeCopy(sourceDir, targetDir, file[i]);
        }
    }

    private static void executeCopy(String sourceDir, String targetDir, File file) {
        if (file.isFile()) {
            String safeDir = FilePathUtils.getSafePath(targetDir);
            File targetFile = new File(safeDir + File.separator + file.getName());
            StreamUtils.copyFile(file, targetFile);
        } else if (file.isDirectory() && !file.isHidden()) {
            String dir1 = sourceDir + File.separator + file.getName();
            String dir2 = targetDir + File.separator + file.getName();
            FileUtils.copyDir(dir1, dir2);
        }
    }

    public static boolean isDiskFull(String filePath, long fileSize) {
        File file = new File(filePath);
        long freeSpace = 0L;
        try {
            if (!file.exists()) {
                boolean create = file.createNewFile();
                freeSpace = file.getFreeSpace();
                boolean delete = new File(filePath).delete();
                ToolLoggerFactory.getLogger(FileUtils.class).info("create new file error" + create + "delete new file error!" + delete);
            } else {
                freeSpace = file.getFreeSpace();
            }
            ToolLoggerFactory.getLogger(FileUtils.class).info("freeSpace size:{}", (Object)freeSpace);
        }
        catch (IOException e) {
            ToolLoggerFactory.getLogger(FileUtils.class).error("create new file error", (Throwable)e);
            return false;
        }
        return freeSpace > fileSize;
    }

    public static boolean isDiskSpaceFull(String filePath, InputStream ins) {
        long fileSize = 0L;
        try {
            fileSize = ins.available();
        }
        catch (IOException e1) {
            ToolLoggerFactory.getLogger(FileUtils.class).error("File does not exist", (Throwable)e1);
            return false;
        }
        return FileUtils.isDiskFull(filePath, fileSize);
    }

    public static void setFilePermissions(String filePath) {
        FileUtils.setFilePermissions(new File(filePath));
    }

    public static void setFilePermissions(File file) {
        if (!ApplicationContext.getInstance().isWindowsOS()) {
            log.warn("not windows, don't need set file permissions");
            return;
        }
        if (null == file || !file.exists()) {
            String errMsg = null == file ? "the file is not set!" : file.toString();
            ToolLoggerFactory.getLogger(FileUtils.class).info("Set file permissions failed." + errMsg);
            return;
        }
        String path = "";
        try {
            path = file.getCanonicalPath();
            String userAccount = ApplicationContext.getInstance().getCurToolkitUser();
            String allUserGroup = OSCmdUtils.executeCmd("net localgroup");
            allUserGroup = allUserGroup.substring(allUserGroup.indexOf("*Administrators"), allUserGroup.lastIndexOf("*Users") + 6);
            String[] groups = allUserGroup.split("\r\n");
            FileUtils.setPermissions(path, userAccount, groups);
            ToolLoggerFactory.getLogger(FileUtils.class).info("Set file permissions success!");
        }
        catch (IOException e) {
            ToolLoggerFactory.getLogger(FileUtils.class).error("cannonical path if failed", (Throwable)e);
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(FileUtils.class).error("catch exception when setPermissions", (Throwable)e);
        }
    }

    private static void setPermissions(String path, String userAccount, String[] groups) {
        StringBuffer cmdBuf = new StringBuffer();
        cmdBuf.append("icacls \"").append(path).append('\"').append(" /inheritance:d").append(' ');
        for (String string : groups) {
            if (!(string = string.replace("*", "").trim()).contains("user") && !string.contains("guest") && !string.contains("User") && !string.contains("Guest")) continue;
            cmdBuf.append("/remove:g \"").append(string).append('\"').append(' ');
        }
        cmdBuf.append("/remove:g \"Authenticated users\"").append(' ');
        cmdBuf.append("/grant Administrators:f").append(' ');
        cmdBuf.append("/grant \"china\\").append(userAccount).append("\":f").append(' ');
        cmdBuf.append("/grant \"").append(userAccount).append("\":f");
        OSCmdUtils.executeCmd(cmdBuf.toString());
    }

    public static boolean fileSizeInvalid(File file, long maxSize) {
        if (null == file) {
            return false;
        }
        return file.length() <= maxSize;
    }

    public static boolean fileSize2GInvalid(File file) {
        return FileUtils.fileSizeInvalid(file, 0x80000000L);
    }

    public static boolean fileSize4GInvalid(File file) {
        return FileUtils.fileSizeInvalid(file, 0x100000000L);
    }

    public static void setLogsPermissions() {
        String path = ApplicationContext.getInstance().getRunnigLogPath() + File.separator + "log" + File.separator;
        File file = new File(path + ApplicationContext.getInstance().getCurToolkitUser());
        try {
            String autStr = "CMD /C echo Y|cacls \"" + file.getCanonicalPath() + "\" /T /G " + ApplicationContext.getInstance().getCurToolkitUser() + ":F administrators:F";
            String result = OSCmdUtils.executeCmd(autStr);
            ToolLoggerFactory.getLogger(FileUtils.class).info("Set file:" + path + FileUtils.cryptonymHandle(ApplicationContext.getInstance().getCurToolkitUser()) + "process:" + result);
        }
        catch (IOException e) {
            ToolLoggerFactory.getLogger(FileUtils.class).error("set log permission error.", (Throwable)e);
        }
    }

    public static String filterLogIfComputerName(String log) {
        if (StringUtils.isNULLStr(log)) {
            ToolLoggerFactory.getLogger(FileUtils.class).error("input log is null.");
            return "";
        }
        StringBuffer result = new StringBuffer();
        String computerName = ApplicationContext.getInstance().getCurToolkitUser();
        String logUpper = log.toUpperCase();
        logUpper = logUpper.replace(computerName.toUpperCase(), FileUtils.cryptonymHandle(computerName));
        int logLen = log.length();
        if (logLen != logUpper.length()) {
            ToolLoggerFactory.getLogger(FileUtils.class).error("logLen not equals logUpper len.");
            return logUpper;
        }
        for (int i = 0; i < logLen; ++i) {
            String upperLogTemp;
            String logTemp = String.valueOf(log.charAt(i));
            if (logTemp.equalsIgnoreCase(upperLogTemp = String.valueOf(logUpper.charAt(i)))) {
                result.append(log.charAt(i));
                continue;
            }
            result.append("*");
        }
        return result.toString();
    }

    public static String cryptonymHandle(String input) {
        StringBuffer sb = new StringBuffer();
        if (null == input) {
            ToolLoggerFactory.getLogger(FileUtils.class).error("input log is null.");
            return "";
        }
        int len = input.length();
        for (int i = 0; i < len; ++i) {
            if (0 == i || 1 == i) {
                sb.append(input.charAt(i));
                continue;
            }
            if (len - 2 == i || len - 1 == i) {
                sb.append(input.charAt(i));
                continue;
            }
            sb.append("*");
        }
        return sb.toString();
    }

    public static FileLock getFileLock(File file, RandomAccessFile out) {
        FileChannel fcout = out.getChannel();
        int count = 6;
        while (count > 0) {
            try {
                --count;
                Thread.sleep(50L);
                FileLock lock = fcout.lock();
                if (lock == null || !lock.isValid()) continue;
                return lock;
            }
            catch (IOException e) {
                LoggerFactory.getLogger(FileUtils.class).error("access file lock error!", (Throwable)e);
            }
            catch (Exception e) {
                LoggerFactory.getLogger(FileUtils.class).error("access file lock error!", (Throwable)e);
            }
        }
        return null;
    }

    public static void deleteAndReleaseLock(String fileName, FileLock lock) {
        try {
            FileUtils.releaseFileLock(lock);
            UserOpDataSaveUtil.deleteFileLock(new File(fileName));
        }
        catch (Exception e) {
            LoggerFactory.getLogger(FileUtils.class).error("delete error!", (Throwable)e);
        }
    }

    public static FileLock getFileLock(String fileName, boolean isCreateIfNotExists) {
        if (fileName == null) {
            return null;
        }
        File file = new File(fileName);
        RandomAccessFile randomAccessFile = null;
        try {
            if (isCreateIfNotExists && !file.exists() && !file.createNewFile()) {
                ToolLoggerFactory.getLogger(FileUtils.class).error("Creat file error" + file.getName());
            }
            if (!file.isFile()) {
                throw new IllegalArgumentException("File does not exists or is not a file!");
            }
            randomAccessFile = new RandomAccessFile(file, RW);
            FileLock fileLock = FileUtils.getFileLock(file, randomAccessFile);
            return fileLock;
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("File does not exists or is not a file!", e);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("File does not exists or is not a file!", e);
        }
        finally {
            if (null != randomAccessFile) {
                try {
                    randomAccessFile.close();
                }
                catch (IOException exp) {
                    LoggerFactory.getLogger(FileUtils.class).error("close stream error!", (Throwable)exp);
                }
            }
        }
    }

    public static FileLock getFileLock(String fileName) {
        if (fileName == null) {
            return null;
        }
        File file = new File(fileName);
        if (!file.exists() || !file.isFile()) {
            throw new IllegalArgumentException("File does not exists or is not a file!");
        }
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, RW);
            FileLock fileLock = FileUtils.getFileLock(file, randomAccessFile);
            return fileLock;
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("File does not exists or is not a file!");
        }
        finally {
            if (null != randomAccessFile) {
                try {
                    randomAccessFile.close();
                }
                catch (IOException e) {
                    ToolLoggerFactory.getLogger(FileUtils.class).error(e.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean isFileLocked(File file) {
        if (!file.exists()) {
            return false;
        }
        FileLock lock = null;
        RandomAccessFile fos = null;
        try {
            fos = new RandomAccessFile(file, RW);
            lock = fos.getChannel().tryLock();
            if (null == lock || !lock.isValid()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (RuntimeException e) {
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean bl = true;
            return bl;
        }
        finally {
            if (null != lock) {
                try {
                    lock.release();
                }
                catch (IOException e) {
                    LoggerFactory.getLogger(FileUtils.class).error("release file lock failed!" + e);
                }
            }
            try {
                if (null != fos) {
                    fos.close();
                }
            }
            catch (IOException e) {
                LoggerFactory.getLogger(FileUtils.class).error("close the file fos failed" + e);
            }
        }
    }

    public static File getAndCreateFile(String fileLoc) {
        File file = new File(fileLoc);
        if (!file.exists()) {
            try {
                if (!file.createNewFile()) {
                    ToolLoggerFactory.getLogger(FileUtils.class).error("Creat file error" + file.getName());
                }
            }
            catch (IOException e) {
                ToolLoggerFactory.getLogger(FileUtils.class).error("getFile error", (Throwable)e);
            }
        }
        return file;
    }

    public static void releaseFileLock(FileLock lock) {
        if (lock == null) {
            return;
        }
        try {
            lock.release();
        }
        catch (Exception e) {
            LoggerFactory.getLogger(FileUtils.class).error("release file lock error!", (Throwable)e);
        }
        finally {
            try {
                lock.close();
            }
            catch (IOException e) {
                ToolLoggerFactory.getLogger(FileUtils.class).error("close lock exception", (Throwable)e);
            }
        }
    }

    public static InputStream getStreamWithObj(Class<?> obj, String filePath) {
        ClassLoader loader = obj.getClassLoader();
        if (loader == null) {
            throw new EncapsulatedRuntimeException("cannot get the class loader.");
        }
        InputStream stream = loader.getResourceAsStream(filePath);
        if (stream == null) {
            throw new EncapsulatedRuntimeException("cannot get the stream.");
        }
        return stream;
    }

    public static boolean isFileNameInvalid(File file) {
        return file.getName().contains("..");
    }

    public static String getFileName(String path) {
        if (StringUtils.isNULLStr(path)) {
            return "";
        }
        String trimmedPath = path.trim();
        if (trimmedPath.contains("/")) {
            return trimmedPath.substring(trimmedPath.lastIndexOf("/") + 1);
        }
        if (trimmedPath.contains("\\")) {
            return trimmedPath.substring(trimmedPath.lastIndexOf("\\") + 1);
        }
        return trimmedPath;
    }

    public static boolean isNormalPath(String path) {
        String normalizedPath = path.replaceAll("\\\\", "").replaceAll("/", "").replaceAll(":", "").replaceAll("\\.", "");
        if (normalizedPath.contains("  ")) {
            return false;
        }
        return normalizedPath.matches("[\\w ]+");
    }

    public static File getDefaultDirectory() {
        File file = FileSystemView.getFileSystemView().getDefaultDirectory();
        if (!FileUtils.isNormalPath(FilePathUtils.getCanonicalPath(file))) {
            file = FileUtils.buildWithOsSystem();
        }
        return file;
    }

    @NotNull
    private static File buildWithOsSystem() {
        if (ApplicationContext.getInstance().isWindowsOS()) {
            return new File(FilePathUtils.checkFile(System.getProperty("java.io.tmpdir")));
        }
        File file = new File(System.getProperty("user.dir"));
        if (!FileUtils.isNormalPath(FilePathUtils.getCanonicalPath(file))) {
            String tmpdir = FilePathUtils.checkFile(System.getProperty("java.io.tmpdir"));
            file = new File(tmpdir);
        }
        return file;
    }

    public static boolean createJavaIoTmpDir(String tmpDir) {
        String actualTmpDir = FilePathUtils.getSafePath(tmpDir);
        File eServiceFile = new File(actualTmpDir, "eService.exe");
        if (eServiceFile.exists()) {
            ToolLoggerFactory.getLogger(FileUtils.class).info("eService.exe exists.");
            return false;
        }
        boolean createSucc = true;
        File tmpDirFile = new File(actualTmpDir);
        if (!tmpDirFile.exists()) {
            createSucc = tmpDirFile.mkdirs();
        } else {
            ToolLoggerFactory.getLogger(FileUtils.class).info(actualTmpDir + " exists.");
        }
        System.setProperty("java.io.tmpdir", actualTmpDir);
        return createSucc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getTempFileFromInputStream(InputStream ins, String fileName) {
        if (ins == null || fileName == null) {
            return null;
        }
        FileOutputStream outputStream = null;
        try {
            Boolean fileDeleted;
            String systemTempPath = System.getProperty("java.io.tmpdir");
            String newPath = systemTempPath + File.separator + fileName;
            File file = new File(newPath);
            if (file.exists() && !(fileDeleted = Boolean.valueOf(file.delete())).booleanValue()) {
                log.error("delete temp file failed: " + StringUtils.getCleanMessage(newPath));
                throw new IOException("delete temp file failed: " + newPath);
            }
            outputStream = new FileOutputStream(file);
            int byteCount = 0;
            byte[] bytes = new byte[1024];
            while ((byteCount = ins.read(bytes)) != -1) {
                ((OutputStream)outputStream).write(bytes, 0, byteCount);
            }
            File file2 = file;
            StreamUtils.closeStream(outputStream, ins);
            return file2;
        }
        catch (IOException e) {
            log.error("read file exception", (Object)StringUtils.getCleanMessage(e.getMessage()));
        }
        finally {
            StreamUtils.closeStream(outputStream, ins);
        }
        return null;
    }

    public static boolean createFile(File file) throws IOException {
        if (file == null) {
            return false;
        }
        if (file.getParentFile() != null && !file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            log.warn("create parent dir {} fail.", (Object)file.getParent());
            return false;
        }
        return file.createNewFile();
    }

    public static class FileComp
    implements Comparator<File>,
    Serializable {
        private static final long serialVersionUID = -8303198023256290707L;
        private static final int EQUAL = 0;

        @Override
        public int compare(File o1, File o2) {
            if (o1 == null || o2 == null) {
                return 0;
            }
            return (int)(o1.lastModified() - o2.lastModified());
        }
    }
}

