/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.utils;

import com.huawei.ism.tool.base.utils.OSCmdUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import java.util.Locale;

public final class PingUtils {
    private PingUtils() {
    }

    public static String executeCmd(String cmd) {
        return OSCmdUtils.executeCmd(cmd);
    }

    private static void closeProcess(Process proc) {
        if (null != proc) {
            try {
                proc.destroy();
            }
            catch (Exception t) {
                ToolLoggerFactory.getLogger(PingUtils.class).error("proc destroy error", (Throwable)t);
            }
        }
    }

    public static boolean pingHost(String host) {
        String ret = "";
        ret = ApplicationContext.getInstance().isWindowsOS() ? PingUtils.executeCmd("ping " + host) : PingUtils.executeCmd(PingUtils.getPingCmd(host) + host + " -c 4");
        ToolLoggerFactory.getLogger(PingUtils.class).error("Result of ping " + host + ": " + ret);
        return PingUtils.checkLink(ret, host);
    }

    public static boolean fastPingHost(String host) {
        String cmd = "ping " + host;
        String trimString = host + " -c 4";
        cmd = ApplicationContext.getInstance().isWindowsOS() ? cmd + " -n 1 -w 2000" : PingUtils.getPingCmd(host) + trimString;
        String ret = PingUtils.executeCmd(cmd);
        ToolLoggerFactory.getLogger(PingUtils.class).error("Result of ping " + host + ": " + ret);
        return PingUtils.checkLink(ret, host);
    }

    public static boolean pingHostOnePacket(String host) {
        String cmd = "ping " + host;
        String trimString = host + " -c 4";
        cmd = ApplicationContext.getInstance().isWindowsOS() ? cmd + " -n 1" : PingUtils.getPingCmd(host) + trimString;
        String ret = PingUtils.executeCmd(cmd);
        ToolLoggerFactory.getLogger(PingUtils.class).error("Result of ping " + host + ": " + ret);
        return PingUtils.checkLink(ret, host);
    }

    public static String getPingCmd(String host) {
        String cmd = "";
        cmd = StringUtils.isValidIPV6(host) ? "ping6 " : "ping ";
        return cmd;
    }

    private static boolean checkLink(String ret, String ip) {
        if (ret.contains("TTL=")) {
            return true;
        }
        if (ret.contains("TTL =")) {
            return true;
        }
        if (ret.contains("TTL")) {
            return true;
        }
        if (ret.contains("ttl=")) {
            return true;
        }
        if (ret.toLowerCase(Locale.ENGLISH).contains("reply from") && !ret.toLowerCase(Locale.ENGLISH).contains("unreachable")) {
            return true;
        }
        return StringUtils.isIpv6Address(ip) && ret.contains("<");
    }
}

