/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.utils;

import com.huawei.ism.tool.base.utils.IpAddress;
import com.huawei.ism.tool.base.utils.KeyValue;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.reflection.ReflectionUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.runtime.SystemProperties;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.text.Normalizer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StringUtils {
    public static final String DOT = ".";
    public static final String NULL_IP_TEXT = " . . . ";
    private static final String REGEX_IPV6_ADDRESS = "^\\s*((([0-9A-Fa-f]{1,4}:){7}(([0-9A-Fa-f]{1,4})|:))|(([0-9A-Fa-f]{1,4}:){6}(:|((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})|(:[0-9A-Fa-f]{1,4})))|(([0-9A-Fa-f]{1,4}:){5}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(([0-9A-Fa-f]{1,4}:){4}(:[0-9A-Fa-f]{1,4}){0,1}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(([0-9A-Fa-f]{1,4}:){3}(:[0-9A-Fa-f]{1,4}){0,2}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(([0-9A-Fa-f]{1,4}:){2}(:[0-9A-Fa-f]{1,4}){0,3}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(([0-9A-Fa-f]{1,4}:)(:[0-9A-Fa-f]{1,4}){0,4}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(:(:[0-9A-Fa-f]{1,4}){0,5}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})))(%.+)?\\s*$";
    private static final Pattern IPV4_PATTERN = Pattern.compile("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}");
    private static final Pattern LOWERCASE_LETTER_REG = Pattern.compile("[a-z]");
    private static final Pattern UPPERCASE_LETTER_REG = Pattern.compile("[A-Z]");
    private static final Pattern NUMBER_REG = Pattern.compile("\\d");
    private static final Pattern SPECIAL_CHARACTER_REG = Pattern.compile("[`~!@#$%^&*()\\-_=+|\\[{}\\];:'\",<.>/?]");
    public static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final String TOOLSFOLDER = "tools";
    public static final String TIME_STYLE_yyyyMMddhhmmss = "yyyyMMddHHmmss";
    public static final String TIME_STYLE_yyyy_MM_ddhhmmss = "yyyy-MM-dd HH:mm:ss";
    public static final String TIME_STYLE_yyyy_MM_ddhhmmssz = "yyyy-MM-dd HH:mm:ss z";
    public static final String TIME_STYLE_hhmmss = "HH:mm:ss";
    public static final String TIME_STYLE_yyyy_MM_dd = "yyyy-MM-dd";

    private StringUtils() {
    }

    public static String convertMacToString(byte[] macArray) {
        if (null == macArray) {
            return null;
        }
        char[] src = new char[17];
        for (int offset = 0; offset < 5; ++offset) {
            src[offset * 3] = StringUtils.hexUpperChar(macArray[offset]);
            src[offset * 3 + 1] = StringUtils.hexLowerChar(macArray[offset]);
            src[offset * 3 + 2] = 58;
        }
        src[15] = StringUtils.hexUpperChar(macArray[5]);
        src[16] = StringUtils.hexLowerChar(macArray[5]);
        return new String(src);
    }

    public static String millls2FormatString(long duringTimingMills) {
        int secMillis;
        int minMillis;
        int hourMillis;
        long second = 1000L;
        long minutes = second * 60L;
        long hour = minutes * 60L;
        long day = hour * 24L;
        StringBuilder buffer = new StringBuilder();
        int dayMillis = (int)(duringTimingMills / day);
        if (dayMillis > 0) {
            buffer.append(ResourceUtil.getStringWithParams("day", dayMillis));
        }
        if ((hourMillis = (int)(duringTimingMills % day / hour)) > 0) {
            buffer.append(ResourceUtil.getStringWithParams("hour", hourMillis));
        }
        if ((minMillis = (int)(duringTimingMills % day % hour / minutes)) > 0) {
            buffer.append(ResourceUtil.getStringWithParams("min", minMillis));
        }
        if ((secMillis = (int)(duringTimingMills % day % hour % minutes / second)) > 0) {
            buffer.append(ResourceUtil.getStringWithParams("second", secMillis));
        }
        return buffer.toString();
    }

    private static char hexUpperChar(byte bite) {
        byte actualBite = (byte)(bite >> 4 & 0xF);
        if (actualBite == 0) {
            return '0';
        }
        if (actualBite < 10) {
            return (char)(48 + actualBite);
        }
        return (char)(97 + actualBite - 10);
    }

    private static char hexLowerChar(byte bite) {
        byte actualBite = (byte)(bite & 0xF);
        if (actualBite == 0) {
            return '0';
        }
        if (actualBite < 10) {
            return (char)(48 + actualBite);
        }
        return (char)(97 + actualBite - 10);
    }

    public static boolean ipTxtEmpty(String txtIp) {
        return null == txtIp || txtIp.isEmpty() || txtIp.equals(NULL_IP_TEXT);
    }

    public static boolean isSameSubnetIpv4(IpAddress addr1, IpAddress addr2) {
        long mask2;
        long ip2;
        long result2;
        long mask1;
        if (null == addr1 || null == addr2) {
            return false;
        }
        long ip1 = StringUtils.ip2long(addr1.getIp());
        long result1 = ip1 & (mask1 = StringUtils.ip2long(addr1.getMask()));
        return result1 == (result2 = (ip2 = StringUtils.ip2long(addr2.getIp())) & (mask2 = StringUtils.ip2long(addr2.getMask())));
    }

    public static boolean isNULLStr(String str) {
        return null == str || "".equals(str.trim());
    }

    public static boolean isNULLObjectOrNullStr(String str) {
        return null == str || "".equals(str.trim()) || "null".equals(str);
    }

    public static boolean isCorrectMac(String mac) {
        String regex = "[A-Fa-f0-9]{12}";
        return Normalizer.normalize(mac, Normalizer.Form.NFKC).matches(regex);
    }

    public static String getDefaultValueIfNull(String value, String defaultValue) {
        String result = defaultValue;
        if (null != value) {
            result = value;
        }
        return result;
    }

    public static boolean hasNULLStr(String ... strs) {
        for (String s : strs) {
            if (!StringUtils.isNULLStr(s)) continue;
            return true;
        }
        return false;
    }

    public static boolean isChinese(String str) {
        return Pattern.compile("[\u4e00-\u9fa5]").matcher(Normalizer.normalize(str, Normalizer.Form.NFKC)).find();
    }

    public static boolean containsChineseWithSymbol(String str) {
        Pattern chineseSymbolPattern = Pattern.compile("[\uff01\uff0c\u3002\uff08\uff09\u300a\u300b\u201c\u201d\uff1f\uff1a\uff1b\u3010\u3011]");
        return StringUtils.isChinese(str) || chineseSymbolPattern.matcher(str).find();
    }

    public static boolean isZero(String str) {
        return !StringUtils.isNULLStr(str) && "0".equals(str);
    }

    public static boolean isHundred(String str) {
        return !StringUtils.isNULLStr(str) && "100".equals(str);
    }

    public static int object2Int(Object obj) {
        if (obj instanceof Byte) {
            return ((Byte)obj).byteValue();
        }
        if (obj instanceof Short) {
            return ((Short)obj).shortValue();
        }
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        return -1;
    }

    public static int str2Int(String str) {
        if (null == str) {
            return -1;
        }
        try {
            int indexofDot = str.indexOf(DOT);
            return Integer.valueOf(-1 != indexofDot ? str.substring(0, indexofDot) : str);
        }
        catch (NumberFormatException e) {
            ToolLoggerFactory.getLogger(StringUtils.class).error("", (Throwable)e);
            return -1;
        }
    }

    public static int str2IntMuted(String str) {
        if (null == str) {
            return -1;
        }
        try {
            int indexofDot = str.indexOf(DOT);
            return Integer.valueOf(-1 != indexofDot ? str.substring(0, indexofDot) : str);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public static int str2Int(String str, int defaultValue) {
        if (-1 == StringUtils.str2Int(str)) {
            return defaultValue;
        }
        return StringUtils.str2Int(str);
    }

    public static long str2Long(String str) {
        if (StringUtils.isNULLStr(str)) {
            return -1L;
        }
        try {
            int indexofDot = str.indexOf(DOT);
            return Long.parseLong(-1 != indexofDot ? str.substring(0, indexofDot) : str);
        }
        catch (NumberFormatException e) {
            ToolLoggerFactory.getLogger(StringUtils.class).error("", (Throwable)e);
            return -1L;
        }
    }

    public static long str2Long(String str, long defaultValue) {
        if (-1L == StringUtils.str2Long(str)) {
            return defaultValue;
        }
        return StringUtils.str2Long(str);
    }

    public static String findMatchStr(String source, String regex) {
        return StringUtils.findMatchStr(source, regex, 1);
    }

    public static boolean hasMatchStr(String source, String regex) {
        String result = StringUtils.findMatchStr(source, regex, 0);
        return null != result && !result.isEmpty();
    }

    public static String findMatchStr(String source, String regex, int group) {
        if (null == regex) {
            throw new NullPointerException();
        }
        Pattern pattern = Pattern.compile(Normalizer.normalize(regex, Normalizer.Form.NFKC));
        Matcher matcher = pattern.matcher(source);
        if (matcher.find()) {
            return matcher.group(group);
        }
        return "";
    }

    public static boolean isFullIpAddress(String ipAdrress) {
        return StringUtils.isValidIPV4(ipAdrress);
    }

    public static boolean isValidIPV4(String ip) {
        if (!StringUtils.meetBasicIPV4Rules(ip)) {
            return false;
        }
        String[] str = ip.split("\\.");
        int ipField1 = Integer.parseInt(str[0]);
        if (1 <= ipField1 && 223 >= ipField1 && 127 != ipField1) {
            try {
                StringUtils.checkIPV4(ip);
                return true;
            }
            catch (Throwable t) {
                ToolLoggerFactory.getLogger(StringUtils.class).error("isValidIPV4 error.", t);
                return false;
            }
        }
        return false;
    }

    public static boolean isWeakPassword(String password) {
        List<Pattern> weakPattern = Arrays.asList(Pattern.compile("[a-z]"), Pattern.compile("[A-Z]"), Pattern.compile("\\d"), Pattern.compile("[`~!@#$%^&*()\\-_=+|\\[{}\\];:'\",<.>/?]"));
        return password.length() < 8 || weakPattern.stream().filter(pattern -> pattern.matcher(password).find()).count() < 2L;
    }

    public static boolean checkPasswordComplexity(String password) {
        List<Pattern> weakPattern = Arrays.asList(LOWERCASE_LETTER_REG, UPPERCASE_LETTER_REG, NUMBER_REG, SPECIAL_CHARACTER_REG);
        return password.length() >= 8 && weakPattern.stream().filter(pattern -> pattern.matcher(password).find()).count() >= 3L;
    }

    public static boolean meetBasicIPV4Rules(String ip) {
        return IPV4_PATTERN.matcher(ip).matches() && Arrays.stream(ip.split("\\.")).map(Integer::parseInt).noneMatch(num -> num > 255);
    }

    public static void checkIPV4(String ip) throws IllegalArgumentException {
        try {
            InetAddress.getByName(ip);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("wrong IP scope\uff1a" + ip, e);
        }
    }

    public static boolean allIsVaildIpv4(String ... ips) {
        for (String ip : ips) {
            if (StringUtils.isFullIpAddress(ip)) continue;
            return false;
        }
        return true;
    }

    public static boolean ipEqualsByBit(String ip1, String ip2) {
        if (null == ip1 || null == ip2) {
            return false;
        }
        if (StringUtils.allIsVaildIpv6(ip1, ip2)) {
            BigInteger ip1Bit = StringUtils.ipv6Str2Int(ip1);
            BigInteger ip2Bit = StringUtils.ipv6Str2Int(ip2);
            if (null == ip1Bit || null == ip2Bit) {
                return false;
            }
            return ip1Bit.equals(ip2Bit);
        }
        if (StringUtils.allIsVaildIpv4(ip1, ip2)) {
            return StringUtils.ipv4Str2Long(ip1) == StringUtils.ipv4Str2Long(ip2);
        }
        return false;
    }

    public static long ipv4Str2Long(String ip) throws IllegalArgumentException {
        StringUtils.checkIPV4(ip);
        String[] str = ip.split("\\.");
        long ipValue = 0L;
        for (int i = str.length - 1; i >= 0; --i) {
            int tmp = Integer.valueOf(str[i]);
            long longNumber = 0L;
            longNumber = (longNumber | (long)tmp) << 8 * (str.length - i - 1);
            ipValue |= longNumber;
        }
        return ipValue;
    }

    public static BigInteger ipv6Str2Int(String ip) {
        try {
            InetAddress add = InetAddress.getByName(ip);
            BigInteger bi = new BigInteger(add.getAddress());
            return bi;
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public static boolean allIsVaildIpv6(String ... ips) {
        for (String ip : ips) {
            if (StringUtils.isIpv6Address(ip)) continue;
            return false;
        }
        return true;
    }

    public static boolean isDigit(String s) {
        return StringUtils.str2IntMuted(s) != -1;
    }

    public static boolean isIpv6Address(String addr) {
        if (StringUtils.isNULLStr(addr)) {
            return false;
        }
        return StringUtils.isValidIPV6(addr);
    }

    public static boolean isValidIPV6(String ipv6) {
        if (null == ipv6) {
            return false;
        }
        Pattern pattern = Pattern.compile(REGEX_IPV6_ADDRESS);
        Matcher mat = pattern.matcher(ipv6);
        if (mat.matches()) {
            try {
                Inet6Address address = (Inet6Address)InetAddress.getByName(ipv6);
                if (null != address) {
                    return !address.isMulticastAddress() && !address.isLoopbackAddress() && !address.isAnyLocalAddress();
                }
                return false;
            }
            catch (UnknownHostException e) {
                return false;
            }
            catch (Exception e1) {
                return false;
            }
        }
        return false;
    }

    public static String fillValues(String src, Object ... args) {
        return MessageFormat.format(src, args);
    }

    public static String genNextIpAddr(String startIp) {
        if (!StringUtils.isFullIpAddress(startIp)) {
            return "";
        }
        String[] loca = startIp.split("\\.");
        Integer val = StringUtils.str2Int(loca[3]);
        String bakedIp = startIp.substring(0, startIp.lastIndexOf(46) + 1);
        return bakedIp + ((val = Integer.valueOf(val + 1)) > 254 ? 254 : val);
    }

    public static String genNextIpv6Addr(String startIp) {
        String[] loca = startIp.split(":");
        Integer val = Integer.valueOf(loca[loca.length - 1], 16) + 1;
        String bakedIp = startIp.substring(0, startIp.lastIndexOf(58) + 1);
        return bakedIp + Integer.toHexString(val > 65534 ? 65535 : val);
    }

    public static String genDigitString(int val, int num, boolean location) {
        StringBuilder str = new StringBuilder(String.valueOf(val));
        while (str.length() < num) {
            int locat = location ? 0 : str.length();
            str.insert(locat, "0");
        }
        return str.toString();
    }

    public static KeyValue<Boolean, String> checkIpMaskUnite(String ip, String mask) {
        String strMask = Long.toBinaryString(StringUtils.ip2long(mask));
        String strIp = Long.toBinaryString(StringUtils.ip2long(ip));
        int hostLength = 32 - strMask.indexOf("0");
        int ipLength = strIp.length();
        String hostStr = strIp.substring(ipLength - hostLength, ipLength);
        char[] strArray = hostStr.toCharArray();
        int strLen = strArray.length;
        if (1 == strLen) {
            return new KeyValue<Boolean, String>(false, String.valueOf(strArray[0]));
        }
        char firstChar = strArray[0];
        for (int i = 1; i < strLen; ++i) {
            if (firstChar == strArray[i]) continue;
            return new KeyValue<Boolean, Object>(true, null);
        }
        return new KeyValue<Boolean, String>(false, String.valueOf(firstChar));
    }

    public static boolean ipMaskBinaryCheck(String mask) {
        String[] arr;
        String regex = "[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}";
        String normalizedMask = Normalizer.normalize(mask, Normalizer.Form.NFKC);
        if (!normalizedMask.matches(regex)) {
            return false;
        }
        StringBuilder binMask = new StringBuilder();
        for (String m : arr = normalizedMask.split("\\.")) {
            if (StringUtils.str2Int(m) <= 255) continue;
            return false;
        }
        if (255 == StringUtils.str2Int(arr[3])) {
            return false;
        }
        for (String s : arr) {
            binMask.append(StringUtils.fillMask(Integer.toBinaryString(StringUtils.str2Int(s)).toCharArray()));
        }
        return -1 == binMask.indexOf("01");
    }

    public static char[] fillMask(char[] charArr) {
        int len = charArr.length;
        char[] eightBit = new char[]{'0', '0', '0', '0', '0', '0', '0', '0'};
        int startIndex = 8 - len;
        for (int i = 0; i < len; ++i) {
            eightBit[startIndex + i] = charArr[i];
        }
        return eightBit;
    }

    public static String toUpperHexString(int i) {
        String hex = Integer.toHexString(i);
        return hex.toUpperCase(Locale.ENGLISH);
    }

    public static boolean startIgnoreCase(String source, String header) {
        if (StringUtils.isNULLStr(source) || StringUtils.isNULLStr(header)) {
            return false;
        }
        return source.toLowerCase(Locale.ENGLISH).startsWith(header);
    }

    public static boolean isEmailAddress(String email) {
        if (StringUtils.isNULLStr(email)) {
            return false;
        }
        if (email.contains("..")) {
            return false;
        }
        return email.matches("^[\\w]+[\\w\\.]*+@(\\w+[.])+\\w+$");
    }

    public static String getDateFormat(String formatString) {
        String foramt = "";
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(formatString);
            foramt = sdf.format(new Date());
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(StringUtils.class).error("format date error.", (Throwable)e);
        }
        return foramt;
    }

    public static String safetyGetStr(String[] arr, int index) {
        if (arr.length > index) {
            return arr[index].trim();
        }
        return "";
    }

    public static String fillStr(String src, int maxLen, String fillChar) {
        StringBuffer buffer = new StringBuffer(src);
        while (buffer.length() < maxLen) {
            buffer.append(fillChar);
        }
        return buffer.toString();
    }

    public static String formatDate(Object date, String formatStyle) {
        String foramt = "";
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(formatStyle);
            if (date instanceof Calendar) {
                return sdf.format(((Calendar)date).getTime());
            }
            foramt = sdf.format(date);
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(StringUtils.class).error("format date error.", (Throwable)e);
        }
        return foramt;
    }

    public static long parseDate2Long(String dateStr, String dateStrStyle) {
        SimpleDateFormat format = new SimpleDateFormat(dateStrStyle);
        try {
            format.setLenient(false);
            Date date = format.parse(dateStr);
            return date.getTime();
        }
        catch (ParseException e) {
            ToolLoggerFactory.getLogger(StringUtils.class).error("parseDate2Long error.", (Throwable)e);
            return 0L;
        }
    }

    public static String deleteFirstLast(String str) {
        if (StringUtils.isNULLStr(str)) {
            return "";
        }
        StringBuilder sbr = new StringBuilder(str);
        sbr.deleteCharAt(0);
        sbr.deleteCharAt(sbr.length() - 1);
        return sbr.toString();
    }

    public static long ip2long(String ipAddress) {
        String regex = "\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}";
        if (!ipAddress.matches(regex)) {
            return 0L;
        }
        String[] strVals = ipAddress.split("\\.");
        int sectLength = strVals.length;
        long val = 0L;
        for (String s : strVals) {
            long sect = StringUtils.str2Long(s);
            int bit = 8 * (sectLength - 1);
            val += sect << bit;
            --sectLength;
        }
        return val;
    }

    public static String getFirstPk() {
        StringBuffer pk = new StringBuffer();
        pk.append("bd");
        pk.append("401a");
        return pk.toString();
    }

    public static String getFirstRsaKey() {
        StringBuffer rsaKey = new StringBuffer();
        rsaKey.append("MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAhFZjry7nN");
        rsaKey.append("XtnCtp6sT2FbpN+RTuU+LnzSNawdKXA4zOu23hJ6mQyOsK0A9ZpoHbIBP1XUKyK");
        return rsaKey.toString();
    }

    public static String long2ip(long val) {
        long s1 = val >> 24;
        long s2 = val >> 16 & 0xFFL;
        long s3 = val >> 8 & 0xFFL;
        long s4 = val & 0xFFL;
        return s1 + DOT + s2 + DOT + s3 + DOT + s4;
    }

    public static String getNoStripUUID() {
        UUID uuid = UUID.randomUUID();
        String string = uuid.toString();
        return string.replaceAll("-", "");
    }

    public static String toString(Object object) {
        if (null == object) {
            return "";
        }
        return object.toString();
    }

    public static String maskPassword(String inStr) {
        String strMask = "******";
        String str = inStr;
        try {
            KeyValue<Integer, Integer> pos = StringUtils.getPasswordPos(0, str);
            while (null != pos) {
                int start = pos.getKey();
                int end = pos.getValue();
                str = str.substring(0, start) + strMask + str.substring(end + 1);
                int nextStartPos = start + strMask.length();
                pos = StringUtils.getPasswordPos(nextStartPos, str);
            }
            return str;
        }
        catch (RuntimeException e) {
            ToolLoggerFactory.getLogger(StringUtils.class).error("mask pwd error.");
            return strMask;
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(StringUtils.class).error("mask pwd error.");
            return strMask;
        }
    }

    public static boolean getCheckItemValue(String value) {
        boolean flag = false;
        String userDir = ApplicationContext.getInstance().getWorkPath();
        String workPath = "";
        try {
            int index = userDir.lastIndexOf(TOOLSFOLDER);
            workPath = index != -1 ? userDir.substring(0, index) : userDir;
            ToolLoggerFactory.getLogger(StringUtils.class).info("the current work path is :" + workPath.replace('\n', '_').replace('\r', '_'));
            SystemProperties appConfigs = new SystemProperties(workPath);
            flag = "true".equalsIgnoreCase(appConfigs.getValue(value));
        }
        catch (MissingResourceException e) {
            ToolLoggerFactory.getLogger(StringUtils.class).error("Can not find the key from system.properties:" + value);
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(StringUtils.class).error("Find other exception:", (Throwable)e);
        }
        ToolLoggerFactory.getLogger(StringUtils.class).info(value + ":" + flag);
        return flag;
    }

    private static KeyValue<Integer, Integer> getPasswordPos(int startPos, String strCmd) {
        int end;
        String str = strCmd.toLowerCase(Locale.ENGLISH);
        String[] pwdArr = new String[]{"password", "pass", "pwd", "secretkey", "isverifysshhostkey", "isverifycert", "sshhostkey", "-p"};
        boolean found = false;
        int foundPos = Integer.MAX_VALUE;
        String foundKey = "";
        for (int j = 0; j < pwdArr.length; ++j) {
            int i = str.indexOf(pwdArr[j], startPos);
            if (i < 0 || i >= foundPos) continue;
            found = true;
            foundPos = i;
            foundKey = pwdArr[j];
        }
        if (!found) {
            return null;
        }
        int start = foundPos + foundKey.length() + 1;
        if ("-p".equals(foundKey)) {
            --start;
        }
        if ((end = strCmd.indexOf(";; ", start)) < 0) {
            int p;
            int m = strCmd.indexOf("\",\"", start);
            int n = p = strCmd.indexOf("\"}", start);
            while (p > 0 && strCmd.charAt(p - 1) == '\\') {
                int s = p + "\"}".length();
                if ((p = strCmd.indexOf("\"}", s)) <= 0) continue;
                n = p;
            }
            int n2 = end = m >= 0 && m < n || n < 0 ? m : n;
            if (end > 0) {
                start += ":\"".length();
            }
        }
        if (end > 0) {
            --end;
        } else if (end < 0) {
            end = strCmd.length() - 1;
        }
        return new KeyValue<Integer, Integer>(start, end);
    }

    public static String cleanPwd(String pwd) {
        try {
            if (null == pwd) {
                return pwd;
            }
            Field stringValue = String.class.getDeclaredField("value");
            ReflectionUtils.setAccessable(stringValue, true);
            char[] pwdChar = (char[])stringValue.get(pwd);
            for (int i = 0; i < pwdChar.length; ++i) {
                pwdChar[i] = 63;
            }
            ReflectionUtils.setAccessable(stringValue, false);
        }
        catch (RuntimeException e) {
            ToolLoggerFactory.getLogger(StringUtils.class).error("Clean pwd RuntimeException...", (Throwable)e);
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(StringUtils.class).error("Clean pwd Exception...", (Throwable)e);
        }
        return pwd;
    }

    public static String formatDateStr(String dateStr) {
        String resultStr = "";
        if (!StringUtils.isNULLStr(dateStr)) {
            try {
                DateTimeFormatter formatter = DateTimeFormatter.BASIC_ISO_DATE;
                LocalDate formatted = LocalDate.parse(dateStr, formatter);
                resultStr = formatted == null ? "" : formatted.toString();
            }
            catch (Exception e) {
                ToolLoggerFactory.getLogger(StringUtils.class).error("dateStr parse date is error!dateStr:" + dateStr, (Throwable)e);
            }
        }
        return resultStr;
    }

    public static String getCleanMessage(String message) {
        if (message == null) {
            return "";
        }
        return Normalizer.normalize(message, Normalizer.Form.NFKC).replaceAll("[\r\n\f\b\u007f\u000b]", "");
    }

    public static String parseIpFromStr(String input) {
        if (StringUtils.isNULLStr(input)) {
            return "";
        }
        Matcher matcher = IPV4_PATTERN.matcher(input);
        if (matcher.find()) {
            return matcher.group();
        }
        Matcher ipv6Mather = IPV4_PATTERN.matcher(input);
        if (ipv6Mather.matches()) {
            return ipv6Mather.group();
        }
        return "";
    }
}

