/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.utils;

import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class ThreadPool {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ThreadPool.class);
    ExecutorService _asyncExcutor = new ThreadPoolExecutor(2, 256, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    private ExecutorService _newCachedExcutor = Executors.newCachedThreadPool();
    private static ThreadPool _instance = new ThreadPool();
    private ReavedTask reavedTask = new ReavedTask();

    private ThreadPool() {
        this._newCachedExcutor.execute(this.reavedTask);
    }

    public static ThreadPool getInstance() {
        return _instance;
    }

    public void execute(Runnable command) {
        this._newCachedExcutor.execute(command);
    }

    public <T> Future<T> submit(Callable<T> task) {
        return this._newCachedExcutor.submit(task);
    }

    public void executeAndLogException(Runnable command) {
        this.executeAndLogException(command, null);
    }

    public void reaveExecute(Runnable command) {
        this.reavedTask.setCommand(command);
    }

    public void executeAndLogException(Runnable command, String taskName) {
        MyCUstCommand task = new MyCUstCommand(command, taskName);
        this._newCachedExcutor.execute(task);
    }

    static final class ReavedTask
    implements Runnable {
        Runnable command;
        long num = 0L;

        ReavedTask() {
        }

        public synchronized void setCommand(Runnable command) {
            this.command = command;
            this.notifyAll();
        }

        @Override
        public void run() {
            Thread.currentThread().setName("ReavedTask");
            while (true) {
                this.toRun();
            }
        }

        private synchronized void toRun() {
            try {
                while (null == this.command) {
                    this.wait();
                }
                Runnable tmpCmd = this.command;
                this.command = null;
                tmpCmd.run();
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("ReavedTask execute times: " + this.num++);
                }
            }
            catch (RuntimeException e) {
                LOGGER.error(e.getMessage());
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
            }
        }
    }

    private static final class MyCUstCommand
    implements Runnable {
        private final Runnable command;
        private final String taskName;

        private MyCUstCommand(Runnable command, String taskName) {
            this.command = command;
            this.taskName = taskName;
        }

        @Override
        public void run() {
            String oldName = Thread.currentThread().getName();
            try {
                if (this.taskName != null) {
                    Thread.currentThread().setName(this.taskName);
                }
                this.command.run();
            }
            catch (Exception e) {
                LOGGER.error("Task :" + this.taskName, (Throwable)e);
            }
            finally {
                Thread.currentThread().setName(oldName);
            }
        }
    }
}

