/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.utils.aescache;

import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

public class DelayedItem<K>
implements Delayed {
    private K itemKey;
    private long liveTime;
    private long removeTime;

    public DelayedItem(K itemKey, long liveTime) {
        this.setItemKey(itemKey);
        this.liveTime = liveTime;
        this.removeTime = TimeUnit.NANOSECONDS.convert(liveTime, TimeUnit.NANOSECONDS) + System.nanoTime();
    }

    public K getItemKey() {
        return this.itemKey;
    }

    public void setItemKey(K itemKey) {
        this.itemKey = itemKey;
    }

    @Override
    public int compareTo(Delayed delayed) {
        if (delayed == null) {
            return 1;
        }
        if (delayed == this) {
            return 0;
        }
        if (delayed instanceof DelayedItem) {
            DelayedItem tmpDelayedItem = (DelayedItem)delayed;
            if (this.liveTime > tmpDelayedItem.liveTime) {
                return 1;
            }
            if (this.liveTime == tmpDelayedItem.liveTime) {
                return 0;
            }
            return -1;
        }
        long diff = this.getDelay(TimeUnit.NANOSECONDS) - delayed.getDelay(TimeUnit.NANOSECONDS);
        return diff > 0L ? 1 : (diff == 0L ? 0 : -1);
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.removeTime - System.nanoTime(), unit);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.liveTime ^ this.liveTime >>> 32);
        result = 31 * result + (int)(this.removeTime ^ this.removeTime >>> 32);
        result = 31 * result + (this.itemKey == null ? 0 : this.itemKey.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DelayedItem other = (DelayedItem)obj;
        if (this.liveTime != other.liveTime) {
            return false;
        }
        if (this.removeTime != other.removeTime) {
            return false;
        }
        return !(this.itemKey == null ? other.itemKey != null : !this.itemKey.equals(other.itemKey));
    }

    public String toString() {
        return "DelayedItem [itemKey=" + this.itemKey + ", liveTime=" + this.liveTime + ", removeTime=" + this.removeTime + "]";
    }
}

