/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.validate;

import com.huawei.ism.tool.base.utils.ClassUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.validate.AbstractValidator;
import java.text.Normalizer;

public final class CommonValidators {

    public static class LargeThan
    extends AbstractValidator {
        @Override
        public boolean validate(Object object, String objectDesc, Object ... params) {
            if (null == object || params.length == 0) {
                return true;
            }
            Double val = null;
            Double givenVal = null;
            try {
                val = Double.valueOf(object.toString());
                givenVal = Double.valueOf(params[0].toString());
            }
            catch (NumberFormatException e) {
                return true;
            }
            if (val.compareTo(givenVal) <= 0) {
                super.setErrMsgKey("validate.error.largethan", objectDesc, params[0]);
                return false;
            }
            return true;
        }
    }

    public static class Max
    extends AbstractValidator {
        @Override
        public boolean validate(Object object, String objectDesc, Object ... params) {
            if (null == object || params.length == 0) {
                return true;
            }
            Double val = null;
            Double max = null;
            try {
                val = Double.valueOf(object.toString());
                max = Double.valueOf(params[0].toString());
            }
            catch (NumberFormatException e) {
                return true;
            }
            if (val.compareTo(max) > 0) {
                super.setErrMsgKey("validate.error.max", objectDesc, params[0]);
                return false;
            }
            return true;
        }
    }

    public static class MaxLength
    extends AbstractValidator {
        @Override
        public boolean validate(Object object, String objectDesc, Object ... params) {
            boolean b = true;
            if (null != object && object.toString().length() > Integer.parseInt((String)params[0])) {
                b = false;
                super.setErrMsgKey("validate.error.maxlength", objectDesc, params[0]);
            }
            return b;
        }
    }

    public static class Int
    extends AbstractValidator {
        @Override
        public boolean validate(Object object, String objectDesc, Object ... params) {
            String normalized;
            boolean b = true;
            if (null != object && !(normalized = Normalizer.normalize(object.toString(), Normalizer.Form.NFKC)).matches("[0-9]+")) {
                b = false;
                super.setErrMsgKey("validate.error.int", objectDesc);
            }
            return b;
        }
    }

    public static class NoChinese
    extends AbstractValidator {
        @Override
        public boolean validate(Object object, String objectDesc, Object ... params) {
            boolean b = true;
            if (null != object && !Normalizer.normalize(object.toString(), Normalizer.Form.NFKC).matches("[0-9a-zA-Z_-]*")) {
                b = false;
                super.setErrMsgKey("validate.error.contain.chinese", objectDesc);
            }
            return b;
        }
    }

    public static class Mask
    extends AbstractValidator {
        @Override
        public boolean validate(Object object, String objectDesc, Object ... params) {
            boolean b = true;
            if (null != object && !StringUtils.ipMaskBinaryCheck(object.toString())) {
                b = false;
                super.setErrMsgKey("validate.error.mask", objectDesc);
            }
            return b;
        }
    }

    public static class Macs
    extends AbstractValidator {
        @Override
        public boolean validate(Object object, String objectDesc, Object ... params) {
            if (null == object || "".equals(object)) {
                return true;
            }
            boolean b = true;
            for (String mac : object.toString().split(";")) {
                if (StringUtils.isCorrectMac(mac)) continue;
                b = false;
                super.setErrMsgKey("validate.error.macs", objectDesc);
                break;
            }
            return b;
        }
    }

    public static class Mac
    extends AbstractValidator {
        @Override
        public boolean validate(Object object, String objectDesc, Object ... params) {
            boolean b = true;
            if (null != object && !"".equals(object) && !StringUtils.isCorrectMac(object.toString())) {
                b = false;
                super.setErrMsgKey("validate.error.mac", objectDesc);
            }
            return b;
        }
    }

    public static class Ipv4v6
    extends AbstractValidator {
        @Override
        public boolean validate(Object object, String objectDesc, Object ... params) {
            boolean b = true;
            String str = ClassUtils.objectToString(object);
            if (!StringUtils.allIsVaildIpv6(str) && !StringUtils.allIsVaildIpv4(str)) {
                b = false;
                super.setErrMsgKey("validate.error.ipv4", objectDesc);
            }
            return b;
        }
    }

    public static class Ipv4
    extends AbstractValidator {
        @Override
        public boolean validate(Object object, String objectDesc, Object ... params) {
            boolean b = true;
            if (null != object && !"".equals(object) && !StringUtils.allIsVaildIpv4(ClassUtils.objectToString(object))) {
                b = false;
                super.setErrMsgKey("validate.error.ipv4", objectDesc);
            }
            return b;
        }
    }

    public static class Integrality
    extends AbstractValidator {
        @Override
        public boolean validate(Object object, String objectDesc, Object ... params) {
            if (params.length == 0) {
                return true;
            }
            Object p = params[0];
            boolean b = null == p || "".equals(p);
            for (int i = 1; i < params.length; ++i) {
                boolean b2;
                p = params[i];
                boolean bl = b2 = null == p || "".equals(p);
                if (b2 == b) continue;
                super.setErrMsgKey("validate.error.integrality", objectDesc);
                return false;
            }
            return true;
        }
    }

    public static class NotNull
    extends AbstractValidator {
        @Override
        public boolean validate(Object object, String objectDesc, Object ... params) {
            boolean b = true;
            if (null == object || "".equals(object)) {
                b = false;
                super.setErrMsgKey("validate.error.notnull", objectDesc);
            }
            return b;
        }
    }
}

